/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.core.api.event.ChainEvent;
import dev.sterner.witchery.core.api.interfaces.EntityChainInterface;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.features.chain.ChainManager;
import dev.sterner.witchery.network.SyncChainS2CPayload;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 H2\u00020\u0001:\u0002GHB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&H\u0016J\u000e\u0010'\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0001J\u000e\u0010(\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0001J\b\u0010)\u001a\u0004\u0018\u00010\u0001J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000fH\u0016J\b\u0010/\u001a\u00020+H\u0016J \u00100\u001a\u00020\u00192\u0006\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u0016H\u0016J\u0010\u00100\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0001H\u0016J\b\u00104\u001a\u00020+H\u0016J\u0014\u00105\u001a\u00020\u00192\n\u00106\u001a\u0006\u0012\u0002\b\u000307H\u0016J\u000e\u00108\u001a\u00020\u00192\u0006\u00109\u001a\u00020\u0007J\u000e\u0010:\u001a\u00020\u00192\u0006\u0010;\u001a\u00020\u000fJ\u000e\u0010<\u001a\u00020\u00192\u0006\u0010;\u001a\u00020\u000fJ\u000e\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020\u000fJ\u0006\u0010?\u001a\u00020\rJ\u0006\u0010@\u001a\u00020\u000fJ\u0006\u0010A\u001a\u00020\u000fJ\u0006\u0010B\u001a\u00020\u000fJ\u0006\u0010C\u001a\u00020\u000fJ\u0006\u0010D\u001a\u00020\u0019J\u0010\u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\rH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Ldev/sterner/witchery/content/entity/ChainEntity;", "Lnet/minecraft/world/entity/Entity;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "life", "", "targetEntityId", "Ljava/util/Optional;", "Ljava/util/UUID;", "targetEntity", "chainState", "Ldev/sterner/witchery/content/entity/ChainEntity$ChainState;", "chainProgress", "", "retractProgress", "extensionSpeed", "retractionSpeed", "pullStrength", "maxLinks", "initialDistance", "", "headPosition", "tick", "", "runDiscard", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "readAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "getAddEntityPacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "entity", "Lnet/minecraft/server/level/ServerEntity;", "setTargetEntity", "sync", "getTargetEntity", "hurt", "", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "isPushable", "push", "dx", "dy", "dz", "canBeCollidedWith", "onSyncedDataUpdated", "key", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "setLife", "ticks", "setExtensionSpeed", "speed", "setRetractionSpeed", "setPullStrength", "strength", "getChainState", "getChainProgress", "getRetractProgress", "getHeadPosition", "getRawLinkCount", "startRetracting", "setChainState", "state", "ChainState", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nChainEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChainEntity.kt\ndev/sterner/witchery/content/entity/ChainEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,375:1\n1#2:376\n37#3,2:377\n*S KotlinDebug\n*F\n+ 1 ChainEntity.kt\ndev/sterner/witchery/content/entity/ChainEntity\n*L\n198#1:377,2\n*E\n"})
public final class ChainEntity
extends Entity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int life;
    @NotNull
    private Optional<UUID> targetEntityId;
    @Nullable
    private Entity targetEntity;
    @NotNull
    private ChainState chainState;
    private float chainProgress;
    private float retractProgress;
    private float extensionSpeed;
    private float retractionSpeed;
    private float pullStrength;
    private int maxLinks;
    private double initialDistance;
    private float headPosition;
    private static final EntityDataAccessor<Optional<UUID>> TARGET_ENTITY = SynchedEntityData.defineId(ChainEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> CHAIN_STATE = SynchedEntityData.defineId(ChainEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> CHAIN_PROGRESS = SynchedEntityData.defineId(ChainEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> RETRACT_PROGRESS = SynchedEntityData.defineId(ChainEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> HEAD_POSITION = SynchedEntityData.defineId(ChainEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(ChainEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ChainEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getCHAIN().get(), level);
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        this.targetEntityId = optional;
        this.chainState = ChainState.EXTENDING;
        this.extensionSpeed = 0.05f;
        this.retractionSpeed = 0.03f;
        this.noPhysics = true;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        if (this.targetEntity == null && this.targetEntityId.isPresent() && this.level() instanceof ServerLevel) {
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            Entity entity = this.targetEntity = ((ServerLevel)level).getEntity(this.targetEntityId.get());
            if (entity != null) {
                Entity it = entity;
                boolean bl = false;
                this.sync(it);
            }
        }
        Entity entity = this.targetEntity;
        if (entity != null) {
            Entity target = entity;
            boolean bl = false;
            double currentDistance = this.position().distanceTo(target.position());
            double effectiveLinkLength = 0.29999998211860657;
            if (currentDistance > this.initialDistance * 1.1) {
                this.initialDistance = currentDistance;
                this.maxLinks = (int)Math.ceil(currentDistance / effectiveLinkLength);
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.getChainState().ordinal()]) {
            case 1: {
                float headPos = ((Number)this.entityData.get(HEAD_POSITION)).floatValue() + this.extensionSpeed;
                this.entityData.set(HEAD_POSITION, (Object)Float.valueOf(RangesKt.coerceAtMost((float)headPos, (float)1.0f)));
                float chainGrowthSpeed = this.extensionSpeed * 0.8f;
                float progress = ((Number)this.entityData.get(CHAIN_PROGRESS)).floatValue() + chainGrowthSpeed;
                this.entityData.set(CHAIN_PROGRESS, (Object)Float.valueOf(RangesKt.coerceAtMost((float)progress, (float)1.0f)));
                Entity entity2 = this.targetEntity;
                if (entity2 != null) {
                    Entity target = entity2;
                    boolean bl = false;
                    double currentDistance = this.position().distanceTo(target.position());
                    if (currentDistance > this.initialDistance * 1.5 && headPos > 0.7f) {
                        this.entityData.set(HEAD_POSITION, (Object)Float.valueOf(RangesKt.coerceAtLeast((float)(headPos - 0.01f), (float)0.7f)));
                    }
                }
                if (!(headPos >= 1.0f)) break;
                this.setChainState(ChainState.CONNECTED);
                break;
            }
            case 2: {
                Entity entity3 = this.targetEntity;
                if (entity3 != null) {
                    Entity target = entity3;
                    boolean bl = false;
                    if (target instanceof LivingEntity && target instanceof EntityChainInterface) {
                        boolean lockPos = this.pullStrength == 0.0f;
                        ((EntityChainInterface)target).witchery$restrainMovement(this, lockPos);
                    }
                }
                if (!(this.pullStrength > 0.0f)) break;
                this.setChainState(ChainState.RETRACTING);
                break;
            }
            case 3: {
                Entity entity4 = this.targetEntity;
                if (entity4 != null) {
                    Entity target = entity4;
                    boolean bl = false;
                    if (!(target instanceof LivingEntity)) break;
                    Vec3 origin = this.position();
                    Vec3 targetPos = target.position();
                    Vec3 toOrigin = origin.subtract(targetPos);
                    double distance = toOrigin.length();
                    if (this.getBoundingBox().inflate(0.25).intersects(((LivingEntity)target).getBoundingBox())) {
                        this.setChainState(ChainState.FINISHED);
                        break;
                    }
                    float progressIncrement = distance > 2.0 ? this.retractionSpeed * 0.5f : this.retractionSpeed * 0.8f;
                    float progress = ((Number)this.entityData.get(RETRACT_PROGRESS)).floatValue() + progressIncrement;
                    this.entityData.set(RETRACT_PROGRESS, (Object)Float.valueOf(RangesKt.coerceAtMost((float)progress, (float)1.0f)));
                    if (progress <= 0.5f) {
                        this.entityData.set(HEAD_POSITION, (Object)Float.valueOf(1.0f));
                    } else {
                        double targetDistanceFactor = RangesKt.coerceIn((double)(distance / (distance + 2.0)), (double)0.0, (double)1.0);
                        float headPos = (float)targetDistanceFactor;
                        this.entityData.set(HEAD_POSITION, (Object)Float.valueOf(headPos));
                    }
                    Vec3 adjusted = new Vec3(toOrigin.x, toOrigin.y, toOrigin.z);
                    double maxPullPerTick = 0.75;
                    double clamped = RangesKt.coerceAtMost((double)adjusted.length(), (double)maxPullPerTick);
                    Vec3 pullVector = adjusted.normalize().scale(clamped * (double)this.pullStrength * (double)1.2f);
                    ((LivingEntity)target).setDeltaMovement(((LivingEntity)target).getDeltaMovement().add(pullVector));
                    target.fallDistance = 0.0f;
                }
                break;
            }
            case 4: {
                this.runDiscard(this.targetEntity);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (this.life > 0) {
            int n = this.life;
            this.life = n + -1;
            if (this.life <= 0) {
                this.runDiscard(this.targetEntity);
            }
        }
    }

    private final void runDiscard(Entity targetEntity) {
        Entity it;
        Entity entity = targetEntity;
        if (entity != null) {
            it = entity;
            boolean bl = false;
            it.setDeltaMovement(Vec3.ZERO);
        }
        Entity entity2 = targetEntity;
        if (entity2 != null) {
            it = entity2;
            boolean bl = false;
            ChainManager.INSTANCE.tryReleaseEntity(this, it);
        }
        NeoForge.EVENT_BUS.post((Event)new ChainEvent.Discard(targetEntity, this));
        this.discard();
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(TARGET_ENTITY, Optional.empty());
        builder.define(CHAIN_STATE, (Object)ChainState.EXTENDING.ordinal());
        builder.define(CHAIN_PROGRESS, (Object)Float.valueOf(0.0f));
        builder.define(RETRACT_PROGRESS, (Object)Float.valueOf(0.0f));
        builder.define(HEAD_POSITION, (Object)Float.valueOf(0.0f));
        builder.define(TYPE, (Object)0);
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        if (compound.hasUUID("TargetEntity")) {
            Optional<UUID> optional = Optional.of(compound.getUUID("TargetEntity"));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            this.targetEntityId = optional;
        }
        this.life = compound.getInt("Life");
        Collection $this$toTypedArray$iv = (Collection)ChainState.getEntries();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.chainState = thisCollection$iv.toArray(new ChainState[0])[compound.getInt("ChainState")];
        this.chainProgress = compound.getFloat("ChainProgress");
        this.retractProgress = compound.getFloat("RetractProgress");
        this.headPosition = compound.getFloat("HeadPosition");
        this.extensionSpeed = compound.getFloat("ExtensionSpeed");
        this.retractionSpeed = compound.getFloat("RetractionSpeed");
        this.pullStrength = compound.getFloat("PullStrength");
        this.maxLinks = compound.getInt("MaxLinks");
        this.initialDistance = compound.getDouble("InitialDistance");
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.targetEntityId.ifPresent(arg_0 -> ChainEntity.addAdditionalSaveData$lambda$1(arg_0 -> ChainEntity.addAdditionalSaveData$lambda$0(compound, arg_0), arg_0));
        compound.putInt("Life", this.life);
        compound.putInt("ChainState", this.chainState.ordinal());
        compound.putFloat("ChainProgress", this.chainProgress);
        compound.putFloat("RetractProgress", this.retractProgress);
        compound.putFloat("HeadPosition", this.headPosition);
        compound.putFloat("ExtensionSpeed", this.extensionSpeed);
        compound.putFloat("RetractionSpeed", this.retractionSpeed);
        compound.putFloat("PullStrength", this.pullStrength);
        compound.putInt("MaxLinks", this.maxLinks);
        compound.putDouble("InitialDistance", this.initialDistance);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(@NotNull ServerEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return (Packet)new ClientboundAddEntityPacket((Entity)this, entity);
    }

    public final void setTargetEntity(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.targetEntity = entity;
        Optional<UUID> optional = Optional.of(entity.getUUID());
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        this.targetEntityId = optional;
        this.entityData.set(TARGET_ENTITY, Optional.of(entity.getUUID()));
        this.sync(entity);
        this.initialDistance = this.position().distanceTo(entity.position());
        double effectiveLinkLength = 0.29999998211860657;
        this.maxLinks = (int)Math.ceil(this.initialDistance / effectiveLinkLength);
    }

    public final void sync(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.level() instanceof ServerLevel) {
            Level level = entity.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(entity.blockPosition()), (CustomPacketPayload)new SyncChainS2CPayload(this, entity), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Nullable
    public final Entity getTargetEntity() {
        if (this.targetEntity != null) {
            return this.targetEntity;
        }
        Optional id = (Optional)this.entityData.get(TARGET_ENTITY);
        if (id.isPresent() && this.level() instanceof ServerLevel) {
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            this.targetEntity = ((ServerLevel)level).getEntity((UUID)id.get());
            return this.targetEntity;
        }
        return null;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public void push(double dx, double dy, double dz) {
    }

    public void push(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> key) {
        Optional uuid;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        super.onSyncedDataUpdated(key);
        if (Intrinsics.areEqual(key, TARGET_ENTITY) && (uuid = (Optional)this.entityData.get(TARGET_ENTITY)).isPresent()) {
            Intrinsics.checkNotNull((Object)uuid);
            this.targetEntityId = uuid;
        }
    }

    public final void setLife(int ticks) {
        this.life = ticks;
    }

    public final void setExtensionSpeed(float speed) {
        this.extensionSpeed = speed;
    }

    public final void setRetractionSpeed(float speed) {
        this.retractionSpeed = speed;
    }

    public final void setPullStrength(float strength) {
        this.pullStrength = strength;
    }

    @NotNull
    public final ChainState getChainState() {
        EnumEntries<ChainState> enumEntries = ChainState.getEntries();
        Object object = this.entityData.get(CHAIN_STATE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ChainState)((Object)enumEntries.get(((Number)object).intValue()));
    }

    public final float getChainProgress() {
        Object object = this.entityData.get(CHAIN_PROGRESS);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).floatValue();
    }

    public final float getRetractProgress() {
        Object object = this.entityData.get(RETRACT_PROGRESS);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).floatValue();
    }

    public final float getHeadPosition() {
        Object object = this.entityData.get(HEAD_POSITION);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).floatValue();
    }

    public final float getRawLinkCount() {
        ChainState chainState = this.getChainState();
        Entity entity = this.targetEntity;
        if (entity != null) {
            int neededLinks;
            Entity target = entity;
            boolean bl = false;
            double currentDistance = this.position().distanceTo(target.position());
            double effectiveLinkLength = 0.29999998211860657;
            if ((chainState == ChainState.EXTENDING || chainState == ChainState.CONNECTED) && (neededLinks = (int)Math.ceil(currentDistance / effectiveLinkLength)) > this.maxLinks) {
                this.maxLinks = neededLinks;
            }
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[chainState.ordinal()]) {
            case 1 -> RangesKt.coerceAtLeast((float)((float)this.maxLinks * this.getChainProgress()), (float)0.1f);
            case 2 -> this.maxLinks;
            case 3 -> {
                float baseRetraction = this.getRetractProgress();
                yield RangesKt.coerceAtLeast((float)((1.0f - baseRetraction) * (float)this.maxLinks), (float)0.1f);
            }
            case 4 -> 0.0f;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void startRetracting() {
        this.setChainState(ChainState.RETRACTING);
    }

    private final void setChainState(ChainState state) {
        this.entityData.set(CHAIN_STATE, (Object)state.ordinal());
        switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                this.entityData.set(CHAIN_PROGRESS, (Object)Float.valueOf(0.0f));
                this.entityData.set(HEAD_POSITION, (Object)Float.valueOf(0.0f));
                break;
            }
            case 3: {
                this.entityData.set(RETRACT_PROGRESS, (Object)Float.valueOf(0.0f));
                this.entityData.set(HEAD_POSITION, (Object)Float.valueOf(1.0f));
            }
        }
    }

    private static final Unit addAdditionalSaveData$lambda$0(CompoundTag $compound, UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        $compound.putUUID("TargetEntity", uuid);
        return Unit.INSTANCE;
    }

    private static final void addAdditionalSaveData$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ldev/sterner/witchery/content/entity/ChainEntity$ChainState;", "", "<init>", "(Ljava/lang/String;I)V", "EXTENDING", "CONNECTED", "RETRACTING", "FINISHED", "witchery"})
    public static final class ChainState
    extends Enum<ChainState> {
        public static final /* enum */ ChainState EXTENDING = new ChainState();
        public static final /* enum */ ChainState CONNECTED = new ChainState();
        public static final /* enum */ ChainState RETRACTING = new ChainState();
        public static final /* enum */ ChainState FINISHED = new ChainState();
        private static final /* synthetic */ ChainState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ChainState[] values() {
            return (ChainState[])$VALUES.clone();
        }

        public static ChainState valueOf(String value) {
            return Enum.valueOf(ChainState.class, value);
        }

        @NotNull
        public static EnumEntries<ChainState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = chainStateArray = new ChainState[]{ChainState.EXTENDING, ChainState.CONNECTED, ChainState.RETRACTING, ChainState.FINISHED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Rj\u0010\u0004\u001a^\u0012(\u0012&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006 \b*.\u0012(\u0012&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\t\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\n0\n \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\n0\n\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000e\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\u000f\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\n0\n \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\n0\n\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/content/entity/ChainEntity$Companion;", "", "<init>", "()V", "TARGET_ENTITY", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "Ljava/util/Optional;", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "CHAIN_STATE", "", "CHAIN_PROGRESS", "", "RETRACT_PROGRESS", "HEAD_POSITION", "TYPE", "getTYPE", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final EntityDataAccessor<Integer> getTYPE() {
            return TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChainState.values().length];
            try {
                nArray[ChainState.EXTENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChainState.CONNECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChainState.RETRACTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChainState.FINISHED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

