/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.content.block.ritual.GoldenChalkBlock;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.coven.CovenHandler;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 92\u00020\u0001:\u00059:;<=B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0014J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010%\u001a\u00020\u00122\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0006\u0010'\u001a\u00020\rJ\u000e\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\rJ\u0006\u0010*\u001a\u00020\rJ\u000e\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\rJ\u000e\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\rJ\u0010\u0010/\u001a\u00020\u00122\b\u00100\u001a\u0004\u0018\u00010\u000fJ\u0006\u00101\u001a\u00020\u0012J\u0010\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00122\u0006\u00103\u001a\u000204H\u0016J\u0010\u00106\u001a\u00020\u00122\b\u00107\u001a\u0004\u0018\u00010\bJ\b\u00108\u001a\u0004\u0018\u00010\bR\u0019\u0010\u0006\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Ldev/sterner/witchery/content/entity/CovenWitchEntity;", "Lnet/minecraft/world/entity/PathfinderMob;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "lastRitualPosInternal", "Ljava/util/Optional;", "Lnet/minecraft/core/BlockPos;", "Lkotlin/jvm/internal/EnhancedNullability;", "despawnTimer", "", "ritualCompleted", "", "ownerUuid", "Ljava/util/UUID;", "homePos", "registerGoals", "", "mobInteract", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "aiStep", "die", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "hurt", "source", "amount", "", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "getLastRitualPos", "setLastRitualPos", "ritualPos", "getIsCoven", "setIsCoven", "isCoven", "getHasDemonHeart", "setHasDemonHeart", "hasDemonHeart", "setRitualCompleted", "completed", "setOwner", "uuid", "resetDespawnTimer", "addAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "setHome", "pos", "getHome", "Companion", "RitualAttendanceGoal", "HomeWanderGoal", "FindHomeGoal", "HomeWanderFarGoal", "witchery"})
@SourceDebugExtension(value={"SMAP\nCovenWitchEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CovenWitchEntity.kt\ndev/sterner/witchery/content/entity/CovenWitchEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,464:1\n1#2:465\n*E\n"})
public final class CovenWitchEntity
extends PathfinderMob {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Optional<BlockPos> lastRitualPosInternal;
    private int despawnTimer;
    private boolean ritualCompleted;
    @Nullable
    private UUID ownerUuid;
    @Nullable
    private BlockPos homePos;
    @NotNull
    private static final EntityDataAccessor<Optional<BlockPos>> LAST_RITUAL_POS;
    @NotNull
    private static final EntityDataAccessor<Boolean> IS_COVEN;
    @NotNull
    private static final EntityDataAccessor<Boolean> HAS_DEMON_HEART;

    public CovenWitchEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getCOVEN_WITCH().get(), level);
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        this.lastRitualPosInternal = optional;
        this.despawnTimer = 24000;
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FindHomeGoal(this));
        this.goalSelector.addGoal(1, (Goal)new RitualAttendanceGoal(this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new HomeWanderGoal(this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new HomeWanderFarGoal(this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is((Item)WitcheryItems.INSTANCE.getDEMON_HEART().get()) && !this.getHasDemonHeart()) {
            if (!this.level().isClientSide) {
                this.setHasDemonHeart(true);
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
                Level level = this.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, this.getX(), this.getY() + (double)this.getBbHeight() + 0.5, this.getZ(), 10, 0.4, 0.2, 0.4, 0.0);
                this.level().playSound(null, this.blockPosition(), SoundEvents.WITCH_CELEBRATE, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.mobInteract(player, hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"mobInteract(...)");
        return interactionResult;
    }

    public void aiStep() {
        if (this.level().isClientSide) {
            super.aiStep();
            return;
        }
        if (this.level().getGameTime() % (long)200 == 0L && this.lastRitualPosInternal.isPresent()) {
            BlockPos blockPos = this.lastRitualPosInternal.get();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"get(...)");
            BlockPos pos = blockPos;
            if (!(this.level().getBlockState(pos).getBlock() instanceof GoldenChalkBlock)) {
                Optional<BlockPos> optional = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                this.setLastRitualPos(optional);
                this.ritualCompleted = true;
            }
        }
        if (this.getIsCoven() && !this.isPersistenceRequired()) {
            if (this.ritualCompleted) {
                this.despawnTimer -= 2;
            } else {
                int pos = this.despawnTimer;
                this.despawnTimer = pos + -1;
            }
            if (this.despawnTimer <= 0) {
                if (this.ownerUuid != null) {
                    Level level = this.level();
                    UUID uUID = this.ownerUuid;
                    Intrinsics.checkNotNull((Object)uUID);
                    Player owner = level.getPlayerByUUID(uUID);
                    if (owner instanceof ServerPlayer) {
                        CovenHandler.INSTANCE.returnWitchToCoven((ServerPlayer)owner, this);
                    }
                }
                this.discard();
            }
        }
        super.aiStep();
    }

    public void die(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        if (this.getIsCoven() && this.ownerUuid != null && !this.level().isClientSide) {
            Level level = this.level();
            UUID uUID = this.ownerUuid;
            Intrinsics.checkNotNull((Object)uUID);
            Player owner = level.getPlayerByUUID(uUID);
            if (owner instanceof ServerPlayer) {
                CovenHandler.INSTANCE.handleWitchDeath((ServerPlayer)owner, this);
            }
        }
        super.die(damageSource);
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean result = super.hurt(source, amount);
        if (result && this.getIsCoven() && this.ownerUuid != null && !this.level().isClientSide) {
            Level level = this.level();
            UUID uUID = this.ownerUuid;
            Intrinsics.checkNotNull((Object)uUID);
            Player owner = level.getPlayerByUUID(uUID);
            if (owner instanceof ServerPlayer) {
                CovenHandler.INSTANCE.updateWitchHealth((ServerPlayer)owner, this);
            }
        }
        return result;
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(LAST_RITUAL_POS, Optional.empty());
        builder.define(IS_COVEN, (Object)false);
        builder.define(HAS_DEMON_HEART, (Object)false);
    }

    @NotNull
    public final Optional<BlockPos> getLastRitualPos() {
        Object object = this.entityData.get(LAST_RITUAL_POS);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Optional)object;
    }

    public final void setLastRitualPos(@NotNull Optional<BlockPos> ritualPos) {
        Intrinsics.checkNotNullParameter(ritualPos, (String)"ritualPos");
        this.entityData.set(LAST_RITUAL_POS, ritualPos);
        this.lastRitualPosInternal = ritualPos;
    }

    public final boolean getIsCoven() {
        Object object = this.entityData.get(IS_COVEN);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    public final void setIsCoven(boolean isCoven) {
        this.entityData.set(IS_COVEN, (Object)isCoven);
    }

    public final boolean getHasDemonHeart() {
        Object object = this.entityData.get(HAS_DEMON_HEART);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    public final void setHasDemonHeart(boolean hasDemonHeart) {
        this.entityData.set(HAS_DEMON_HEART, (Object)hasDemonHeart);
    }

    public final void setRitualCompleted(boolean completed) {
        this.ritualCompleted = completed;
    }

    public final void setOwner(@Nullable UUID uuid) {
        this.ownerUuid = uuid;
    }

    public final void resetDespawnTimer() {
        this.despawnTimer = 24000;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        block2: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            super.addAdditionalSaveData(compound);
            if (this.lastRitualPosInternal.isPresent()) {
                compound.put("LastRitualPos", NbtUtils.writeBlockPos((BlockPos)this.lastRitualPosInternal.get()));
            }
            BlockPos blockPos = this.homePos;
            if (blockPos != null) {
                it = blockPos;
                boolean bl = false;
                compound.put("HomePos", NbtUtils.writeBlockPos((BlockPos)it));
            }
            compound.putInt("DespawnTimer", this.despawnTimer);
            compound.putBoolean("IsCoven", this.getIsCoven());
            compound.putBoolean("HasDemonHeart", this.getHasDemonHeart());
            compound.putBoolean("RitualCompleted", this.ritualCompleted);
            UUID uUID = this.ownerUuid;
            if (uUID == null) break block2;
            it = uUID;
            boolean bl = false;
            compound.putUUID("OwnerUUID", (UUID)it);
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        if (compound.contains("LastRitualPos")) {
            Optional optional = NbtUtils.readBlockPos((CompoundTag)compound, (String)"LastRitualPos");
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"readBlockPos(...)");
            this.lastRitualPosInternal = optional;
            this.setLastRitualPos(this.lastRitualPosInternal);
        }
        if (compound.contains("HomePos")) {
            this.homePos = NbtUtils.readBlockPos((CompoundTag)compound, (String)"HomePos").orElse(null);
        }
        if (compound.contains("DespawnTimer")) {
            this.despawnTimer = compound.getInt("DespawnTimer");
        }
        if (compound.contains("IsCoven")) {
            this.setIsCoven(compound.getBoolean("IsCoven"));
        }
        if (compound.contains("HasDemonHeart")) {
            this.setHasDemonHeart(compound.getBoolean("HasDemonHeart"));
        }
        if (compound.contains("RitualCompleted")) {
            this.ritualCompleted = compound.getBoolean("RitualCompleted");
        }
        if (compound.hasUUID("OwnerUUID")) {
            this.ownerUuid = compound.getUUID("OwnerUUID");
        }
    }

    public final void setHome(@Nullable BlockPos pos) {
        this.homePos = pos;
    }

    @Nullable
    public final BlockPos getHome() {
        return this.homePos;
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(CovenWitchEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        LAST_RITUAL_POS = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(CovenWitchEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        IS_COVEN = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.defineId(CovenWitchEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        HAS_DEMON_HEART = entityDataAccessor3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000f\u001a\u00020\u0010R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/content/entity/CovenWitchEntity$Companion;", "", "<init>", "()V", "LAST_RITUAL_POS", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "Ljava/util/Optional;", "Lnet/minecraft/core/BlockPos;", "getLAST_RITUAL_POS", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "IS_COVEN", "", "getIS_COVEN", "HAS_DEMON_HEART", "getHAS_DEMON_HEART", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Optional<BlockPos>> getLAST_RITUAL_POS() {
            return LAST_RITUAL_POS;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getIS_COVEN() {
            return IS_COVEN;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getHAS_DEMON_HEART() {
            return HAS_DEMON_HEART;
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 26.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 48.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/content/entity/CovenWitchEntity$FindHomeGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "witch", "Ldev/sterner/witchery/content/entity/CovenWitchEntity;", "<init>", "(Ldev/sterner/witchery/content/entity/CovenWitchEntity;)V", "searchCooldown", "", "searchRadius", "", "canUse", "", "start", "", "findRowanSapling", "witchery"})
    public static final class FindHomeGoal
    extends Goal {
        @NotNull
        private final CovenWitchEntity witch;
        private int searchCooldown;
        private final double searchRadius;

        public FindHomeGoal(@NotNull CovenWitchEntity witch) {
            Intrinsics.checkNotNullParameter((Object)((Object)witch), (String)"witch");
            this.witch = witch;
            this.searchRadius = 32.0;
            this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.witch.getHome() != null) {
                return false;
            }
            int n = this.searchCooldown;
            this.searchCooldown = n + -1;
            return this.searchCooldown <= 0;
        }

        public void start() {
            this.findRowanSapling();
            this.searchCooldown = 200;
        }

        private final void findRowanSapling() {
            BlockPos witchPos = this.witch.blockPosition();
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)witchPos.offset(-((int)this.searchRadius), -8, -((int)this.searchRadius)), (BlockPos)witchPos.offset((int)this.searchRadius, 8, (int)this.searchRadius))) {
                if (!this.witch.level().getBlockState(pos).is((Block)WitcheryBlocks.INSTANCE.getPOTTED_ROWAN_SAPLING().get())) continue;
                this.witch.setHome(pos.immutable());
                return;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/content/entity/CovenWitchEntity$HomeWanderFarGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "witch", "Ldev/sterner/witchery/content/entity/CovenWitchEntity;", "speed", "", "<init>", "(Ldev/sterner/witchery/content/entity/CovenWitchEntity;D)V", "pathFinder", "Lnet/minecraft/world/entity/ai/navigation/PathNavigation;", "farWanderRadius", "maxDistanceFromHome", "canUse", "", "start", "", "canContinueToUse", "stop", "witchery"})
    public static final class HomeWanderFarGoal
    extends Goal {
        @NotNull
        private final CovenWitchEntity witch;
        private final double speed;
        @NotNull
        private final PathNavigation pathFinder;
        private final double farWanderRadius;
        private final double maxDistanceFromHome;

        public HomeWanderFarGoal(@NotNull CovenWitchEntity witch, double speed) {
            Intrinsics.checkNotNullParameter((Object)((Object)witch), (String)"witch");
            this.witch = witch;
            this.speed = speed;
            PathNavigation pathNavigation = this.witch.navigation;
            Intrinsics.checkNotNullExpressionValue((Object)pathNavigation, (String)"access$getNavigation$p$s-1542758153(...)");
            this.pathFinder = pathNavigation;
            this.farWanderRadius = 40.0;
            this.maxDistanceFromHome = 48.0;
            this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.witch.random.nextFloat() > 0.002f) {
                return false;
            }
            if (this.witch.getIsCoven() && this.witch.getLastRitualPos().isPresent()) {
                return false;
            }
            BlockPos blockPos = this.witch.getHome();
            if (blockPos == null) {
                return false;
            }
            BlockPos home = blockPos;
            if (!this.witch.level().getBlockState(home).is((Block)WitcheryBlocks.INSTANCE.getPOTTED_ROWAN_SAPLING().get())) {
                this.witch.setHome(null);
                return false;
            }
            double distance = this.witch.position().distanceTo(Vec3.atCenterOf((Vec3i)((Vec3i)home)));
            return distance < this.maxDistanceFromHome;
        }

        public void start() {
            BlockPos blockPos = this.witch.getHome();
            if (blockPos == null) {
                return;
            }
            BlockPos home = blockPos;
            double angle = this.witch.random.nextDouble() * Math.PI * (double)2;
            double distance = 20.0 + this.witch.random.nextDouble() * (this.farWanderRadius - 20.0);
            double targetX = (double)home.getX() + 0.5 + Math.cos(angle) * distance;
            double targetZ = (double)home.getZ() + 0.5 + Math.sin(angle) * distance;
            this.pathFinder.moveTo(targetX, (double)home.getY(), targetZ, this.speed);
        }

        public boolean canContinueToUse() {
            return !this.pathFinder.isDone();
        }

        public void stop() {
            this.pathFinder.stop();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/content/entity/CovenWitchEntity$HomeWanderGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "witch", "Ldev/sterner/witchery/content/entity/CovenWitchEntity;", "speed", "", "<init>", "(Ldev/sterner/witchery/content/entity/CovenWitchEntity;D)V", "pathFinder", "Lnet/minecraft/world/entity/ai/navigation/PathNavigation;", "wanderRadius", "maxDistanceFromHome", "canUse", "", "start", "", "canContinueToUse", "stop", "witchery"})
    public static final class HomeWanderGoal
    extends Goal {
        @NotNull
        private final CovenWitchEntity witch;
        private final double speed;
        @NotNull
        private final PathNavigation pathFinder;
        private final double wanderRadius;
        private final double maxDistanceFromHome;

        public HomeWanderGoal(@NotNull CovenWitchEntity witch, double speed) {
            Intrinsics.checkNotNullParameter((Object)((Object)witch), (String)"witch");
            this.witch = witch;
            this.speed = speed;
            PathNavigation pathNavigation = this.witch.navigation;
            Intrinsics.checkNotNullExpressionValue((Object)pathNavigation, (String)"access$getNavigation$p$s-1542758153(...)");
            this.pathFinder = pathNavigation;
            this.wanderRadius = 16.0;
            this.maxDistanceFromHome = 24.0;
            this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.witch.random.nextFloat() > 0.02f) {
                return false;
            }
            if (this.witch.getIsCoven() && this.witch.getLastRitualPos().isPresent()) {
                return false;
            }
            BlockPos blockPos = this.witch.getHome();
            if (blockPos == null) {
                return false;
            }
            BlockPos home = blockPos;
            if (!this.witch.level().getBlockState(home).is((Block)WitcheryBlocks.INSTANCE.getPOTTED_ROWAN_SAPLING().get())) {
                this.witch.setHome(null);
                return false;
            }
            double distance = this.witch.position().distanceTo(Vec3.atCenterOf((Vec3i)((Vec3i)home)));
            return distance < this.maxDistanceFromHome;
        }

        public void start() {
            BlockPos blockPos = this.witch.getHome();
            if (blockPos == null) {
                return;
            }
            BlockPos home = blockPos;
            double angle = this.witch.random.nextDouble() * Math.PI * (double)2;
            double distance = 4.0 + this.witch.random.nextDouble() * (this.wanderRadius - 4.0);
            double targetX = (double)home.getX() + 0.5 + Math.cos(angle) * distance;
            double targetZ = (double)home.getZ() + 0.5 + Math.sin(angle) * distance;
            this.pathFinder.moveTo(targetX, (double)home.getY(), targetZ, this.speed);
        }

        public boolean canContinueToUse() {
            return !this.pathFinder.isDone();
        }

        public void stop() {
            this.pathFinder.stop();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/content/entity/CovenWitchEntity$RitualAttendanceGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "witch", "Ldev/sterner/witchery/content/entity/CovenWitchEntity;", "speed", "", "<init>", "(Ldev/sterner/witchery/content/entity/CovenWitchEntity;D)V", "pathFinder", "Lnet/minecraft/world/entity/ai/navigation/PathNavigation;", "timeoutCounter", "", "ritual", "Lnet/minecraft/core/BlockPos;", "desiredDistance", "canUse", "", "start", "", "stop", "tick", "witchery"})
    public static final class RitualAttendanceGoal
    extends Goal {
        @NotNull
        private final CovenWitchEntity witch;
        @NotNull
        private final PathNavigation pathFinder;
        private final double speed;
        private int timeoutCounter;
        @Nullable
        private BlockPos ritual;
        private final double desiredDistance;

        public RitualAttendanceGoal(@NotNull CovenWitchEntity witch, double speed) {
            Intrinsics.checkNotNullParameter((Object)((Object)witch), (String)"witch");
            this.witch = witch;
            PathNavigation pathNavigation = this.witch.navigation;
            Intrinsics.checkNotNullExpressionValue((Object)pathNavigation, (String)"access$getNavigation$p$s-1542758153(...)");
            this.pathFinder = pathNavigation;
            this.desiredDistance = 4.0;
            this.speed = speed;
            this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (!this.witch.getIsCoven()) {
                return false;
            }
            Optional<BlockPos> ritualPos = this.witch.getLastRitualPos();
            if (!ritualPos.isPresent()) {
                return false;
            }
            this.ritual = ritualPos.get();
            return true;
        }

        public void start() {
            this.timeoutCounter = 0;
        }

        public void stop() {
            this.pathFinder.stop();
            this.ritual = null;
        }

        public void tick() {
            double dz;
            double dy;
            BlockPos blockPos = this.ritual;
            if (blockPos == null) {
                return;
            }
            BlockPos ritualPos = blockPos;
            double dx = (double)ritualPos.getX() + 0.5 - this.witch.getX();
            double distanceSq = dx * dx + (dy = (double)ritualPos.getY() - this.witch.getY()) * dy + (dz = (double)ritualPos.getZ() + 0.5 - this.witch.getZ()) * dz;
            if (distanceSq > this.desiredDistance * this.desiredDistance) {
                int n = this.timeoutCounter;
                this.timeoutCounter = n + -1;
                if (this.timeoutCounter <= 0) {
                    this.timeoutCounter = 10 + this.witch.random.nextInt(40);
                    double angle = this.witch.random.nextDouble() * Math.PI * (double)2;
                    double targetX = (double)ritualPos.getX() + 0.5 + Math.cos(angle) * this.desiredDistance;
                    double targetZ = (double)ritualPos.getZ() + 0.5 + Math.sin(angle) * this.desiredDistance;
                    this.pathFinder.moveTo(targetX, (double)ritualPos.getY(), targetZ, this.speed);
                }
            } else {
                this.witch.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3((double)ritualPos.getX() + 0.5, (double)ritualPos.getY() + 0.5, (double)ritualPos.getZ() + 0.5));
            }
        }
    }
}

