/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.content.entity.LilithEntity;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0014J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u001d"}, d2={"Ldev/sterner/witchery/content/entity/ElleEntity;", "Lnet/minecraft/world/entity/PathfinderMob;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "conversionTime", "", "Ljava/lang/Integer;", "fireImmune", "", "baseTick", "", "transformToLilith", "isInNether", "registerGoals", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "getOwnerUUID", "Ljava/util/UUID;", "setOwnerUUID", "uuid", "addAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "Companion", "ElleFollowOwnerGoal", "witchery"})
public final class ElleEntity
extends PathfinderMob {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Integer conversionTime;
    @NotNull
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID;

    public ElleEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getELLE().get(), level);
    }

    public boolean fireImmune() {
        return true;
    }

    public void baseTick() {
        Player player;
        super.baseTick();
        if (this.isInNether()) {
            if (this.conversionTime == null) {
                this.conversionTime = 300;
            } else {
                Integer n = this.conversionTime;
                Integer n2 = this.conversionTime = n != null ? Integer.valueOf(n - 1) : null;
                if (n2 != null && n2 == 0) {
                    this.transformToLilith();
                }
            }
        } else {
            this.conversionTime = null;
        }
        if (!((Optional)this.entityData.get(DATA_OWNERUUID_ID)).isPresent() && (player = this.level().getNearestPlayer((Entity)this, 10.0)) != null) {
            this.setOwnerUUID(player.getUUID());
        }
    }

    private final void transformToLilith() {
        LilithEntity lilith;
        LilithEntity lilithEntity = lilith = (LilithEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getLILITH().get()).create(this.level());
        Intrinsics.checkNotNull((Object)((Object)lilithEntity));
        lilithEntity.moveTo(this.position());
        this.level().addFreshEntity((Entity)lilith);
        this.discard();
    }

    private final boolean isInNether() {
        return Intrinsics.areEqual((Object)this.level().dimension(), (Object)Level.NETHER);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ElleFollowOwnerGoal(this, 1.0, 5.0f));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        super.registerGoals();
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(DATA_OWNERUUID_ID, Optional.empty());
    }

    @Nullable
    public final UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(DATA_OWNERUUID_ID)).orElse(null);
    }

    public final void setOwnerUUID(@Nullable UUID uuid) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.addAdditionalSaveData(compound);
        if (this.getOwnerUUID() != null) {
            UUID uUID = this.getOwnerUUID();
            Intrinsics.checkNotNull((Object)uUID);
            compound.putUUID("Owner", uUID);
        }
        if (this.conversionTime != null) {
            Integer n = this.conversionTime;
            Intrinsics.checkNotNull((Object)n);
            compound.putInt("ConversionTime", n.intValue());
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        UUID uUID = null;
        if (compound.hasUUID("Owner")) {
            uUID = compound.getUUID("Owner");
        } else {
            String string = compound.getString("Owner");
            uUID = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)string);
        }
        if (uUID != null) {
            this.setOwnerUUID(uUID);
        }
        if (compound.contains("ConversionTime")) {
            this.conversionTime = compound.getInt("ConversionTime");
        }
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(ElleEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DATA_OWNERUUID_ID = entityDataAccessor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/content/entity/ElleEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "DATA_OWNERUUID_ID", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "Ljava/util/Optional;", "Ljava/util/UUID;", "getDATA_OWNERUUID_ID", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = PathfinderMob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.FOLLOW_RANGE, 48.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final EntityDataAccessor<Optional<UUID>> getDATA_OWNERUUID_ID() {
            return DATA_OWNERUUID_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/sterner/witchery/content/entity/ElleEntity$ElleFollowOwnerGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "elle", "Ldev/sterner/witchery/content/entity/ElleEntity;", "speedModifier", "", "startDistance", "", "<init>", "(Ldev/sterner/witchery/content/entity/ElleEntity;DF)V", "owner", "Lnet/minecraft/world/entity/LivingEntity;", "navigation", "Lnet/minecraft/world/entity/ai/navigation/PathNavigation;", "timeToRecalcPath", "", "oldWaterCost", "canUse", "", "canContinueToUse", "start", "", "stop", "tick", "witchery"})
    public static final class ElleFollowOwnerGoal
    extends Goal {
        @NotNull
        private final ElleEntity elle;
        private final double speedModifier;
        private final float startDistance;
        @Nullable
        private LivingEntity owner;
        @NotNull
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private float oldWaterCost;

        public ElleFollowOwnerGoal(@NotNull ElleEntity elle, double speedModifier, float startDistance) {
            Intrinsics.checkNotNullParameter((Object)((Object)elle), (String)"elle");
            this.elle = elle;
            this.speedModifier = speedModifier;
            this.startDistance = startDistance;
            PathNavigation pathNavigation = this.elle.navigation;
            Intrinsics.checkNotNullExpressionValue((Object)pathNavigation, (String)"access$getNavigation$p$s-1837010813(...)");
            this.navigation = pathNavigation;
            this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
        }

        public boolean canUse() {
            Optional uuid = (Optional)this.elle.entityData.get(Companion.getDATA_OWNERUUID_ID());
            if (uuid.isPresent()) {
                Player livingEntity = this.elle.level().getPlayerByUUID((UUID)uuid.get());
                if (livingEntity == null) {
                    return false;
                }
                if (this.elle.distanceToSqr((Entity)livingEntity) < (double)(this.startDistance * this.startDistance)) {
                    return false;
                }
                this.owner = (LivingEntity)livingEntity;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return !this.navigation.isDone();
        }

        public void start() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.elle.getPathfindingMalus(PathType.WATER);
            this.elle.setPathfindingMalus(PathType.WATER, 0.0f);
        }

        public void stop() {
            this.owner = null;
            this.navigation.stop();
            this.elle.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        }

        public void tick() {
            this.elle.lookControl.setLookAt((Entity)this.owner, 10.0f, (float)this.elle.getMaxHeadXRot());
            this.timeToRecalcPath += -1;
            if (this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.adjustedTickDelay(10);
                this.navigation.moveTo((Entity)this.owner, this.speedModifier);
            }
        }
    }
}

