/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.content.block.soul_cage.SoulCageBlockEntity;
import dev.sterner.witchery.content.entity.goal.LookAtTradingPlayerGoal;
import dev.sterner.witchery.content.entity.goal.TradeWithPlayerGoal;
import dev.sterner.witchery.content.item.EntTwigItem;
import dev.sterner.witchery.content.menu.SoulTradingMenu;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.necromancy.EtherealEntityAttachment;
import dev.sterner.witchery.network.SyncSoulTradeDataS2CPayload;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u00016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0014J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0012\u0010\u0017\u001a\u00020\u0010*\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a*\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0018J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0016J(\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020.H\u0014J\u0010\u0010/\u001a\u00020.2\u0006\u00100\u001a\u000201H\u0014J\b\u00102\u001a\u00020.H\u0014J\b\u00103\u001a\u000204H\u0014J\b\u00105\u001a\u00020\rH\u0014R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u00067"}, d2={"Ldev/sterner/witchery/content/entity/ImpEntity;", "Lnet/minecraft/world/entity/PathfinderMob;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "tradingPlayer", "Lnet/minecraft/world/entity/player/Player;", "getTradingPlayer", "()Lnet/minecraft/world/entity/player/Player;", "setTradingPlayer", "(Lnet/minecraft/world/entity/player/Player;)V", "isOnFire", "", "fireImmune", "baseTick", "", "registerGoals", "mobInteract", "Lnet/minecraft/world/InteractionResult;", "player", "hand", "Lnet/minecraft/world/InteractionHand;", "openTradingMenu", "Lnet/minecraft/server/level/ServerPlayer;", "findNearbySouls", "", "Ldev/sterner/witchery/content/menu/SoulTradingMenu$SoulData;", "calculateSoulWeight", "", "entityType", "", "createNavigation", "Lnet/minecraft/world/entity/ai/navigation/PathNavigation;", "travel", "travelVector", "Lnet/minecraft/world/phys/Vec3;", "checkFallDamage", "y", "", "onGround", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "pos", "Lnet/minecraft/core/BlockPos;", "getAmbientSound", "Lnet/minecraft/sounds/SoundEvent;", "getHurtSound", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "getDeathSound", "getSoundVolume", "", "isFlapping", "Companion", "witchery"})
public final class ImpEntity
extends PathfinderMob {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Player tradingPlayer;

    public ImpEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getIMP().get(), level);
        this.moveControl = (MoveControl)new FlyingMoveControl((Mob)this, 20, true);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
    }

    @Nullable
    public final Player getTradingPlayer() {
        return this.tradingPlayer;
    }

    public final void setTradingPlayer(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    public void baseTick() {
        super.baseTick();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new TradeWithPlayerGoal(this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new LookAtTradingPlayerGoal(this));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        super.registerGoals();
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (!this.level().isClientSide) {
            this.tradingPlayer = player;
            this.openTradingMenu(this, (ServerPlayer)player);
        }
        InteractionResult interactionResult = super.mobInteract(player, hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"mobInteract(...)");
        return interactionResult;
    }

    public final void openTradingMenu(@NotNull ImpEntity $this$openTradingMenu, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$openTradingMenu), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ImpEntity imp = this;
        player.openMenu(new MenuProvider($this$openTradingMenu, imp){
            final /* synthetic */ ImpEntity $this_openTradingMenu;
            final /* synthetic */ ImpEntity $imp;
            {
                this.$this_openTradingMenu = $receiver;
                this.$imp = $imp;
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
                Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.writeInt(this.$this_openTradingMenu.getId());
                SoulTradingMenu menu = new SoulTradingMenu(containerId, inventory, buf, this.$imp);
                List<SoulTradingMenu.SoulTrade> trades = ImpEntity.Companion.getAvailableTrades();
                List<SoulTradingMenu.SoulData> souls = this.$this_openTradingMenu.findNearbySouls(this.$this_openTradingMenu, (ServerPlayer)player);
                menu.setTrades(trades);
                menu.setSouls(souls);
                this.$imp.setTradingPlayer(player);
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new SyncSoulTradeDataS2CPayload(trades, souls, CollectionsKt.emptyList(), -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return menu;
            }

            public Component getDisplayName() {
                MutableComponent mutableComponent = Component.translatable((String)"container.witchery.soul_trade_menu");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                return (Component)mutableComponent;
            }
        }, arg_0 -> ImpEntity.openTradingMenu$lambda$0($this$openTradingMenu, arg_0));
    }

    @NotNull
    public final List<SoulTradingMenu.SoulData> findNearbySouls(@NotNull ImpEntity $this$findNearbySouls, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$findNearbySouls), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ServerLevel level = player.serverLevel();
        List souls = new ArrayList();
        double searchRadius = 16.0;
        BlockPos playerPos = player.blockPosition();
        AABB searchBox = new AABB(playerPos).inflate(searchRadius);
        List entities = level.getEntitiesOfClass(LivingEntity.class, searchBox, arg_0 -> ImpEntity.findNearbySouls$lambda$1(ImpEntity::findNearbySouls$lambda$0, arg_0));
        for (LivingEntity entity : entities) {
            String entityType;
            Intrinsics.checkNotNullExpressionValue((Object)entity.getType().toString(), (String)"toString(...)");
            souls.add(new SoulTradingMenu.SoulData(entity.getId(), $this$findNearbySouls.calculateSoulWeight(entityType), entityType, false));
        }
        BlockPos minPos = new BlockPos(playerPos.getX() - (int)searchRadius, playerPos.getY() - (int)searchRadius, playerPos.getZ() - (int)searchRadius);
        BlockPos maxPos = new BlockPos(playerPos.getX() + (int)searchRadius, playerPos.getY() + (int)searchRadius, playerPos.getZ() + (int)searchRadius);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos)) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            SoulCageBlockEntity blockEntity2 = blockEntity instanceof SoulCageBlockEntity ? (SoulCageBlockEntity)blockEntity : null;
            if (blockEntity2 == null || !blockEntity2.getHasSoul()) continue;
            souls.add(new SoulTradingMenu.SoulData((int)pos.asLong(), $this$findNearbySouls.calculateSoulWeight("villager"), "minecraft:villager", true));
        }
        return souls;
    }

    public final int calculateSoulWeight(@NotNull String entityType) {
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        return StringsKt.contains((CharSequence)entityType, (CharSequence)"villager", (boolean)true) ? 200 : (StringsKt.contains((CharSequence)entityType, (CharSequence)"pillager", (boolean)true) ? 100 : (StringsKt.contains((CharSequence)entityType, (CharSequence)"vindicator", (boolean)true) ? 100 : 50));
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, level);
        flyingPathNavigation.setCanOpenDoors(false);
        flyingPathNavigation.setCanFloat(true);
        flyingPathNavigation.setCanPassDoors(true);
        return (PathNavigation)flyingPathNavigation;
    }

    public void travel(@NotNull Vec3 travelVector) {
        Intrinsics.checkNotNullParameter((Object)travelVector, (String)"travelVector");
        if (this.isControlledByLocalInstance()) {
            if (this.isInWater()) {
                this.moveRelative(0.02f, travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
            } else if (this.isInLava()) {
                this.moveRelative(0.02f, travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            } else {
                this.moveRelative(this.getSpeed(), travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.91f));
            }
        }
        this.calculateEntityAnimation(false);
    }

    protected void checkFallDamage(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
    }

    @NotNull
    protected SoundEvent getAmbientSound() {
        SoundEvent soundEvent;
        if (this.hasItemInSlot(EquipmentSlot.MAINHAND)) {
            SoundEvent soundEvent2 = SoundEvents.ALLAY_AMBIENT_WITH_ITEM;
            soundEvent = soundEvent2;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent2, (String)"ALLAY_AMBIENT_WITH_ITEM");
        } else {
            SoundEvent soundEvent3 = SoundEvents.ALLAY_AMBIENT_WITHOUT_ITEM;
            soundEvent = soundEvent3;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent3, (String)"ALLAY_AMBIENT_WITHOUT_ITEM");
        }
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        SoundEvent soundEvent = SoundEvents.ALLAY_HURT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"ALLAY_HURT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        SoundEvent soundEvent = SoundEvents.ALLAY_DEATH;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"ALLAY_DEATH");
        return soundEvent;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    protected boolean isFlapping() {
        return !this.onGround();
    }

    private static final void openTradingMenu$lambda$0(ImpEntity $this_openTradingMenu, RegistryFriendlyByteBuf buf) {
        buf.writeInt($this_openTradingMenu.getId());
    }

    private static final boolean findNearbySouls$lambda$0(LivingEntity entity) {
        return entity != null && EtherealEntityAttachment.getData(entity).isEthereal();
    }

    private static final boolean findNearbySouls$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/content/entity/ImpEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "getAvailableTrades", "", "Ldev/sterner/witchery/content/menu/SoulTradingMenu$SoulTrade;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = PathfinderMob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FLYING_SPEED, (double)0.1f).add(Attributes.MOVEMENT_SPEED, (double)0.1f).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 48.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final List<SoulTradingMenu.SoulTrade> getAvailableTrades() {
            Object[] objectArray = new SoulTradingMenu.SoulTrade[7];
            objectArray[0] = new SoulTradingMenu.SoulTrade(new ItemStack((ItemLike)WitcheryItems.INSTANCE.getDEMON_HEART().get()), 200);
            ItemStack itemStack = ((Item)WitcheryItems.INSTANCE.getTOE_OF_FROG().get()).getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
            objectArray[1] = new SoulTradingMenu.SoulTrade(itemStack, 50);
            ItemStack itemStack2 = ((Item)WitcheryItems.INSTANCE.getWOOL_OF_BAT().get()).getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getDefaultInstance(...)");
            objectArray[2] = new SoulTradingMenu.SoulTrade(itemStack2, 60);
            ItemStack itemStack3 = ((Item)WitcheryItems.INSTANCE.getTONGUE_OF_DOG().get()).getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"getDefaultInstance(...)");
            objectArray[3] = new SoulTradingMenu.SoulTrade(itemStack3, 50);
            ItemStack itemStack4 = ((Item)WitcheryItems.INSTANCE.getOWLETS_WING().get()).getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"getDefaultInstance(...)");
            objectArray[4] = new SoulTradingMenu.SoulTrade(itemStack4, 80);
            ItemStack itemStack5 = ((EntTwigItem)((Object)WitcheryItems.INSTANCE.getENT_TWIG().get())).getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack5, (String)"getDefaultInstance(...)");
            objectArray[5] = new SoulTradingMenu.SoulTrade(itemStack5, 90);
            ItemStack itemStack6 = ((Item)WitcheryItems.INSTANCE.getDEMONS_BLOOD().get()).getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack6, (String)"getDefaultInstance(...)");
            objectArray[6] = new SoulTradingMenu.SoulTrade(itemStack6, 100);
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

