/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity.goal;

import dev.sterner.witchery.core.data.BloodPoolReloadListener;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/content/entity/goal/DrinkBloodTargetingGoal;", "T", "Lnet/minecraft/world/entity/LivingEntity;", "Lnet/minecraft/world/entity/ai/goal/target/NearestAttackableTargetGoal;", "mob", "Lnet/minecraft/world/entity/Mob;", "targetClass", "Ljava/lang/Class;", "checkVisibility", "", "<init>", "(Lnet/minecraft/world/entity/Mob;Ljava/lang/Class;Z)V", "canUse", "findTarget", "", "witchery"})
public final class DrinkBloodTargetingGoal<T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    public DrinkBloodTargetingGoal(@NotNull Mob mob, @NotNull Class<T> targetClass, boolean checkVisibility) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        super(mob, targetClass, checkVisibility);
    }

    public boolean canUse() {
        Mob mob = this.mob;
        Intrinsics.checkNotNullExpressionValue((Object)mob, (String)"mob");
        BloodPoolLivingEntityAttachment.Data bloodPool = BloodPoolLivingEntityAttachment.getData((LivingEntity)mob);
        if (bloodPool.getBloodPool() == bloodPool.getMaxBlood()) {
            return false;
        }
        return super.canUse();
    }

    protected void findTarget() {
        if (!Intrinsics.areEqual((Object)this.targetType, Player.class) && !Intrinsics.areEqual((Object)this.targetType, ServerPlayer.class)) {
            List entities = this.mob.level().getEntitiesOfClass(this.targetType, this.getTargetSearchArea(this.getFollowDistance()), arg_0 -> DrinkBloodTargetingGoal.findTarget$lambda$1(DrinkBloodTargetingGoal::findTarget$lambda$0, arg_0));
            this.target = this.mob.level().getNearestEntity(entities, this.targetConditions, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
        }
        this.target = (LivingEntity)this.mob.level().getNearestPlayer(this.targetConditions, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
    }

    private static final boolean findTarget$lambda$0(LivingEntity it) {
        return BloodPoolReloadListener.INSTANCE.getBLOOD_PAIR().containsKey(((Entity)it).getType());
    }

    private static final boolean findTarget$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

