/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity.goal;

import dev.sterner.witchery.content.entity.DeathEntity;
import java.util.EnumSet;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u000bJ\b\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u001c\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/sterner/witchery/content/entity/goal/FocusSummonerGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "mob", "Lnet/minecraft/world/entity/Mob;", "focusDurationTicks", "", "<init>", "(Lnet/minecraft/world/entity/Mob;I)V", "summonerUUID", "Ljava/util/UUID;", "focusEndTime", "", "ticksWithoutTarget", "setSummoner", "", "summoner", "Lnet/minecraft/world/entity/LivingEntity;", "isFocusActive", "", "getRemainingFocusTime", "canUse", "canContinueToUse", "start", "tick", "stop", "getSummoner", "clearFocus", "attemptTeleportToSummoner", "onSummonerDeath", "witchery"})
public final class FocusSummonerGoal
extends Goal {
    @NotNull
    private final Mob mob;
    private final int focusDurationTicks;
    @Nullable
    private UUID summonerUUID;
    private long focusEndTime;
    private int ticksWithoutTarget;

    public FocusSummonerGoal(@NotNull Mob mob, int focusDurationTicks) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        this.mob = mob;
        this.focusDurationTicks = focusDurationTicks;
        this.setFlags(EnumSet.of((Enum)Goal.Flag.TARGET));
    }

    public /* synthetic */ FocusSummonerGoal(Mob mob, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1200;
        }
        this(mob, n);
    }

    public final void setSummoner(@NotNull LivingEntity summoner) {
        Intrinsics.checkNotNullParameter((Object)summoner, (String)"summoner");
        this.summonerUUID = summoner.getUUID();
        this.focusEndTime = this.mob.level().getGameTime() + (long)this.focusDurationTicks;
        this.ticksWithoutTarget = 0;
    }

    public final boolean isFocusActive() {
        return this.summonerUUID != null && this.mob.level().getGameTime() < this.focusEndTime;
    }

    public final long getRemainingFocusTime() {
        return this.isFocusActive() ? this.focusEndTime - this.mob.level().getGameTime() : 0L;
    }

    public boolean canUse() {
        if (!this.isFocusActive()) {
            return false;
        }
        LivingEntity summoner = this.getSummoner();
        return summoner != null && summoner.isAlive();
    }

    public boolean canContinueToUse() {
        if (!this.isFocusActive()) {
            return false;
        }
        LivingEntity summoner = this.getSummoner();
        if (summoner == null || !summoner.isAlive()) {
            this.clearFocus();
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.mob.level(), (Object)summoner.level())) {
            int n = this.ticksWithoutTarget;
            this.ticksWithoutTarget = n + 1;
            if (this.ticksWithoutTarget > 200) {
                this.clearFocus();
                return false;
            }
        } else {
            this.ticksWithoutTarget = 0;
        }
        return true;
    }

    public void start() {
        LivingEntity summoner = this.getSummoner();
        if (summoner != null) {
            this.mob.setTarget(summoner);
        }
    }

    public void tick() {
        double distanceSq;
        LivingEntity livingEntity = this.getSummoner();
        if (livingEntity == null) {
            return;
        }
        LivingEntity summoner = livingEntity;
        if (!Intrinsics.areEqual((Object)this.mob.getTarget(), (Object)summoner)) {
            this.mob.setTarget(summoner);
        }
        if (this.mob instanceof DeathEntity && !((DeathEntity)this.mob).getHasForcedTarget()) {
            ((DeathEntity)this.mob).setForcedTarget(summoner);
        }
        if (Intrinsics.areEqual((Object)this.mob.level(), (Object)summoner.level()) && (distanceSq = this.mob.distanceToSqr((Entity)summoner)) > 4096.0) {
            this.attemptTeleportToSummoner(summoner);
        }
    }

    public void stop() {
        if (this.mob instanceof DeathEntity) {
            ((DeathEntity)this.mob).setHasForcedTarget(false);
        }
    }

    private final LivingEntity getSummoner() {
        UUID uUID = this.summonerUUID;
        if (uUID == null) {
            return null;
        }
        UUID uuid = uUID;
        for (Player player : this.mob.level().players()) {
            if (!Intrinsics.areEqual((Object)player.getUUID(), (Object)uuid)) continue;
            return (LivingEntity)player;
        }
        return null;
    }

    private final void clearFocus() {
        this.summonerUUID = null;
        this.focusEndTime = 0L;
        if (this.mob instanceof DeathEntity) {
            ((DeathEntity)this.mob).setHasForcedTarget(false);
        }
    }

    private final void attemptTeleportToSummoner(LivingEntity summoner) {
        if (!(this.mob instanceof DeathEntity)) {
            return;
        }
        Mob mob = this.mob;
        Intrinsics.checkNotNull((Object)mob, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.entity.DeathEntity");
        DeathEntity death = (DeathEntity)mob;
        RandomSource random = ((DeathEntity)this.mob).getRandom();
        for (int i = 0; i < 10; ++i) {
            double angle = random.nextDouble() * Math.PI * (double)2;
            double distance = 5.0 + random.nextDouble() * 10.0;
            double x = summoner.getX() + Math.cos(angle) * distance;
            double z = summoner.getZ() + Math.sin(angle) * distance;
            double y = summoner.getY();
            death.teleportTo(x, y, z);
            if (this.mob.distanceToSqr((Entity)summoner) < 1024.0) break;
        }
    }

    public final void onSummonerDeath() {
        this.clearFocus();
    }
}

