/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity.goal;

import dev.sterner.witchery.content.entity.CovenWitchEntity;
import java.util.EnumSet;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/content/entity/goal/LookAtPosGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "witch", "Ldev/sterner/witchery/content/entity/CovenWitchEntity;", "<init>", "(Ldev/sterner/witchery/content/entity/CovenWitchEntity;)V", "canUse", "", "canContinueToUse", "requiresUpdateEveryTick", "tick", "", "witchery"})
public final class LookAtPosGoal
extends Goal {
    @NotNull
    private final CovenWitchEntity witch;

    public LookAtPosGoal(@NotNull CovenWitchEntity witch) {
        Intrinsics.checkNotNullParameter((Object)((Object)witch), (String)"witch");
        this.witch = witch;
        this.setFlags(EnumSet.of((Enum)Goal.Flag.MOVE, (Enum)Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.witch.getLastRitualPos().isPresent();
    }

    public boolean canContinueToUse() {
        return this.witch.getLastRitualPos().isPresent();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        Optional<BlockPos> pos = this.witch.getLastRitualPos();
        if (pos.isPresent()) {
            this.witch.getLookControl().setLookAt((double)pos.get().getX() + 0.5, (double)pos.get().getY() + 0.5, (double)pos.get().getZ() + 0.5);
        }
    }
}

