/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.client.tooltip.BloodPoolComponent;
import dev.sterner.witchery.core.data.BloodPoolReloadListener;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.blood.BloodPoolHandler;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J \u0010 \u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u001aH\u0016J&\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150#2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0013H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u0018\u001a\u00020\u0015H\u0016\u00a8\u0006)"}, d2={"Ldev/sterner/witchery/content/item/CaneSwordItem;", "Lnet/minecraft/world/item/SwordItem;", "tier", "Lnet/minecraft/world/item/Tier;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Tier;Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "transformCane", "", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "getUseDuration", "", "stack", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "getDrinkingSound", "Lnet/minecraft/sounds/SoundEvent;", "getEatingSound", "finishUsingItem", "livingEntity", "use", "Lnet/minecraft/world/InteractionResultHolder;", "usedHand", "getTooltipImage", "Ljava/util/Optional;", "Lnet/minecraft/world/inventory/tooltip/TooltipComponent;", "Companion", "witchery"})
public final class CaneSwordItem
extends SwordItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MAX_STORED_BLOOD = 600;

    public CaneSwordItem(@NotNull Tier tier, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)tier, (String)"tier");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(tier, properties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        if (player != null) {
            Intrinsics.checkNotNull((Object)level);
            Intrinsics.checkNotNull((Object)hand);
            ItemStack itemStack = player.getMainHandItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            this.transformCane(level, player, hand, itemStack);
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.useOn(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }

    private final void transformCane(Level level, Player player, InteractionHand hand, ItemStack itemStack) {
        if (!level.isClientSide && !player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND) {
            ItemStack item = itemStack.copy();
            item.remove(DataComponents.ATTRIBUTE_MODIFIERS);
            if (itemStack.has((DataComponentType)WitcheryDataComponents.INSTANCE.getUNSHEETED().get())) {
                Object object = itemStack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getUNSHEETED().get());
                Intrinsics.checkNotNull((Object)object);
                boolean unsheeted = (Boolean)object;
                item.set((DataComponentType)WitcheryDataComponents.INSTANCE.getUNSHEETED().get(), (Object)(!unsheeted ? 1 : 0));
                if (!unsheeted) {
                    item.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)SwordItem.createAttributes((Tier)((Tier)Tiers.IRON), (int)4, (float)-2.4f));
                }
            } else {
                item.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)SwordItem.createAttributes((Tier)((Tier)Tiers.IRON), (int)4, (float)-2.4f));
                item.set((DataComponentType)WitcheryDataComponents.INSTANCE.getUNSHEETED().get(), (Object)true);
            }
            player.setItemInHand(InteractionHand.MAIN_HAND, item);
        }
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 40;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.DRINK;
    }

    @NotNull
    public SoundEvent getDrinkingSound() {
        SoundEvent soundEvent = SoundEvents.HONEY_DRINK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"HONEY_DRINK");
        return soundEvent;
    }

    @NotNull
    public SoundEvent getEatingSound() {
        SoundEvent soundEvent = SoundEvents.HONEY_DRINK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"HONEY_DRINK");
        return soundEvent;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        super.finishUsingItem(stack, level, livingEntity);
        if (livingEntity instanceof ServerPlayer) {
            int currentBlood;
            BloodPoolLivingEntityAttachment.Data playerBloodPool;
            int maxBlood;
            int transferableBlood;
            int storedBlood;
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)livingEntity, stack);
            ((ServerPlayer)livingEntity).awardStat(Stats.ITEM_USED.get((Object)this));
            Integer n = (Integer)stack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getCANE_BLOOD_AMOUNT().get());
            int n2 = storedBlood = n != null ? n : 0;
            if (storedBlood > 0 && (transferableBlood = Math.min(storedBlood, (maxBlood = (playerBloodPool = BloodPoolLivingEntityAttachment.getData(livingEntity)).getMaxBlood()) - (currentBlood = playerBloodPool.getBloodPool()))) > 0) {
                BloodPoolHandler.increaseBlood(livingEntity, transferableBlood);
                stack.set((DataComponentType)WitcheryDataComponents.INSTANCE.getCANE_BLOOD_AMOUNT().get(), (Object)(storedBlood - transferableBlood));
                return stack;
            }
        }
        return stack;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        Integer n = (Integer)player.getMainHandItem().get((DataComponentType)WitcheryDataComponents.INSTANCE.getCANE_BLOOD_AMOUNT().get());
        if ((n != null ? n : 0) > 0 && !Intrinsics.areEqual((Object)player.getMainHandItem().get((DataComponentType)WitcheryDataComponents.INSTANCE.getUNSHEETED().get()), (Object)true) && player.isShiftKeyDown()) {
            InteractionResultHolder interactionResultHolder = ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"startUsingInstantly(...)");
            return interactionResultHolder;
        }
        if (!player.isShiftKeyDown()) {
            ItemStack itemStack = player.getMainHandItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            this.transformCane(level, player, usedHand, itemStack);
        }
        InteractionResultHolder interactionResultHolder = super.use(level, player, usedHand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
        return interactionResultHolder;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Optional<TooltipComponent> optional = Optional.of(new BloodPoolComponent(stack));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/content/item/CaneSwordItem$Companion;", "", "<init>", "()V", "MAX_STORED_BLOOD", "", "harvestBlood", "", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final void harvestBlood(@Nullable LivingEntity livingEntity, @Nullable DamageSource damageSource) {
            if (livingEntity != null && BloodPoolReloadListener.INSTANCE.getBLOOD_PAIR().containsKey(livingEntity.getType())) {
                DamageSource damageSource2 = damageSource;
                if ((damageSource2 != null ? damageSource2.getEntity() : null) instanceof Player) {
                    Entity entity = damageSource.getEntity();
                    Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
                    Player player = (Player)entity;
                    if (player.getMainHandItem().is((Item)WitcheryItems.INSTANCE.getCANE_SWORD().get())) {
                        ItemStack cane = player.getMainHandItem().copy();
                        BloodPoolReloadListener.BloodData bloodData = BloodPoolReloadListener.INSTANCE.getBLOOD_PAIR().get(livingEntity.getType());
                        Intrinsics.checkNotNull((Object)bloodData);
                        int drops = bloodData.getBloodDrops();
                        int absorbedAmount = drops * 300 / 20;
                        Integer n = (Integer)cane.get((DataComponentType)WitcheryDataComponents.INSTANCE.getCANE_BLOOD_AMOUNT().get());
                        int oldBloodValue = n != null ? n : 0;
                        int finalValue = Math.min(oldBloodValue + absorbedAmount, 600);
                        cane.set((DataComponentType)WitcheryDataComponents.INSTANCE.getCANE_BLOOD_AMOUNT().get(), (Object)finalValue);
                        player.setItemInHand(InteractionHand.MAIN_HAND, cane);
                    }
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

