/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.content.entity.CustomBoat;
import dev.sterner.witchery.content.entity.CustomChestBoat;
import dev.sterner.witchery.content.item.CustomBoatItem;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Ldev/sterner/witchery/content/item/CustomBoatItem;", "Lnet/minecraft/world/item/BoatItem;", "chest", "", "type", "Lnet/minecraft/world/entity/vehicle/Boat$Type;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(ZLnet/minecraft/world/entity/vehicle/Boat$Type;Lnet/minecraft/world/item/Item$Properties;)V", "getChest", "()Z", "getType", "()Lnet/minecraft/world/entity/vehicle/Boat$Type;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "interactionHand", "Lnet/minecraft/world/InteractionHand;", "getBoat", "Lnet/minecraft/world/entity/vehicle/Boat;", "hitResult", "Lnet/minecraft/world/phys/HitResult;", "itemStack", "Companion", "witchery"})
public final class CustomBoatItem
extends BoatItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean chest;
    @NotNull
    private final Boat.Type type;
    @NotNull
    private static final Predicate<Entity> ENTITY_PREDICATE;

    public CustomBoatItem(boolean chest, @NotNull Boat.Type type, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(chest, type, properties);
        this.chest = chest;
        this.type = type;
    }

    public final boolean getChest() {
        return this.chest;
    }

    @NotNull
    public final Boat.Type getType() {
        return this.type;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        ItemStack itemStack = player.getItemInHand(interactionHand);
        BlockHitResult blockHitResult = BoatItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"getPlayerPOVHitResult(...)");
        HitResult hitResult = (HitResult)blockHitResult;
        if (hitResult.getType() == HitResult.Type.MISS) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)itemStack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
            return interactionResultHolder;
        }
        Vec3 vec3 = player.getViewVector(1.0f);
        List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(vec3.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        Intrinsics.checkNotNull((Object)list);
        if (!((Collection)list).isEmpty()) {
            Vec3 vec32 = player.getEyePosition();
            for (Object e : list) {
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type net.minecraft.world.entity.Entity");
                Entity entity = (Entity)e;
                AABB aABB = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!aABB.contains(vec32)) continue;
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)itemStack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
                return interactionResultHolder;
            }
        }
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            Intrinsics.checkNotNull((Object)itemStack);
            Boat boat = this.getBoat(level, hitResult, itemStack, player);
            boat.setVariant(this.type);
            boat.setYRot(player.getYRot());
            if (!level.noCollision((Entity)boat, boat.getBoundingBox())) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)itemStack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                return interactionResultHolder;
            }
            if (!level.isClientSide) {
                level.addFreshEntity((Entity)boat);
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, hitResult.getLocation());
                itemStack.consume(1, (LivingEntity)player);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
        return interactionResultHolder;
    }

    private final Boat getBoat(Level level, HitResult hitResult, ItemStack itemStack, Player player) {
        Boat boat;
        Vec3 vec3 = hitResult.getLocation();
        Boat boat2 = boat = this.chest ? (Boat)new CustomChestBoat(level, vec3.x, vec3.y, vec3.z) : (Boat)new CustomBoat(level, vec3.x, vec3.y, vec3.z);
        if (level instanceof ServerLevel) {
            EntityType.createDefaultStackConfig((ServerLevel)((ServerLevel)level), (ItemStack)itemStack, (Player)player).accept(boat);
        }
        return boat;
    }

    private static final boolean ENTITY_PREDICATE$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Predicate<Object> predicate = EntitySelector.NO_SPECTATORS.and(arg_0 -> CustomBoatItem.ENTITY_PREDICATE$lambda$0(Companion.ENTITY_PREDICATE.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"and(...)");
        ENTITY_PREDICATE = predicate;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/content/item/CustomBoatItem$Companion;", "", "<init>", "()V", "ENTITY_PREDICATE", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/entity/Entity;", "getENTITY_PREDICATE", "()Ljava/util/function/Predicate;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Predicate<Entity> getENTITY_PREDICATE() {
            return ENTITY_PREDICATE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

