/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.content.block.poppet.PoppetBlockEntity;
import dev.sterner.witchery.content.item.TaglockItem;
import dev.sterner.witchery.core.api.WitcheryApi;
import java.awt.Color;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\rH\u0016J.\u0010\u001e\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$H\u0016\u00a8\u0006%"}, d2={"Ldev/sterner/witchery/content/item/PoppetItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "isDamageable", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "calculateHitResult", "Lnet/minecraft/world/phys/HitResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "getUseDuration", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "releaseUsing", "", "level", "Lnet/minecraft/world/level/Level;", "livingEntity", "timeCharged", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "appendHoverText", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "witchery"})
@SourceDebugExtension(value={"SMAP\nPoppetItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoppetItem.kt\ndev/sterner/witchery/content/item/PoppetItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public class PoppetItem
extends Item {
    public PoppetItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties.stacksTo(1));
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Player player = context.getPlayer();
        if (player != null && this.calculateHitResult(player).getType() == HitResult.Type.BLOCK) {
            player.startUsingItem(context.getHand());
        }
        return InteractionResult.CONSUME;
    }

    public boolean isDamageable(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return true;
    }

    private final HitResult calculateHitResult(Player player) {
        HitResult hitResult = ProjectileUtil.getHitResultOnViewVector((Entity)((Entity)player), PoppetItem::calculateHitResult$lambda$0, (double)player.blockInteractionRange());
        Intrinsics.checkNotNullExpressionValue((Object)hitResult, (String)"getHitResultOnViewVector(...)");
        return hitResult;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 2000;
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity, int timeCharged) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        super.releaseUsing(stack, level, livingEntity, timeCharged);
        if (livingEntity instanceof Player && timeCharged > 40) {
            Vec3 dir = livingEntity.getViewVector(0.0f);
            Vec3 eyePos = livingEntity.getEyePosition(0.0f);
            Vec3 rayEnd = eyePos.add(dir.scale(5.0));
            BlockHitResult blockHitResult = level.clip(new ClipContext(eyePos, rayEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity));
            Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"clip(...)");
            BlockHitResult result = blockHitResult;
            if (result.getDirection().getAxis().isHorizontal()) {
                WitcheryApi.INSTANCE.makePlayerWitchy((Player)livingEntity);
                BlockPos blockPos = result.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                Player player = (Player)livingEntity;
                Direction direction = result.getDirection();
                Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"getDirection(...)");
                PoppetBlockEntity.Companion.placePoppet(level, blockPos, player, direction);
            }
        }
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    /*
     * WARNING - void declaration
     */
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        ResolvableProfile player = TaglockItem.Companion.getPlayerProfile(stack);
        String living = TaglockItem.Companion.getLivingEntityName(stack);
        if (player != null) {
            String string;
            List<Component> list = tooltipComponents;
            String string2 = player.gameProfile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String string3 = string2;
            if (((CharSequence)string3).length() > 0) {
                void p0;
                char c = string3.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                List<Component> list2 = list;
                boolean bl = false;
                String string4 = String.valueOf((char)p0);
                Intrinsics.checkNotNull((Object)string4, (String)"null cannot be cast to non-null type java.lang.String");
                String string5 = string4.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                String string6 = string5;
                list = list2;
                StringBuilder stringBuilder2 = stringBuilder.append((Object)string6);
                String string7 = string3;
                int n = 1;
                String string8 = string7.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
                string = stringBuilder2.append(string8).toString();
            } else {
                string = string3;
            }
            MutableComponent mutableComponent = Component.literal((String)string).setStyle(Style.EMPTY.withColor(new Color(255, 2, 100).getRGB()));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"setStyle(...)");
            list.add((Component)mutableComponent);
        } else if (living != null) {
            MutableComponent mutableComponent = Component.translatable((String)living).setStyle(Style.EMPTY.withColor(new Color(255, 100, 100).getRGB()));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"setStyle(...)");
            tooltipComponents.add((Component)mutableComponent);
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    private static final boolean calculateHitResult$lambda$0(Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return !entity.isSpectator() && entity.isPickable();
    }
}

