/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/content/item/WaterCropBlockItem;", "Lnet/minecraft/world/item/ItemNameBlockItem;", "cropBlock", "Lnet/minecraft/world/level/block/Block;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/level/block/Block;Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "witchery"})
public final class WaterCropBlockItem
extends ItemNameBlockItem {
    @NotNull
    private final Block cropBlock;

    public WaterCropBlockItem(@NotNull Block cropBlock, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)cropBlock, (String)"cropBlock");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(cropBlock, properties);
        this.cropBlock = cropBlock;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player != null) {
            BlockHitResult blockHitResult = ItemNameBlockItem.getPlayerPOVHitResult((Level)context.getLevel(), (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            BlockPos blockPos = blockHitResult.getBlockPos();
            Direction direction = blockHitResult.getDirection();
            BlockPos blockPos2 = blockPos.relative(direction);
            if (level.getBlockState(blockPos).is(Blocks.WATER) && level.getBlockState(blockPos2).is(Blocks.AIR)) {
                context.getLevel().setBlockAndUpdate(blockPos2, this.cropBlock.defaultBlockState());
                if (context.getPlayer() != null) {
                    Player player2 = context.getPlayer();
                    Intrinsics.checkNotNull((Object)player2);
                    if (!player2.isCreative()) {
                        context.getItemInHand().shrink(1);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        InteractionResult interactionResult = super.useOn(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }
}

