/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.api;

import dev.sterner.witchery.features.misc.InventoryLockPlayerAttachment;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\"\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ldev/sterner/witchery/core/api/InventorySlots;", "", "<init>", "()V", "HOTBAR_START", "", "HOTBAR_END", "MAIN_START", "MAIN_END", "BOOTS", "LEGGINGS", "CHESTPLATE", "HELMET", "OFFHAND", "lockHotbar", "", "player", "Lnet/minecraft/world/entity/player/Player;", "lockArmor", "lockMainInventory", "lockAllExceptHotbar", "lockAll", "unlockHotbar", "unlockArmor", "unlockMainInventory", "unlockAllExceptHotbar", "unlockAll", "toggleHotbar", "toggleArmor", "toggleMainInventory", "isHotbarLocked", "", "isArmorLocked", "isMainInventoryLocked", "getLockedSlotsCount", "witchery"})
@SourceDebugExtension(value={"SMAP\nInventorySlots.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InventorySlots.kt\ndev/sterner/witchery/core/api/InventorySlots\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1761#2,3:123\n1761#2,3:126\n1761#2,3:129\n1740#2,3:132\n1740#2,3:135\n1740#2,3:138\n*S KotlinDebug\n*F\n+ 1 InventorySlots.kt\ndev/sterner/witchery/core/api/InventorySlots\n*L\n76#1:123,3\n86#1:126,3\n96#1:129,3\n106#1:132,3\n111#1:135,3\n116#1:138,3\n*E\n"})
public final class InventorySlots {
    @NotNull
    public static final InventorySlots INSTANCE = new InventorySlots();
    public static final int HOTBAR_START = 0;
    public static final int HOTBAR_END = 8;
    public static final int MAIN_START = 9;
    public static final int MAIN_END = 35;
    public static final int BOOTS = 36;
    public static final int LEGGINGS = 37;
    public static final int CHESTPLATE = 38;
    public static final int HELMET = 39;
    public static final int OFFHAND = 40;

    private InventorySlots() {
    }

    public final void lockHotbar(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Set slots = CollectionsKt.toSet((Iterable)((Iterable)new IntRange(0, 8)));
        InventoryLockPlayerAttachment.INSTANCE.lockSlots(player, slots);
    }

    public final void lockArmor(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object[] objectArray = new Integer[]{36, 37, 38, 39};
        Set slots = SetsKt.setOf((Object[])objectArray);
        InventoryLockPlayerAttachment.INSTANCE.lockSlots(player, slots);
    }

    public final void lockMainInventory(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Set slots = CollectionsKt.toSet((Iterable)((Iterable)new IntRange(9, 35)));
        InventoryLockPlayerAttachment.INSTANCE.lockSlots(player, slots);
    }

    public final void lockAllExceptHotbar(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object[] objectArray = new Integer[]{36, 37, 38, 39, 40};
        Set slots = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Iterable)((Iterable)new IntRange(9, 35)), (Iterable)CollectionsKt.listOf((Object[])objectArray)));
        InventoryLockPlayerAttachment.INSTANCE.lockSlots(player, slots);
    }

    public final void lockAll(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Set slots = CollectionsKt.toSet((Iterable)((Iterable)new IntRange(0, 40)));
        InventoryLockPlayerAttachment.INSTANCE.lockSlots(player, slots);
    }

    public final void unlockHotbar(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Set slots = CollectionsKt.toSet((Iterable)((Iterable)new IntRange(0, 8)));
        InventoryLockPlayerAttachment.INSTANCE.unlockSlots(player, slots);
    }

    public final void unlockArmor(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object[] objectArray = new Integer[]{36, 37, 38, 39};
        Set slots = SetsKt.setOf((Object[])objectArray);
        InventoryLockPlayerAttachment.INSTANCE.unlockSlots(player, slots);
    }

    public final void unlockMainInventory(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Set slots = CollectionsKt.toSet((Iterable)((Iterable)new IntRange(9, 35)));
        InventoryLockPlayerAttachment.INSTANCE.unlockSlots(player, slots);
    }

    public final void unlockAllExceptHotbar(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object[] objectArray = new Integer[]{36, 37, 38, 39, 40};
        Set slots = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Iterable)((Iterable)new IntRange(9, 35)), (Iterable)CollectionsKt.listOf((Object[])objectArray)));
        InventoryLockPlayerAttachment.INSTANCE.unlockSlots(player, slots);
    }

    public final void unlockAll(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        InventoryLockPlayerAttachment.INSTANCE.unlockAllSlots(player);
    }

    public final void toggleHotbar(@NotNull Player player) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            InventoryLockPlayerAttachment.Data data2 = InventoryLockPlayerAttachment.getData(player);
            Set hotbarSlots = CollectionsKt.toSet((Iterable)((Iterable)new IntRange(0, 8)));
            Iterable $this$any$iv = hotbarSlots;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (!data2.getLockedSlots().contains(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            this.unlockHotbar(player);
        } else {
            this.lockHotbar(player);
        }
    }

    public final void toggleArmor(@NotNull Player player) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            InventoryLockPlayerAttachment.Data data2 = InventoryLockPlayerAttachment.getData(player);
            Object[] objectArray = new Integer[]{36, 37, 38, 39};
            Set armorSlots = SetsKt.setOf((Object[])objectArray);
            Iterable $this$any$iv = armorSlots;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (!data2.getLockedSlots().contains(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            this.unlockArmor(player);
        } else {
            this.lockArmor(player);
        }
    }

    public final void toggleMainInventory(@NotNull Player player) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            InventoryLockPlayerAttachment.Data data2 = InventoryLockPlayerAttachment.getData(player);
            Set mainSlots = CollectionsKt.toSet((Iterable)((Iterable)new IntRange(9, 35)));
            Iterable $this$any$iv = mainSlots;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (!data2.getLockedSlots().contains(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            this.unlockMainInventory(player);
        } else {
            this.lockMainInventory(player);
        }
    }

    public final boolean isHotbarLocked(@NotNull Player player) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            InventoryLockPlayerAttachment.Data data2 = InventoryLockPlayerAttachment.getData(player);
            Iterable $this$all$iv = (Iterable)new IntRange(0, 8);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (data2.getLockedSlots().contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean isArmorLocked(@NotNull Player player) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            InventoryLockPlayerAttachment.Data data2 = InventoryLockPlayerAttachment.getData(player);
            Object[] objectArray = new Integer[]{36, 37, 38, 39};
            Iterable $this$all$iv = SetsKt.setOf((Object[])objectArray);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (data2.getLockedSlots().contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean isMainInventoryLocked(@NotNull Player player) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            InventoryLockPlayerAttachment.Data data2 = InventoryLockPlayerAttachment.getData(player);
            Iterable $this$all$iv = (Iterable)new IntRange(9, 35);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (data2.getLockedSlots().contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final int getLockedSlotsCount(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return InventoryLockPlayerAttachment.getData(player).getLockedSlots().size();
    }
}

