/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.api;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.item.potion.WitcheryPotionIngredient;
import dev.sterner.witchery.core.world.WitcheryWorldState;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016JH\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ(\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"Ldev/sterner/witchery/core/api/SpecialPotion;", "", "id", "Lnet/minecraft/resources/ResourceLocation;", "<init>", "(Lnet/minecraft/resources/ResourceLocation;)V", "", "(Ljava/lang/String;)V", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "onDrunk", "", "level", "Lnet/minecraft/world/level/Level;", "owner", "Lnet/minecraft/world/entity/LivingEntity;", "duration", "", "amplifier", "onActivated", "Lnet/minecraft/world/entity/Entity;", "hitResult", "Lnet/minecraft/world/phys/HitResult;", "list", "", "mergedDispersalModifier", "Ldev/sterner/witchery/content/item/potion/WitcheryPotionIngredient$DispersalModifier;", "getBox", "Lnet/minecraft/world/phys/AABB;", "partLiquidFor", "box", "fluid", "Lnet/minecraft/world/level/material/Fluid;", "seconds", "witchery"})
public class SpecialPotion {
    @NotNull
    private final ResourceLocation id;

    public SpecialPotion(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
    }

    @NotNull
    public final ResourceLocation getId() {
        return this.id;
    }

    public SpecialPotion(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResourceLocation resourceLocation = Witchery.Companion.id(id);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        this(resourceLocation);
    }

    public void onDrunk(@NotNull Level level, @Nullable LivingEntity owner, int duration, int amplifier) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
    }

    public void onActivated(@NotNull Level level, @Nullable Entity owner, @NotNull HitResult hitResult, @NotNull List<Entity> list, @NotNull WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier, int duration, int amplifier) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
    }

    @NotNull
    public final AABB getBox(@NotNull HitResult hitResult, @NotNull WitcheryPotionIngredient.DispersalModifier mergedDispersalModifier) {
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        Intrinsics.checkNotNullParameter((Object)mergedDispersalModifier, (String)"mergedDispersalModifier");
        AABB aABB = AABB.ofSize((Vec3)hitResult.getLocation(), (double)((double)4 * (double)mergedDispersalModifier.getRangeModifier()), (double)((double)2 * (double)mergedDispersalModifier.getRangeModifier()), (double)((double)4 * (double)mergedDispersalModifier.getRangeModifier()));
        Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"ofSize(...)");
        return aABB;
    }

    public final void partLiquidFor(@NotNull Level level, @NotNull AABB box, @NotNull Fluid fluid, int seconds) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel;
        WitcheryWorldState data2 = WitcheryWorldState.Companion.get(serverLevel2);
        GlobalPos origin = GlobalPos.of((ResourceKey)serverLevel2.dimension(), (BlockPos)BlockPos.containing((Position)((Position)box.getCenter())));
        Map stateMap = new LinkedHashMap();
        BlockPos.betweenClosedStream((AABB)box).forEach(arg_0 -> SpecialPotion.partLiquidFor$lambda$1(arg_0 -> SpecialPotion.partLiquidFor$lambda$0(level, fluid, stateMap, arg_0), arg_0));
        data2.getPendingRestores().put(origin, (Pair<Integer, Map<BlockPos, BlockState>>)TuplesKt.to((Object)(20 * seconds), (Object)stateMap));
        data2.setDirty();
    }

    public static /* synthetic */ void partLiquidFor$default(SpecialPotion specialPotion, Level level, AABB aABB, Fluid fluid, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: partLiquidFor");
        }
        if ((n2 & 8) != 0) {
            n = 20;
        }
        specialPotion.partLiquidFor(level, aABB, fluid, n);
    }

    private static final Unit partLiquidFor$lambda$0(Level $level, Fluid $fluid, Map $stateMap, BlockPos pos) {
        BlockState state = ((ServerLevel)$level).getBlockState(pos);
        if (state.getFluidState().is($fluid)) {
            $stateMap.put(pos.immutable(), state);
            $level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
        return Unit.INSTANCE;
    }

    private static final void partLiquidFor$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

