/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.sterner.witchery.core.api.Curse;
import dev.sterner.witchery.core.registry.WitcheryCurseRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J2\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/core/commands/CurseArgumentType;", "Lcom/mojang/brigadier/arguments/ArgumentType;", "Ldev/sterner/witchery/core/api/Curse;", "<init>", "()V", "parse", "reader", "Lcom/mojang/brigadier/StringReader;", "getExamples", "", "", "listSuggestions", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "S", "", "context", "Lcom/mojang/brigadier/context/CommandContext;", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nCurseArgumentType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurseArgumentType.kt\ndev/sterner/witchery/core/commands/CurseArgumentType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1563#2:59\n1634#2,3:60\n1869#2,2:63\n*S KotlinDebug\n*F\n+ 1 CurseArgumentType.kt\ndev/sterner/witchery/core/commands/CurseArgumentType\n*L\n29#1:59\n29#1:60,3\n39#1:63,2\n*E\n"})
public final class CurseArgumentType
implements ArgumentType<Curse> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Curse parse(@NotNull StringReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        ResourceLocation input = ResourceLocation.read((StringReader)reader);
        Curse curse = (Curse)WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().get(input);
        if (curse == null) {
            throw new CommandSyntaxException((CommandExceptionType)CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument(), (Message)Component.literal((String)("Curse with ID " + input + " does not exist.")));
        }
        return curse;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getExamples() {
        void $this$mapTo$iv$iv;
        Set set = WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNull(k);
            String string = ((ResourceKey)k).location().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@Nullable CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        String input = builder.getRemaining();
        Set set = WitcheryCurseRegistry.INSTANCE.getCURSES_REGISTRY().entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String curseId;
            Map.Entry curse = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((ResourceKey)curse.getKey()).toString(), (String)"toString(...)");
            Intrinsics.checkNotNull((Object)input);
            if (!StringsKt.startsWith$default((String)curseId, (String)input, (boolean)false, (int)2, null)) continue;
            builder.suggest(curseId);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"buildFuture(...)");
        return completableFuture;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/core/commands/CurseArgumentType$Companion;", "", "<init>", "()V", "curseType", "Ldev/sterner/witchery/core/commands/CurseArgumentType;", "getCurse", "Ldev/sterner/witchery/core/api/Curse;", "context", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/commands/CommandSourceStack;", "name", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CurseArgumentType curseType() {
            return new CurseArgumentType();
        }

        @NotNull
        public final Curse getCurse(@NotNull CommandContext<CommandSourceStack> context, @NotNull String name) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Object object = context.getArgument(name, Curse.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getArgument(...)");
            return (Curse)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

