/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryShaders;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import dev.sterner.witchery.features.necromancy.SoulPoolPlayerAttachment;
import dev.sterner.witchery.network.DebugAABBRenderS2CPayload;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jl\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\b\b\u0002\u0010\u0014\u001a\u00020\u000e2\b\b\u0002\u0010\u0015\u001a\u00020\u000bJl\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\b\b\u0002\u0010\u0014\u001a\u00020\u000e2\b\b\u0002\u0010\u0015\u001a\u00020\u000bJt\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\b\b\u0002\u0010\u0014\u001a\u00020\u000e2\b\b\u0002\u0010\u0015\u001a\u00020\u000bJ.\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eJX\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J.\u0010\"\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000eJH\u0010%\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)J&\u0010*\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ.\u0010*\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010.\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010/\u001a\u0002002\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ.\u00101\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ2\u00104\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u00105\u001a\u00020\u000b2\b\b\u0002\u00106\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000bJ*\u00104\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u00105\u001a\u00020\u000b2\b\b\u0002\u00106\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\tJV\u00108\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dJV\u0010A\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dJJ\u0010B\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020D2\b\u0010E\u001a\u0004\u0018\u00010F2\b\u0010G\u001a\u0004\u0018\u00010F2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010X\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010Z\u001a\u00020[Jx\u0010\\\u001a\u00020\u00052\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`2\u0006\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\u000e2\u0006\u0010a\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u000e2\u0006\u0010b\u001a\u00020\u000e2\u0006\u0010c\u001a\u00020\u000e2\u0006\u0010d\u001a\u00020\u000e2\u0006\u0010e\u001a\u00020\u000e2\u0006\u0010f\u001a\u00020\u000e2\u0006\u0010g\u001a\u00020\u000e2\u0006\u0010h\u001a\u00020\u000eH\u0002J*\u0010i\u001a\u00020\u00052\u0006\u0010j\u001a\u00020k2\b\b\u0002\u0010\u0015\u001a\u00020\u000b2\b\b\u0002\u0010l\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020mR\u0019\u0010H\u001a\n I*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u0019\u0010L\u001a\n I*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010KR\u0019\u0010N\u001a\n I*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010KR\u0019\u0010P\u001a\n I*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010KR\u0019\u0010R\u001a\n I*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010KR\u0019\u0010T\u001a\n I*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010KR\u0019\u0010V\u001a\n I*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010K\u00a8\u0006n"}, d2={"Ldev/sterner/witchery/core/util/RenderUtils;", "", "<init>", "()V", "blitWithAlpha", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "atlasLocation", "Lnet/minecraft/resources/ResourceLocation;", "x", "", "y", "uOffset", "", "vOffset", "width", "height", "textureWidth", "textureHeight", "alpha", "color", "z", "renderItemWithAlpha", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "stack", "Lnet/minecraft/world/item/ItemStack;", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "level", "Lnet/minecraft/world/level/Level;", "seed", "guiOffset", "renderItemDecorations", "font", "Lnet/minecraft/client/gui/Font;", "drawString", "text", "", "shadow", "", "innerRenderBlood", "living", "maxBlood", "bloodPool", "innerRenderSouls", "player", "Lnet/minecraft/world/entity/player/Player;", "innerRenderBat", "maxTicks", "ticks", "renderChalk", "px", "py", "texture", "renderEntityOnScreen", "x1", "y1", "x2", "y2", "scale", "yOffset", "mouseX", "mouseY", "renderEntityInInventoryFollowsMouse", "renderEntityInInventory", "translate", "Lorg/joml/Vector3f;", "pose", "Lorg/joml/Quaternionf;", "cameraOrientation", "TEXTURE_FRONT", "kotlin.jvm.PlatformType", "getTEXTURE_FRONT", "()Lnet/minecraft/resources/ResourceLocation;", "TEXTURE_BACK", "getTEXTURE_BACK", "TEXTURE_LEFT", "getTEXTURE_LEFT", "TEXTURE_RIGHT", "getTEXTURE_RIGHT", "TEXTURE_TOP", "getTEXTURE_TOP", "TEXTURE_BOTTOM", "getTEXTURE_BOTTOM", "TEXTURE_CORE", "getTEXTURE_CORE", "renderGlowBoxEffect11", "fadeProgress", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "addGlowFace", "builder", "Lcom/mojang/blaze3d/vertex/BufferBuilder;", "matrix", "Lorg/joml/Matrix4f;", "z1", "z2", "x3", "y3", "z3", "x4", "y4", "z4", "makeDebugAABB", "aabb", "Lnet/minecraft/world/phys/AABB;", "durationTicks", "Lnet/minecraft/server/level/ServerLevel;", "witchery"})
public final class RenderUtils {
    @NotNull
    public static final RenderUtils INSTANCE = new RenderUtils();
    private static final ResourceLocation TEXTURE_FRONT = Witchery.Companion.id("textures/entity/soul_lantern_front.png");
    private static final ResourceLocation TEXTURE_BACK = Witchery.Companion.id("textures/entity/soul_lantern_front.png");
    private static final ResourceLocation TEXTURE_LEFT = Witchery.Companion.id("textures/entity/soul_lantern_right.png");
    private static final ResourceLocation TEXTURE_RIGHT = Witchery.Companion.id("textures/entity/soul_lantern_right.png");
    private static final ResourceLocation TEXTURE_TOP = Witchery.Companion.id("textures/entity/soul_lantern_top.png");
    private static final ResourceLocation TEXTURE_BOTTOM = Witchery.Companion.id("textures/entity/soul_lantern_top.png");
    private static final ResourceLocation TEXTURE_CORE = Witchery.Companion.id("textures/entity/soul_lantern_core.png");

    private RenderUtils() {
    }

    public final void blitWithAlpha(@NotNull PoseStack poseStack, @Nullable ResourceLocation atlasLocation, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight, float alpha, int color) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (atlasLocation != null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        }
        RenderSystem.setShader(RenderUtils::blitWithAlpha$lambda$0);
        Matrix4f matrix4f = poseStack.last().pose();
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"pose(...)");
        Matrix4f matrix4f2 = matrix4f;
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        float minU = uOffset / (float)textureWidth;
        float maxU = (uOffset + (float)width) / (float)textureWidth;
        float minV = vOffset / (float)textureHeight;
        float maxV = (vOffset + (float)height) / (float)textureHeight;
        bufferBuilder.addVertex(matrix4f2, (float)x, (float)y, 0.0f).setColor(red, green, blue, alpha).setUv(minU, minV);
        bufferBuilder.addVertex(matrix4f2, (float)x, (float)(y + height), 0.0f).setColor(red, green, blue, alpha).setUv(minU, maxV);
        bufferBuilder.addVertex(matrix4f2, (float)(x + width), (float)(y + height), 0.0f).setColor(red, green, blue, alpha).setUv(maxU, maxV);
        bufferBuilder.addVertex(matrix4f2, (float)(x + width), (float)y, 0.0f).setColor(red, green, blue, alpha).setUv(maxU, minV);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static /* synthetic */ void blitWithAlpha$default(RenderUtils renderUtils, PoseStack poseStack, ResourceLocation resourceLocation, int n, int n2, float f, float f2, int n3, int n4, int n5, int n6, float f3, int n7, int n8, Object object) {
        if ((n8 & 0x400) != 0) {
            f3 = 1.0f;
        }
        if ((n8 & 0x800) != 0) {
            n7 = 0xFFFFFF;
        }
        renderUtils.blitWithAlpha(poseStack, resourceLocation, n, n2, f, f2, n3, n4, n5, n6, f3, n7);
    }

    public final void blitWithAlpha(@NotNull PoseStack poseStack, @Nullable ResourceLocation atlasLocation, float x, float y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight, float alpha, int color) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        this.blitWithAlpha(poseStack, atlasLocation, x, y, 0.0f, uOffset, vOffset, width, height, textureWidth, textureHeight, alpha, color);
    }

    public static /* synthetic */ void blitWithAlpha$default(RenderUtils renderUtils, PoseStack poseStack, ResourceLocation resourceLocation, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4, float f5, int n5, int n6, Object object) {
        if ((n6 & 0x400) != 0) {
            f5 = 1.0f;
        }
        if ((n6 & 0x800) != 0) {
            n5 = 0xFFFFFF;
        }
        renderUtils.blitWithAlpha(poseStack, resourceLocation, f, f2, f3, f4, n, n2, n3, n4, f5, n5);
    }

    public final void blitWithAlpha(@NotNull PoseStack poseStack, @Nullable ResourceLocation atlasLocation, float x, float y, float z, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight, float alpha, int color) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (atlasLocation != null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        }
        RenderSystem.setShader(RenderUtils::blitWithAlpha$lambda$1);
        Matrix4f matrix4f = poseStack.last().pose();
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"pose(...)");
        Matrix4f matrix4f2 = matrix4f;
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        float minU = uOffset / (float)textureWidth;
        float maxU = (uOffset + (float)width) / (float)textureWidth;
        float minV = vOffset / (float)textureHeight;
        float maxV = (vOffset + (float)height) / (float)textureHeight;
        bufferBuilder.addVertex(matrix4f2, x, y, z).setColor(red, green, blue, alpha).setUv(minU, minV);
        bufferBuilder.addVertex(matrix4f2, x, y + (float)height, z).setColor(red, green, blue, alpha).setUv(minU, maxV);
        bufferBuilder.addVertex(matrix4f2, x + (float)width, y + (float)height, z).setColor(red, green, blue, alpha).setUv(maxU, maxV);
        bufferBuilder.addVertex(matrix4f2, x + (float)width, y, z).setColor(red, green, blue, alpha).setUv(maxU, minV);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static /* synthetic */ void blitWithAlpha$default(RenderUtils renderUtils, PoseStack poseStack, ResourceLocation resourceLocation, float f, float f2, float f3, float f4, float f5, int n, int n2, int n3, int n4, float f6, int n5, int n6, Object object) {
        if ((n6 & 0x800) != 0) {
            f6 = 1.0f;
        }
        if ((n6 & 0x1000) != 0) {
            n5 = 0xFFFFFF;
        }
        renderUtils.blitWithAlpha(poseStack, resourceLocation, f, f2, f3, f4, f5, n, n2, n3, n4, f6, n5);
    }

    public final void renderItemWithAlpha(@NotNull GuiGraphics guiGraphics, @NotNull ItemStack stack, float x, float y, float alpha) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel level = Minecraft.getInstance().level;
        this.renderItemWithAlpha(guiGraphics, (LivingEntity)player, (Level)level, stack, x, y, 0, 0, alpha);
    }

    private final void renderItemWithAlpha(GuiGraphics guiGraphics, @javax.annotation.Nullable LivingEntity entity, @javax.annotation.Nullable Level level, ItemStack stack, float x, float y, int seed, int guiOffset, float alpha) {
        if (stack.isEmpty()) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        BakedModel bakedModel = client.getItemRenderer().getModel(stack, level, entity, seed);
        Intrinsics.checkNotNullExpressionValue((Object)bakedModel, (String)"getModel(...)");
        BakedModel bakedModel2 = bakedModel;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)x + 8.0, (double)y + 8.0, 150.0 + (double)(bakedModel2.isGui3d() ? guiOffset : 0));
        try {
            boolean flat;
            guiGraphics.pose().scale(16.0f, -16.0f, 16.0f);
            boolean bl = flat = !bakedModel2.usesBlockLight();
            if (flat) {
                Lighting.setupForFlatItems();
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            client.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel2);
            guiGraphics.flush();
            RenderSystem.disableBlend();
            if (flat) {
                Lighting.setupFor3DItems();
            }
        }
        catch (Throwable throwable) {
            throw new ReportedException(CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item with alpha"));
        }
        guiGraphics.pose().popPose();
    }

    public final void renderItemDecorations(@NotNull GuiGraphics guiGraphics, @NotNull Font font, @NotNull ItemStack stack, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!stack.isEmpty()) {
            guiGraphics.pose().pushPose();
            if (stack.getCount() != 1) {
                String s = String.valueOf(stack.getCount());
                guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
                guiGraphics.drawString(font, s, x + (float)19 - (float)2 - (float)font.width(s), y + (float)6 + (float)3, 0xFFFFFF, true);
            }
            guiGraphics.pose().popPose();
        }
    }

    public final int drawString(@NotNull GuiGraphics guiGraphics, @NotNull Font font, @Nullable String text, float x, float y, float z, int color, boolean shadow) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        if (text == null) {
            return 0;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, z);
        int result = font.drawInBatch(text, x, y, color, shadow, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
        guiGraphics.pose().popPose();
        guiGraphics.flushIfUnmanaged();
        return result;
    }

    public final void innerRenderBlood(@NotNull GuiGraphics guiGraphics, @NotNull LivingEntity living, int y, int x) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)living, (String)"living");
        BloodPoolLivingEntityAttachment.Data data2 = BloodPoolLivingEntityAttachment.getData(living);
        int bloodPool = data2.getBloodPool();
        int maxBlood = data2.getMaxBlood();
        this.innerRenderBlood(guiGraphics, maxBlood, bloodPool, y, x);
    }

    public final void innerRenderBlood(@NotNull GuiGraphics guiGraphics, int maxBlood, int bloodPool, int y, int x) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        int dropCount = maxBlood / 300;
        int fullIcons = bloodPool / 300;
        int partialFill = bloodPool % 300;
        int iconSize = 10;
        for (int i = 0; i < dropCount; ++i) {
            int xPos = x - i * 7 - 8;
            PoseStack poseStack = guiGraphics.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
            this.blitWithAlpha(poseStack, Witchery.Companion.id("textures/gui/blood_pool_empty.png"), xPos, y - 1, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize, 1.0f, 0xFFFFFF);
            if (i < fullIcons) {
                PoseStack poseStack2 = guiGraphics.pose();
                Intrinsics.checkNotNullExpressionValue((Object)poseStack2, (String)"pose(...)");
                this.blitWithAlpha(poseStack2, Witchery.Companion.id("textures/gui/blood_pool_full.png"), xPos, y - 1, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize, 1.0f, 0xFFFFFF);
                continue;
            }
            if (i != fullIcons || partialFill <= 0) continue;
            int filledHeight = partialFill * iconSize / 300;
            int emptyHeight = iconSize - filledHeight;
            PoseStack poseStack3 = guiGraphics.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack3, (String)"pose(...)");
            this.blitWithAlpha(poseStack3, Witchery.Companion.id("textures/gui/blood_pool_full.png"), xPos, y + emptyHeight - 1, 0.0f, (float)emptyHeight, iconSize, filledHeight, iconSize, iconSize, 1.0f, 0xFFFFFF);
        }
    }

    public final void innerRenderSouls(@NotNull GuiGraphics guiGraphics, @NotNull Player player, int y, int x) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        SoulPoolPlayerAttachment.Data data2 = SoulPoolPlayerAttachment.getData(player);
        int maxSouls = data2.getMaxSouls();
        int currentSouls = data2.getSoulPool();
        int iconSize = 10;
        for (int i = 0; i < maxSouls; ++i) {
            int xPos = x - i * 12 - 8;
            PoseStack poseStack = guiGraphics.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
            this.blitWithAlpha(poseStack, Witchery.Companion.id("textures/gui/soul_empty.png"), xPos, y - 1, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize, 1.0f, 0xFFFFFF);
            if (i >= currentSouls) continue;
            PoseStack poseStack2 = guiGraphics.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack2, (String)"pose(...)");
            this.blitWithAlpha(poseStack2, Witchery.Companion.id("textures/gui/soul_pure.png"), xPos, y - 1, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize, 1.0f, 0xFFFFFF);
        }
    }

    public final void innerRenderBat(@NotNull GuiGraphics guiGraphics, int maxTicks, int ticks, int y, int x) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        int q = 1200;
        int dropCount = maxTicks / q;
        int fullIcons = ticks / q;
        int partialFill = ticks % q;
        int width = 13;
        int height = 7;
        for (int i = 0; i < dropCount; ++i) {
            int xPos = x + i * 12 - 8;
            PoseStack poseStack = guiGraphics.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
            this.blitWithAlpha(poseStack, Witchery.Companion.id("textures/gui/affliction_abilities/bat_form_empty.png"), xPos, y - 1, 0.0f, 0.0f, width, height, width, height, 1.0f, 0xFFFFFF);
            if (i < fullIcons) {
                PoseStack poseStack2 = guiGraphics.pose();
                Intrinsics.checkNotNullExpressionValue((Object)poseStack2, (String)"pose(...)");
                this.blitWithAlpha(poseStack2, Witchery.Companion.id("textures/gui/affliction_abilities/bat_form_full.png"), xPos, y - 1, 0.0f, 0.0f, width, height, width, height, 1.0f, 0xFFFFFF);
                continue;
            }
            if (i != fullIcons || partialFill <= 0) continue;
            int filledWidth = partialFill * width / q;
            PoseStack poseStack3 = guiGraphics.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack3, (String)"pose(...)");
            this.blitWithAlpha(poseStack3, Witchery.Companion.id("textures/gui/affliction_abilities/bat_form_full.png"), xPos, y - 1, 0.0f, 0.0f, filledWidth, height, width, height, 1.0f, 0xFFFFFF);
        }
    }

    public final void renderChalk(@NotNull PoseStack poseStack, int px, int py, @NotNull ResourceLocation texture, int color) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        this.blitWithAlpha(poseStack, texture, 1 + px, 33 + py, 0.0f, 0.0f, 16, 16, 16, 16, 0.45f, 0);
        this.blitWithAlpha(poseStack, texture, 0 + px, 32 + py, 0.0f, 0.0f, 16, 16, 16, 16, 1.0f, color);
    }

    public static /* synthetic */ void renderChalk$default(RenderUtils renderUtils, PoseStack poseStack, int n, int n2, ResourceLocation resourceLocation, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        renderUtils.renderChalk(poseStack, n, n2, resourceLocation, n3);
    }

    public final void renderChalk(@NotNull PoseStack poseStack, int px, int py, @NotNull ResourceLocation texture) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        this.blitWithAlpha(poseStack, texture, 1 + px, 33 + py, 0.0f, 0.0f, 16, 16, 16, 16, 0.45f, 0);
        RenderUtils.blitWithAlpha$default(this, poseStack, texture, 0 + px, 32 + py, 0.0f, 0.0f, 16, 16, 16, 16, 0.0f, 0, 3072, null);
    }

    public static /* synthetic */ void renderChalk$default(RenderUtils renderUtils, PoseStack poseStack, int n, int n2, ResourceLocation resourceLocation, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        renderUtils.renderChalk(poseStack, n, n2, resourceLocation);
    }

    public final void renderEntityOnScreen(@NotNull GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int scale, float yOffset, float mouseX, float mouseY, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        guiGraphics.enableScissor(x1, y1, x2, y2);
        this.renderEntityInInventoryFollowsMouse(guiGraphics, x1, y1, x2, y2, scale, yOffset, mouseX, mouseY, entity);
        guiGraphics.disableScissor();
    }

    public final void renderEntityInInventoryFollowsMouse(@NotNull GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int scale, float yOffset, float mouseX, float mouseY, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        float f = (float)(x1 + x2) / 2.0f;
        float g = (float)(y1 + y2) / 2.0f;
        float h = (float)Math.atan((f - mouseX) / 40.0f);
        float i = (float)Math.atan((g - mouseY) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(i * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float j = entity.yBodyRot;
        float k = entity.getYRot();
        float l = entity.getXRot();
        float m = entity.yHeadRotO;
        float n = entity.yHeadRot;
        entity.yBodyRot = 180.0f + h * 20.0f;
        entity.setYRot(180.0f + h * 40.0f);
        entity.setXRot(-i * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        float o = entity.getScale();
        Vector3f vector3f = new Vector3f(0.0f, entity.getBbHeight() / 2.0f + yOffset * o, 0.0f);
        float p = (float)scale / o;
        this.renderEntityInInventory(guiGraphics, f, g, p, vector3f, quaternionf, quaternionf2, entity);
        entity.yBodyRot = j;
        entity.setYRot(k);
        entity.setXRot(l);
        entity.yHeadRotO = m;
        entity.yHeadRot = n;
    }

    public final void renderEntityInInventory(@NotNull GuiGraphics guiGraphics, float x, float y, float scale, @NotNull Vector3f translate, @Nullable Quaternionf pose, @Nullable Quaternionf cameraOrientation, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)translate, (String)"translate");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)x, (double)y, 950.0);
        poseStack.scale(scale, scale, -scale);
        poseStack.translate(translate.x, translate.y, translate.z);
        if (pose != null) {
            poseStack.mulPose(pose);
        }
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        if (cameraOrientation != null) {
            entityRenderDispatcher.overrideCameraOrientation(cameraOrientation.conjugate(new Quaternionf()).rotateY((float)Math.PI));
        }
        entityRenderDispatcher.setRenderShadow(false);
        RenderSystem.runAsFancy(() -> RenderUtils.renderEntityInInventory$lambda$0(entityRenderDispatcher, entity, poseStack, guiGraphics));
        guiGraphics.flush();
        entityRenderDispatcher.setRenderShadow(true);
        poseStack.popPose();
        Lighting.setupFor3DItems();
    }

    public final ResourceLocation getTEXTURE_FRONT() {
        return TEXTURE_FRONT;
    }

    public final ResourceLocation getTEXTURE_BACK() {
        return TEXTURE_BACK;
    }

    public final ResourceLocation getTEXTURE_LEFT() {
        return TEXTURE_LEFT;
    }

    public final ResourceLocation getTEXTURE_RIGHT() {
        return TEXTURE_RIGHT;
    }

    public final ResourceLocation getTEXTURE_TOP() {
        return TEXTURE_TOP;
    }

    public final ResourceLocation getTEXTURE_BOTTOM() {
        return TEXTURE_BOTTOM;
    }

    public final ResourceLocation getTEXTURE_CORE() {
        return TEXTURE_CORE;
    }

    public final void renderGlowBoxEffect11(float fadeProgress, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        ShaderInstance shaderInstance = WitcheryShaders.soulLantern;
        if (shaderInstance == null) {
            return;
        }
        ShaderInstance shader = shaderInstance;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        double time = (double)System.currentTimeMillis() / 1000.0;
        float wobble = (float)Math.sin(time * 2.0) * 0.025f;
        float wobble2 = (float)Math.cos(time * 1.5) * 0.025f;
        float glowMin = -5.5f + wobble;
        float glowMax = 5.5f + wobble2;
        Matrix4f matrix = poseStack.last().pose();
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)bufferSource).endBatch();
        }
        ShaderInstance prevShader = RenderSystem.getShader();
        boolean prevCull = GL11.glIsEnabled((int)2884);
        boolean prevDepthMask = GL11.glGetBoolean((int)2930);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        shader.safeGetUniform("Alpha").set(fadeProgress * 0.7f);
        RenderSystem.setShader(() -> RenderUtils.renderGlowBoxEffect11$lambda$0(shader));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_FRONT);
        BufferBuilder builderFront = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)builderFront);
        Intrinsics.checkNotNull((Object)matrix);
        this.addGlowFace(builderFront, matrix, glowMin, glowMin, glowMax, glowMax, glowMin, glowMax, glowMax, glowMax, glowMax, glowMin, glowMax, glowMax);
        BufferUploader.drawWithShader((MeshData)builderFront.buildOrThrow());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_BACK);
        BufferBuilder builderBack = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)builderBack);
        this.addGlowFace(builderBack, matrix, glowMax, glowMin, glowMin, glowMin, glowMin, glowMin, glowMin, glowMax, glowMin, glowMax, glowMax, glowMin);
        BufferUploader.drawWithShader((MeshData)builderBack.buildOrThrow());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_LEFT);
        BufferBuilder builderLeft = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)builderLeft);
        this.addGlowFace(builderLeft, matrix, glowMin, glowMin, glowMin, glowMin, glowMin, glowMax, glowMin, glowMax, glowMax, glowMin, glowMax, glowMin);
        BufferUploader.drawWithShader((MeshData)builderLeft.buildOrThrow());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_RIGHT);
        BufferBuilder builderRight = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)builderRight);
        this.addGlowFace(builderRight, matrix, glowMax, glowMin, glowMax, glowMax, glowMin, glowMin, glowMax, glowMax, glowMin, glowMax, glowMax, glowMax);
        BufferUploader.drawWithShader((MeshData)builderRight.buildOrThrow());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_TOP);
        BufferBuilder builderTop = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)builderTop);
        this.addGlowFace(builderTop, matrix, glowMin, glowMax, glowMax, glowMax, glowMax, glowMax, glowMax, glowMax, glowMin, glowMin, glowMax, glowMin);
        BufferUploader.drawWithShader((MeshData)builderTop.buildOrThrow());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_BOTTOM);
        BufferBuilder builderBottom = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)builderBottom);
        this.addGlowFace(builderBottom, matrix, glowMin, glowMin, glowMin, glowMax, glowMin, glowMin, glowMax, glowMin, glowMax, glowMin, glowMin, glowMax);
        BufferUploader.drawWithShader((MeshData)builderBottom.buildOrThrow());
        float coreSize = 5.4f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_CORE);
        BufferBuilder builderCoreFront = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)builderCoreFront);
        this.addGlowFace(builderCoreFront, matrix, -coreSize, -coreSize, coreSize, coreSize, -coreSize, coreSize, coreSize, coreSize, coreSize, -coreSize, coreSize, coreSize);
        BufferUploader.drawWithShader((MeshData)builderCoreFront.buildOrThrow());
        BufferBuilder builderCoreBack = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)builderCoreBack);
        this.addGlowFace(builderCoreBack, matrix, coreSize, -coreSize, -coreSize, -coreSize, -coreSize, -coreSize, -coreSize, coreSize, -coreSize, coreSize, coreSize, -coreSize);
        BufferUploader.drawWithShader((MeshData)builderCoreBack.buildOrThrow());
        BufferBuilder builderCoreLeft = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)builderCoreLeft);
        this.addGlowFace(builderCoreLeft, matrix, -coreSize, -coreSize, -coreSize, -coreSize, -coreSize, coreSize, -coreSize, coreSize, coreSize, -coreSize, coreSize, -coreSize);
        BufferUploader.drawWithShader((MeshData)builderCoreLeft.buildOrThrow());
        BufferBuilder builderCoreRight = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)builderCoreRight);
        this.addGlowFace(builderCoreRight, matrix, coreSize, -coreSize, coreSize, coreSize, -coreSize, -coreSize, coreSize, coreSize, -coreSize, coreSize, coreSize, coreSize);
        BufferUploader.drawWithShader((MeshData)builderCoreRight.buildOrThrow());
        BufferBuilder builderCoreTop = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)builderCoreTop);
        this.addGlowFace(builderCoreTop, matrix, -coreSize, coreSize, coreSize, coreSize, coreSize, coreSize, coreSize, coreSize, -coreSize, -coreSize, coreSize, -coreSize);
        BufferUploader.drawWithShader((MeshData)builderCoreTop.buildOrThrow());
        BufferBuilder builderCoreBottom = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Intrinsics.checkNotNull((Object)builderCoreBottom);
        this.addGlowFace(builderCoreBottom, matrix, -coreSize, -coreSize, -coreSize, coreSize, -coreSize, -coreSize, coreSize, -coreSize, coreSize, -coreSize, -coreSize, coreSize);
        BufferUploader.drawWithShader((MeshData)builderCoreBottom.buildOrThrow());
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)prevDepthMask);
        if (prevCull) {
            RenderSystem.enableCull();
        }
        if (prevShader != null) {
            RenderSystem.setShader(() -> RenderUtils.renderGlowBoxEffect11$lambda$1(prevShader));
        }
        poseStack.popPose();
    }

    private final void addGlowFace(BufferBuilder builder, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        int light = 240;
        builder.addVertex(matrix, x1, y1, z1).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setUv2(light, light);
        builder.addVertex(matrix, x2, y2, z2).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setUv2(light, light);
        builder.addVertex(matrix, x3, y3, z3).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setUv2(light, light);
        builder.addVertex(matrix, x4, y4, z4).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setUv2(light, light);
    }

    public final void makeDebugAABB(@NotNull AABB aabb, int color, int durationTicks, @NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)aabb, (String)"aabb");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)new ChunkPos(BlockPos.containing((Position)((Position)aabb.getCenter()))), (CustomPacketPayload)new DebugAABBRenderS2CPayload(aabb, color, durationTicks), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static /* synthetic */ void makeDebugAABB$default(RenderUtils renderUtils, AABB aABB, int n, int n2, ServerLevel serverLevel, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0xFF0000;
        }
        if ((n3 & 4) != 0) {
            n2 = 100;
        }
        renderUtils.makeDebugAABB(aABB, n, n2, serverLevel);
    }

    private static final ShaderInstance blitWithAlpha$lambda$0() {
        return GameRenderer.getPositionTexColorShader();
    }

    private static final ShaderInstance blitWithAlpha$lambda$1() {
        return GameRenderer.getPositionTexColorShader();
    }

    private static final void renderEntityInInventory$lambda$0(EntityRenderDispatcher $entityRenderDispatcher, LivingEntity $entity, PoseStack $poseStack, GuiGraphics $guiGraphics) {
        $entityRenderDispatcher.render((Entity)$entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, $poseStack, (MultiBufferSource)$guiGraphics.bufferSource(), 0xF000F0);
    }

    private static final ShaderInstance renderGlowBoxEffect11$lambda$0(ShaderInstance $shader) {
        return $shader;
    }

    private static final ShaderInstance renderGlowBoxEffect11$lambda$1(ShaderInstance $prevShader) {
        return $prevShader;
    }
}

