/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.event;

import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.ability.AbilityCooldownManager;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbility;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbilityHandler;
import dev.sterner.witchery.features.blood.BloodPoolHandler;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import dev.sterner.witchery.network.AfflictionAbilityUseC2SPayload;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J$\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00152\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u001a\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u001a\u0010\u001c\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/sterner/witchery/features/affliction/event/AfflictionEventHandler;", "", "<init>", "()V", "HUMAN_BLOOD_REGEN_RATE", "", "HUMAN_BLOOD_REGEN_AMOUNT", "isInAbilityMode", "", "player", "Lnet/minecraft/world/entity/player/Player;", "tick", "", "regenerateHumanBlood", "Lnet/minecraft/server/level/ServerPlayer;", "rightClickBlockAbility", "event", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$RightClickBlock;", "interactionHand", "Lnet/minecraft/world/InteractionHand;", "interactEntityWithAbility", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$EntityInteract;", "entity", "Lnet/minecraft/world/entity/Entity;", "leftClickBlock", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$LeftClickBlock;", "rightClickItem", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$RightClickItem;", "clientRightClickAbility", "witchery"})
public final class AfflictionEventHandler {
    @NotNull
    public static final AfflictionEventHandler INSTANCE = new AfflictionEventHandler();
    private static final int HUMAN_BLOOD_REGEN_RATE = 1000;
    private static final int HUMAN_BLOOD_REGEN_AMOUNT = 10;

    private AfflictionEventHandler() {
    }

    private final boolean isInAbilityMode(Player player) {
        return AfflictionPlayerAttachment.getData(player).getAbilityIndex() != -1;
    }

    @JvmStatic
    public static final void tick(@Nullable Player player) {
        boolean any;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        int vampLevel = AfflictionPlayerAttachment.getData(player).getVampireLevel();
        if (vampLevel < 1) {
            INSTANCE.regenerateHumanBlood((ServerPlayer)player);
        }
        if (any = AfflictionPlayerAttachment.getData(player).getAnyLevel()) {
            AbilityCooldownManager.INSTANCE.tick(player);
        }
    }

    private final void regenerateHumanBlood(ServerPlayer player) {
        BloodPoolLivingEntityAttachment.Data humanBloodData = BloodPoolLivingEntityAttachment.getData((LivingEntity)player);
        if (humanBloodData.getBloodPool() < humanBloodData.getMaxBlood() && player.tickCount % 1000 == 0) {
            BloodPoolHandler.increaseBlood((LivingEntity)player, 10);
        }
    }

    @JvmStatic
    public static final void rightClickBlockAbility(@NotNull PlayerInteractEvent.RightClickBlock event, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        if (interactionHand == InteractionHand.OFF_HAND) {
            return;
        }
        if (INSTANCE.isInAbilityMode(player)) {
            if (player.level().isClientSide) {
                AfflictionAbilityHandler.INSTANCE.useSelectedAbility(player);
            }
            event.setCanceled(true);
        }
    }

    @JvmStatic
    public static final void interactEntityWithAbility(@NotNull PlayerInteractEvent.EntityInteract event, @Nullable Player player, @Nullable Entity entity) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(player instanceof ServerPlayer) || entity == null) {
            return;
        }
        if (INSTANCE.isInAbilityMode(player)) {
            AfflictionAbility ability = AfflictionAbilityHandler.INSTANCE.getSelectedAbility(player);
            if (ability != null && !AbilityCooldownManager.INSTANCE.isOnCooldown(player, ability)) {
                ability.use(player, entity);
            }
            event.setCanceled(true);
        }
    }

    @JvmStatic
    public static final void leftClickBlock(@NotNull PlayerInteractEvent.LeftClickBlock event, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (INSTANCE.isInAbilityMode(player)) {
            event.setCanceled(true);
        }
    }

    @JvmStatic
    public static final void rightClickItem(@NotNull PlayerInteractEvent.RightClickItem event, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        if (interactionHand == InteractionHand.OFF_HAND) {
            return;
        }
        if (INSTANCE.isInAbilityMode(player)) {
            event.setCanceled(true);
        }
    }

    public final boolean clientRightClickAbility(@Nullable Player player, @Nullable InteractionHand interactionHand) {
        if (player == null || interactionHand == InteractionHand.OFF_HAND) {
            return false;
        }
        if (this.isInAbilityMode(player)) {
            int index;
            List<AfflictionAbility> abilities = AfflictionAbilityHandler.INSTANCE.getAbilities(player);
            AfflictionAbility ability = (AfflictionAbility)CollectionsKt.getOrNull(abilities, (int)(index = AfflictionPlayerAttachment.getData(player).getAbilityIndex()));
            if (ability != null && !ability.getPassive()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new AfflictionAbilityUseC2SPayload(index), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return true;
        }
        return false;
    }
}

