/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.lich;

import dev.sterner.witchery.content.block.ancient_tablet.AncientTabletBlock;
import dev.sterner.witchery.content.block.ancient_tablet.AncientTabletBlockEntity;
import dev.sterner.witchery.content.entity.player_shell.SoulShellPlayerEntity;
import dev.sterner.witchery.core.api.InventorySlots;
import dev.sterner.witchery.core.api.entity.PlayerShellEntity;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbilityHandler;
import dev.sterner.witchery.features.affliction.lich.LichdomLeveling;
import dev.sterner.witchery.features.affliction.lich.LichdomSoulPoolHandler;
import dev.sterner.witchery.features.necromancy.EtherealEntityAttachment;
import dev.sterner.witchery.features.necromancy.PhylacteryLevelDataAttachment;
import dev.sterner.witchery.features.necromancy.SoulPoolPlayerAttachment;
import dev.sterner.witchery.features.possession.EntityAiToggle;
import dev.sterner.witchery.features.possession.PossessionComponentAttachment;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J(\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J \u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J \u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!H\u0007J\u0018\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u000bH\u0002J\u0016\u0010$\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bJ\u0016\u0010(\u001a\u00020!2\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bJ \u0010,\u001a\u00020\u00072\u0006\u0010#\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Ldev/sterner/witchery/features/affliction/lich/LichdomSpecificEventHandler;", "", "<init>", "()V", "PHYLACTERY_SKYLIGHT_CHECK_RATE", "", "tick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "lichTick", "Lnet/minecraft/server/level/ServerPlayer;", "level", "handlePhylacteryRequirements", "applySoulFormEffects", "onBlockInteract", "event", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$RightClickBlock;", "hand", "Lnet/minecraft/world/InteractionHand;", "pos", "Lnet/minecraft/core/BlockPos;", "onKillEntity", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "onDeath", "Lnet/neoforged/neoforge/event/entity/living/LivingDeathEvent;", "respawn", "newPlayer", "oldPlayer", "alive", "", "isPlayerMinion", "entity", "returnToShell", "shell", "Ldev/sterner/witchery/content/entity/player_shell/SoulShellPlayerEntity;", "activateSoulForm", "attemptPossession", "target", "Lnet/minecraft/world/entity/Mob;", "exitPossessionToSoulForm", "playEffects", "Lnet/minecraft/world/entity/Entity;", "sound", "Lnet/minecraft/sounds/SoundEvent;", "particle", "Lnet/minecraft/core/particles/ParticleOptions;", "witchery"})
@SourceDebugExtension(value={"SMAP\nLichdomSpecificEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LichdomSpecificEventHandler.kt\ndev/sterner/witchery/features/affliction/lich/LichdomSpecificEventHandler\n+ 2 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n*L\n1#1,366:1\n69#2,15:367\n69#2,15:382\n69#2,15:397\n69#2,15:412\n*S KotlinDebug\n*F\n+ 1 LichdomSpecificEventHandler.kt\ndev/sterner/witchery/features/affliction/lich/LichdomSpecificEventHandler\n*L\n218#1:367,15\n263#1:382,15\n302#1:397,15\n325#1:412,15\n*E\n"})
public final class LichdomSpecificEventHandler {
    @NotNull
    public static final LichdomSpecificEventHandler INSTANCE = new LichdomSpecificEventHandler();
    private static final int PHYLACTERY_SKYLIGHT_CHECK_RATE = 200;

    private LichdomSpecificEventHandler() {
    }

    @JvmStatic
    public static final void tick(@Nullable Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        int lichLevel = AfflictionPlayerAttachment.getData(player).getLichLevel();
        if (((ServerPlayer)player).isAlive() && lichLevel > 0) {
            INSTANCE.lichTick((ServerPlayer)player, lichLevel);
        }
    }

    private final void lichTick(ServerPlayer player, int level) {
        this.handlePhylacteryRequirements(player, level);
        this.applySoulFormEffects(player, level);
    }

    private final void handlePhylacteryRequirements(ServerPlayer player, int level) {
        AfflictionPlayerAttachment.Data data2;
        if (level < 9) {
            return;
        }
        if (player.tickCount % 200 == 0 && (data2 = AfflictionPlayerAttachment.getData((Player)player)).isPhylacteryBound()) {
            Level level2 = player.level();
            Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level2;
            UUID uUID = player.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            List<PhylacteryLevelDataAttachment.PhylacteryRecord> phylacteryPos = PhylacteryLevelDataAttachment.INSTANCE.listPhylacteriesForPlayer(serverLevel, uUID);
            for (PhylacteryLevelDataAttachment.PhylacteryRecord phy : phylacteryPos) {
                boolean canSeeSky = player.level().canSeeSky(phy.getPos());
                if (canSeeSky) continue;
                player.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 200, 1));
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 0));
            }
        }
    }

    private final void applySoulFormEffects(ServerPlayer player, int level) {
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player);
    }

    @JvmStatic
    public static final void onBlockInteract(@NotNull PlayerInteractEvent.RightClickBlock event, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockPos pos) {
        BlockEntity blockEntity;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        BlockState blockState = player.level().getBlockState(pos);
        if (blockState.getBlock() instanceof AncientTabletBlock && (blockEntity = player.level().getBlockEntity(pos)) instanceof AncientTabletBlockEntity) {
            UUID tabletId = ((AncientTabletBlockEntity)blockEntity).getTabletId();
            if (LichdomLeveling.readAncientTablet((ServerPlayer)player, tabletId)) {
                player.level().playSound(null, pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 0.5f);
                for (int i = 0; i < 11; ++i) {
                    Level level = player.level();
                    Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    ServerLevel level2 = (ServerLevel)level;
                    level2.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 1, 0.5, 0.5, 0.5, 0.1);
                }
            }
            event.setCanceled(true);
            return;
        }
    }

    @JvmStatic
    public static final void onKillEntity(@NotNull LivingEntity livingEntity, @NotNull DamageSource damageSource) {
        AfflictionPlayerAttachment.Data data2;
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        Entity entity = damageSource.getEntity();
        ServerPlayer serverPlayer = entity instanceof ServerPlayer ? (ServerPlayer)entity : null;
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer player = serverPlayer;
        int lichLevel = AfflictionPlayerAttachment.getData((Player)player).getLichLevel();
        if (lichLevel == 0) {
            return;
        }
        if (damageSource.getEntity() instanceof Zombie) {
            Entity entity2 = damageSource.getEntity();
            Intrinsics.checkNotNull((Object)entity2, (String)"null cannot be cast to non-null type net.minecraft.world.entity.monster.Zombie");
            if (INSTANCE.isPlayerMinion((LivingEntity)((Zombie)entity2), player) && livingEntity instanceof Monster) {
                LichdomLeveling.recordZombieKill(player);
            }
        }
        if (livingEntity instanceof IronGolem || livingEntity instanceof SnowGolem) {
            LichdomLeveling.increaseKilledGolems(player);
        }
        if ((data2 = AfflictionPlayerAttachment.getData((Player)player)).isSoulForm() && livingEntity instanceof Villager) {
            LichdomLeveling.recordPossessedKill(player);
        }
        if (livingEntity instanceof WitherBoss) {
            LichdomLeveling.recordWitherKill(player);
        }
    }

    @JvmStatic
    public static final void onDeath(@NotNull LivingDeathEvent event, @NotNull LivingEntity livingEntity, @NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        int lichLevel = AfflictionPlayerAttachment.getData((Player)livingEntity).getLichLevel();
        if (lichLevel < 2) {
            return;
        }
        int currentSouls = LichdomSoulPoolHandler.INSTANCE.getCurrentSouls((ServerPlayer)livingEntity);
        if (currentSouls > 0) {
            LichdomSoulPoolHandler.decreaseSouls$default(LichdomSoulPoolHandler.INSTANCE, (ServerPlayer)livingEntity, 1, null, 4, null);
            ((ServerPlayer)livingEntity).setHealth(((ServerPlayer)livingEntity).getMaxHealth() * 0.5f);
            livingEntity.removeAllEffects();
            livingEntity.level().playSound(null, ((ServerPlayer)livingEntity).getX(), ((ServerPlayer)livingEntity).getY(), ((ServerPlayer)livingEntity).getZ(), SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 1.0f, 0.7f);
            LichdomLeveling.recordPhylacteryUse((ServerPlayer)livingEntity);
            LichdomLeveling.recordPhylacteryTripleDeath((ServerPlayer)livingEntity);
            event.setCanceled(true);
            return;
        }
    }

    @JvmStatic
    public static final void respawn(@NotNull Player newPlayer, @NotNull Player oldPlayer, boolean alive) {
        Intrinsics.checkNotNullParameter((Object)newPlayer, (String)"newPlayer");
        Intrinsics.checkNotNullParameter((Object)oldPlayer, (String)"oldPlayer");
        int lichLevel = AfflictionPlayerAttachment.getData(oldPlayer).getLichLevel();
        if (lichLevel > 0) {
            AfflictionPlayerAttachment.Data currentData$iv;
            SoulPoolPlayerAttachment.Data soulData = SoulPoolPlayerAttachment.getData(oldPlayer);
            SoulPoolPlayerAttachment.setData(newPlayer, new SoulPoolPlayerAttachment.Data(soulData.getMaxSouls(), 50));
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = newPlayer;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$respawn_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            AfflictionPlayerAttachment.Data newData$iv = $this$respawn_u24lambda_u240.withSoulForm(false);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
            int currentSouls = LichdomSoulPoolHandler.INSTANCE.getCurrentSouls((ServerPlayer)newPlayer);
            LichdomSoulPoolHandler.INSTANCE.setMaxSouls(newPlayer, lichLevel);
            SoulPoolPlayerAttachment.Data pool = SoulPoolPlayerAttachment.getData(newPlayer);
            SoulPoolPlayerAttachment.setData(newPlayer, SoulPoolPlayerAttachment.Data.copy$default(pool, 0, currentSouls, 1, null));
        } else if (AfflictionPlayerAttachment.getData(oldPlayer).isSoulForm()) {
            InventorySlots.INSTANCE.lockAll(newPlayer);
        }
    }

    private final boolean isPlayerMinion(LivingEntity entity, ServerPlayer player) {
        return Intrinsics.areEqual((Object)EtherealEntityAttachment.getData(entity).getOwnerUUID(), (Object)player.getUUID());
    }

    public final void returnToShell(@NotNull ServerPlayer player, @NotNull SoulShellPlayerEntity shell) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)shell), (String)"shell");
        if (shell.isRemoved() || !Intrinsics.areEqual(shell.getOriginalUUID().orElse(null), (Object)player.getUUID())) {
            return;
        }
        shell.mergeSoulWithShell((Player)player);
        player.teleportTo(shell.getX(), shell.getY(), shell.getZ());
        InventorySlots.INSTANCE.unlockAll((Player)player);
        Integer n = AfflictionAbilityHandler.INSTANCE.getAbilityIndex();
        int n2 = -1;
        if (n == null || n != n2) {
            AfflictionAbilityHandler.INSTANCE.setAbilityIndex((Player)player, -1);
            player.getInventory().selected = 0;
        }
        Entity entity = (Entity)player;
        Object object = SoundEvents.SOUL_ESCAPE.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        SoundEvent soundEvent = (SoundEvent)object;
        SimpleParticleType simpleParticleType = ParticleTypes.SOUL;
        Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"SOUL");
        this.playEffects(entity, soundEvent, (ParticleOptions)simpleParticleType);
    }

    public final void activateSoulForm(@NotNull ServerPlayer player) {
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        SoulShellPlayerEntity shell = PlayerShellEntity.Companion.createShellFromPlayer((Player)player);
        player.level().addFreshEntity((Entity)shell);
        player.getInventory().clearContent();
        player.getInventory().armor.clear();
        player.getInventory().offhand.clear();
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player$iv = (Player)player;
        boolean sync$iv = true;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$activateSoulForm_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = $this$activateSoulForm_u24lambda_u240.withSoulForm(true).withVagrant(false);
        AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
        if (player$iv.level() instanceof ServerLevel) {
            AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
        }
        SoulShellPlayerEntity.Companion.enableFlight(player);
        player.getAbilities().flying = true;
        InventorySlots.INSTANCE.lockAll((Player)player);
        RandomSource random = player.getRandom();
        player.setDeltaMovement(player.getDeltaMovement().add((random.nextDouble() - 0.5) * 0.1, 0.2 + random.nextDouble() * 0.1, (random.nextDouble() - 0.5) * 0.1));
        player.hurtMarked = true;
        player.onUpdateAbilities();
        Entity entity = (Entity)player;
        Object object = SoundEvents.SOUL_ESCAPE.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        SoundEvent soundEvent = (SoundEvent)object;
        SimpleParticleType simpleParticleType = ParticleTypes.SOUL;
        Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"SOUL");
        this.playEffects(entity, soundEvent, (ParticleOptions)simpleParticleType);
    }

    public final boolean attemptPossession(@NotNull ServerPlayer player, @NotNull Mob target) {
        boolean canPossess;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int lichLevel = AfflictionPlayerAttachment.getData((Player)player).getLichLevel();
        boolean bl = target instanceof ZombieVillager ? lichLevel >= 6 : (target.getType().is(EntityTypeTags.UNDEAD) ? true : (target.getType().is(EntityTypeTags.ILLAGER) ? lichLevel >= 8 : (canPossess = false)));
        if (!canPossess || target.getHealth() <= 0.0f || target.isRemoved()) {
            return false;
        }
        PossessionComponentAttachment.PossessionComponent possessionComponent = PossessionComponentAttachment.INSTANCE.get((Player)player);
        boolean success = possessionComponent.startPossessing(target);
        if (success) {
            AfflictionPlayerAttachment.Data currentData$iv;
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = (Player)player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$attemptPossession_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl2 = false;
            AfflictionPlayerAttachment.Data newData$iv = $this$attemptPossession_u24lambda_u240.withSoulForm(false).withVagrant(true);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
            SoulShellPlayerEntity.Companion.disableFlight(player);
            player.onUpdateAbilities();
            InventorySlots.INSTANCE.unlockAll((Player)player);
            Entity entity = (Entity)target;
            SoundEvent soundEvent = SoundEvents.ENDERMAN_TELEPORT;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"ENDERMAN_TELEPORT");
            SimpleParticleType simpleParticleType = ParticleTypes.PORTAL;
            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"PORTAL");
            this.playEffects(entity, soundEvent, (ParticleOptions)simpleParticleType);
        }
        return success;
    }

    public final void exitPossessionToSoulForm(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PossessionComponentAttachment.PossessionComponent possessionComponent = PossessionComponentAttachment.INSTANCE.get((Player)player);
        Mob host = possessionComponent.getHost();
        if (host != null) {
            AfflictionPlayerAttachment.Data currentData$iv;
            possessionComponent.stopPossessing(false);
            host.hurt(host.damageSources().magic(), host.getMaxHealth() * 0.5f);
            EntityAiToggle.toggleAi((LivingEntity)host, EntityAiToggle.INSTANCE.getPOSSESSION_MECHANISM_ID(), false, false);
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = (Player)player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$exitPossessionToSoulForm_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            AfflictionPlayerAttachment.Data newData$iv = $this$exitPossessionToSoulForm_u24lambda_u240.withSoulForm(true).withVagrant(false);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
            InventorySlots.INSTANCE.lockAll((Player)player);
            SoulShellPlayerEntity.Companion.enableFlight(player);
            player.getAbilities().flying = true;
            RandomSource random = player.getRandom();
            player.setDeltaMovement(player.getDeltaMovement().add((random.nextDouble() - 0.5) * 0.1, 0.2 + random.nextDouble() * 0.1, (random.nextDouble() - 0.5) * 0.1));
            player.hurtMarked = true;
            player.onUpdateAbilities();
            Entity entity = (Entity)player;
            SoundEvent soundEvent = SoundEvents.SCULK_SHRIEKER_SHRIEK;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"SCULK_SHRIEKER_SHRIEK");
            SimpleParticleType simpleParticleType = ParticleTypes.SOUL_FIRE_FLAME;
            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"SOUL_FIRE_FLAME");
            this.playEffects(entity, soundEvent, (ParticleOptions)simpleParticleType);
        }
    }

    private final void playEffects(Entity entity, SoundEvent sound, ParticleOptions particle) {
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), sound, SoundSource.PLAYERS, 1.0f, 0.5f);
        if (entity.level() instanceof ServerLevel) {
            Level level = entity.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles(particle, entity.getX(), entity.getY() + 1.0, entity.getZ(), 20, 0.5, 0.5, 0.5, 0.1);
        }
    }
}

