/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.vampire;

import dev.sterner.witchery.core.api.interfaces.VillagerTransfix;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.AfflictionTypes;
import dev.sterner.witchery.features.affliction.ability.AbilityCooldownManager;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbility;
import dev.sterner.witchery.features.affliction.event.AfflictionHandler;
import dev.sterner.witchery.features.affliction.event.TransformationHandler;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B#\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/features/affliction/vampire/VampireAbility;", "Ldev/sterner/witchery/features/affliction/ability/AfflictionAbility;", "", "requiredLevel", "", "cooldown", "affliction", "Ldev/sterner/witchery/features/affliction/AfflictionTypes;", "<init>", "(Ljava/lang/String;IIILdev/sterner/witchery/features/affliction/AfflictionTypes;)V", "getRequiredLevel", "()I", "getCooldown", "getAffliction", "()Ldev/sterner/witchery/features/affliction/AfflictionTypes;", "DRINK_BLOOD", "NIGHT_VISION", "TRANSFIX", "SPEED", "BAT_FORM", "witchery"})
public abstract class VampireAbility
extends Enum<VampireAbility>
implements AfflictionAbility {
    private final int requiredLevel;
    private final int cooldown;
    @NotNull
    private final AfflictionTypes affliction;
    public static final /* enum */ VampireAbility DRINK_BLOOD = new DRINK_BLOOD("DRINK_BLOOD", 0);
    public static final /* enum */ VampireAbility NIGHT_VISION = new NIGHT_VISION("NIGHT_VISION", 1);
    public static final /* enum */ VampireAbility TRANSFIX = new TRANSFIX("TRANSFIX", 2);
    public static final /* enum */ VampireAbility SPEED = new SPEED("SPEED", 3);
    public static final /* enum */ VampireAbility BAT_FORM = new BAT_FORM("BAT_FORM", 4);
    private static final /* synthetic */ VampireAbility[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private VampireAbility(int requiredLevel, int cooldown, AfflictionTypes affliction) {
        this.requiredLevel = requiredLevel;
        this.cooldown = cooldown;
        this.affliction = affliction;
    }

    /* synthetic */ VampireAbility(String string, int n, int n2, int n3, AfflictionTypes afflictionTypes, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            afflictionTypes = AfflictionTypes.VAMPIRISM;
        }
        this(n2, n3, afflictionTypes);
    }

    @Override
    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    @NotNull
    public AfflictionTypes getAffliction() {
        return this.affliction;
    }

    public static VampireAbility[] values() {
        return (VampireAbility[])$VALUES.clone();
    }

    public static VampireAbility valueOf(String value) {
        return Enum.valueOf(VampireAbility.class, value);
    }

    @NotNull
    public static EnumEntries<VampireAbility> getEntries() {
        return $ENTRIES;
    }

    static {
        $VALUES = vampireAbilityArray = new VampireAbility[]{VampireAbility.DRINK_BLOOD, VampireAbility.NIGHT_VISION, VampireAbility.TRANSFIX, VampireAbility.SPEED, VampireAbility.BAT_FORM};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"dev/sterner/witchery/features/affliction/vampire/VampireAbility.BAT_FORM", "Ldev/sterner/witchery/features/affliction/vampire/VampireAbility;", "id", "", "getId", "()Ljava/lang/String;", "use", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    static final class BAT_FORM
    extends VampireAbility {
        /*
         * WARNING - void declaration
         */
        BAT_FORM() {
            void var1_1;
        }

        @Override
        @NotNull
        public String getId() {
            return "bat_form";
        }

        @Override
        public boolean use(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            boolean isBat = TransformationHandler.isBat(player);
            if (isBat) {
                TransformationHandler.removeForm(player);
                AbilityCooldownManager.INSTANCE.startCooldown(player, this);
            } else {
                TransformationHandler.setBatForm(player);
            }
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"dev/sterner/witchery/features/affliction/vampire/VampireAbility.DRINK_BLOOD", "Ldev/sterner/witchery/features/affliction/vampire/VampireAbility;", "id", "", "getId", "()Ljava/lang/String;", "requiresTarget", "", "getRequiresTarget", "()Z", "use", "player", "Lnet/minecraft/world/entity/player/Player;", "target", "Lnet/minecraft/world/entity/Entity;", "witchery"})
    static final class DRINK_BLOOD
    extends VampireAbility {
        private final boolean requiresTarget;

        /*
         * WARNING - void declaration
         */
        DRINK_BLOOD() {
            void var1_1;
            this.requiresTarget = true;
        }

        @Override
        @NotNull
        public String getId() {
            return "drink_blood";
        }

        @Override
        public boolean getRequiresTarget() {
            return this.requiresTarget;
        }

        @Override
        public boolean use(@NotNull Player player, @NotNull Entity target) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (!(player instanceof ServerPlayer) || !(target instanceof LivingEntity)) {
                return false;
            }
            BloodPoolLivingEntityAttachment.Data playerBloodData = BloodPoolLivingEntityAttachment.getData((LivingEntity)player);
            BloodPoolLivingEntityAttachment.Data targetData = BloodPoolLivingEntityAttachment.getData((LivingEntity)target);
            if (playerBloodData.getBloodPool() >= playerBloodData.getMaxBlood() || targetData.getBloodPool() <= 0) {
                return false;
            }
            return AfflictionHandler.INSTANCE.vampireDrinkBloodAbility((ServerPlayer)player, (LivingEntity)target, playerBloodData);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"dev/sterner/witchery/features/affliction/vampire/VampireAbility.NIGHT_VISION", "Ldev/sterner/witchery/features/affliction/vampire/VampireAbility;", "id", "", "getId", "()Ljava/lang/String;", "affliction", "Ldev/sterner/witchery/features/affliction/AfflictionTypes;", "getAffliction", "()Ldev/sterner/witchery/features/affliction/AfflictionTypes;", "use", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    @SourceDebugExtension(value={"SMAP\nVampireAbility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VampireAbility.kt\ndev/sterner/witchery/features/affliction/vampire/VampireAbility$NIGHT_VISION\n+ 2 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n*L\n1#1,123:1\n69#2,15:124\n*S KotlinDebug\n*F\n+ 1 VampireAbility.kt\ndev/sterner/witchery/features/affliction/vampire/VampireAbility$NIGHT_VISION\n*L\n49#1:124,15\n*E\n"})
    static final class NIGHT_VISION
    extends VampireAbility {
        @NotNull
        private final AfflictionTypes affliction = AfflictionTypes.VAMPIRISM;

        /*
         * WARNING - void declaration
         */
        NIGHT_VISION() {
            void var1_1;
        }

        @Override
        @NotNull
        public String getId() {
            return "night_vision";
        }

        @Override
        @NotNull
        public AfflictionTypes getAffliction() {
            return this.affliction;
        }

        @Override
        public boolean use(@NotNull Player player) {
            AfflictionPlayerAttachment.Data currentData$iv;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            boolean hadNightVision = AfflictionPlayerAttachment.getData(player).hasNightVision();
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$use_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            AfflictionPlayerAttachment.Data newData$iv = $this$use_u24lambda_u240.withNightVision(!hadNightVision);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
            if (hadNightVision) {
                AbilityCooldownManager.INSTANCE.startCooldown(player, this);
            }
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"dev/sterner/witchery/features/affliction/vampire/VampireAbility.SPEED", "Ldev/sterner/witchery/features/affliction/vampire/VampireAbility;", "id", "", "getId", "()Ljava/lang/String;", "use", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    @SourceDebugExtension(value={"SMAP\nVampireAbility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VampireAbility.kt\ndev/sterner/witchery/features/affliction/vampire/VampireAbility$SPEED\n+ 2 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n*L\n1#1,123:1\n69#2,15:124\n*S KotlinDebug\n*F\n+ 1 VampireAbility.kt\ndev/sterner/witchery/features/affliction/vampire/VampireAbility$SPEED\n*L\n93#1:124,15\n*E\n"})
    static final class SPEED
    extends VampireAbility {
        /*
         * WARNING - void declaration
         */
        SPEED() {
            void var1_1;
        }

        @Override
        @NotNull
        public String getId() {
            return "speed";
        }

        @Override
        public boolean use(@NotNull Player player) {
            AfflictionPlayerAttachment.Data currentData$iv;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            boolean wasActive = AfflictionPlayerAttachment.getData(player).hasSpeedBoost();
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$use_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            AfflictionPlayerAttachment.Data newData$iv = $this$use_u24lambda_u240.withSpeedBoost(!wasActive);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
            if (wasActive) {
                AbilityCooldownManager.INSTANCE.startCooldown(player, this);
            }
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000/\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"dev/sterner/witchery/features/affliction/vampire/VampireAbility.TRANSFIX", "Ldev/sterner/witchery/features/affliction/vampire/VampireAbility;", "id", "", "getId", "()Ljava/lang/String;", "affliction", "Ldev/sterner/witchery/features/affliction/AfflictionTypes;", "getAffliction", "()Ldev/sterner/witchery/features/affliction/AfflictionTypes;", "requiresTarget", "", "getRequiresTarget", "()Z", "use", "player", "Lnet/minecraft/world/entity/player/Player;", "target", "Lnet/minecraft/world/entity/Entity;", "witchery"})
    static final class TRANSFIX
    extends VampireAbility {
        @NotNull
        private final AfflictionTypes affliction = AfflictionTypes.VAMPIRISM;

        /*
         * WARNING - void declaration
         */
        TRANSFIX() {
            void var1_1;
        }

        @Override
        @NotNull
        public String getId() {
            return "transfix";
        }

        @Override
        @NotNull
        public AfflictionTypes getAffliction() {
            return this.affliction;
        }

        @Override
        public boolean getRequiresTarget() {
            return true;
        }

        @Override
        public boolean use(@NotNull Player player, @NotNull Entity target) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (!(player instanceof ServerPlayer) || !(target instanceof LivingEntity)) {
                return false;
            }
            if (target instanceof VillagerTransfix) {
                VillagerTransfix transfixVillager = (VillagerTransfix)target;
                Vec3 vec3 = ((ServerPlayer)player).getEyePosition();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
                transfixVillager.setTransfixedLookVector(vec3);
                if (AfflictionPlayerAttachment.getData(player).getVampireLevel() >= 8) {
                    UUID uUID = ((ServerPlayer)player).getUUID();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                    transfixVillager.witchery$setMesmerized(uUID);
                }
                AbilityCooldownManager.INSTANCE.startCooldown(player, this);
                return true;
            }
            return false;
        }
    }
}

