/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.vampire;

import dev.sterner.witchery.content.entity.VampireEntity;
import dev.sterner.witchery.features.affliction.vampire.VampireChildrenHuntLevelAttachment;
import dev.sterner.witchery.features.blood.BloodPoolHandler;
import dev.sterner.witchery.network.SpawnSmokeParticlesS2CPayload;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Ldev/sterner/witchery/features/affliction/vampire/VampireChildrenHuntHandler;", "", "<init>", "()V", "findSpawnPosition", "Lnet/minecraft/core/BlockPos;", "serverLevel", "Lnet/minecraft/server/level/ServerLevel;", "coffinPos", "returnFromHunt", "Ldev/sterner/witchery/content/entity/VampireEntity;", "huntData", "Ldev/sterner/witchery/features/affliction/vampire/VampireChildrenHuntLevelAttachment$HuntData;", "calculateBloodCollected", "", "tryStartHunt", "", "vampireEntity", "playerUUID", "Ljava/util/UUID;", "tickHuntAllLevels", "minecraftServer", "Lnet/minecraft/server/MinecraftServer;", "tickHunt", "data", "Ldev/sterner/witchery/features/affliction/vampire/VampireChildrenHuntLevelAttachment$Data;", "witchery"})
@SourceDebugExtension(value={"SMAP\nVampireChildrenHuntHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VampireChildrenHuntHandler.kt\ndev/sterner/witchery/features/affliction/vampire/VampireChildrenHuntHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,145:1\n382#2,7:146\n*S KotlinDebug\n*F\n+ 1 VampireChildrenHuntHandler.kt\ndev/sterner/witchery/features/affliction/vampire/VampireChildrenHuntHandler\n*L\n75#1:146,7\n*E\n"})
public final class VampireChildrenHuntHandler {
    @NotNull
    public static final VampireChildrenHuntHandler INSTANCE = new VampireChildrenHuntHandler();

    private VampireChildrenHuntHandler() {
    }

    private final BlockPos findSpawnPosition(ServerLevel serverLevel, BlockPos coffinPos) {
        Stream stream = BlockPos.betweenClosedStream((AABB)AABB.ofSize((Vec3)coffinPos.getCenter(), (double)10.0, (double)10.0, (double)10.0));
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"betweenClosedStream(...)");
        Stream directions = stream;
        return directions.filter(arg_0 -> VampireChildrenHuntHandler.findSpawnPosition$lambda$1(arg_0 -> VampireChildrenHuntHandler.findSpawnPosition$lambda$0(serverLevel, arg_0), arg_0)).findFirst().orElse(null);
    }

    @JvmStatic
    @Nullable
    public static final VampireEntity returnFromHunt(@NotNull ServerLevel serverLevel, @NotNull VampireChildrenHuntLevelAttachment.HuntData huntData) {
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        Intrinsics.checkNotNullParameter((Object)huntData, (String)"huntData");
        BlockPos coffinPos = huntData.getCoffinPos();
        BlockPos blockPos = INSTANCE.findSpawnPosition(serverLevel, coffinPos);
        if (blockPos == null) {
            return null;
        }
        BlockPos spawnPos = blockPos;
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)huntData.getEntityNbt(), (Level)((Level)serverLevel), VampireChildrenHuntHandler::returnFromHunt$lambda$0);
        if (entity == null) {
            return null;
        }
        Entity entity2 = entity;
        if (entity2 instanceof VampireEntity) {
            entity2.moveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, serverLevel.random.nextFloat() * 360.0f, 0.0f);
            serverLevel.addFreshEntity(entity2);
            int bloodCollected = INSTANCE.calculateBloodCollected(serverLevel);
            ((VampireEntity)entity2).returnFromHunt(bloodCollected);
            return (VampireEntity)entity2;
        }
        return null;
    }

    private final int calculateBloodCollected(ServerLevel serverLevel) {
        int baseAmount = 25;
        int randomBonus = serverLevel.random.nextInt(75);
        return baseAmount + randomBonus;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void tryStartHunt(@NotNull ServerLevel serverLevel, @NotNull VampireEntity vampireEntity, @NotNull UUID playerUUID) {
        Object object;
        void $this$getOrPut$iv;
        Map mutableData;
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        Intrinsics.checkNotNullParameter((Object)((Object)vampireEntity), (String)"vampireEntity");
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        if (serverLevel.isDay()) {
            return;
        }
        VampireChildrenHuntLevelAttachment.Data data2 = VampireChildrenHuntLevelAttachment.getData(serverLevel);
        Map map = mutableData = MapsKt.toMutableMap(data2.getData());
        UUID key$iv = playerUUID;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        List hunts = (List)object;
        if (vampireEntity.getHuntedLastNight()) {
            return;
        }
        CompoundTag savedNbt = new CompoundTag();
        vampireEntity.saveAsPassenger(savedNbt);
        Object object2 = vampireEntity.getCoffinPos();
        if (object2 == null && (object2 = vampireEntity.getCreationPos()) == null) {
            Player player = serverLevel.getPlayerByUUID(playerUUID);
            object2 = player != null ? player.blockPosition() : null;
            if (object2 == null) {
                return;
            }
        }
        BlockPos blockPos = vampireEntity.getCreationPos();
        if (blockPos == null) {
            return;
        }
        VampireChildrenHuntLevelAttachment.HuntData huntData = new VampireChildrenHuntLevelAttachment.HuntData(savedNbt, (BlockPos)object2, blockPos);
        hunts.add(huntData);
        VampireChildrenHuntLevelAttachment.setData(serverLevel, new VampireChildrenHuntLevelAttachment.Data(mutableData));
        ChunkPos chunkPos = vampireEntity.chunkPosition();
        Vec3 vec3 = vampireEntity.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)chunkPos, (CustomPacketPayload)new SpawnSmokeParticlesS2CPayload(vec3), (CustomPacketPayload[])new CustomPacketPayload[0]);
        vampireEntity.remove(Entity.RemovalReason.DISCARDED);
    }

    public final void tickHuntAllLevels(@Nullable MinecraftServer minecraftServer) {
        if (minecraftServer == null) {
            return;
        }
        for (ServerLevel serverLevel : minecraftServer.getAllLevels()) {
            Intrinsics.checkNotNull((Object)serverLevel);
            VampireChildrenHuntLevelAttachment.Data data2 = VampireChildrenHuntLevelAttachment.getData(serverLevel);
            if (!(!data2.getData().isEmpty())) continue;
            this.tickHunt(serverLevel, data2);
        }
    }

    private final void tickHunt(ServerLevel serverLevel, VampireChildrenHuntLevelAttachment.Data data2) {
        if (serverLevel.isDay()) {
            long currentTime = serverLevel.getDayTime();
            Iterator<Map.Entry<UUID, List<VampireChildrenHuntLevelAttachment.HuntData>>> iterator = data2.getData().entrySet().iterator();
            while (iterator.hasNext()) {
                List<VampireChildrenHuntLevelAttachment.HuntData> hunts = iterator.next().getValue();
                Iterator<VampireChildrenHuntLevelAttachment.HuntData> huntsIterator = hunts.iterator();
                while (huntsIterator.hasNext()) {
                    VampireChildrenHuntLevelAttachment.HuntData huntData = huntsIterator.next();
                    VampireEntity vampireEntity = VampireChildrenHuntHandler.returnFromHunt(serverLevel, huntData);
                    if (vampireEntity == null) continue;
                    vampireEntity.setHuntedLastNight(true);
                    vampireEntity.setLastHuntTimestamp(currentTime);
                    BloodPoolHandler.increaseBlood((LivingEntity)vampireEntity, 300);
                    huntsIterator.remove();
                }
                if (!hunts.isEmpty()) continue;
                iterator.remove();
            }
            VampireChildrenHuntLevelAttachment.setData(serverLevel, data2);
        }
    }

    private static final boolean findSpawnPosition$lambda$0(ServerLevel $serverLevel, BlockPos pos) {
        return $serverLevel.getBlockState(pos).isAir() && $serverLevel.getBlockState(pos.above()).isAir();
    }

    private static final boolean findSpawnPosition$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Entity returnFromHunt$lambda$0(Entity it) {
        return (Entity)(it instanceof VampireEntity ? (VampireEntity)it : null);
    }
}

