/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.werewolf;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.core.api.event.WerewolfEvent;
import dev.sterner.witchery.core.util.WitcheryUtil;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.AfflictionTypes;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbilityHandler;
import dev.sterner.witchery.features.affliction.event.TransformationHandler;
import dev.sterner.witchery.features.affliction.vampire.VampireLeveling;
import dev.sterner.witchery.network.RefreshDimensionsS2CPayload;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"J\u001e\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0018J\u001a\u0010&\u001a\u00020\u00112\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u0005H\u0002J\u0018\u0010/\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020,0+\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u00061"}, d2={"Ldev/sterner/witchery/features/affliction/werewolf/WerewolfLeveling;", "", "<init>", "()V", "KNOCKBACK_BONUS", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "KNOCKBACK_BONUS_2", "ATTACK_BONUS", "ATTACK_BONUS_2", "SPEED_BONUS", "SPEED_BONUS_2", "STEP_HEIGHT_BONUS", "SAFE_HEIGHT", "HEALTH_BONUS", "RESIST_BONUS", "RESIST_TOUGH_BONUS", "setLevel", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "level", "", "increaseWerewolfLevel", "canPerformQuest", "", "targetLevel", "increaseKilledPiglin", "setHasKilledHuntsman", "increaseKilledWolf", "increaseKilledSheep", "checkAndLevelUp", "data", "Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$Data;", "removeAllModifiers", "Lnet/minecraft/world/entity/player/Player;", "updateModifiers", "wolf", "wolfMan", "addModifierSafely", "attributeInstance", "Lnet/minecraft/world/entity/ai/attributes/AttributeInstance;", "modifier", "LEVEL_REQUIREMENTS", "", "Ldev/sterner/witchery/features/affliction/werewolf/WerewolfLeveling$Requirement;", "getLEVEL_REQUIREMENTS", "()Ljava/util/Map;", "canLevelUp", "Requirement", "witchery"})
@SourceDebugExtension(value={"SMAP\nWerewolfLeveling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WerewolfLeveling.kt\ndev/sterner/witchery/features/affliction/werewolf/WerewolfLeveling\n+ 2 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,289:1\n69#2,15:290\n74#2,10:305\n74#2,10:315\n74#2,10:325\n74#2,10:335\n1#3:345\n*S KotlinDebug\n*F\n+ 1 WerewolfLeveling.kt\ndev/sterner/witchery/features/affliction/werewolf/WerewolfLeveling\n*L\n66#1:290,15\n134#1:305,10\n147#1:315,10\n160#1:325,10\n173#1:335,10\n*E\n"})
public final class WerewolfLeveling {
    @NotNull
    public static final WerewolfLeveling INSTANCE = new WerewolfLeveling();
    @NotNull
    private static final AttributeModifier KNOCKBACK_BONUS = new AttributeModifier(Witchery.Companion.id("werewolf_knockback"), 0.5, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final AttributeModifier KNOCKBACK_BONUS_2 = new AttributeModifier(Witchery.Companion.id("werewolf_knockback_2"), 0.6, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final AttributeModifier ATTACK_BONUS = new AttributeModifier(Witchery.Companion.id("werewolf_damage"), 0.5, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final AttributeModifier ATTACK_BONUS_2 = new AttributeModifier(Witchery.Companion.id("werewolf_damage_2"), 0.75, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final AttributeModifier SPEED_BONUS = new AttributeModifier(Witchery.Companion.id("werewolf_speed"), 0.1, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final AttributeModifier SPEED_BONUS_2 = new AttributeModifier(Witchery.Companion.id("werewolf_speed_2"), 0.05, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final AttributeModifier STEP_HEIGHT_BONUS = new AttributeModifier(Witchery.Companion.id("werewolf_step"), 0.75, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final AttributeModifier SAFE_HEIGHT = new AttributeModifier(Witchery.Companion.id("werewolf_land"), 2.0, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final AttributeModifier HEALTH_BONUS = new AttributeModifier(Witchery.Companion.id("werewolf_health"), 10.0, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final AttributeModifier RESIST_BONUS = new AttributeModifier(Witchery.Companion.id("werewolf_resist"), 5.0, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final AttributeModifier RESIST_TOUGH_BONUS = new AttributeModifier(Witchery.Companion.id("werewolf_resist_tough"), 5.0, AttributeModifier.Operation.ADD_VALUE);
    @NotNull
    private static final Map<Integer, Requirement> LEVEL_REQUIREMENTS;

    private WerewolfLeveling() {
    }

    @JvmStatic
    public static final void setLevel(@NotNull ServerPlayer player, int level) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int previousLevel = AfflictionPlayerAttachment.getData((Player)player).getWerewolfLevel();
        if (level == 0) {
            newData = AfflictionPlayerAttachment.getData((Player)player).setLevel(AfflictionTypes.LYCANTHROPY, 0).withAbilityIndex(-1).withWolfForm(false).withWolfManForm(false).withWolfPack(0);
            AfflictionPlayerAttachment.setData((Player)player, (AfflictionPlayerAttachment.Data)newData, false);
            AfflictionPlayerAttachment.syncFull((Player)player, (AfflictionPlayerAttachment.Data)newData);
            TransformationHandler.removeForm((Player)player);
        } else {
            AfflictionPlayerAttachment.Data currentData$iv;
            newData = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = (Player)player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$setLevel_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl = false;
            AfflictionPlayerAttachment.Data newData$iv = $this$setLevel_u24lambda_u240.setLevel(AfflictionTypes.LYCANTHROPY, level);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
        }
        boolean wolf = TransformationHandler.isWolf((Player)player);
        boolean were = TransformationHandler.isWerewolf((Player)player);
        INSTANCE.updateModifiers((Player)player, wolf, were);
        player.refreshDimensions();
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)player.serverLevel(), (ChunkPos)player.chunkPosition(), (CustomPacketPayload)new RefreshDimensionsS2CPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (level > previousLevel) {
            AfflictionAbilityHandler.addAbilityOnLevelUp$default(AfflictionAbilityHandler.INSTANCE, (Player)player, level, AfflictionTypes.LYCANTHROPY, false, 8, null);
        }
    }

    @JvmStatic
    public static final void increaseWerewolfLevel(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AfflictionPlayerAttachment.Data currentData = AfflictionPlayerAttachment.getData((Player)player);
        int currentLevel = currentData.getWerewolfLevel();
        int nextLevel = currentLevel + 1;
        if (nextLevel > 10) {
            return;
        }
        if (nextLevel > 1 && !INSTANCE.canLevelUp(currentData, nextLevel)) {
            return;
        }
        WerewolfEvent.LevelUp event = new WerewolfEvent.LevelUp((Player)player, currentLevel, nextLevel);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        WerewolfLeveling.setLevel(player, nextLevel);
        player.sendSystemMessage((Component)Component.literal((String)("Werewolf Level Up: " + nextLevel)));
        INSTANCE.updateModifiers((Player)player, currentData.isWolfForm(), currentData.isWolfManForm());
        WitcheryApi.INSTANCE.makePlayerWitchy((Player)player);
    }

    private final boolean canPerformQuest(ServerPlayer player, int targetLevel) {
        AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData((Player)player);
        if (data2.getWerewolfLevel() != targetLevel) {
            return false;
        }
        Requirement requirement = LEVEL_REQUIREMENTS.get(targetLevel);
        if (requirement == null || (requirement = requirement.getAdvancement()) == null) {
            return false;
        }
        Requirement requiredAdvancement = requirement;
        return WitcheryUtil.INSTANCE.hasAdvancement(player, (ResourceLocation)requiredAdvancement);
    }

    /*
     * WARNING - void declaration
     */
    public final void increaseKilledPiglin(@NotNull ServerPlayer player) {
        void player$iv;
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.canPerformQuest(player, 8)) {
            return;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player2 = (Player)player;
        boolean sync$iv = false;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$increaseKilledPiglin_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData((Player)player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = AfflictionPlayerAttachment.Data.incrementPigmenKilled$default($this$increaseKilledPiglin_u24lambda_u240, 0, 1, null);
        AfflictionPlayerAttachment.setData((Player)player$iv, newData$iv, false);
        AfflictionPlayerAttachment.Data newData = newData$iv;
        this.checkAndLevelUp(player, newData);
    }

    /*
     * WARNING - void declaration
     */
    public final void setHasKilledHuntsman(@NotNull ServerPlayer player) {
        void player$iv;
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.canPerformQuest(player, 4)) {
            return;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player2 = (Player)player;
        boolean sync$iv = false;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$setHasKilledHuntsman_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData((Player)player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = $this$setHasKilledHuntsman_u24lambda_u240.withKilledHornedOne(true);
        AfflictionPlayerAttachment.setData((Player)player$iv, newData$iv, false);
        AfflictionPlayerAttachment.Data newData = newData$iv;
        this.checkAndLevelUp(player, newData);
    }

    /*
     * WARNING - void declaration
     */
    public final void increaseKilledWolf(@NotNull ServerPlayer player) {
        void player$iv;
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.canPerformQuest(player, 3)) {
            return;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player2 = (Player)player;
        boolean sync$iv = false;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$increaseKilledWolf_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData((Player)player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = AfflictionPlayerAttachment.Data.incrementKilledWolves$default($this$increaseKilledWolf_u24lambda_u240, 0, 1, null);
        AfflictionPlayerAttachment.setData((Player)player$iv, newData$iv, false);
        AfflictionPlayerAttachment.Data newData = newData$iv;
        this.checkAndLevelUp(player, newData);
    }

    /*
     * WARNING - void declaration
     */
    public final void increaseKilledSheep(@NotNull ServerPlayer player) {
        void player$iv;
        AfflictionPlayerAttachment.Data currentData$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.canPerformQuest(player, 2)) {
            return;
        }
        AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
        Player player2 = (Player)player;
        boolean sync$iv = false;
        boolean $i$f$smartUpdate = false;
        AfflictionPlayerAttachment.Data $this$increaseKilledSheep_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData((Player)player$iv);
        boolean bl = false;
        AfflictionPlayerAttachment.Data newData$iv = AfflictionPlayerAttachment.Data.incrementKilledSheep$default($this$increaseKilledSheep_u24lambda_u240, 0, 1, null);
        AfflictionPlayerAttachment.setData((Player)player$iv, newData$iv, false);
        AfflictionPlayerAttachment.Data newData = newData$iv;
        this.checkAndLevelUp(player, newData);
    }

    private final void checkAndLevelUp(ServerPlayer player, AfflictionPlayerAttachment.Data data2) {
        int currentLevel = data2.getWerewolfLevel();
        int nextLevel = currentLevel + 1;
        if (nextLevel <= 10 && this.canLevelUp(data2, nextLevel)) {
            VampireLeveling.increaseVampireLevel(player);
        }
    }

    public final void removeAllModifiers(@NotNull Player player) {
        block7: {
            AttributeInstance it;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            AttributeInstance attributeInstance = player.getAttributes().getInstance(Attributes.ATTACK_KNOCKBACK);
            if (attributeInstance != null) {
                it = attributeInstance;
                boolean bl = false;
                it.removeModifier(KNOCKBACK_BONUS);
                it.removeModifier(KNOCKBACK_BONUS_2);
            }
            AttributeInstance attributeInstance2 = player.getAttributes().getInstance(Attributes.MOVEMENT_SPEED);
            if (attributeInstance2 != null) {
                it = attributeInstance2;
                boolean bl = false;
                it.removeModifier(SPEED_BONUS);
                it.removeModifier(SPEED_BONUS_2);
            }
            AttributeInstance attributeInstance3 = player.getAttributes().getInstance(Attributes.ATTACK_DAMAGE);
            if (attributeInstance3 != null) {
                it = attributeInstance3;
                boolean bl = false;
                it.removeModifier(ATTACK_BONUS);
                it.removeModifier(ATTACK_BONUS_2);
            }
            AttributeInstance attributeInstance4 = player.getAttributes().getInstance(Attributes.STEP_HEIGHT);
            if (attributeInstance4 != null) {
                attributeInstance4.removeModifier(STEP_HEIGHT_BONUS);
            }
            AttributeInstance attributeInstance5 = player.getAttributes().getInstance(Attributes.SAFE_FALL_DISTANCE);
            if (attributeInstance5 != null) {
                attributeInstance5.removeModifier(SAFE_HEIGHT);
            }
            AttributeInstance attributeInstance6 = player.getAttributes().getInstance(Attributes.MAX_HEALTH);
            if (attributeInstance6 != null) {
                attributeInstance6.removeModifier(HEALTH_BONUS);
            }
            AttributeInstance attributeInstance7 = player.getAttributes().getInstance(Attributes.ARMOR);
            if (attributeInstance7 != null) {
                attributeInstance7.removeModifier(RESIST_BONUS);
            }
            AttributeInstance attributeInstance8 = player.getAttributes().getInstance(Attributes.ARMOR_TOUGHNESS);
            if (attributeInstance8 == null) break block7;
            attributeInstance8.removeModifier(RESIST_TOUGH_BONUS);
        }
    }

    public final void updateModifiers(@NotNull Player player, boolean wolf, boolean wolfMan) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.removeAllModifiers(player);
        if (wolf) {
            this.addModifierSafely(player.getAttributes().getInstance(Attributes.ATTACK_DAMAGE), ATTACK_BONUS);
            this.addModifierSafely(player.getAttributes().getInstance(Attributes.MOVEMENT_SPEED), SPEED_BONUS);
            this.addModifierSafely(player.getAttributes().getInstance(Attributes.ATTACK_KNOCKBACK), KNOCKBACK_BONUS);
            this.addModifierSafely(player.getAttributes().getInstance(Attributes.STEP_HEIGHT), STEP_HEIGHT_BONUS);
        } else if (wolfMan) {
            this.addModifierSafely(player.getAttributes().getInstance(Attributes.ATTACK_DAMAGE), ATTACK_BONUS_2);
            this.addModifierSafely(player.getAttributes().getInstance(Attributes.MOVEMENT_SPEED), SPEED_BONUS_2);
            this.addModifierSafely(player.getAttributes().getInstance(Attributes.ATTACK_KNOCKBACK), KNOCKBACK_BONUS_2);
            this.addModifierSafely(player.getAttributes().getInstance(Attributes.STEP_HEIGHT), STEP_HEIGHT_BONUS);
            this.addModifierSafely(player.getAttributes().getInstance(Attributes.SAFE_FALL_DISTANCE), SAFE_HEIGHT);
            this.addModifierSafely(player.getAttributes().getInstance(Attributes.MAX_HEALTH), HEALTH_BONUS);
            this.addModifierSafely(player.getAttributes().getInstance(Attributes.ARMOR), RESIST_BONUS);
            this.addModifierSafely(player.getAttributes().getInstance(Attributes.ARMOR_TOUGHNESS), RESIST_TOUGH_BONUS);
        }
    }

    private final void addModifierSafely(AttributeInstance attributeInstance, AttributeModifier modifier) {
        block1: {
            AttributeInstance attributeInstance2 = attributeInstance;
            if (attributeInstance2 == null) break block1;
            AttributeInstance attribute = attributeInstance2;
            boolean bl = false;
            if (!attribute.hasModifier(modifier.id())) {
                attribute.addPermanentModifier(modifier);
            }
        }
    }

    @NotNull
    public final Map<Integer, Requirement> getLEVEL_REQUIREMENTS() {
        return LEVEL_REQUIREMENTS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canLevelUp(AfflictionPlayerAttachment.Data data2, int targetLevel) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        boolean bl8;
        int it;
        if (targetLevel == 1) {
            return true;
        }
        if (targetLevel > 10) {
            return false;
        }
        Requirement requirement = LEVEL_REQUIREMENTS.get(targetLevel);
        if (requirement == null) {
            return false;
        }
        Requirement requirement2 = requirement;
        Boolean bl9 = requirement2.getThreeGold();
        if (bl9 != null) {
            it = bl9.booleanValue();
            boolean bl10 = false;
            if (data2.hasGivenGold() != it) return false;
            bl8 = true;
        } else {
            bl8 = true;
        }
        if (!bl8) return false;
        Integer n = requirement2.getKilledSheep();
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl11 = false;
            if (data2.getKilledSheep() < it) return false;
            bl7 = true;
        } else {
            bl7 = true;
        }
        if (!bl7) return false;
        Integer n2 = requirement2.getKilledWolves();
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl12 = false;
            if (data2.getKilledWolves() < it) return false;
            bl6 = true;
        } else {
            bl6 = true;
        }
        if (!bl6) return false;
        Boolean bl13 = requirement2.getKillHornedOne();
        if (bl13 != null) {
            it = bl13.booleanValue() ? 1 : 0;
            boolean bl14 = false;
            if (data2.hasKilledHornedOne() != it) return false;
            bl5 = true;
        } else {
            bl5 = true;
        }
        if (!bl5) return false;
        Integer n3 = requirement2.getAirSlayMonster();
        if (n3 != null) {
            it = ((Number)n3).intValue();
            boolean bl15 = false;
            if (data2.getAirSlayMonster() != it) return false;
            bl4 = true;
        } else {
            bl4 = true;
        }
        if (!bl4) return false;
        Integer n4 = requirement2.getNightHowl();
        if (n4 != null) {
            it = ((Number)n4).intValue();
            boolean bl16 = false;
            if (data2.getNightHowl() != it) return false;
            bl3 = true;
        } else {
            bl3 = true;
        }
        if (!bl3) return false;
        Integer n5 = requirement2.getWolfPack();
        if (n5 != null) {
            it = ((Number)n5).intValue();
            boolean bl17 = false;
            if (data2.getWolfPack() != it) return false;
            bl2 = true;
        } else {
            bl2 = true;
        }
        if (!bl2) return false;
        Integer n6 = requirement2.getPigmenKilled();
        if (n6 != null) {
            it = ((Number)n6).intValue();
            boolean bl18 = false;
            if (data2.getPigmenKilled() != it) return false;
            bl = true;
        } else {
            bl = true;
        }
        if (!bl) return false;
        Boolean bl19 = requirement2.getSpreadLycantropy();
        if (bl19 == null) return true;
        it = bl19.booleanValue() ? 1 : 0;
        boolean bl20 = false;
        if (data2.hasSpreadLycanthropy() != it) return false;
        return true;
    }

    static {
        Pair[] pairArray = new Pair[9];
        Integer n = 2;
        ResourceLocation resourceLocation = Witchery.Companion.id("werewolf/1");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        pairArray[0] = TuplesKt.to((Object)n, (Object)new Requirement(resourceLocation, true, null, null, null, null, null, null, null, null, 1020, null));
        Integer n2 = 3;
        ResourceLocation resourceLocation2 = Witchery.Companion.id("werewolf/2");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"id(...)");
        pairArray[1] = TuplesKt.to((Object)n2, (Object)new Requirement(resourceLocation2, null, 30, null, null, null, null, null, null, null, 1018, null));
        Integer n3 = 4;
        ResourceLocation resourceLocation3 = Witchery.Companion.id("werewolf/3");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"id(...)");
        pairArray[2] = TuplesKt.to((Object)n3, (Object)new Requirement(resourceLocation3, null, null, 10, null, null, null, null, null, null, 1014, null));
        Integer n4 = 5;
        ResourceLocation resourceLocation4 = Witchery.Companion.id("werewolf/4");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"id(...)");
        pairArray[3] = TuplesKt.to((Object)n4, (Object)new Requirement(resourceLocation4, null, null, null, true, null, null, null, null, null, 1006, null));
        Integer n5 = 6;
        ResourceLocation resourceLocation5 = Witchery.Companion.id("werewolf/5");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation5, (String)"id(...)");
        pairArray[4] = TuplesKt.to((Object)n5, (Object)new Requirement(resourceLocation5, null, null, null, null, 10, null, null, null, null, 990, null));
        Integer n6 = 7;
        ResourceLocation resourceLocation6 = Witchery.Companion.id("werewolf/6");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation6, (String)"id(...)");
        pairArray[5] = TuplesKt.to((Object)n6, (Object)new Requirement(resourceLocation6, null, null, null, null, null, 10, null, null, null, 958, null));
        Integer n7 = 8;
        ResourceLocation resourceLocation7 = Witchery.Companion.id("werewolf/7");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation7, (String)"id(...)");
        pairArray[6] = TuplesKt.to((Object)n7, (Object)new Requirement(resourceLocation7, null, null, null, null, null, null, 6, null, null, 894, null));
        Integer n8 = 9;
        ResourceLocation resourceLocation8 = Witchery.Companion.id("werewolf/8");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation8, (String)"id(...)");
        pairArray[7] = TuplesKt.to((Object)n8, (Object)new Requirement(resourceLocation8, null, null, null, null, null, null, null, 30, null, 766, null));
        Integer n9 = 10;
        ResourceLocation resourceLocation9 = Witchery.Companion.id("werewolf/9");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation9, (String)"id(...)");
        pairArray[8] = TuplesKt.to((Object)n9, (Object)new Requirement(resourceLocation9, null, null, null, null, null, null, null, null, true, 510, null));
        LEVEL_REQUIREMENTS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b(\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B{\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0010J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010!\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\"\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010#\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010$\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010%\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010&\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010'\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010(\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010)\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0014J\u0084\u0001\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010+J\u0013\u0010,\u001a\u00020\u00052\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020\u0007H\u00d6\u0001J\t\u0010/\u001a\u000200H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0019\u0010\u0017R\u0015\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u001a\u0010\u0014R\u0015\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u001b\u0010\u0017R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u001c\u0010\u0017R\u0015\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u001d\u0010\u0017R\u0015\u0010\r\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u001e\u0010\u0017R\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u001f\u0010\u0014\u00a8\u00061"}, d2={"Ldev/sterner/witchery/features/affliction/werewolf/WerewolfLeveling$Requirement;", "", "advancement", "Lnet/minecraft/resources/ResourceLocation;", "threeGold", "", "killedSheep", "", "killedWolves", "killHornedOne", "airSlayMonster", "nightHowl", "wolfPack", "pigmenKilled", "spreadLycantropy", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;)V", "getAdvancement", "()Lnet/minecraft/resources/ResourceLocation;", "getThreeGold", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getKilledSheep", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getKilledWolves", "getKillHornedOne", "getAirSlayMonster", "getNightHowl", "getWolfPack", "getPigmenKilled", "getSpreadLycantropy", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "(Lnet/minecraft/resources/ResourceLocation;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;)Ldev/sterner/witchery/features/affliction/werewolf/WerewolfLeveling$Requirement;", "equals", "other", "hashCode", "toString", "", "witchery"})
    public static final class Requirement {
        @NotNull
        private final ResourceLocation advancement;
        @Nullable
        private final Boolean threeGold;
        @Nullable
        private final Integer killedSheep;
        @Nullable
        private final Integer killedWolves;
        @Nullable
        private final Boolean killHornedOne;
        @Nullable
        private final Integer airSlayMonster;
        @Nullable
        private final Integer nightHowl;
        @Nullable
        private final Integer wolfPack;
        @Nullable
        private final Integer pigmenKilled;
        @Nullable
        private final Boolean spreadLycantropy;

        public Requirement(@NotNull ResourceLocation advancement, @Nullable Boolean threeGold, @Nullable Integer killedSheep, @Nullable Integer killedWolves, @Nullable Boolean killHornedOne, @Nullable Integer airSlayMonster, @Nullable Integer nightHowl, @Nullable Integer wolfPack, @Nullable Integer pigmenKilled, @Nullable Boolean spreadLycantropy) {
            Intrinsics.checkNotNullParameter((Object)advancement, (String)"advancement");
            this.advancement = advancement;
            this.threeGold = threeGold;
            this.killedSheep = killedSheep;
            this.killedWolves = killedWolves;
            this.killHornedOne = killHornedOne;
            this.airSlayMonster = airSlayMonster;
            this.nightHowl = nightHowl;
            this.wolfPack = wolfPack;
            this.pigmenKilled = pigmenKilled;
            this.spreadLycantropy = spreadLycantropy;
        }

        public /* synthetic */ Requirement(ResourceLocation resourceLocation, Boolean bl, Integer n, Integer n2, Boolean bl2, Integer n3, Integer n4, Integer n5, Integer n6, Boolean bl3, int n7, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n7 & 2) != 0) {
                bl = null;
            }
            if ((n7 & 4) != 0) {
                n = null;
            }
            if ((n7 & 8) != 0) {
                n2 = null;
            }
            if ((n7 & 0x10) != 0) {
                bl2 = null;
            }
            if ((n7 & 0x20) != 0) {
                n3 = null;
            }
            if ((n7 & 0x40) != 0) {
                n4 = null;
            }
            if ((n7 & 0x80) != 0) {
                n5 = null;
            }
            if ((n7 & 0x100) != 0) {
                n6 = null;
            }
            if ((n7 & 0x200) != 0) {
                bl3 = null;
            }
            this(resourceLocation, bl, n, n2, bl2, n3, n4, n5, n6, bl3);
        }

        @NotNull
        public final ResourceLocation getAdvancement() {
            return this.advancement;
        }

        @Nullable
        public final Boolean getThreeGold() {
            return this.threeGold;
        }

        @Nullable
        public final Integer getKilledSheep() {
            return this.killedSheep;
        }

        @Nullable
        public final Integer getKilledWolves() {
            return this.killedWolves;
        }

        @Nullable
        public final Boolean getKillHornedOne() {
            return this.killHornedOne;
        }

        @Nullable
        public final Integer getAirSlayMonster() {
            return this.airSlayMonster;
        }

        @Nullable
        public final Integer getNightHowl() {
            return this.nightHowl;
        }

        @Nullable
        public final Integer getWolfPack() {
            return this.wolfPack;
        }

        @Nullable
        public final Integer getPigmenKilled() {
            return this.pigmenKilled;
        }

        @Nullable
        public final Boolean getSpreadLycantropy() {
            return this.spreadLycantropy;
        }

        @NotNull
        public final ResourceLocation component1() {
            return this.advancement;
        }

        @Nullable
        public final Boolean component2() {
            return this.threeGold;
        }

        @Nullable
        public final Integer component3() {
            return this.killedSheep;
        }

        @Nullable
        public final Integer component4() {
            return this.killedWolves;
        }

        @Nullable
        public final Boolean component5() {
            return this.killHornedOne;
        }

        @Nullable
        public final Integer component6() {
            return this.airSlayMonster;
        }

        @Nullable
        public final Integer component7() {
            return this.nightHowl;
        }

        @Nullable
        public final Integer component8() {
            return this.wolfPack;
        }

        @Nullable
        public final Integer component9() {
            return this.pigmenKilled;
        }

        @Nullable
        public final Boolean component10() {
            return this.spreadLycantropy;
        }

        @NotNull
        public final Requirement copy(@NotNull ResourceLocation advancement, @Nullable Boolean threeGold, @Nullable Integer killedSheep, @Nullable Integer killedWolves, @Nullable Boolean killHornedOne, @Nullable Integer airSlayMonster, @Nullable Integer nightHowl, @Nullable Integer wolfPack, @Nullable Integer pigmenKilled, @Nullable Boolean spreadLycantropy) {
            Intrinsics.checkNotNullParameter((Object)advancement, (String)"advancement");
            return new Requirement(advancement, threeGold, killedSheep, killedWolves, killHornedOne, airSlayMonster, nightHowl, wolfPack, pigmenKilled, spreadLycantropy);
        }

        public static /* synthetic */ Requirement copy$default(Requirement requirement, ResourceLocation resourceLocation, Boolean bl, Integer n, Integer n2, Boolean bl2, Integer n3, Integer n4, Integer n5, Integer n6, Boolean bl3, int n7, Object object) {
            if ((n7 & 1) != 0) {
                resourceLocation = requirement.advancement;
            }
            if ((n7 & 2) != 0) {
                bl = requirement.threeGold;
            }
            if ((n7 & 4) != 0) {
                n = requirement.killedSheep;
            }
            if ((n7 & 8) != 0) {
                n2 = requirement.killedWolves;
            }
            if ((n7 & 0x10) != 0) {
                bl2 = requirement.killHornedOne;
            }
            if ((n7 & 0x20) != 0) {
                n3 = requirement.airSlayMonster;
            }
            if ((n7 & 0x40) != 0) {
                n4 = requirement.nightHowl;
            }
            if ((n7 & 0x80) != 0) {
                n5 = requirement.wolfPack;
            }
            if ((n7 & 0x100) != 0) {
                n6 = requirement.pigmenKilled;
            }
            if ((n7 & 0x200) != 0) {
                bl3 = requirement.spreadLycantropy;
            }
            return requirement.copy(resourceLocation, bl, n, n2, bl2, n3, n4, n5, n6, bl3);
        }

        @NotNull
        public String toString() {
            return "Requirement(advancement=" + this.advancement + ", threeGold=" + this.threeGold + ", killedSheep=" + this.killedSheep + ", killedWolves=" + this.killedWolves + ", killHornedOne=" + this.killHornedOne + ", airSlayMonster=" + this.airSlayMonster + ", nightHowl=" + this.nightHowl + ", wolfPack=" + this.wolfPack + ", pigmenKilled=" + this.pigmenKilled + ", spreadLycantropy=" + this.spreadLycantropy + ")";
        }

        public int hashCode() {
            int result = this.advancement.hashCode();
            result = result * 31 + (this.threeGold == null ? 0 : ((Object)this.threeGold).hashCode());
            result = result * 31 + (this.killedSheep == null ? 0 : ((Object)this.killedSheep).hashCode());
            result = result * 31 + (this.killedWolves == null ? 0 : ((Object)this.killedWolves).hashCode());
            result = result * 31 + (this.killHornedOne == null ? 0 : ((Object)this.killHornedOne).hashCode());
            result = result * 31 + (this.airSlayMonster == null ? 0 : ((Object)this.airSlayMonster).hashCode());
            result = result * 31 + (this.nightHowl == null ? 0 : ((Object)this.nightHowl).hashCode());
            result = result * 31 + (this.wolfPack == null ? 0 : ((Object)this.wolfPack).hashCode());
            result = result * 31 + (this.pigmenKilled == null ? 0 : ((Object)this.pigmenKilled).hashCode());
            result = result * 31 + (this.spreadLycantropy == null ? 0 : ((Object)this.spreadLycantropy).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Requirement)) {
                return false;
            }
            Requirement requirement = (Requirement)other;
            if (!Intrinsics.areEqual((Object)this.advancement, (Object)requirement.advancement)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.threeGold, (Object)requirement.threeGold)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.killedSheep, (Object)requirement.killedSheep)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.killedWolves, (Object)requirement.killedWolves)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.killHornedOne, (Object)requirement.killHornedOne)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.airSlayMonster, (Object)requirement.airSlayMonster)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nightHowl, (Object)requirement.nightHowl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.wolfPack, (Object)requirement.wolfPack)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pigmenKilled, (Object)requirement.pigmenKilled)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.spreadLycantropy, (Object)requirement.spreadLycantropy);
        }
    }
}

