/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.bark_belt;

import dev.sterner.witchery.core.registry.WitcheryTags;
import dev.sterner.witchery.features.bark_belt.BarkBeltPlayerAttachment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/features/bark_belt/BarkBeltHandler;", "", "<init>", "()V", "TIME_TO_RECHARGE", "", "hurt", "", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "damage", "tick", "", "player", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
public final class BarkBeltHandler {
    @NotNull
    public static final BarkBeltHandler INSTANCE = new BarkBeltHandler();
    public static final int TIME_TO_RECHARGE = 100;

    private BarkBeltHandler() {
    }

    public final float hurt(@Nullable LivingEntity livingEntity, @NotNull DamageSource damageSource, float damage) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        if (livingEntity instanceof Player) {
            BarkBeltPlayerAttachment.Data data2 = BarkBeltPlayerAttachment.getData((Player)livingEntity);
            if (damageSource.getEntity() instanceof LivingEntity) {
                Entity entity = damageSource.getEntity();
                Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
                LivingEntity living = (LivingEntity)entity;
                if (living.getMainHandItem().is(WitcheryTags.INSTANCE.getWOODEN_WEAPONS())) {
                    BarkBeltPlayerAttachment.setData((Player)livingEntity, BarkBeltPlayerAttachment.Data.copy$default(data2, 0, 0, 0, 0, 14, null));
                    return damage;
                }
            }
            if (data2.getCurrentBark() > 0) {
                float absorbedDamage = RangesKt.coerceAtMost((float)(damage / (float)2), (float)data2.getCurrentBark());
                int newCharge = (int)((float)data2.getCurrentBark() - absorbedDamage);
                float remainingDamage = damage - absorbedDamage;
                BarkBeltPlayerAttachment.setData((Player)livingEntity, BarkBeltPlayerAttachment.Data.copy$default(data2, newCharge, 0, 0, 0, 6, null));
                return remainingDamage;
            }
        }
        return damage;
    }

    public final void tick(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            BarkBeltPlayerAttachment.Data data2 = BarkBeltPlayerAttachment.getData(player);
            int newTickCounter = data2.getTickCounter() + 1;
            if (newTickCounter >= 100 && data2.getCurrentBark() < data2.getMaxBark()) {
                int newCharge = RangesKt.coerceAtMost((int)(data2.getCurrentBark() + data2.getRechargeRate()), (int)data2.getMaxBark());
                BarkBeltPlayerAttachment.setData(player, BarkBeltPlayerAttachment.Data.copy$default(data2, newCharge, 0, 0, 0, 6, null));
            } else {
                BarkBeltPlayerAttachment.setData(player, BarkBeltPlayerAttachment.Data.copy$default(data2, 0, 0, 0, newTickCounter, 7, null));
            }
        }
    }
}

