/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.curse;

import dev.sterner.witchery.core.api.Curse;
import dev.sterner.witchery.core.api.PoppetLocation;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.core.api.interfaces.PoppetType;
import dev.sterner.witchery.core.registry.WitcheryPoppetRegistry;
import dev.sterner.witchery.features.poppet.CorruptPoppetPlayerAttachment;
import dev.sterner.witchery.features.poppet.PoppetHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J2\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/features/curse/CurseOfCorruptPoppet;", "Ldev/sterner/witchery/core/api/Curse;", "<init>", "()V", "onTickCurse", "", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "catBoosted", "", "onHurt", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "fl", "", "onRemoved", "onAdded", "attemptToCorruptPoppet", "showCorruptedPoppetParticles", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nCurseOfCorruptPoppet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurseOfCorruptPoppet.kt\ndev/sterner/witchery/features/curse/CurseOfCorruptPoppet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n1869#2,2:225\n1869#2,2:227\n*S KotlinDebug\n*F\n+ 1 CurseOfCorruptPoppet.kt\ndev/sterner/witchery/features/curse/CurseOfCorruptPoppet\n*L\n129#1:225,2\n188#1:227,2\n*E\n"})
public final class CurseOfCorruptPoppet
extends Curse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MAX_CORRUPTED_POPPETS = 10;
    private static final SimpleParticleType CORRUPTED_POPPET_PARTICLES = ParticleTypes.WITCH;

    @Override
    public void onTickCurse(@NotNull Level level, @NotNull Player player, boolean catBoosted) {
        long tickInterval;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onTickCurse(level, player, catBoosted);
        long l = tickInterval = WitcheryApi.INSTANCE.isWitchy(player) ? 100L : 300L;
        if (level.getGameTime() % tickInterval == 0L) {
            this.attemptToCorruptPoppet(level, player);
        }
        if (level.isClientSide && level.random.nextFloat() < 0.1f) {
            this.showCorruptedPoppetParticles(level, player);
        }
    }

    @Override
    public void onHurt(@NotNull Level level, @NotNull Player player, @Nullable DamageSource damageSource, float fl, boolean catBoosted) {
        float corruptChance;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onHurt(level, player, damageSource, fl, catBoosted);
        float f = corruptChance = WitcheryApi.INSTANCE.isWitchy(player) ? 0.2f : 0.05f;
        if (level.random.nextFloat() < corruptChance) {
            this.attemptToCorruptPoppet(level, player);
        }
    }

    @Override
    public void onRemoved(@NotNull Level level, @NotNull Player player, boolean catBoosted) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onRemoved(level, player, catBoosted);
        CorruptPoppetPlayerAttachment.Data corruptData = CorruptPoppetPlayerAttachment.getData(player);
        if (corruptData.getCorruptedPoppetCount() > 0) {
            CorruptPoppetPlayerAttachment.setData(player, new CorruptPoppetPlayerAttachment.Data(0, null, 3, null));
            CorruptPoppetPlayerAttachment.INSTANCE.sync(player, new CorruptPoppetPlayerAttachment.Data(0, null, 3, null));
            if (level instanceof ServerLevel) {
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.ENCHANT, player.getX(), player.getY() + 1.0, player.getZ(), 30, 0.5, 0.5, 0.5, 0.1);
            }
            player.displayClientMessage((Component)Component.translatable((String)"curse.witchery.corrupt_poppet.cleansed").withStyle(ChatFormatting.GREEN), true);
        }
    }

    @Override
    public void onAdded(@NotNull Level level, @NotNull Player player, boolean catBoosted) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onAdded(level, player, catBoosted);
        CorruptPoppetPlayerAttachment.setData(player, new CorruptPoppetPlayerAttachment.Data(0, null, 3, null));
        CorruptPoppetPlayerAttachment.INSTANCE.sync(player, new CorruptPoppetPlayerAttachment.Data(0, null, 3, null));
        player.displayClientMessage((Component)Component.translatable((String)"curse.witchery.corrupt_poppet.applied").withStyle(ChatFormatting.DARK_PURPLE), true);
        if (level instanceof ServerLevel) {
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.WITCH, player.getX(), player.getY() + 1.0, player.getZ(), 20, 0.5, 0.5, 0.5, 0.1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void attemptToCorruptPoppet(Level level, Player player) {
        void $this$attemptToCorruptPoppet_u24lambda_u241;
        Object poppetType;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        CorruptPoppetPlayerAttachment.Data corruptData = CorruptPoppetPlayerAttachment.getData(player);
        if (corruptData.getCorruptedPoppetCount() >= 10) {
            return;
        }
        List allPoppets = new ArrayList();
        Iterable $this$forEach$iv = (Iterable)WitcheryPoppetRegistry.INSTANCE.getPOPPET_REGISTRY();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            poppetType = (PoppetType)element$iv;
            boolean bl = false;
            if (!poppetType.canBeCorrupted() || CollectionsKt.contains((Iterable)corruptData.getCorruptedPoppets(), (Object)poppetType.getRegistryId())) continue;
            LivingEntity livingEntity = (LivingEntity)player;
            Intrinsics.checkNotNull((Object)poppetType);
            Pair<ItemStack, PoppetLocation> pair = PoppetHandler.INSTANCE.findPoppet(livingEntity, (PoppetType)poppetType);
            ItemStack poppet = (ItemStack)pair.component1();
            PoppetLocation location = (PoppetLocation)((Object)pair.component2());
            if (poppet == null || location == null) continue;
            allPoppets.add(new Pair(poppetType, (Object)location));
        }
        if (allPoppets.isEmpty()) {
            return;
        }
        PoppetType selectedPoppet = (PoppetType)((Pair)CollectionsKt.random((Collection)allPoppets, (Random)((Random)Random.Default))).component1();
        Object[] objectArray = corruptData.getCorruptedPoppets();
        poppetType = objectArray;
        int n = corruptData.getCorruptedPoppetCount() + 1;
        CorruptPoppetPlayerAttachment.Data data2 = corruptData;
        boolean bl = false;
        ResourceLocation resourceLocation = selectedPoppet.getRegistryId();
        Intrinsics.checkNotNull((Object)resourceLocation);
        $this$attemptToCorruptPoppet_u24lambda_u241.add(resourceLocation);
        Unit unit = Unit.INSTANCE;
        CorruptPoppetPlayerAttachment.Data updatedData = data2.copy(n, (Set<ResourceLocation>)objectArray);
        CorruptPoppetPlayerAttachment.setData(player, updatedData);
        CorruptPoppetPlayerAttachment.INSTANCE.sync(player, updatedData);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WITCH_CELEBRATE, SoundSource.PLAYERS, 1.0f, 0.5f + level.random.nextFloat() * 0.5f);
        ((ServerLevel)level).sendParticles((ParticleOptions)CORRUPTED_POPPET_PARTICLES, player.getX(), player.getY() + 1.0, player.getZ(), 15, 0.5, 0.5, 0.5, 0.1);
        objectArray = new Object[]{Component.translatable((String)selectedPoppet.getItem().getDescriptionId())};
        player.displayClientMessage((Component)Component.translatable((String)"curse.witchery.corrupt_poppet.corrupted", (Object[])objectArray).withStyle(ChatFormatting.DARK_PURPLE), true);
    }

    private final void showCorruptedPoppetParticles(Level level, Player player) {
        if (!level.isClientSide) {
            return;
        }
        CorruptPoppetPlayerAttachment.Data corruptData = CorruptPoppetPlayerAttachment.getData(player);
        if (corruptData.getCorruptedPoppetCount() <= 0) {
            return;
        }
        Iterable $this$forEach$iv = (Iterable)WitcheryPoppetRegistry.INSTANCE.getPOPPET_REGISTRY();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PoppetType poppetType = (PoppetType)element$iv;
            boolean bl = false;
            if (!CollectionsKt.contains((Iterable)corruptData.getCorruptedPoppets(), (Object)poppetType.getRegistryId())) continue;
            LivingEntity livingEntity = (LivingEntity)player;
            Intrinsics.checkNotNull((Object)poppetType);
            Pair<ItemStack, PoppetLocation> pair = PoppetHandler.INSTANCE.findPoppet(livingEntity, poppetType);
            ItemStack poppet = (ItemStack)pair.component1();
            PoppetLocation location = (PoppetLocation)((Object)pair.component2());
            if (poppet == null) continue;
            PoppetLocation poppetLocation = location;
            switch (poppetLocation == null ? -1 : WhenMappings.$EnumSwitchMapping$0[poppetLocation.ordinal()]) {
                case 1: {
                    level.addParticle((ParticleOptions)CORRUPTED_POPPET_PARTICLES, player.getX() + ((double)level.random.nextFloat() - 0.5) * 0.5, player.getY() + (double)(level.random.nextFloat() * player.getBbHeight()), player.getZ() + ((double)level.random.nextFloat() - 0.5) * 0.5, 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    if (!(level.random.nextFloat() < 0.3f)) break;
                    level.addParticle((ParticleOptions)CORRUPTED_POPPET_PARTICLES, player.getX() + ((double)level.random.nextFloat() - 0.5) * 0.3, player.getY() + 0.5 + (double)level.random.nextFloat() * 0.5, player.getZ() + ((double)level.random.nextFloat() - 0.5) * 0.3, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/features/curse/CurseOfCorruptPoppet$Companion;", "", "<init>", "()V", "MAX_CORRUPTED_POPPETS", "", "CORRUPTED_POPPET_PARTICLES", "Lnet/minecraft/core/particles/SimpleParticleType;", "kotlin.jvm.PlatformType", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PoppetLocation.values().length];
            try {
                nArray[PoppetLocation.ACCESSORY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PoppetLocation.INVENTORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PoppetLocation.WORLD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

