/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.hunter;

import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.hunter.HunterArmorParticleEffects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/sterner/witchery/features/hunter/HunterArmorDefenseHandler;", "", "<init>", "()V", "POTION_DURATION_REDUCTION", "", "CURSE_DURATION_REDUCTION", "MAGIC_DAMAGE_REDUCTION", "CURSE_REFLECT_CHANCE", "getHunterArmorPieceCount", "", "player", "Lnet/minecraft/world/entity/player/Player;", "getProtectionMultiplier", "reduceCurseDuration", "originalDuration", "tryReflectCurse", "", "sourcePlayer", "Lnet/minecraft/server/level/ServerPlayer;", "onPotionEffectApplied", "", "event", "Lnet/neoforged/neoforge/event/entity/living/MobEffectEvent$Added;", "witchery"})
public final class HunterArmorDefenseHandler {
    @NotNull
    public static final HunterArmorDefenseHandler INSTANCE = new HunterArmorDefenseHandler();
    private static final float POTION_DURATION_REDUCTION = 0.5f;
    private static final float CURSE_DURATION_REDUCTION = 0.4f;
    public static final float MAGIC_DAMAGE_REDUCTION = 0.25f;
    private static final float CURSE_REFLECT_CHANCE = 0.15f;

    private HunterArmorDefenseHandler() {
    }

    public final int getHunterArmorPieceCount(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int count = 0;
        if (Intrinsics.areEqual((Object)player.getItemBySlot(EquipmentSlot.HEAD).getItem(), (Object)WitcheryItems.INSTANCE.getHUNTER_HELMET().get())) {
            ++count;
        }
        if (Intrinsics.areEqual((Object)player.getItemBySlot(EquipmentSlot.CHEST).getItem(), (Object)WitcheryItems.INSTANCE.getHUNTER_CHESTPLATE().get())) {
            ++count;
        }
        if (Intrinsics.areEqual((Object)player.getItemBySlot(EquipmentSlot.LEGS).getItem(), (Object)WitcheryItems.INSTANCE.getHUNTER_LEGGINGS().get())) {
            ++count;
        }
        if (Intrinsics.areEqual((Object)player.getItemBySlot(EquipmentSlot.FEET).getItem(), (Object)WitcheryItems.INSTANCE.getHUNTER_BOOTS().get())) {
            ++count;
        }
        return count;
    }

    public final float getProtectionMultiplier(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int pieceCount = this.getHunterArmorPieceCount(player);
        return (float)pieceCount * 0.25f * 0.5f;
    }

    public final int reduceCurseDuration(@NotNull Player player, int originalDuration) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int pieceCount = this.getHunterArmorPieceCount(player);
        if (pieceCount == 0) {
            return originalDuration;
        }
        float multiplier = this.getProtectionMultiplier(player);
        float reduction = 0.4f * multiplier;
        int newDuration = (int)((float)originalDuration * (1.0f - reduction));
        HunterArmorParticleEffects.INSTANCE.spawnProtectionParticles(player, HunterArmorParticleEffects.ProtectionType.CURSE_REDUCTION);
        return RangesKt.coerceAtLeast((int)newDuration, (int)20);
    }

    public final boolean tryReflectCurse(@NotNull Player player, @Nullable ServerPlayer sourcePlayer) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.getHunterArmorPieceCount(player) != 4) {
            return false;
        }
        if (sourcePlayer == null) {
            return false;
        }
        RandomSource random = player.level().random;
        if (random.nextFloat() < 0.15f) {
            if (player instanceof ServerPlayer) {
                HunterArmorParticleEffects.INSTANCE.spawnCurseReflectionEffect(player, sourcePlayer);
                HunterArmorParticleEffects.INSTANCE.spawnProtectionParticles(player, HunterArmorParticleEffects.ProtectionType.CURSE_REFLECTION);
            }
            return true;
        }
        return false;
    }

    public final void onPotionEffectApplied(@NotNull MobEffectEvent.Added event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity() instanceof Player) {
            LivingEntity livingEntity = event.getEntity();
            Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)livingEntity;
            int count = this.getHunterArmorPieceCount(player);
            if (count > 0) {
                MobEffectInstance mobEffectInstance = event.getEffectInstance();
                if (mobEffectInstance == null) {
                    return;
                }
                MobEffectInstance effectInstance = mobEffectInstance;
                if (((MobEffect)effectInstance.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL) {
                    double durationModifier = (double)count * 0.25 * (double)0.5f;
                    int originalDuration = effectInstance.getDuration();
                    player.removeEffect(effectInstance.getEffect());
                    player.addEffect(new MobEffectInstance(effectInstance.getEffect(), (int)((double)originalDuration * durationModifier), effectInstance.getAmplifier(), effectInstance.isAmbient(), effectInstance.isVisible(), effectInstance.showIcon()));
                    HunterArmorParticleEffects.INSTANCE.spawnProtectionParticles(player, HunterArmorParticleEffects.ProtectionType.POTION_REDUCTION);
                }
            }
        }
    }
}

