/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.lifeblood;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.network.SyncLifebloodS2CPayload;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/lifeblood/LifebloodPlayerAttachment;", "", "<init>", "()V", "getData", "Ldev/sterner/witchery/features/lifeblood/LifebloodPlayerAttachment$Data;", "player", "Lnet/minecraft/world/entity/player/Player;", "setData", "", "data", "sync", "Data", "witchery"})
public final class LifebloodPlayerAttachment {
    @NotNull
    public static final LifebloodPlayerAttachment INSTANCE = new LifebloodPlayerAttachment();

    private LifebloodPlayerAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getData(WitcheryDataAttachments.getLIFEBLOOD_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        player.setData(WitcheryDataAttachments.getLIFEBLOOD_ATTACHMENT(), (Object)data2);
        INSTANCE.sync(player, data2);
    }

    public final void sync(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (player.level() instanceof ServerLevel) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)player), (CustomPacketPayload)new SyncLifebloodS2CPayload(player, data2), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Ldev/sterner/witchery/features/lifeblood/LifebloodPlayerAttachment$Data;", "", "lifebloodPoints", "", "lastRegenTick", "", "<init>", "(IJ)V", "getLifebloodPoints", "()I", "setLifebloodPoints", "(I)V", "getLastRegenTick", "()J", "setLastRegenTick", "(J)V", "getFullHearts", "getPartialHeartPoints", "getMaxRegenPoints", "canRegenerate", "", "addPoints", "amount", "removePoints", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int lifebloodPoints;
        private long lastRegenTick;
        @NotNull
        private static final ResourceLocation ID;
        public static final int POINTS_PER_HEART = 5;
        public static final int REGEN_INTERVAL_TICKS = 100;
        @NotNull
        private static final Codec<Data> CODEC;

        public Data(int lifebloodPoints, long lastRegenTick) {
            this.lifebloodPoints = lifebloodPoints;
            this.lastRegenTick = lastRegenTick;
        }

        public /* synthetic */ Data(int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                l = 0L;
            }
            this(n, l);
        }

        public final int getLifebloodPoints() {
            return this.lifebloodPoints;
        }

        public final void setLifebloodPoints(int n) {
            this.lifebloodPoints = n;
        }

        public final long getLastRegenTick() {
            return this.lastRegenTick;
        }

        public final void setLastRegenTick(long l) {
            this.lastRegenTick = l;
        }

        public final int getFullHearts() {
            return this.lifebloodPoints / 5;
        }

        public final int getPartialHeartPoints() {
            return this.lifebloodPoints % 5;
        }

        public final int getMaxRegenPoints() {
            if (this.lifebloodPoints == 0) {
                return 0;
            }
            int currentHeartLevel = (this.lifebloodPoints - 1) / 5 + 1;
            return currentHeartLevel * 5;
        }

        public final boolean canRegenerate() {
            return this.lifebloodPoints > 0 && this.lifebloodPoints < this.getMaxRegenPoints();
        }

        @NotNull
        public final Data addPoints(int amount) {
            return Data.copy$default(this, RangesKt.coerceAtLeast((int)(this.lifebloodPoints + amount), (int)0), 0L, 2, null);
        }

        @NotNull
        public final Data removePoints(int amount) {
            return Data.copy$default(this, RangesKt.coerceAtLeast((int)(this.lifebloodPoints - amount), (int)0), 0L, 2, null);
        }

        public final int component1() {
            return this.lifebloodPoints;
        }

        public final long component2() {
            return this.lastRegenTick;
        }

        @NotNull
        public final Data copy(int lifebloodPoints, long lastRegenTick) {
            return new Data(lifebloodPoints, lastRegenTick);
        }

        public static /* synthetic */ Data copy$default(Data data2, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = data2.lifebloodPoints;
            }
            if ((n2 & 2) != 0) {
                l = data2.lastRegenTick;
            }
            return data2.copy(n, l);
        }

        @NotNull
        public String toString() {
            return "Data(lifebloodPoints=" + this.lifebloodPoints + ", lastRegenTick=" + this.lastRegenTick + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.lifebloodPoints);
            result = result * 31 + Long.hashCode(this.lastRegenTick);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (this.lifebloodPoints != data2.lifebloodPoints) {
                return false;
            }
            return this.lastRegenTick == data2.lastRegenTick;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.INT.fieldOf("lifebloodPoints").forGetter(Data::CODEC$lambda$0$0), (App)Codec.LONG.optionalFieldOf("lastRegenTick", (Object)0L).forGetter(Data::CODEC$lambda$0$1)).apply((Applicative)instance, Data::new);
        }

        private static final Integer CODEC$lambda$0$0(Data it) {
            return it.lifebloodPoints;
        }

        private static final Long CODEC$lambda$0$1(Data it) {
            return it.lastRegenTick;
        }

        public Data() {
            this(0, 0L, 3, null);
        }

        static {
            ResourceLocation resourceLocation = Witchery.Companion.id("lifeblood");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ldev/sterner/witchery/features/lifeblood/LifebloodPlayerAttachment$Data$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "POINTS_PER_HEART", "", "REGEN_INTERVAL_TICKS", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/lifeblood/LifebloodPlayerAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

