/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.necromancy;

import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.registry.WitcheryTags;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.infusion.InfusionPlayerAttachment;
import dev.sterner.witchery.features.infusion.InfusionType;
import dev.sterner.witchery.features.necromancy.EtherealEntityAttachment;
import dev.sterner.witchery.features.necromancy.NecromancerLevelAttachment;
import dev.sterner.witchery.network.SpawnNecroParticlesS2CPayload;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\rJ\u001a\u0010\u001d\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005H\u0002J&\u0010#\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0005J\u0016\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J4\u0010*\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0019\u0012\b\u0012\u0006\u0012\u0002\b\u00030-0,0+2\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ldev/sterner/witchery/features/necromancy/NecroHandler;", "", "<init>", "()V", "MINECRAFT_DAY", "", "PARTICLE_SPAWN_RADIUS", "", "PARTICLE_DETECTION_RANGE", "PARTICLE_COUNT", "tickLiving", "", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "discardNecro", "tick", "level", "Lnet/minecraft/world/level/Level;", "playerHasWitchHand", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "spawnNecroParticles", "Lnet/minecraft/server/level/ServerLevel;", "pos", "Lnet/minecraft/core/BlockPos;", "processListExhaustion", "addNecro", "entity", "onDeath", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "calculateDespawnTime", "", "lichLevel", "summonNecroAroundPos", "summoner", "Lnet/minecraft/world/entity/player/Player;", "center", "radius", "removeNecro", "serverLevel", "collectNecroLists", "", "Lkotlin/Pair;", "Lnet/minecraft/world/entity/EntityType;", "witchery"})
@SourceDebugExtension(value={"SMAP\nNecroHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NecroHandler.kt\ndev/sterner/witchery/features/necromancy/NecroHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n774#2:277\n865#2,2:278\n774#2:280\n865#2,2:281\n1617#2,9:283\n1869#2:292\n1870#2:294\n1626#2:295\n1#3:293\n*S KotlinDebug\n*F\n+ 1 NecroHandler.kt\ndev/sterner/witchery/features/necromancy/NecroHandler\n*L\n74#1:277\n74#1:278,2\n126#1:280\n126#1:281,2\n256#1:283,9\n256#1:292\n256#1:294\n256#1:295\n256#1:293\n*E\n"})
public final class NecroHandler {
    @NotNull
    public static final NecroHandler INSTANCE = new NecroHandler();
    private static final int MINECRAFT_DAY = 24000;
    private static final double PARTICLE_SPAWN_RADIUS = 0.5;
    private static final double PARTICLE_DETECTION_RANGE = 16.0;
    private static final int PARTICLE_COUNT = 3;

    private NecroHandler() {
    }

    public final void tickLiving(@NotNull LivingEntity livingEntity) {
        EtherealEntityAttachment.Data etherealData;
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (livingEntity.level().getGameTime() % (long)10 != 0L) {
            return;
        }
        if (livingEntity.getType().is(WitcheryTags.INSTANCE.getNECROMANCER_SUMMONABLE()) && (etherealData = EtherealEntityAttachment.getData(livingEntity)).isEthereal()) {
            long timeAlive;
            EtherealEntityAttachment.INSTANCE.sync(livingEntity, etherealData);
            if (etherealData.getMaxLifeTime() > 0L && (timeAlive = livingEntity.level().getGameTime() - etherealData.getSummonTime()) >= etherealData.getMaxLifeTime()) {
                this.discardNecro(livingEntity);
            }
        }
    }

    public final void discardNecro(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (livingEntity.level() instanceof ServerLevel) {
            Level level = livingEntity.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.SOUL, livingEntity.getX(), livingEntity.getY() + (double)(livingEntity.getBbHeight() / (float)2), livingEntity.getZ(), 10, 0.3, 0.3, 0.3, 0.05);
        }
        livingEntity.discard();
    }

    /*
     * WARNING - void declaration
     */
    public final void tick(@NotNull Level level) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (level.isClientSide) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (serverLevel.getGameTime() % (long)10 != 0L) {
            return;
        }
        NecromancerLevelAttachment.Data necroData = NecromancerLevelAttachment.getData(serverLevel);
        if (necroData.getNecroList().isEmpty()) {
            return;
        }
        List list = serverLevel.players();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ServerPlayer it = (ServerPlayer)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!INSTANCE.playerHasWitchHand(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List playersWithHand = (List)destination$iv$iv;
        if (playersWithHand.isEmpty()) {
            return;
        }
        for (NecromancerLevelAttachment.DeadEntityData necroEntry : necroData.getNecroList()) {
            if (necroEntry.getPos() == null) continue;
            for (ServerPlayer player : playersWithHand) {
                BlockPos pos;
                Vec3 blockPos;
                Vec3 playerPos;
                if (player == null || !((playerPos = player.position()).distanceToSqr(blockPos = Vec3.atCenterOf((Vec3i)((Vec3i)pos))) <= 256.0)) continue;
                this.spawnNecroParticles(serverLevel, player, pos);
            }
        }
    }

    private final boolean playerHasWitchHand(ServerPlayer player) {
        boolean bl = player.getMainHandItem().is((Item)WitcheryItems.INSTANCE.getWITCHES_HAND().get()) || player.getOffhandItem().is((Item)WitcheryItems.INSTANCE.getWITCHES_HAND().get());
        boolean bl2 = InfusionPlayerAttachment.getData((Player)player).getType() == InfusionType.NECRO;
        return bl && bl2;
    }

    private final void spawnNecroParticles(ServerLevel level, ServerPlayer player, BlockPos pos) {
        Vec3 blockCenter = Vec3.atCenterOf((Vec3i)((Vec3i)pos));
        for (int i = 0; i < 3; ++i) {
            double offsetX = (level.random.nextDouble() - 0.5) * 0.5;
            double offsetY = (level.random.nextDouble() - 0.5) * 0.5;
            double offsetZ = (level.random.nextDouble() - 0.5) * 0.5;
            double x = blockCenter.x + offsetX;
            double y = blockCenter.y + offsetY;
            double z = blockCenter.z + offsetZ;
            PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SpawnNecroParticlesS2CPayload(new Vec3(x, y, z)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void processListExhaustion(@NotNull Level level) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (level.isClientSide) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        long currentTime = serverLevel.getGameTime();
        if (currentTime % (long)24000 != 0L) {
            return;
        }
        NecromancerLevelAttachment.Data data2 = NecromancerLevelAttachment.getData(serverLevel);
        Iterable $this$filter$iv = data2.getNecroList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NecromancerLevelAttachment.DeadEntityData entry = (NecromancerLevelAttachment.DeadEntityData)element$iv$iv;
            boolean bl = false;
            Long entryTime = entry.getTimestamp();
            if (!(entryTime == null || currentTime - entryTime <= 168000L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredList = (List)destination$iv$iv;
        if (filteredList.size() != data2.getNecroList().size()) {
            List mutable = CollectionsKt.toMutableList((Collection)data2.getNecroList());
            mutable.clear();
            mutable.addAll(filteredList);
            NecromancerLevelAttachment.setData(serverLevel, data2.copy(mutable));
        }
    }

    public final void addNecro(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Level level = entity.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel;
        NecromancerLevelAttachment.Data data2 = NecromancerLevelAttachment.getData(serverLevel2);
        BlockPos exactPos = entity.blockPosition();
        NecromancerLevelAttachment.DeadEntityData newData = new NecromancerLevelAttachment.DeadEntityData(exactPos, entity.getType(), entity.level().getGameTime());
        List newList = CollectionsKt.toMutableList((Collection)data2.getNecroList());
        newList.add(newData);
        data2.setNecroList(newList);
        NecromancerLevelAttachment.setData(serverLevel2, data2);
    }

    public final void onDeath(@Nullable LivingEntity livingEntity, @Nullable DamageSource damageSource) {
        if (livingEntity != null) {
            boolean isEthereal;
            if (livingEntity.getType().is(WitcheryTags.INSTANCE.getNECROMANCER_SUMMONABLE()) && !(isEthereal = EtherealEntityAttachment.getData(livingEntity).isEthereal())) {
                this.addNecro(livingEntity);
            }
            if (Intrinsics.areEqual((Object)livingEntity.getType(), (Object)EntityType.VILLAGER)) {
                int lichLevel;
                Player attacker;
                DamageSource damageSource2 = damageSource;
                Entity entity = damageSource2 != null ? damageSource2.getEntity() : null;
                Player player = attacker = entity instanceof Player ? (Player)entity : null;
                if (attacker != null && (lichLevel = AfflictionPlayerAttachment.getData(attacker).getLichLevel()) >= 6) {
                    Level level = livingEntity.level();
                    ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
                    if (serverLevel == null) {
                        return;
                    }
                    ServerLevel serverLevel2 = serverLevel;
                    NecromancerLevelAttachment.Data data2 = NecromancerLevelAttachment.getData(serverLevel2);
                    BlockPos exactPos = livingEntity.blockPosition();
                    NecromancerLevelAttachment.DeadEntityData newData = new NecromancerLevelAttachment.DeadEntityData(exactPos, EntityType.VILLAGER, livingEntity.level().getGameTime());
                    List newList = CollectionsKt.toMutableList((Collection)data2.getNecroList());
                    newList.add(newData);
                    data2.setNecroList(newList);
                    NecromancerLevelAttachment.setData(serverLevel2, data2);
                }
            }
        }
    }

    private final long calculateDespawnTime(int lichLevel) {
        return switch (lichLevel) {
            case 1 -> 1200L;
            case 2 -> 2400L;
            case 3 -> 3600L;
            case 4 -> 4800L;
            case 5 -> 6000L;
            case 6 -> 9000L;
            case 7 -> 12000L;
            case 8 -> 18000L;
            case 9 -> 24000L;
            case 10 -> -1L;
            default -> 600L;
        };
    }

    public final void summonNecroAroundPos(@NotNull ServerLevel level, @NotNull Player summoner, @NotNull BlockPos center, int radius) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)summoner, (String)"summoner");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        List<Pair<BlockPos, EntityType<?>>> list = this.collectNecroLists(level, center, radius);
        if (list.isEmpty()) {
            return;
        }
        int lichLevel = AfflictionPlayerAttachment.getData(summoner).getLichLevel();
        long despawnTime = this.calculateDespawnTime(lichLevel);
        for (Pair<BlockPos, EntityType<?>> pair : list) {
            LivingEntity entity;
            BlockPos pos = (BlockPos)pair.component1();
            EntityType entityType = (EntityType)pair.component2();
            Entity entity2 = entityType.create((Level)level);
            if ((entity2 instanceof LivingEntity ? (LivingEntity)entity2 : null) == null) continue;
            entity = entity;
            entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, level.random.nextFloat() * 360.0f, 0.0f);
            EtherealEntityAttachment.setData(entity, new EtherealEntityAttachment.Data(summoner.getUUID(), false, true, level.getGameTime(), despawnTime));
            level.addFreshEntity((Entity)entity);
            this.removeNecro(level, pos);
        }
    }

    public final void removeNecro(@NotNull ServerLevel serverLevel, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        NecromancerLevelAttachment.Data data2 = NecromancerLevelAttachment.getData(serverLevel);
        data2.getNecroList().removeIf(arg_0 -> NecroHandler.removeNecro$lambda$1(arg_0 -> NecroHandler.removeNecro$lambda$0(pos, arg_0), arg_0));
        NecromancerLevelAttachment.setData(serverLevel, data2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<BlockPos, EntityType<?>>> collectNecroLists(@NotNull ServerLevel level, @NotNull BlockPos center, int radius) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        NecromancerLevelAttachment.Data data2 = NecromancerLevelAttachment.getData(level);
        int radiusSquared = radius * radius;
        Iterable $this$mapNotNull$iv = data2.getNecroList();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            int dz;
            int dy;
            BlockPos pos;
            int dx;
            int distanceSquared;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            NecromancerLevelAttachment.DeadEntityData entry = (NecromancerLevelAttachment.DeadEntityData)element$iv$iv;
            boolean bl2 = false;
            EntityType<?> type = entry.getEntityType();
            if ((entry.getPos() == null ? null : (type == null ? null : ((distanceSquared = (dx = pos.getX() - center.getX()) * dx + (dy = pos.getY() - center.getY()) * dy + (dz = pos.getZ() - center.getZ()) * dz) <= radiusSquared ? new Pair((Object)pos, type) : null))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean removeNecro$lambda$0(BlockPos $pos, NecromancerLevelAttachment.DeadEntityData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BlockPos blockPos = it.getPos();
        return (blockPos != null ? blockPos.getX() == $pos.getX() : false) && it.getPos().getY() == $pos.getY() && it.getPos().getZ() == $pos.getZ();
    }

    private static final boolean removeNecro$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

