/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.petrification;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.features.petrification.PetrifiedEntityAttachment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0015H\u0007J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!J\u0016\u0010#\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ldev/sterner/witchery/features/petrification/PetrificationHandler;", "", "<init>", "()V", "PETRIFIED_SLOWNESS_ID", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "PETRIFIED_WEAKNESS_ID", "petrify", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "duration", "", "unpetrify", "onLivingTick", "event", "Lnet/neoforged/neoforge/event/tick/EntityTickEvent$Pre;", "onAttackEntity", "Lnet/neoforged/neoforge/event/entity/player/AttackEntityEvent;", "onLivingDamage", "Lnet/neoforged/neoforge/event/entity/living/LivingIncomingDamageEvent;", "handlePlayerPunch", "player", "Lnet/minecraft/world/entity/player/Player;", "applyPetrificationEffects", "removePetrificationEffects", "spawnPetrifiedParticles", "level", "Lnet/minecraft/server/level/ServerLevel;", "spawnBreakParticles", "spawnPetrificationWave", "start", "Lnet/minecraft/world/phys/Vec3;", "end", "spawnTransformationParticles", "witchery"})
public final class PetrificationHandler {
    @NotNull
    public static final PetrificationHandler INSTANCE = new PetrificationHandler();
    private static final ResourceLocation PETRIFIED_SLOWNESS_ID = Witchery.Companion.id("petrified_slowness");
    private static final ResourceLocation PETRIFIED_WEAKNESS_ID = Witchery.Companion.id("petrified_weakness");

    private PetrificationHandler() {
    }

    /*
     * Unable to fully structure code
     */
    public final void petrify(@NotNull LivingEntity entity, int duration) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        data = PetrifiedEntityAttachment.INSTANCE.getData(entity);
        f = entity.yBodyRot;
        f1 = entity.yHeadRot;
        yaw = f1 - f;
        if (!entity.isPassenger() || entity.getVehicle() == null) ** GOTO lbl-1000
        v0 = entity.getVehicle();
        Intrinsics.checkNotNull((Object)v0);
        if (v0.shouldRiderSit()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = shouldSit = false;
        }
        if (shouldSit && entity.getVehicle() instanceof LivingEntity) {
            v2 = entity.getVehicle();
            Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            livingentity = (LivingEntity)v2;
            f = livingentity.yBodyRot;
            yaw = f1 - f;
            f3 = Mth.wrapDegrees((float)yaw);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            yaw = f1 - f;
        }
        pitch = entity.getXRot();
        newData = data.withPetrification(duration, entity.tickCount, entity.walkAnimation.speed(), entity.walkAnimation.position(), yaw, pitch, entity.yBodyRot);
        PetrifiedEntityAttachment.INSTANCE.setData(entity, newData);
        entity.level().playSound(null, entity.blockPosition(), SoundEvents.STONE_BREAK, SoundSource.HOSTILE, 1.0f, 0.5f);
        this.applyPetrificationEffects(entity);
    }

    public final void unpetrify(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        PetrifiedEntityAttachment.Data data2 = PetrifiedEntityAttachment.Data.copy$default(PetrifiedEntityAttachment.INSTANCE.getData(entity), false, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, 508, null);
        PetrifiedEntityAttachment.INSTANCE.setData(entity, data2);
        this.removePetrificationEffects(entity);
        entity.level().playSound(null, entity.blockPosition(), SoundEvents.STONE_BREAK, SoundSource.HOSTILE, 1.0f, 1.5f);
        if (entity.level() instanceof ServerLevel) {
            Level level = entity.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            this.spawnBreakParticles((ServerLevel)level, entity);
        }
    }

    @SubscribeEvent
    public final void onLivingTick(@NotNull EntityTickEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        if (entity.level().isClientSide) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        PetrifiedEntityAttachment.Data data2 = PetrifiedEntityAttachment.INSTANCE.getData((LivingEntity)entity);
        if (!data2.isPetrified()) {
            return;
        }
        PetrifiedEntityAttachment.Data newData = data2.tick();
        PetrifiedEntityAttachment.INSTANCE.setData((LivingEntity)entity, newData);
        if (newData.isPetrified()) {
            this.applyPetrificationEffects((LivingEntity)entity);
            if (((LivingEntity)entity).level().getGameTime() % (long)20 == 0L) {
                Level level = ((LivingEntity)entity).level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                this.spawnPetrifiedParticles((ServerLevel)level, (LivingEntity)entity);
            }
        } else {
            this.removePetrificationEffects((LivingEntity)entity);
        }
    }

    @SubscribeEvent
    public final void onAttackEntity(@NotNull AttackEntityEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player attacker = event.getEntity();
        Entity target = event.getTarget();
        if (!(target instanceof LivingEntity)) {
            return;
        }
        PetrifiedEntityAttachment.Data data2 = PetrifiedEntityAttachment.INSTANCE.getData((LivingEntity)target);
        if (!data2.isPetrified()) {
            return;
        }
        if (attacker != null && Intrinsics.areEqual((Object)target, (Object)attacker)) {
            this.handlePlayerPunch(attacker);
            event.setCanceled(true);
            return;
        }
        if (!attacker.getMainHandItem().is(ItemTags.PICKAXES)) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public final void onLivingDamage(@NotNull LivingIncomingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
        LivingEntity entity = livingEntity;
        PetrifiedEntityAttachment.Data data2 = PetrifiedEntityAttachment.INSTANCE.getData(entity);
        if (!data2.isPetrified()) {
            return;
        }
        Entity attacker = event.getSource().getEntity();
        if (attacker instanceof LivingEntity && ((LivingEntity)attacker).getMainHandItem().is(ItemTags.PICKAXES)) {
            Level level = entity.level();
            if (level instanceof ServerLevel) {
                PetrifiedEntityAttachment.Data newData = data2.incrementBreakProgress();
                PetrifiedEntityAttachment.INSTANCE.setData(entity, newData);
                ((ServerLevel)level).playSound(null, entity.blockPosition(), SoundEvents.STONE_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (newData.getBreakProgress() >= 5) {
                    this.unpetrify(entity);
                }
            }
        } else {
            event.setAmount(0.0f);
        }
    }

    public final void handlePlayerPunch(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PetrifiedEntityAttachment.Data data2 = PetrifiedEntityAttachment.INSTANCE.getData((LivingEntity)player);
        if (!data2.isPetrified()) {
            return;
        }
        PetrifiedEntityAttachment.Data newData = data2.incrementPunchCount();
        PetrifiedEntityAttachment.INSTANCE.setData((LivingEntity)player, newData);
        Level level = player.level();
        level.playSound(null, player.blockPosition(), SoundEvents.STONE_HIT, SoundSource.PLAYERS, 0.5f, 0.8f + (float)newData.getPlayerPunchCount() * 0.02f);
        if (newData.getPlayerPunchCount() >= 10) {
            this.unpetrify((LivingEntity)player);
        }
    }

    private final void applyPetrificationEffects(LivingEntity entity) {
        block1: {
            AttributeInstance attackAttribute;
            AttributeInstance speedAttribute;
            AttributeInstance attributeInstance = speedAttribute = entity.getAttribute(Attributes.MOVEMENT_SPEED);
            if (attributeInstance != null) {
                AttributeInstance attr = attributeInstance;
                boolean bl = false;
                attr.removeModifier(PETRIFIED_SLOWNESS_ID);
                double slowAmount = -0.95;
                attr.addTransientModifier(new AttributeModifier(PETRIFIED_SLOWNESS_ID, slowAmount, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            AttributeInstance attributeInstance2 = attackAttribute = entity.getAttribute(Attributes.ATTACK_DAMAGE);
            if (attributeInstance2 == null) break block1;
            AttributeInstance attr = attributeInstance2;
            boolean bl = false;
            attr.removeModifier(PETRIFIED_WEAKNESS_ID);
            double weaknessAmount = -0.8;
            attr.addTransientModifier(new AttributeModifier(PETRIFIED_WEAKNESS_ID, weaknessAmount, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
    }

    private final void removePetrificationEffects(LivingEntity entity) {
        block1: {
            AttributeInstance attributeInstance = entity.getAttribute(Attributes.MOVEMENT_SPEED);
            if (attributeInstance != null) {
                attributeInstance.removeModifier(PETRIFIED_SLOWNESS_ID);
            }
            AttributeInstance attributeInstance2 = entity.getAttribute(Attributes.ATTACK_DAMAGE);
            if (attributeInstance2 == null) break block1;
            attributeInstance2.removeModifier(PETRIFIED_WEAKNESS_ID);
        }
    }

    public final void spawnPetrifiedParticles(@NotNull ServerLevel level, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Vec3 pos = entity.position();
        RandomSource random = entity.getRandom();
        for (int i = 0; i < 3; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * (double)entity.getBbWidth();
            double offsetY = random.nextDouble() * (double)entity.getBbHeight();
            double offsetZ = (random.nextDouble() - 0.5) * (double)entity.getBbWidth();
            level.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.STONE.defaultBlockState()), pos.x + offsetX, pos.y + offsetY, pos.z + offsetZ, 1, 0.0, -0.1, 0.0, 0.1);
        }
    }

    private final void spawnBreakParticles(ServerLevel level, LivingEntity entity) {
        Vec3 pos = entity.position();
        for (int i = 0; i < 21; ++i) {
            double angle = (double)i / 20.0 * Math.PI * (double)2;
            double radius = (double)entity.getBbWidth() * 0.5;
            double x = pos.x + Math.cos(angle) * radius;
            double y = pos.y + (double)(entity.getBbHeight() / (float)2);
            double z = pos.z + Math.sin(angle) * radius;
            level.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.STONE.defaultBlockState()), x, y, z, 3, 0.2, 0.2, 0.2, 0.15);
        }
    }

    public final void spawnPetrificationWave(@NotNull ServerLevel level, @NotNull Vec3 start, @NotNull Vec3 end) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Vec3 direction = end.subtract(start).normalize();
        double distance = start.distanceTo(end);
        int steps = RangesKt.coerceAtLeast((int)((int)(distance * (double)5)), (int)10);
        int i = 0;
        if (i <= steps) {
            while (true) {
                double progress = (double)i / (double)steps;
                Vec3 pos = start.add(direction.scale(distance * progress));
                level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, pos.x, pos.y, pos.z, 3, 0.1, 0.1, 0.1, 0.02);
                if (i == steps) break;
                ++i;
            }
        }
    }

    public final void spawnTransformationParticles(@NotNull ServerLevel level, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Vec3 pos = entity.position();
        float height = entity.getBbHeight();
        for (int i = 0; i < 31; ++i) {
            double angle = (double)i / 30.0 * Math.PI * (double)4;
            double heightOffset = (double)i / 30.0 * (double)height;
            double radius = (double)entity.getBbWidth() * 0.7;
            double x = pos.x + Math.cos(angle) * radius;
            double y = pos.y + heightOffset;
            double z = pos.z + Math.sin(angle) * radius;
            level.sendParticles((ParticleOptions)ParticleTypes.END_ROD, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, pos.x, pos.y + (double)(height / (float)2), pos.z, 1, 0.0, 0.0, 0.0, 0.0);
    }
}

