/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.poppet;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.network.SyncCorruptPoppetS2CPayload;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/poppet/CorruptPoppetPlayerAttachment;", "", "<init>", "()V", "setData", "", "player", "Lnet/minecraft/world/entity/player/Player;", "data", "Ldev/sterner/witchery/features/poppet/CorruptPoppetPlayerAttachment$Data;", "getData", "sync", "Data", "witchery"})
public final class CorruptPoppetPlayerAttachment {
    @NotNull
    public static final CorruptPoppetPlayerAttachment INSTANCE = new CorruptPoppetPlayerAttachment();

    private CorruptPoppetPlayerAttachment() {
    }

    @JvmStatic
    public static final void setData(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        player.setData(WitcheryDataAttachments.getCORRUPT_POPPET_DATA_ATTACHMENT(), (Object)data2);
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getData(WitcheryDataAttachments.getCORRUPT_POPPET_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    public final void sync(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (player.level() instanceof ServerLevel) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)player), (CustomPacketPayload)new SyncCorruptPoppetS2CPayload(player, data2), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Ldev/sterner/witchery/features/poppet/CorruptPoppetPlayerAttachment$Data;", "", "corruptedPoppetCount", "", "corruptedPoppets", "", "Lnet/minecraft/resources/ResourceLocation;", "<init>", "(ILjava/util/Set;)V", "getCorruptedPoppetCount", "()I", "getCorruptedPoppets", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int corruptedPoppetCount;
        @NotNull
        private final Set<ResourceLocation> corruptedPoppets;
        @NotNull
        private static final Codec<Data> CODEC;
        @NotNull
        private static final ResourceLocation ID;

        public Data(int corruptedPoppetCount, @NotNull Set<ResourceLocation> corruptedPoppets) {
            Intrinsics.checkNotNullParameter(corruptedPoppets, (String)"corruptedPoppets");
            this.corruptedPoppetCount = corruptedPoppetCount;
            this.corruptedPoppets = corruptedPoppets;
        }

        public /* synthetic */ Data(int n, Set set, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                set = new LinkedHashSet();
            }
            this(n, set);
        }

        public final int getCorruptedPoppetCount() {
            return this.corruptedPoppetCount;
        }

        @NotNull
        public final Set<ResourceLocation> getCorruptedPoppets() {
            return this.corruptedPoppets;
        }

        public final int component1() {
            return this.corruptedPoppetCount;
        }

        @NotNull
        public final Set<ResourceLocation> component2() {
            return this.corruptedPoppets;
        }

        @NotNull
        public final Data copy(int corruptedPoppetCount, @NotNull Set<ResourceLocation> corruptedPoppets) {
            Intrinsics.checkNotNullParameter(corruptedPoppets, (String)"corruptedPoppets");
            return new Data(corruptedPoppetCount, corruptedPoppets);
        }

        public static /* synthetic */ Data copy$default(Data data2, int n, Set set, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = data2.corruptedPoppetCount;
            }
            if ((n2 & 2) != 0) {
                set = data2.corruptedPoppets;
            }
            return data2.copy(n, set);
        }

        @NotNull
        public String toString() {
            return "Data(corruptedPoppetCount=" + this.corruptedPoppetCount + ", corruptedPoppets=" + this.corruptedPoppets + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.corruptedPoppetCount);
            result = result * 31 + ((Object)this.corruptedPoppets).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (this.corruptedPoppetCount != data2.corruptedPoppetCount) {
                return false;
            }
            return Intrinsics.areEqual(this.corruptedPoppets, data2.corruptedPoppets);
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.INT.fieldOf("corruptedPoppetCount").forGetter(Data::CODEC$lambda$0$0), (App)ResourceLocation.CODEC.listOf().xmap(arg_0 -> Data.CODEC$lambda$0$2(Data::CODEC$lambda$0$1, arg_0), arg_0 -> Data.CODEC$lambda$0$4(Data::CODEC$lambda$0$3, arg_0)).fieldOf("corruptedPoppets").forGetter(Data::CODEC$lambda$0$5)).apply((Applicative)instance, Data::new);
        }

        private static final Integer CODEC$lambda$0$0(Data it) {
            return it.corruptedPoppetCount;
        }

        private static final Set CODEC$lambda$0$1(List it) {
            Intrinsics.checkNotNull((Object)it);
            return CollectionsKt.toMutableSet((Iterable)it);
        }

        private static final Set CODEC$lambda$0$2(Function1 $tmp0, Object p0) {
            return (Set)$tmp0.invoke(p0);
        }

        private static final List CODEC$lambda$0$3(Set it) {
            Intrinsics.checkNotNull((Object)it);
            return CollectionsKt.toList((Iterable)it);
        }

        private static final List CODEC$lambda$0$4(Function1 $tmp0, Object p0) {
            return (List)$tmp0.invoke(p0);
        }

        private static final Set CODEC$lambda$0$5(Data it) {
            return it.corruptedPoppets;
        }

        public Data() {
            this(0, null, 3, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            ResourceLocation resourceLocation = Witchery.Companion.id("corrupt_poppet_data");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/poppet/CorruptPoppetPlayerAttachment$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/poppet/CorruptPoppetPlayerAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

