/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.poppet;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0011\u00a8\u0006\u001b"}, d2={"Ldev/sterner/witchery/features/poppet/PoppetLevelAttachment;", "", "<init>", "()V", "getPoppetData", "Ldev/sterner/witchery/features/poppet/PoppetLevelAttachment$PoppetData;", "level", "Lnet/minecraft/server/level/ServerLevel;", "setPoppetData", "", "data", "handleBlockDestruction", "pos", "Lnet/minecraft/core/BlockPos;", "addPoppetData", "Ldev/sterner/witchery/features/poppet/PoppetLevelAttachment$PoppetData$Data;", "getPoppet", "Lnet/minecraft/world/item/ItemStack;", "getPoppets", "", "uuid", "Ljava/util/UUID;", "ofType", "Lnet/minecraft/world/item/Item;", "updatePoppetItem", "newStack", "PoppetData", "witchery"})
@SourceDebugExtension(value={"SMAP\nPoppetLevelAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoppetLevelAttachment.kt\ndev/sterner/witchery/features/poppet/PoppetLevelAttachment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1#2:101\n1#2:112\n1617#3,9:102\n1869#3:111\n1870#3:113\n1626#3:114\n*S KotlinDebug\n*F\n+ 1 PoppetLevelAttachment.kt\ndev/sterner/witchery/features/poppet/PoppetLevelAttachment\n*L\n47#1:112\n47#1:102,9\n47#1:111\n47#1:113\n47#1:114\n*E\n"})
public final class PoppetLevelAttachment {
    @NotNull
    public static final PoppetLevelAttachment INSTANCE = new PoppetLevelAttachment();

    private PoppetLevelAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final PoppetData getPoppetData(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Object object = level.getData(WitcheryDataAttachments.getPOPPET_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (PoppetData)object;
    }

    @JvmStatic
    public static final void setPoppetData(@NotNull ServerLevel level, @NotNull PoppetData data2) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        level.setData(WitcheryDataAttachments.getPOPPET_DATA_ATTACHMENT(), (Object)data2);
    }

    public final void handleBlockDestruction(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        PoppetData oldData = PoppetLevelAttachment.getPoppetData(level);
        if (oldData.getPoppetDataMap().removeIf(arg_0 -> PoppetLevelAttachment.handleBlockDestruction$lambda$1(arg_0 -> PoppetLevelAttachment.handleBlockDestruction$lambda$0(pos, arg_0), arg_0))) {
            PoppetLevelAttachment.setPoppetData(level, oldData);
        }
    }

    public final void addPoppetData(@NotNull ServerLevel level, @NotNull PoppetData.Data data2) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        PoppetData oldData = PoppetLevelAttachment.getPoppetData(level);
        oldData.getPoppetDataMap().add(data2);
        PoppetLevelAttachment.setPoppetData(level, oldData);
    }

    @Nullable
    public final ItemStack getPoppet(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Iterable iterable = PoppetLevelAttachment.getPoppetData(level).getPoppetDataMap();
            for (Object t : iterable) {
                PoppetData.Data it = (PoppetData.Data)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getBlockPos(), (Object)pos)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        PoppetData.Data data2 = v0;
        return data2 != null ? data2.getPoppetItemStack() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemStack> getPoppets(@NotNull ServerLevel level, @NotNull UUID uuid) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        PoppetData data2 = PoppetLevelAttachment.getPoppetData(level);
        Iterable $this$mapNotNull$iv = data2.getPoppetDataMap();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ItemStack it$iv$iv;
            UUID uUID;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PoppetData.Data it = (PoppetData.Data)element$iv$iv;
            boolean bl2 = false;
            try {
                uUID = UUID.fromString((String)it.getPoppetItemStack().get((DataComponentType)WitcheryDataComponents.INSTANCE.getENTITY_ID_COMPONENT().get()));
            }
            catch (IllegalArgumentException e) {
                uUID = null;
            }
            UUID targetUUID = uUID;
            if ((Intrinsics.areEqual((Object)it.getPoppetItemStack().get((DataComponentType)WitcheryDataComponents.INSTANCE.getPLAYER_UUID().get()), (Object)uuid) || Intrinsics.areEqual((Object)targetUUID, (Object)uuid) ? it.getPoppetItemStack() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ItemStack getPoppet(@NotNull ServerLevel level, @NotNull UUID uuid, @NotNull Item ofType) {
        ItemStack itemStack;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)ofType, (String)"ofType");
            Iterable iterable = this.getPoppets(level, uuid);
            for (Object t : iterable) {
                ItemStack it = (ItemStack)t;
                boolean bl = false;
                if (!it.is(ofType)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((itemStack = (ItemStack)v0) == null) {
            ItemStack itemStack2 = ItemStack.EMPTY;
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
        }
        return itemStack;
    }

    public final void updatePoppetItem(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull ItemStack newStack) {
        Object v0;
        PoppetData oldData;
        block2: {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)newStack, (String)"newStack");
            oldData = PoppetLevelAttachment.getPoppetData(level);
            Iterable iterable = oldData.getPoppetDataMap();
            for (Object t : iterable) {
                PoppetData.Data it = (PoppetData.Data)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getBlockPos(), (Object)pos)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        PoppetData.Data targetData = v0;
        if (targetData != null) {
            ItemStack itemStack = newStack.copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            targetData.setPoppetItemStack(itemStack);
            PoppetLevelAttachment.setPoppetData(level, oldData);
        }
    }

    private static final boolean handleBlockDestruction$lambda$0(BlockPos $pos, PoppetData.Data it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getBlockPos(), (Object)$pos);
    }

    private static final boolean handleBlockDestruction$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/features/poppet/PoppetLevelAttachment$PoppetData;", "", "poppetDataMap", "", "Ldev/sterner/witchery/features/poppet/PoppetLevelAttachment$PoppetData$Data;", "<init>", "(Ljava/util/List;)V", "getPoppetDataMap", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "Data", "witchery"})
    public static final class PoppetData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<Data> poppetDataMap;
        @NotNull
        private static final Codec<PoppetData> CODEC;
        @NotNull
        private static final ResourceLocation ID;

        public PoppetData(@NotNull List<Data> poppetDataMap) {
            Intrinsics.checkNotNullParameter(poppetDataMap, (String)"poppetDataMap");
            this.poppetDataMap = poppetDataMap;
        }

        @NotNull
        public final List<Data> getPoppetDataMap() {
            return this.poppetDataMap;
        }

        @NotNull
        public final List<Data> component1() {
            return this.poppetDataMap;
        }

        @NotNull
        public final PoppetData copy(@NotNull List<Data> poppetDataMap) {
            Intrinsics.checkNotNullParameter(poppetDataMap, (String)"poppetDataMap");
            return new PoppetData(poppetDataMap);
        }

        public static /* synthetic */ PoppetData copy$default(PoppetData poppetData, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = poppetData.poppetDataMap;
            }
            return poppetData.copy(list);
        }

        @NotNull
        public String toString() {
            return "PoppetData(poppetDataMap=" + this.poppetDataMap + ")";
        }

        public int hashCode() {
            return ((Object)this.poppetDataMap).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PoppetData)) {
                return false;
            }
            PoppetData poppetData = (PoppetData)other;
            return Intrinsics.areEqual(this.poppetDataMap, poppetData.poppetDataMap);
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.list(Data.Companion.getCODEC()).fieldOf("poppetData").forGetter(PoppetData::CODEC$lambda$0$0)).apply((Applicative)instance, PoppetData::CODEC$lambda$0$1);
        }

        private static final List CODEC$lambda$0$0(PoppetData it) {
            return it.poppetDataMap;
        }

        private static final PoppetData CODEC$lambda$0$1(List poppetData) {
            Intrinsics.checkNotNull((Object)poppetData);
            return new PoppetData(CollectionsKt.toMutableList((Collection)poppetData));
        }

        static {
            Codec codec = RecordCodecBuilder.create(PoppetData::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            ResourceLocation resourceLocation = Witchery.Companion.id("poppet_data");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/poppet/PoppetLevelAttachment$PoppetData$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/poppet/PoppetLevelAttachment$PoppetData;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<PoppetData> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Ldev/sterner/witchery/features/poppet/PoppetLevelAttachment$PoppetData$Data;", "", "blockPos", "Lnet/minecraft/core/BlockPos;", "poppetItemStack", "Lnet/minecraft/world/item/ItemStack;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/item/ItemStack;)V", "getBlockPos", "()Lnet/minecraft/core/BlockPos;", "getPoppetItemStack", "()Lnet/minecraft/world/item/ItemStack;", "setPoppetItemStack", "(Lnet/minecraft/world/item/ItemStack;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "witchery"})
        public static final class Data {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final BlockPos blockPos;
            @NotNull
            private ItemStack poppetItemStack;
            @NotNull
            private static final Codec<Data> CODEC;

            public Data(@NotNull BlockPos blockPos, @NotNull ItemStack poppetItemStack) {
                Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
                Intrinsics.checkNotNullParameter((Object)poppetItemStack, (String)"poppetItemStack");
                this.blockPos = blockPos;
                this.poppetItemStack = poppetItemStack;
            }

            @NotNull
            public final BlockPos getBlockPos() {
                return this.blockPos;
            }

            @NotNull
            public final ItemStack getPoppetItemStack() {
                return this.poppetItemStack;
            }

            public final void setPoppetItemStack(@NotNull ItemStack itemStack) {
                Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
                this.poppetItemStack = itemStack;
            }

            @NotNull
            public final BlockPos component1() {
                return this.blockPos;
            }

            @NotNull
            public final ItemStack component2() {
                return this.poppetItemStack;
            }

            @NotNull
            public final Data copy(@NotNull BlockPos blockPos, @NotNull ItemStack poppetItemStack) {
                Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
                Intrinsics.checkNotNullParameter((Object)poppetItemStack, (String)"poppetItemStack");
                return new Data(blockPos, poppetItemStack);
            }

            public static /* synthetic */ Data copy$default(Data data2, BlockPos blockPos, ItemStack itemStack, int n, Object object) {
                if ((n & 1) != 0) {
                    blockPos = data2.blockPos;
                }
                if ((n & 2) != 0) {
                    itemStack = data2.poppetItemStack;
                }
                return data2.copy(blockPos, itemStack);
            }

            @NotNull
            public String toString() {
                return "Data(blockPos=" + this.blockPos + ", poppetItemStack=" + this.poppetItemStack + ")";
            }

            public int hashCode() {
                int result = this.blockPos.hashCode();
                result = result * 31 + this.poppetItemStack.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Data)) {
                    return false;
                }
                Data data2 = (Data)other;
                if (!Intrinsics.areEqual((Object)this.blockPos, (Object)data2.blockPos)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.poppetItemStack, (Object)data2.poppetItemStack);
            }

            private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
                return instance.group((App)BlockPos.CODEC.fieldOf("blockPos").forGetter(Data::CODEC$lambda$0$0), (App)ItemStack.CODEC.fieldOf("poppetItemStack").forGetter(Data::CODEC$lambda$0$1)).apply((Applicative)instance, Data::new);
            }

            private static final BlockPos CODEC$lambda$0$0(Data it) {
                return it.blockPos;
            }

            private static final ItemStack CODEC$lambda$0$1(Data it) {
                return it.poppetItemStack;
            }

            static {
                Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
                Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
                CODEC = codec;
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/features/poppet/PoppetLevelAttachment$PoppetData$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/poppet/PoppetLevelAttachment$PoppetData$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final Codec<Data> getCODEC() {
                    return CODEC;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

