/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.ritual;

import com.mojang.serialization.DynamicOps;
import dev.sterner.witchery.content.block.ritual.GoldenChalkBlockEntity;
import dev.sterner.witchery.core.api.Ritual;
import dev.sterner.witchery.core.api.WitcheryApi;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010$\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010%\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0018\u0010&\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010'\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0018\u0010'\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ldev/sterner/witchery/features/ritual/RotRitual;", "Ldev/sterner/witchery/core/api/Ritual;", "<init>", "()V", "TRANSFORM_DELAY", "", "EFFECT_RADIUS", "", "transformingEntities", "", "Lnet/minecraft/world/entity/Entity;", "onTickRitual", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "goldenChalkBlockEntity", "Ldev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity;", "processLivingEntities", "box", "Lnet/minecraft/world/phys/AABB;", "processItemEntities", "processBlocks", "canBeZombified", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "transformEntity", "canRotItem", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "transformItem", "itemEntity", "Lnet/minecraft/world/entity/item/ItemEntity;", "canTransformBlock", "transformBlock", "spawnTransformParticles", "spawnBlockTransformParticles", "spawnCompletionParticles", "Lnet/minecraft/world/phys/Vec3;", "spawnAmbientParticles", "witchery"})
@SourceDebugExtension(value={"SMAP\nRotRitual.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RotRitual.kt\ndev/sterner/witchery/features/ritual/RotRitual\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,423:1\n1869#2,2:424\n1869#2,2:426\n1869#2,2:428\n*S KotlinDebug\n*F\n+ 1 RotRitual.kt\ndev/sterner/witchery/features/ritual/RotRitual\n*L\n359#1:424,2\n377#1:426,2\n395#1:428,2\n*E\n"})
public final class RotRitual
extends Ritual {
    private final int TRANSFORM_DELAY;
    private final double EFFECT_RADIUS;
    @NotNull
    private final Map<Entity, Integer> transformingEntities = new LinkedHashMap();

    public RotRitual() {
        super("rot");
        this.TRANSFORM_DELAY = 40;
        this.EFFECT_RADIUS = 8.0;
    }

    @Override
    public void onTickRitual(@NotNull Level level, @NotNull BlockPos pos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        AABB box = new AABB((double)pos.getX() - this.EFFECT_RADIUS, (double)pos.getY() - this.EFFECT_RADIUS, (double)pos.getZ() - this.EFFECT_RADIUS, (double)pos.getX() + this.EFFECT_RADIUS, (double)pos.getY() + this.EFFECT_RADIUS, (double)pos.getZ() + this.EFFECT_RADIUS);
        this.processLivingEntities(level, box);
        this.processItemEntities(level, box);
        this.processBlocks(level, pos);
        if (level.isClientSide) {
            this.spawnAmbientParticles(level, pos);
        }
    }

    private final void processLivingEntities(Level level, AABB box) {
        List entities = level.getEntitiesOfClass(LivingEntity.class, box, arg_0 -> RotRitual.processLivingEntities$lambda$1(arg_0 -> RotRitual.processLivingEntities$lambda$0(this, arg_0), arg_0));
        for (LivingEntity entity : entities) {
            if (entity instanceof Player && !WitcheryApi.INSTANCE.isWitchy((Player)entity)) {
                int adjustedDelay = this.TRANSFORM_DELAY * 3;
                if (this.transformingEntities.containsKey(entity)) {
                    Integer n = this.transformingEntities.get(entity);
                    Intrinsics.checkNotNull((Object)n);
                    int remainingTicks = ((Number)n).intValue() - 1;
                    if (remainingTicks <= 0) {
                        if (level.random.nextFloat() < 0.7f) {
                            this.transformingEntities.remove(entity);
                            return;
                        }
                        this.transformEntity(level, entity);
                        this.transformingEntities.remove(entity);
                        continue;
                    }
                    this.transformingEntities.put((Entity)entity, remainingTicks);
                    if (remainingTicks % 20 != 0) continue;
                    this.spawnTransformParticles(level, (Entity)entity);
                    continue;
                }
                this.transformingEntities.put((Entity)entity, adjustedDelay);
                continue;
            }
            if (this.transformingEntities.containsKey(entity)) {
                Integer n = this.transformingEntities.get(entity);
                Intrinsics.checkNotNull((Object)n);
                int remainingTicks = ((Number)n).intValue() - 1;
                if (remainingTicks <= 0) {
                    Intrinsics.checkNotNull((Object)entity);
                    this.transformEntity(level, entity);
                    this.transformingEntities.remove(entity);
                    continue;
                }
                this.transformingEntities.put((Entity)entity, remainingTicks);
                Intrinsics.checkNotNull((Object)entity);
                this.spawnTransformParticles(level, (Entity)entity);
                continue;
            }
            this.transformingEntities.put((Entity)entity, this.TRANSFORM_DELAY);
        }
        this.transformingEntities.entrySet().removeIf(arg_0 -> RotRitual.processLivingEntities$lambda$3(arg_0 -> RotRitual.processLivingEntities$lambda$2(box, arg_0), arg_0));
    }

    private final void processItemEntities(Level level, AABB box) {
        List itemEntities = level.getEntitiesOfClass(ItemEntity.class, box, arg_0 -> RotRitual.processItemEntities$lambda$1(arg_0 -> RotRitual.processItemEntities$lambda$0(this, arg_0), arg_0));
        for (ItemEntity itemEntity : itemEntities) {
            if (this.transformingEntities.containsKey(itemEntity)) {
                Integer n = this.transformingEntities.get(itemEntity);
                Intrinsics.checkNotNull((Object)n);
                int remainingTicks = ((Number)n).intValue() - 1;
                if (remainingTicks <= 0) {
                    Intrinsics.checkNotNull((Object)itemEntity);
                    this.transformItem(level, itemEntity);
                    this.transformingEntities.remove(itemEntity);
                    continue;
                }
                this.transformingEntities.put((Entity)itemEntity, remainingTicks);
                Intrinsics.checkNotNull((Object)itemEntity);
                this.spawnTransformParticles(level, (Entity)itemEntity);
                continue;
            }
            this.transformingEntities.put((Entity)itemEntity, this.TRANSFORM_DELAY);
        }
    }

    private final void processBlocks(Level level, BlockPos pos) {
        int range = (int)this.EFFECT_RADIUS;
        int blocksPerTick = 5;
        int processed = 0;
        int x = -range;
        if (x <= range) {
            while (true) {
                int z;
                if ((z = -range) <= range) {
                    while (true) {
                        int y;
                        if (x * x + z * z <= range * range && (y = -range) <= range) {
                            while (true) {
                                BlockPos blockPos = pos.offset(x, y, z);
                                Intrinsics.checkNotNull((Object)blockPos);
                                if (this.canTransformBlock(level, blockPos) && level.random.nextInt(20) == 0) {
                                    this.spawnBlockTransformParticles(level, blockPos);
                                    this.transformBlock(level, blockPos);
                                    if (++processed >= blocksPerTick) {
                                        return;
                                    }
                                }
                                if (y == range) break;
                                ++y;
                            }
                        }
                        if (z == range) break;
                        ++z;
                    }
                }
                if (x == range) break;
                ++x;
            }
        }
    }

    private final boolean canBeZombified(LivingEntity entity) {
        LivingEntity livingEntity = entity;
        return livingEntity instanceof Villager || livingEntity instanceof Pig || livingEntity instanceof Horse || livingEntity instanceof Zoglin || livingEntity instanceof Skeleton;
    }

    private final void transformEntity(Level level, LivingEntity entity) {
        PathfinderMob zombieEntity;
        if (level.isClientSide) {
            return;
        }
        LivingEntity livingEntity = entity;
        if (livingEntity instanceof Villager) {
            ZombieVillager zombieVillager = new ZombieVillager(EntityType.ZOMBIE_VILLAGER, level);
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            zombieVillager.finalizeSpawn((ServerLevelAccessor)((ServerLevel)level), ((ServerLevel)level).getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true));
            zombieVillager.setVillagerData(((Villager)entity).getVillagerData());
            zombieVillager.setGossips((Tag)((Villager)entity).getGossips().store((DynamicOps)NbtOps.INSTANCE));
            zombieVillager.setTradeOffers(((Villager)entity).getOffers().copy());
            zombieVillager.setVillagerXp(((Villager)entity).getVillagerXp());
            zombieVillager.setPos(((Villager)entity).getX(), ((Villager)entity).getY(), ((Villager)entity).getZ());
            zombieVillager.setYRot(((Villager)entity).getYRot());
            zombieVillager.setXRot(((Villager)entity).getXRot());
            v0 = (PathfinderMob)zombieVillager;
        } else if (livingEntity instanceof Pig) {
            ZombifiedPiglin zombiePig = new ZombifiedPiglin(EntityType.ZOMBIFIED_PIGLIN, level);
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            zombiePig.finalizeSpawn((ServerLevelAccessor)((ServerLevel)level), ((ServerLevel)level).getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.CONVERSION, null);
            zombiePig.setPos(((Pig)entity).getX(), ((Pig)entity).getY(), ((Pig)entity).getZ());
            zombiePig.setYRot(((Pig)entity).getYRot());
            zombiePig.setXRot(((Pig)entity).getXRot());
            v0 = (PathfinderMob)zombiePig;
        } else if (livingEntity instanceof Horse) {
            ZombieHorse zombieHorse = new ZombieHorse(EntityType.ZOMBIE_HORSE, level);
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            zombieHorse.finalizeSpawn((ServerLevelAccessor)((ServerLevel)level), ((ServerLevel)level).getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.CONVERSION, null);
            zombieHorse.setPos(((Horse)entity).getX(), ((Horse)entity).getY(), ((Horse)entity).getZ());
            zombieHorse.setYRot(((Horse)entity).getYRot());
            zombieHorse.setXRot(((Horse)entity).getXRot());
            v0 = (PathfinderMob)zombieHorse;
        } else if (livingEntity instanceof Hoglin) {
            Zoglin zoglin = new Zoglin(EntityType.ZOGLIN, level);
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            zoglin.finalizeSpawn((ServerLevelAccessor)((ServerLevel)level), ((ServerLevel)level).getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.CONVERSION, null);
            zoglin.setPos(((Hoglin)entity).getX(), ((Hoglin)entity).getY(), ((Hoglin)entity).getZ());
            zoglin.setYRot(((Hoglin)entity).getYRot());
            zoglin.setXRot(((Hoglin)entity).getXRot());
            v0 = (PathfinderMob)zoglin;
        } else if (livingEntity instanceof Skeleton) {
            WitherSkeleton witherSkeleton = new WitherSkeleton(EntityType.WITHER_SKELETON, level);
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            witherSkeleton.finalizeSpawn((ServerLevelAccessor)((ServerLevel)level), ((ServerLevel)level).getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.CONVERSION, null);
            witherSkeleton.setPos(((Skeleton)entity).getX(), ((Skeleton)entity).getY(), ((Skeleton)entity).getZ());
            witherSkeleton.setYRot(((Skeleton)entity).getYRot());
            witherSkeleton.setXRot(((Skeleton)entity).getXRot());
            v0 = (PathfinderMob)witherSkeleton;
        } else {
            v0 = zombieEntity = null;
        }
        if (zombieEntity != null) {
            entity.remove(Entity.RemovalReason.DISCARDED);
            level.addFreshEntity((Entity)zombieEntity);
            level.playSound(null, entity.blockPosition(), SoundEvents.ZOMBIE_INFECT, SoundSource.HOSTILE, 1.0f, 1.0f);
            this.spawnCompletionParticles(level, (Entity)zombieEntity);
        }
    }

    private final boolean canRotItem(ItemStack itemStack) {
        Item item = itemStack.getItem();
        return Intrinsics.areEqual((Object)item, (Object)Items.BEEF) || Intrinsics.areEqual((Object)item, (Object)Items.PORKCHOP) || Intrinsics.areEqual((Object)item, (Object)Items.CHICKEN) || Intrinsics.areEqual((Object)item, (Object)Items.MUTTON) || Intrinsics.areEqual((Object)item, (Object)Items.RABBIT);
    }

    private final void transformItem(Level level, ItemEntity itemEntity) {
        if (level.isClientSide) {
            return;
        }
        ItemStack stack = itemEntity.getItem();
        ItemStack rottenStack = null;
        Intrinsics.checkNotNull((Object)stack);
        if (this.canRotItem(stack)) {
            rottenStack = new ItemStack((ItemLike)Items.ROTTEN_FLESH, stack.getCount());
        }
        if (rottenStack != null) {
            ItemEntity newItemEntity = new ItemEntity(level, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), rottenStack);
            newItemEntity.setDeltaMovement(itemEntity.getDeltaMovement());
            itemEntity.remove(Entity.RemovalReason.DISCARDED);
            level.addFreshEntity((Entity)newItemEntity);
            level.playSound(null, itemEntity.blockPosition(), SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.BLOCKS, 0.5f, 0.8f);
            this.spawnCompletionParticles(level, (Entity)newItemEntity);
        }
    }

    private final boolean canTransformBlock(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        return block instanceof CropBlock || block instanceof FlowerBlock || block instanceof DoublePlantBlock;
    }

    private final void transformBlock(Level level, BlockPos pos) {
        BlockState newState;
        if (level.isClientSide) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        Block block2 = block;
        BlockState blockState = block2 instanceof CropBlock ? (level.random.nextBoolean() ? Blocks.DEAD_BUSH.defaultBlockState() : (level.random.nextBoolean() ? Blocks.BROWN_MUSHROOM.defaultBlockState() : Blocks.RED_MUSHROOM.defaultBlockState())) : (block2 instanceof FlowerBlock || block2 instanceof DoublePlantBlock ? (level.random.nextBoolean() ? Blocks.DEAD_BUSH.defaultBlockState() : Blocks.WITHER_ROSE.defaultBlockState()) : (newState = null));
        if (newState != null) {
            level.setBlockAndUpdate(pos, newState);
            level.playSound(null, pos, SoundEvents.GRASS_BREAK, SoundSource.BLOCKS, 0.5f, 0.8f);
            this.spawnCompletionParticles(level, new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5));
        }
    }

    private final void spawnTransformParticles(Level level, Entity entity) {
        if (!level.isClientSide) {
            return;
        }
        RandomSource random = level.random;
        AABB box = entity.getBoundingBox();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)5);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            double x = box.minX + random.nextDouble() * (box.maxX - box.minX);
            double y = box.minY + random.nextDouble() * (box.maxY - box.minY);
            double z = box.minZ + random.nextDouble() * (box.maxZ - box.minZ);
            level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)new Color(145, 80, 40).getRGB()), x, y, z, 0.3, 0.1, 0.1);
        }
    }

    private final void spawnBlockTransformParticles(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            return;
        }
        RandomSource random = level.random;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)5);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)new Color(145, 80, 40).getRGB()), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 0.3, 0.1, 0.1);
        }
    }

    private final void spawnCompletionParticles(Level level, Entity entity) {
        Vec3 vec3 = entity.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        this.spawnCompletionParticles(level, vec3);
    }

    private final void spawnCompletionParticles(Level level, Vec3 pos) {
        if (!level.isClientSide) {
            return;
        }
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)15);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, pos.x(), pos.y(), pos.z(), level.random.nextGaussian() * 0.05, level.random.nextGaussian() * 0.05, level.random.nextGaussian() * 0.05);
        }
    }

    private final void spawnAmbientParticles(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            return;
        }
        RandomSource random = level.random;
        if (random.nextInt(5) == 0) {
            double x = (double)pos.getX() + random.nextDouble() * this.EFFECT_RADIUS * (double)2 - this.EFFECT_RADIUS;
            double y = (double)pos.getY() + random.nextDouble() * (double)2;
            double z = (double)pos.getZ() + random.nextDouble() * this.EFFECT_RADIUS * (double)2 - this.EFFECT_RADIUS;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.05, 0.0);
        }
    }

    private static final boolean processLivingEntities$lambda$0(RotRitual this$0, LivingEntity entity) {
        return entity != null && this$0.canBeZombified(entity);
    }

    private static final boolean processLivingEntities$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean processLivingEntities$lambda$2(AABB $box, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        Entity entity = (Entity)entry.getKey();
        return !$box.contains(entity.position()) || entity.isRemoved();
    }

    private static final boolean processLivingEntities$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean processItemEntities$lambda$0(RotRitual this$0, ItemEntity entity) {
        if (entity == null) return false;
        ItemStack itemStack = entity.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        if (!this$0.canRotItem(itemStack)) return false;
        return true;
    }

    private static final boolean processItemEntities$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

