/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.integration.emi;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.WitcheryConfig;
import dev.sterner.witchery.content.block.ritual.RitualHelper;
import dev.sterner.witchery.content.recipe.ritual.RitualRecipe;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.util.RenderUtils;
import dev.sterner.witchery.integration.emi.WitcheryEmiPlugin;
import dev.sterner.witchery.integration.emi.WitcherySlotWidget;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016JJ\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0015H\u0002JI\u0010&\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u00152\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010-J(\u0010.\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010/\u001a\u0002002\u0006\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u0015H\u0002J@\u00101\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010/\u001a\u0002002\u0006\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00063"}, d2={"Ldev/sterner/witchery/integration/emi/RitualEmiRecipe;", "Ldev/emi/emi/api/recipe/EmiRecipe;", "recipeId", "Lnet/minecraft/resources/ResourceLocation;", "recipe", "Ldev/sterner/witchery/content/recipe/ritual/RitualRecipe;", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Ldev/sterner/witchery/content/recipe/ritual/RitualRecipe;)V", "getRecipeId", "()Lnet/minecraft/resources/ResourceLocation;", "getRecipe", "()Ldev/sterner/witchery/content/recipe/ritual/RitualRecipe;", "getCategory", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "getId", "getInputs", "", "Ldev/emi/emi/api/stack/EmiIngredient;", "getOutputs", "Ldev/emi/emi/api/stack/EmiStack;", "getDisplayWidth", "", "getDisplayHeight", "addWidgets", "", "widgets", "Ldev/emi/emi/api/widget/WidgetHolder;", "renderRitualCircle", "pattern", "", "", "blockMapping", "", "", "Lnet/minecraft/world/level/block/Block;", "squareX", "squareY", "squareSize", "addChalkCircleWidget", "posX", "posY", "size", "texturePath", "patternSize", "color", "(Ldev/emi/emi/api/widget/WidgetHolder;IIILjava/lang/String;ILjava/lang/Integer;)V", "addItemCircleWidget", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "renderItem", "index", "witchery"})
public final class RitualEmiRecipe
implements EmiRecipe {
    @NotNull
    private final ResourceLocation recipeId;
    @NotNull
    private final RitualRecipe recipe;

    public RitualEmiRecipe(@NotNull ResourceLocation recipeId, @NotNull RitualRecipe recipe) {
        Intrinsics.checkNotNullParameter((Object)recipeId, (String)"recipeId");
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        this.recipeId = recipeId;
        this.recipe = recipe;
    }

    @NotNull
    public final ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    @NotNull
    public final RitualRecipe getRecipe() {
        return this.recipe;
    }

    @NotNull
    public EmiRecipeCategory getCategory() {
        return WitcheryEmiPlugin.Companion.getRITUAL_CATEGORY();
    }

    @NotNull
    public ResourceLocation getId() {
        return this.recipeId;
    }

    @NotNull
    public List<EmiIngredient> getInputs() {
        List mutableList = new ArrayList();
        for (ItemStack ingredients : this.recipe.getInputItems()) {
            ItemStack[] itemStackArray = new ItemStack[]{ingredients};
            EmiIngredient emiIngredient = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray));
            Intrinsics.checkNotNullExpressionValue((Object)emiIngredient, (String)"of(...)");
            mutableList.add(emiIngredient);
        }
        return mutableList;
    }

    @NotNull
    public List<EmiStack> getOutputs() {
        List mutableList = new ArrayList();
        for (ItemStack itemStacks : this.recipe.getOutputItems()) {
            EmiStack emiStack = EmiStack.of((ItemStack)itemStacks);
            Intrinsics.checkNotNullExpressionValue((Object)emiStack, (String)"of(...)");
            mutableList.add(emiStack);
        }
        return mutableList;
    }

    public int getDisplayWidth() {
        return 162;
    }

    public int getDisplayHeight() {
        return 144;
    }

    public void addWidgets(@NotNull WidgetHolder widgets) {
        int size;
        boolean cat;
        Intrinsics.checkNotNullParameter((Object)widgets, (String)"widgets");
        Map<Character, Block> blockMapping = this.recipe.getBlockMapping();
        List<String> pattern = this.recipe.getPattern();
        widgets.addText((Component)Component.translatable((String)this.getId().toString()), this.getDisplayWidth() / 2, 2, 0xFFFFFF, true).horizontalAlign(TextWidget.Alignment.CENTER);
        widgets.addTooltipText(CollectionsKt.listOf((Object)Component.translatable((String)(this.getId() + ".tooltip"))), 9, 2, 126, 18);
        if (RitualHelper.INSTANCE.usesCurseCommands(this.recipe) && !((Boolean)WitcheryConfig.ENABLE_CURSES.get()).booleanValue()) {
            ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD};
            widgets.addText((Component)Component.literal((String)"Curses Disabled").withStyle(chatFormattingArray), this.getDisplayWidth() / 2, 14, 0xFF0000, true).horizontalAlign(TextWidget.Alignment.CENTER);
        }
        widgets.addTexture(Witchery.Companion.id("textures/gui/black_square.png"), 45, this.getDisplayHeight() - 108, 92, 92, 0, 0, 72, 72, 72, 72);
        boolean fullMoon = this.recipe.getCelestialConditions().contains((Object)RitualRecipe.Celestial.FULL_MOON);
        boolean newMoon = this.recipe.getCelestialConditions().contains((Object)RitualRecipe.Celestial.NEW_MOON);
        boolean night = this.recipe.getCelestialConditions().contains((Object)RitualRecipe.Celestial.NIGHT);
        boolean day = this.recipe.getCelestialConditions().contains((Object)RitualRecipe.Celestial.DAY);
        boolean waxing = this.recipe.getCelestialConditions().contains((Object)RitualRecipe.Celestial.WAXING);
        boolean waning = this.recipe.getCelestialConditions().contains((Object)RitualRecipe.Celestial.WANING);
        boolean all = this.recipe.getCelestialConditions().isEmpty();
        widgets.addTexture(Witchery.Companion.id("textures/gui/celestial/" + (day || all ? "sun" : "empty") + ".png"), 20, 44, 10, 10, 0, 0, 10, 10, 10, 10).tooltip(CollectionsKt.listOf((Object)ClientTooltipComponent.create((FormattedCharSequence)FormattedCharSequence.forward((String)"Day", (Style)Style.EMPTY))));
        widgets.addTexture(Witchery.Companion.id("textures/gui/celestial/" + (fullMoon || night || all ? "full_moon" : "empty") + ".png"), 20, 55, 10, 10, 0, 0, 10, 10, 10, 10).tooltip(CollectionsKt.listOf((Object)ClientTooltipComponent.create((FormattedCharSequence)FormattedCharSequence.forward((String)"Full Moon", (Style)Style.EMPTY))));
        widgets.addTexture(Witchery.Companion.id("textures/gui/celestial/" + (newMoon || night || all ? "new_moon" : "empty") + ".png"), 20, 66, 10, 10, 0, 0, 10, 10, 10, 10).tooltip(CollectionsKt.listOf((Object)ClientTooltipComponent.create((FormattedCharSequence)FormattedCharSequence.forward((String)"New Moon", (Style)Style.EMPTY))));
        widgets.addTexture(Witchery.Companion.id("textures/gui/celestial/" + (waxing || night || all ? "waxing_moon" : "empty") + ".png"), 9, 60, 10, 10, 0, 0, 10, 10, 10, 10).tooltip(CollectionsKt.listOf((Object)ClientTooltipComponent.create((FormattedCharSequence)FormattedCharSequence.forward((String)"Waxing Moon", (Style)Style.EMPTY))));
        widgets.addTexture(Witchery.Companion.id("textures/gui/celestial/" + (waning || night || all ? "waning_moon" : "empty") + ".png"), 31, 60, 10, 10, 0, 0, 10, 10, 10, 10).tooltip(CollectionsKt.listOf((Object)ClientTooltipComponent.create((FormattedCharSequence)FormattedCharSequence.forward((String)"Waning Moon", (Style)Style.EMPTY))));
        boolean rain = this.recipe.getWeather().contains((Object)RitualRecipe.Weather.RAIN);
        boolean thunder = this.recipe.getWeather().contains((Object)RitualRecipe.Weather.STORM);
        if (rain) {
            widgets.addTexture(Witchery.Companion.id("textures/gui/weather/rain.png"), 31, 44, 10, 10, 0, 0, 10, 10, 10, 10).tooltip(CollectionsKt.listOf((Object)ClientTooltipComponent.create((FormattedCharSequence)FormattedCharSequence.forward((String)"Requires Rain", (Style)Style.EMPTY))));
        }
        if (thunder) {
            widgets.addTexture(Witchery.Companion.id("textures/gui/weather/storm.png"), 9, 44, 10, 10, 0, 0, 10, 10, 10, 10).tooltip(CollectionsKt.listOf((Object)ClientTooltipComponent.create((FormattedCharSequence)FormattedCharSequence.forward((String)"Requires Storm", (Style)Style.EMPTY))));
        }
        if (cat = this.recipe.getRequireCat()) {
            widgets.addTexture(Witchery.Companion.id("textures/gui/cat.png"), 20, 33, 10, 10, 0, 0, 10, 10, 10, 10).tooltip(CollectionsKt.listOf((Object)ClientTooltipComponent.create((FormattedCharSequence)FormattedCharSequence.forward((String)"Requires Cat Familiar", (Style)Style.EMPTY))));
        }
        int itemsPerRow = 6;
        int itemSize = 18;
        int rowIndex = 0;
        int colIndex = 0;
        for (ItemStack item : this.recipe.getInputItems()) {
            int posX = 9 + colIndex * itemSize;
            int posY = 18 + rowIndex * itemSize - 4;
            widgets.add((Widget)new WitcherySlotWidget(EmiStack.of((ItemStack)item), posX, posY, 0.0, 8, null));
            if (++colIndex < itemsPerRow) continue;
            colIndex = 0;
            ++rowIndex;
        }
        int squareX = 45;
        int squareY = this.getDisplayHeight() - 108;
        int squareSize = 92;
        this.renderRitualCircle(widgets, pattern, blockMapping, squareX, squareY, squareSize);
        int colXOffset = this.getDisplayWidth() - itemSize - 9;
        rowIndex = 0;
        for (ItemStack item : this.recipe.getOutputItems()) {
            int posY = rowIndex * itemSize + this.getDisplayHeight() - itemsPerRow * itemSize - 18 - 4;
            widgets.add((Widget)new WitcherySlotWidget(EmiStack.of((ItemStack)item), colXOffset, posY, 0.0, 8, null).recipeContext(this));
            ++rowIndex;
        }
        int yOffset = this.getDisplayHeight() / 2 + 6;
        if (this.recipe.getAltarPower() > 0) {
            widgets.addText((Component)Component.literal((String)"Initial Cost"), 7, yOffset, 0xFFFFFF, true);
            widgets.addText((Component)Component.literal((String)String.valueOf(this.recipe.getAltarPower())), 7, yOffset += 12, 16766720, true);
            yOffset += 14;
        }
        if (this.recipe.getAltarPowerPerSecond() > 0) {
            widgets.addText((Component)Component.literal((String)"Per Second"), 7, yOffset, 0xFFFFFF, true);
            widgets.addText((Component)Component.literal((String)String.valueOf(this.recipe.getAltarPowerPerSecond())), 7, yOffset += 12, 8900331, true);
            yOffset += 14;
        }
        if (this.recipe.getAltarPower() == 0 && this.recipe.getAltarPowerPerSecond() == 0) {
            widgets.addText((Component)Component.literal((String)"Power"), 7, yOffset, 0xFFFFFF, true);
            widgets.addText((Component)Component.literal((String)"0"), 7, yOffset += 12, 0xFFFFFF, true);
            yOffset += 14;
        }
        if ((size = this.recipe.getCovenCount()) > 0) {
            widgets.addText((Component)Component.literal((String)("Coven Size: " + size)), 7, yOffset, 0xFFFFFF, true);
        }
        if (!((Collection)this.recipe.getInputEntities()).isEmpty()) {
            Minecraft minecraft = Minecraft.getInstance();
            int entityX = this.getDisplayWidth() / 2;
            int entityY = this.getDisplayHeight() / 2;
            Iterator iterator = ((Iterable)this.recipe.getInputEntities()).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                LivingEntity entity;
                ++n;
                EntityType entityType = (EntityType)iterator.next();
                Entity entity2 = entityType.create((Level)minecraft.level);
                if ((entity2 instanceof LivingEntity ? (LivingEntity)entity2 : null) == null) {
                    return;
                }
                entity = entity;
                double entityHeight = entity.getBoundingBox().getYsize() * (double)4;
                double entityWidth = entity.getBoundingBox().getXsize() * (double)4;
                int baseScale = entityHeight > 2.0 ? 15 : (entityHeight > 1.0 ? 25 : 30);
                float widthAdjustment = entityWidth > 1.0 ? 0.8f : 1.0f;
                float scale = (float)baseScale * widthAdjustment;
                float yOffset2 = entityHeight <= 1.0 ? 0.0f : -8.0f;
                widgets.addDrawable(0, 0, 128, 128, (arg_0, arg_1, arg_2, arg_3) -> RitualEmiRecipe.addWidgets$lambda$0(entityX, entityY, scale, yOffset2, entity, entityType, minecraft, arg_0, arg_1, arg_2, arg_3));
            }
        }
    }

    private final void renderRitualCircle(WidgetHolder widgets, List<String> pattern, Map<Character, ? extends Block> blockMapping, int squareX, int squareY, int squareSize) {
        if (!((Collection)pattern).isEmpty()) {
            int basePatternSize = 15;
            double baseScale = 0.3333333333333333;
            int patternSize = pattern.size();
            double scale = baseScale * ((double)basePatternSize / (double)patternSize);
            int itemSize = (int)((double)16 * scale);
            int totalWidth = pattern.get(0).length() * itemSize;
            int totalHeight = pattern.size() * itemSize;
            int squareCenterX = squareX + squareSize / 2;
            int squareCenterY = squareY + squareSize / 2;
            int startingX = squareCenterX - totalWidth / 2;
            int startingY = squareCenterY - totalHeight / 2 - 16;
            int n = ((Collection)pattern).size();
            for (int y = 0; y < n; ++y) {
                String row = pattern.get(y);
                int n2 = ((CharSequence)row).length();
                for (int x = 0; x < n2; ++x) {
                    char c = row.charAt(x);
                    Block block = blockMapping.get(Character.valueOf(c));
                    Block block2 = block;
                    if (block2 == null || (block2 = block2.asItem()) == null || (block2 = block2.getDefaultInstance()) == null) continue;
                    Block itemStack = block2;
                    int posX = startingX + x * itemSize;
                    int posY = startingY + y * itemSize;
                    this.renderItem(widgets, (ItemStack)itemStack, posX, posY, itemSize, y + x, patternSize);
                }
            }
        }
    }

    private final void addChalkCircleWidget(WidgetHolder widgets, int posX, int posY, int size, String texturePath, int patternSize, Integer color) {
        widgets.addDrawable(posX, posY, size, size, (arg_0, arg_1, arg_2, arg_3) -> RitualEmiRecipe.addChalkCircleWidget$lambda$0(patternSize, color, texturePath, arg_0, arg_1, arg_2, arg_3));
    }

    static /* synthetic */ void addChalkCircleWidget$default(RitualEmiRecipe ritualEmiRecipe, WidgetHolder widgetHolder, int n, int n2, int n3, String string, int n4, Integer n5, int n6, Object object) {
        if ((n6 & 0x40) != 0) {
            n5 = null;
        }
        ritualEmiRecipe.addChalkCircleWidget(widgetHolder, n, n2, n3, string, n4, n5);
    }

    private final void addItemCircleWidget(WidgetHolder widgets, ItemStack itemStack, int posX, int posY) {
        widgets.add((Widget)new WitcherySlotWidget(EmiStack.of((ItemStack)itemStack), posX - 5, posY + 5, 0.3).drawBack(false));
    }

    private final void renderItem(WidgetHolder widgets, ItemStack itemStack, int posX, int posY, int size, int index, int patternSize) {
        if (itemStack.is((Item)WitcheryItems.INSTANCE.getGOLDEN_CHALK().get())) {
            RitualEmiRecipe.addChalkCircleWidget$default(this, widgets, posX, posY, size, "textures/block/golden_chalk.png", patternSize, null, 64, null);
        } else if (itemStack.is((Item)WitcheryItems.INSTANCE.getRITUAL_CHALK().get())) {
            RitualEmiRecipe.addChalkCircleWidget$default(this, widgets, posX, posY, size, "textures/block/chalk_" + index % 15 + ".png", patternSize, null, 64, null);
        } else if (itemStack.is((Item)WitcheryItems.INSTANCE.getOTHERWHERE_CHALK().get())) {
            this.addChalkCircleWidget(widgets, posX, posY, size, "textures/block/chalk_" + index % 15 + ".png", patternSize, new Color(190, 55, 250).getRGB());
        } else if (itemStack.is((Item)WitcheryItems.INSTANCE.getINFERNAL_CHALK().get())) {
            this.addChalkCircleWidget(widgets, posX, posY, size, "textures/block/chalk_" + index % 15 + ".png", patternSize, new Color(230, 0, 75).getRGB());
        } else {
            this.addItemCircleWidget(widgets, itemStack, posX, posY);
        }
    }

    private static final void addWidgets$lambda$0(int $entityX, int $entityY, float $scale, float $yOffset, LivingEntity $entity, EntityType $entityType, Minecraft $minecraft, GuiGraphics graphics, int mouseX, int mouseY, float f) {
        Intrinsics.checkNotNull((Object)graphics);
        RenderUtils.INSTANCE.renderEntityInInventoryFollowsMouse(graphics, $entityX - 20, $entityY + 20, $entityX + 20, $entityY - 20, (int)$scale, $yOffset + (float)8, mouseX, mouseY, $entity);
        MutableComponent entityName = Component.translatable((String)$entityType.getDescriptionId());
        int textWidth = $minecraft.font.width((FormattedText)entityName);
        graphics.drawString($minecraft.font, (Component)entityName, $entityX - textWidth / 2, $entityY + 15, 0xFFFFFF);
    }

    private static final void addChalkCircleWidget$lambda$0(int $patternSize, Integer $color, String $texturePath, GuiGraphics graphics, int n, int n2, float f) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        int basePatternSize = 4;
        float scaleFactor = (float)basePatternSize / (float)$patternSize;
        poseStack.scale(scaleFactor, scaleFactor, scaleFactor);
        if ($color != null) {
            Intrinsics.checkNotNull((Object)poseStack);
            ResourceLocation resourceLocation = Witchery.Companion.id($texturePath);
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            RenderUtils.renderChalk$default(RenderUtils.INSTANCE, poseStack, 0, 0, resourceLocation, $color, 6, null);
        } else {
            Intrinsics.checkNotNull((Object)poseStack);
            ResourceLocation resourceLocation = Witchery.Companion.id($texturePath);
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            RenderUtils.renderChalk$default(RenderUtils.INSTANCE, poseStack, 0, 0, resourceLocation, 6, null);
        }
        poseStack.popPose();
    }
}

