/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import dev.sterner.witchery.features.ritual.RainingToadAttachment;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.frog.Frog;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class FrogEntityMixin {
    @Inject(method={"setOnGround"}, at={@At(value="HEAD")})
    protected void witchery$onSetOnGround(boolean onGround, CallbackInfo ci) {
        Entity self = (Entity)Entity.class.cast(this);
        if (onGround && self instanceof Frog) {
            Frog frog = (Frog)self;
            RainingToadAttachment.Data data2 = RainingToadAttachment.getData((LivingEntity)frog);
            data2.setSafeFall(false);
            RainingToadAttachment.setData((LivingEntity)frog, data2);
        }
    }

    @Inject(method={"push(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")})
    protected void witchery$onPush(Entity entity, CallbackInfo ci) {
        Entity self = (Entity)Entity.class.cast(this);
        if (self instanceof Frog) {
            RainingToadAttachment.Data data2;
            LivingEntity living;
            Frog frog = (Frog)self;
            if (entity instanceof LivingEntity && !((living = (LivingEntity)entity) instanceof Frog) && (data2 = RainingToadAttachment.getData((LivingEntity)frog)).isPoisonous()) {
                living.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 0));
            }
        }
    }
}

