/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import dev.sterner.witchery.mixin_logic.SummonedWolf;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Wolf.class})
public class WolfMixin
implements SummonedWolf {
    @Unique
    private int witchery$summonedTime = -1;
    @Unique
    private boolean witchery$isSummoned = false;
    @Unique
    private int witchery$summonDuration = 600;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void onTick(CallbackInfo ci) {
        Wolf wolf = (Wolf)this;
        if (this.witchery$isSummoned && !wolf.level().isClientSide) {
            Level level;
            ++this.witchery$summonedTime;
            if (this.witchery$summonedTime >= this.witchery$summonDuration) {
                Level level2 = wolf.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, wolf.getX(), wolf.getY() + 0.5, wolf.getZ(), 20, 0.3, 0.3, 0.3, 0.05);
                }
                wolf.discard();
                return;
            }
            if (this.witchery$summonedTime >= this.witchery$summonDuration - 100 && this.witchery$summonedTime % 20 == 0 && (level = wolf.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, wolf.getX(), wolf.getY() + 0.5, wolf.getZ(), 5, 0.2, 0.2, 0.2, 0.0);
            }
        }
    }

    @Override
    public void witchery$setSummoned(boolean summoned) {
        this.witchery$isSummoned = summoned;
        if (summoned) {
            this.witchery$summonedTime = 0;
        }
    }

    @Override
    public boolean witchery$isSummoned() {
        return this.witchery$isSummoned;
    }

    @Override
    public void witchery$setSummonDuration(int ticks) {
        this.witchery$summonDuration = ticks;
    }

    @Override
    public int witchery$getRemainingTime() {
        if (this.witchery$isSummoned) {
            return Math.max(0, this.witchery$summonDuration - this.witchery$summonedTime);
        }
        return 0;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void witchery$saveData(CompoundTag tag, CallbackInfo ci) {
        tag.putBoolean("WitcheryIsSummoned", this.witchery$isSummoned);
        tag.putInt("WitcherySummonedTime", this.witchery$summonedTime);
        tag.putInt("WitcherySummonDuration", this.witchery$summonDuration);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void witchery$loadData(CompoundTag tag, CallbackInfo ci) {
        if (tag.contains("WitcheryIsSummoned")) {
            this.witchery$isSummoned = tag.getBoolean("WitcheryIsSummoned");
        }
        if (tag.contains("WitcherySummonedTime")) {
            this.witchery$summonedTime = tag.getInt("WitcherySummonedTime");
        }
        if (tag.contains("WitcherySummonDuration")) {
            this.witchery$summonDuration = tag.getInt("WitcherySummonDuration");
        }
    }
}

