/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin.client;

import com.klikli_dev.modonomicon.client.gui.book.node.BookParentNodeScreen;
import dev.sterner.witchery.client.WitcheryAdvancementButton;
import dev.sterner.witchery.mixin.client.ScreenAccessor;
import dev.sterner.witchery.network.GrantWitcheryAdvancementsC2SPayload;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BookParentNodeScreen.class}, remap=false)
public class BookParentNodeScreenMixin {
    @Shadow
    public int getFrameWidth() {
        return 0;
    }

    @Shadow
    public int getFrameThicknessW() {
        return 0;
    }

    @Shadow
    public int getFrameHeight() {
        return 0;
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void addWitcheryAdvancementButton(CallbackInfo ci) {
        BookParentNodeScreen self = (BookParentNodeScreen)this;
        int witcheryButtonXOffset = 5;
        int witcheryButtonYOffset = 22;
        int witcheryButtonX = this.getFrameWidth() + this.getFrameThicknessW() + 8 + witcheryButtonXOffset;
        int witcheryButtonY = (self.height - this.getFrameHeight()) / 2 + 8 + witcheryButtonYOffset;
        WitcheryAdvancementButton witcheryAdvancementButton = new WitcheryAdvancementButton(witcheryButtonX, witcheryButtonY, button -> this.witchery$onWitcheryAdvancementButtonClick(), Tooltip.create((Component)Component.literal((String)"Grant all Witchery advancements")));
        ((ScreenAccessor)self).witchery$addRenderableWidget(witcheryAdvancementButton);
    }

    @Unique
    private void witchery$onWitcheryAdvancementButtonClick() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || !mc.player.hasPermissions(2)) {
            return;
        }
        if (mc.player != null && mc.hasSingleplayerServer()) {
            ServerPlayer serverPlayer;
            IntegratedServer server = mc.getSingleplayerServer();
            if (server != null && (serverPlayer = server.getPlayerList().getPlayer(mc.player.getUUID())) != null) {
                this.witchery$grantAllWitcheryAdvancements(serverPlayer, (MinecraftServer)server);
            }
        } else if (mc.player != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new GrantWitcheryAdvancementsC2SPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Unique
    private void witchery$grantAllWitcheryAdvancements(ServerPlayer player, MinecraftServer server) {
        ServerAdvancementManager advancementManager = server.getAdvancements();
        for (AdvancementHolder holder : advancementManager.getAllAdvancements()) {
            ResourceLocation id = holder.id();
            if (!id.getNamespace().equals("witchery")) continue;
            Advancement advancement = holder.value();
            AdvancementProgress progress = player.getAdvancements().getOrStartProgress(holder);
            if (progress.isDone()) continue;
            for (String criterion : advancement.criteria().keySet()) {
                CriterionProgress prog = progress.getCriterion(criterion);
                if (prog == null || prog.isDone()) continue;
                player.getAdvancements().award(holder, criterion);
            }
        }
    }
}

