/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin.possession.possessor;

import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.sugar.Local;
import dev.sterner.witchery.content.entity.player_shell.SoulShellPlayerEntity;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.possession.PossessionComponentAttachment;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public abstract class PlayerListMixin {
    @ModifyReceiver(method={"placeNewPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;contains(Ljava/lang/String;I)Z")})
    @Nullable
    private CompoundTag witchery$placeNewPlayer(CompoundTag serializedPlayer, String key, int type, @Local(argsOnly=true) ServerPlayer player) {
        if (serializedPlayer != null) {
            AfflictionPlayerAttachment.Data data2;
            if (serializedPlayer.contains("PossessedRoot", 10)) {
                ServerLevel world = player.serverLevel();
                CompoundTag serializedPossessedInfo = serializedPlayer.getCompound("PossessedRoot");
                Entity possessedEntityMount = EntityType.loadEntityRecursive((CompoundTag)serializedPossessedInfo.getCompound("PossessedEntity"), (Level)world, entity_1x -> !world.addWithUUID(entity_1x) ? null : entity_1x);
                if (possessedEntityMount != null) {
                    UUID possessedEntityUuid = serializedPossessedInfo.getUUID("PossessedUUID");
                    this.witchery$resumePossession(PossessionComponentAttachment.INSTANCE.get((Player)player), possessedEntityMount, possessedEntityUuid);
                }
            }
            if ((data2 = AfflictionPlayerAttachment.getData((Player)player)).isSoulForm()) {
                SoulShellPlayerEntity.Companion.enableFlight(player);
                player.onUpdateAbilities();
            }
        }
        return serializedPlayer;
    }

    @Unique
    private void witchery$resumePossession(PossessionComponentAttachment.PossessionComponent player, Entity possessedEntityMount, UUID possessedEntityUuid) {
        if (possessedEntityMount instanceof Mob && possessedEntityMount.getUUID().equals(possessedEntityUuid)) {
            player.startPossessing((Mob)possessedEntityMount);
        } else {
            for (Entity entity : possessedEntityMount.getIndirectPassengers()) {
                if (!(entity instanceof Mob) || !entity.getUUID().equals(possessedEntityUuid)) continue;
                player.startPossessing((Mob)entity);
                break;
            }
        }
        if (!player.isPossessionOngoing()) {
            possessedEntityMount.getSelfAndPassengers().forEach(e -> e.setRemoved(Entity.RemovalReason.UNLOADED_WITH_PLAYER));
        }
    }

    @Inject(method={"remove"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerAdvancements;stopListening()V", shift=At.Shift.AFTER)}, allow=1)
    private void witchery$remove(ServerPlayer player, CallbackInfo info) {
        Mob possessedEntity = PossessionComponentAttachment.INSTANCE.get((Player)player).getHost();
        if (possessedEntity != null) {
            possessedEntity.getSelfAndPassengers().forEach(e -> e.setRemoved(Entity.RemovalReason.UNLOADED_WITH_PLAYER));
        }
    }
}

