/*
 * Decompiled with CFR 0.152.
 */
package com.devas.privatecreative;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;

public class PrivateCreative
extends JavaPlugin
implements Listener {
    private Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();
    private Map<UUID, UUID> pendingTpRequests = new HashMap<UUID, UUID>();
    private Map<UUID, Long> tpaCooldown = new HashMap<UUID, Long>();
    private Map<UUID, Boolean> autoKillCreative = new HashMap<UUID, Boolean>();
    private File dataFolder;
    private File creativeDataFolder;
    private long TPA_COOLDOWN;
    private long TPA_TIMEOUT;
    private final String[] allowedCommands = new String[]{"give", "effect", "summon", "time", "weather", "clear", "tp", "teleport", "enchant", "xp", "experience", "setblock", "kill"};

    @Override
    public void onEnable() {
        if (!this.checkVersionCompatibility()) {
            this.getLogger().severe("This plugin is not compatible with your server version!");
            this.getLogger().severe("Supported versions: 1.21.x");
            this.getLogger().severe("Your version: " + Bukkit.getVersion());
            Bukkit.getPluginManager().disablePlugin(this);
            return;
        }
        this.getLogger().info("PrivateCreative v" + this.getDescription().getVersion() + " is loading...");
        this.getLogger().info("Server version: " + this.getServerVersionInfo());
        this.saveDefaultConfig();
        this.getCommand("pc").setExecutor(this);
        this.getCommand("pc").setTabCompleter(this);
        this.getCommand("cw").setExecutor(this);
        this.getCommand("cw").setTabCompleter(this);
        Bukkit.getPluginManager().registerEvents(this, this);
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.dataFolder = new File(this.getDataFolder(), "playerdata");
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        this.creativeDataFolder = new File(this.getDataFolder(), "creativedata");
        if (!this.creativeDataFolder.exists()) {
            this.creativeDataFolder.mkdirs();
        }
        this.TPA_COOLDOWN = this.getConfig().getInt("teleport.cooldown", 10) * 1000;
        this.TPA_TIMEOUT = this.getConfig().getInt("teleport.timeout", 30);
        this.getLogger().info("PrivateCreative v" + this.getDescription().getVersion() + " has been enabled!");
    }

    private boolean checkVersionCompatibility() {
        String[] supportedVersions;
        String version = Bukkit.getVersion();
        String bukkitVersion = Bukkit.getBukkitVersion();
        String[] stringArray = supportedVersions = new String[]{"1.21", "1.21.1", "1.21.2", "1.21.3", "1.21.4", "1.21.5", "1.21.6", "1.21.7", "1.21.8", "1.21.9", "1.21.10"};
        int n = supportedVersions.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedVersion = stringArray[n2];
            if (bukkitVersion.startsWith(supportedVersion)) {
                this.getLogger().info("\u2705 Exact version match: " + bukkitVersion);
                return true;
            }
            ++n2;
        }
        if (bukkitVersion.matches("1\\.21\\.[0-9]+")) {
            this.getLogger().info("\u2705 Generic 1.21.x compatibility: " + bukkitVersion);
            return true;
        }
        if (version.contains("1.21")) {
            this.getLogger().info("\u2705 Version compatibility assumed (fuzzy match): " + version);
            return true;
        }
        this.getLogger().severe("\u274c Unsupported server version detected!");
        this.getLogger().severe("Current version: " + bukkitVersion + " (" + version + ")");
        this.getLogger().severe("Supported range: 1.21.x (tested up to 1.21.10)");
        this.getLogger().severe("This plugin should work with any 1.21.x version, but hasn't been tested on yours.");
        return false;
    }

    private String getServerVersionInfo() {
        return String.format("MC %s (%s)", Bukkit.getBukkitVersion(), Bukkit.getVersion().contains("Paper") ? "Paper" : (Bukkit.getVersion().contains("Spigot") ? "Spigot" : "Bukkit"));
    }

    @Override
    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            UUID uuid = player.getUniqueId();
            if (!player.getWorld().getName().equals("creative_" + uuid.toString())) continue;
            PotionEffect[] currentEffects = player.getActivePotionEffects().toArray(new PotionEffect[0]);
            PlayerData creativeData = new PlayerData(player.getLocation(), player.getInventory().getContents(), player.getGameMode(), currentEffects);
            this.saveCreativeData(uuid, creativeData);
        }
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (label.equalsIgnoreCase("pc")) {
            if (!(sender instanceof Player)) {
                if (args.length == 0) {
                    sender.sendMessage("PrivateCreative Console Commands:");
                    sender.sendMessage("/pc reload - Reload the plugin");
                    return true;
                }
                if (args[0].equalsIgnoreCase("reload")) {
                    return this.handleReloadCommand(sender);
                }
                sender.sendMessage("Unknown console command. Available: reload");
                return true;
            }
            if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                return this.handleReloadCommand(sender);
            }
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be executed as a player.");
            return true;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        if (label.equalsIgnoreCase("pc")) {
            if (args.length == 0) {
                player.sendMessage("\u00a78\u00a7l\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
                player.sendMessage("\u00a76\u00a7l                    PrivateCreative Commands");
                player.sendMessage("\u00a78\u00a7l\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
                player.sendMessage("");
                player.sendMessage("\u00a7a\u00a7l\u25ba World Management:");
                player.sendMessage("\u00a77  /pc creative \u00a78[\u00a73void\u00a77|\u00a73superflat\u00a77|\u00a73normal\u00a78] \u00a78[\u00a73border-size\u00a78] \u00a77- \u00a7fSwitch to creative world");
                player.sendMessage("\u00a77  /pc survival \u00a77- \u00a7fReturn to survival world");
                player.sendMessage("\u00a77  /pc creativestop \u00a77- \u00a7fStop your creative world");
                player.sendMessage("\u00a77  /pc creativeautokill \u00a77- \u00a7fToggle auto-kill of creative world");
                player.sendMessage("\u00a7c  /pc creativedelete \u00a77- \u00a7fDelete your creative world \u00a7c(\u00a7l!\u00a7c)");
                player.sendMessage("");
                player.sendMessage("\u00a7b\u00a7l\u25ba Multiplayer:");
                player.sendMessage("\u00a77  /pc tpa \u00a73<player> \u00a77- \u00a7fRequest teleport to your creative world");
                player.sendMessage("\u00a77  /pc accept \u00a77- \u00a7fAccept teleport request");
                player.sendMessage("\u00a77  /pc deny \u00a77- \u00a7fDeny teleport request");
                player.sendMessage("\u00a77  /pc kick \u00a73<player> \u00a77- \u00a7fKick a guest from your creative world");
                if (player.hasPermission("privatecreative.admin") || player.isOp()) {
                    player.sendMessage("");
                    player.sendMessage("\u00a7e\u00a7l\u25ba Admin Commands:");
                    player.sendMessage("\u00a77  /pc reload \u00a77- \u00a7fReload the plugin configuration");
                }
                player.sendMessage("");
                player.sendMessage("\u00a78\u00a7l\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
                return true;
            }
            String subCommand = args[0].toLowerCase();
            String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
            if (subCommand.equals("creative")) {
                return this.handleCreativeCommand(player, uuid, subArgs);
            }
            if (subCommand.equals("survival")) {
                return this.handleSurvivalCommand(player, uuid);
            }
            if (subCommand.equals("tpa")) {
                return this.handleTpaCommand(player, uuid, subArgs);
            }
            if (subCommand.equals("accept")) {
                return this.handleTpAcceptCommand(player, uuid);
            }
            if (subCommand.equals("deny")) {
                return this.handleTpDenyCommand(player, uuid);
            }
            if (subCommand.equals("creativestop")) {
                return this.handleCreativeStopCommand(player, uuid);
            }
            if (subCommand.equals("creativeautokill")) {
                return this.handleCreativeAutoKillCommand(player, uuid);
            }
            if (subCommand.equals("creativedelete")) {
                return this.handleCreativeDeleteCommand(player, uuid);
            }
            if (subCommand.equals("reload")) {
                return this.handleReloadCommand(player);
            }
            if (subCommand.equals("kick")) {
                return this.handleKickCommand(player, uuid, subArgs);
            }
            player.sendMessage("Unknown subcommand. Use /pc without arguments to see available commands.");
            return true;
        }
        if (label.equalsIgnoreCase("cw")) {
            String baseCmd;
            if (!player.getWorld().getName().equals("creative_" + uuid.toString())) {
                player.sendMessage("This command can only be used in your creative world.");
                return true;
            }
            if (args.length < 1) {
                player.sendMessage("Usage: /cw <command> [arguments] - Example: /cw effect give " + player.getName() + " minecraft:speed 100 2");
                return true;
            }
            String[] stringArray = args;
            int n = args.length;
            int subArgs = 0;
            while (subArgs < n) {
                String arg = stringArray[subArgs];
                if (arg.equalsIgnoreCase("@a") || arg.equalsIgnoreCase("@p") || arg.equalsIgnoreCase("@r") || arg.equalsIgnoreCase("@e")) {
                    player.sendMessage("Using @a, @p, @r or @e is not allowed.");
                    return true;
                }
                ++subArgs;
            }
            List<String> argsList = Arrays.asList(args);
            int i = 0;
            while (i < argsList.size()) {
                Player target;
                if (!argsList.get(i).equalsIgnoreCase(player.getName()) && (target = Bukkit.getPlayer(argsList.get(i))) != null && !target.getWorld().getName().equals("creative_" + uuid.toString())) {
                    player.sendMessage("The player " + target.getName() + " is not in your creative world.");
                    return true;
                }
                ++i;
            }
            String commandString = String.join((CharSequence)" ", args).trim();
            String string = baseCmd = args.length > 0 ? args[0].toLowerCase() : "";
            if (Arrays.stream(this.allowedCommands).noneMatch(cmd -> baseCmd.equals(cmd) || baseCmd.startsWith(cmd + " "))) {
                player.sendMessage("This command is not allowed. Allowed commands: " + String.join((CharSequence)", ", this.allowedCommands));
                return true;
            }
            String[] worldSpecificCommands = new String[]{"time", "weather", "summon", "tp", "teleport", "setblock"};
            boolean useWorldExecution = Arrays.stream(worldSpecificCommands).anyMatch(cmd -> baseCmd.equals(cmd));
            try {
                if (useWorldExecution) {
                    String playerWorldName = player.getWorld().getName();
                    String finalCommand = "execute in " + playerWorldName + " run " + commandString;
                    Bukkit.dispatchCommand(Bukkit.getConsoleSender(), finalCommand);
                } else {
                    Bukkit.dispatchCommand(Bukkit.getConsoleSender(), commandString);
                }
            }
            catch (Exception e) {
                player.sendMessage("Command failed to execute. Check your syntax.");
                this.getLogger().warning("Command execution failed: " + commandString + " - " + e.getMessage());
                return true;
            }
            player.sendMessage("Command executed: " + commandString);
            return true;
        }
        player.sendMessage("Unknown command or incorrect usage. Please check your input.");
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block7: {
            block5: {
                String input;
                block8: {
                    String subcommand;
                    block9: {
                        block6: {
                            completions = new ArrayList<String>();
                            if (!command.getName().equalsIgnoreCase("pc")) break block5;
                            if (args.length != 1) break block6;
                            List<String> subcommands = Arrays.asList("creative", "survival", "tpa", "accept", "deny", "creativestop", "creativeautokill", "creativedelete", "kick", "reload");
                            String input2 = args[0].toLowerCase();
                            for (String string : subcommands) {
                                if (!string.startsWith(input2)) continue;
                                completions.add(string);
                            }
                            break block7;
                        }
                        if (args.length != 2) break block8;
                        subcommand = args[0].toLowerCase();
                        if (!subcommand.equals("creative")) break block9;
                        List<String> worldTypes = Arrays.asList("normal", "superflat", "void");
                        String string = args[1].toLowerCase();
                        for (String worldType : worldTypes) {
                            if (!worldType.startsWith(string)) continue;
                            completions.add(worldType);
                        }
                        break block7;
                    }
                    if (!subcommand.equals("tpa") && !subcommand.equals("kick")) break block7;
                    String input4 = args[1].toLowerCase();
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        String playerName = player.getName().toLowerCase();
                        if (!playerName.startsWith(input4) || player.equals(sender)) continue;
                        completions.add(player.getName());
                    }
                    break block7;
                }
                if (args.length != 3 || !args[0].equalsIgnoreCase("creative") || !(input = args[2]).isEmpty() && !input.matches("\\d+")) break block7;
                completions.addAll(Arrays.asList("100", "500", "1000", "2000", "5000"));
                break block7;
            }
            if (command.getName().equalsIgnoreCase("cw") && args.length == 1) {
                List<String> allowedCmds = Arrays.asList(this.allowedCommands);
                String input = args[0].toLowerCase();
                for (String string : allowedCmds) {
                    if (!string.startsWith(input)) continue;
                    completions.add(string);
                }
            }
        }
        return completions;
    }

    private boolean handleCreativeCommand(Player player, UUID uuid, String[] args) {
        if (player.getWorld().getName().equals("creative_" + uuid.toString())) {
            player.sendMessage("You are already in your creative world.");
            return true;
        }
        String worldType = "normal";
        int worldBorder = 0;
        if (args.length > 0) {
            String firstArg = args[0].toLowerCase();
            if (firstArg.equals("void") || firstArg.equals("superflat") || firstArg.equals("normal")) {
                worldType = firstArg;
            } else {
                player.sendMessage("Usage: /pc creative [void|superflat|normal] [worldborder-size]");
                player.sendMessage("Example: /pc creative void 100");
                return true;
            }
        }
        if (args.length > 1) {
            try {
                worldBorder = Integer.parseInt(args[1]);
                if (worldBorder < 10 || worldBorder > 10000) {
                    player.sendMessage("World border must be between 10 and 10000 blocks.");
                    return true;
                }
            }
            catch (NumberFormatException e) {
                player.sendMessage("Invalid world border size. Use a number between 10 and 10000.");
                return true;
            }
        }
        if (!player.getWorld().getName().startsWith("creative_")) {
            PotionEffect[] currentEffects = player.getActivePotionEffects().toArray(new PotionEffect[0]);
            PlayerData survivalData = new PlayerData(player.getLocation(), player.getInventory().getContents(), player.getGameMode(), currentEffects);
            this.playerDataMap.put(uuid, survivalData);
            this.savePlayerData(uuid, survivalData);
        } else if (!this.playerDataMap.containsKey(uuid) && this.loadPlayerData(uuid) == null) {
            World mainWorld = Bukkit.getWorlds().get(0);
            Location fallbackLocation = mainWorld.getSpawnLocation();
            PlayerData fallbackData = new PlayerData(fallbackLocation, new ItemStack[0], GameMode.SURVIVAL, new PotionEffect[0]);
            this.playerDataMap.put(uuid, fallbackData);
            this.savePlayerData(uuid, fallbackData);
            player.sendMessage("Fallback survival data created as no original data was found.");
        }
        String existingWorldName = "creative_" + uuid.toString();
        World existingWorld = Bukkit.getWorld(existingWorldName);
        if (existingWorld != null && !worldType.equals("normal")) {
            player.sendMessage("You already have a creative world. To change the world type, delete it first with /pc creativedelete.");
            player.sendMessage("Loading current world...");
            worldType = "normal";
        }
        PlayerData creativeData = this.loadCreativeData(uuid);
        World creativeWorld = this.getOrCreateCreativeWorld(uuid, worldType);
        if (worldBorder > 0) {
            creativeWorld.getWorldBorder().setSize(worldBorder * 2);
            creativeWorld.getWorldBorder().setCenter(0.0, 0.0);
            player.sendMessage("World border set to " + worldBorder + " blocks radius.");
        }
        player.getActivePotionEffects().forEach(effect -> player.removePotionEffect(effect.getType()));
        if (creativeData != null) {
            player.teleport(creativeData.location);
            player.getInventory().setContents(creativeData.inventory);
        } else {
            player.teleport(creativeWorld.getSpawnLocation());
            player.getInventory().clear();
        }
        player.setGameMode(GameMode.CREATIVE);
        player.sendMessage("You switched to your private creative world (" + worldType + "). Survival effects have been saved.");
        return true;
    }

    private boolean handleSurvivalCommand(final Player player, final UUID uuid) {
        PlayerData survivalData;
        if (!player.getWorld().getName().startsWith("creative_")) {
            player.sendMessage("You are already in the survival world.");
            return true;
        }
        if (player.getWorld().getName().equals("creative_" + uuid.toString())) {
            PlayerData creativeData = new PlayerData(player.getLocation(), player.getInventory().getContents(), player.getGameMode());
            this.saveCreativeData(uuid, creativeData);
        }
        if ((survivalData = this.playerDataMap.get(uuid)) == null) {
            survivalData = this.loadPlayerData(uuid);
        }
        player.getActivePotionEffects().forEach(effect -> player.removePotionEffect(effect.getType()));
        if (survivalData == null) {
            World mainWorld = Bukkit.getWorlds().get(0);
            Location spawnLocation = mainWorld.getSpawnLocation();
            player.teleport(spawnLocation);
            player.setGameMode(GameMode.SURVIVAL);
            player.getInventory().clear();
            player.sendMessage("You were teleported to spawn location as no survival data was found.");
        } else {
            player.teleport(survivalData.location);
            player.getInventory().setContents(survivalData.inventory);
            player.setGameMode(survivalData.gameMode);
            if (survivalData.effects != null && survivalData.effects.length > 0) {
                PotionEffect[] potionEffectArray = survivalData.effects;
                int n = survivalData.effects.length;
                int n2 = 0;
                while (n2 < n) {
                    PotionEffect effect2 = potionEffectArray[n2];
                    player.addPotionEffect(effect2);
                    ++n2;
                }
                player.sendMessage("You have returned to your survival world. Your effects have been restored.");
            } else {
                player.sendMessage("You have returned to your survival world.");
            }
            if (player.getWorld().getName().equals("creative_" + uuid.toString())) {
                this.playerDataMap.remove(uuid);
                this.deletePlayerDataFile(uuid);
            }
        }
        if (player.getWorld().getName().equals("creative_" + uuid.toString()) && this.autoKillCreative.getOrDefault(uuid, false).booleanValue()) {
            new BukkitRunnable(){

                @Override
                public void run() {
                    String worldName = "creative_" + uuid.toString();
                    World creativeWorld = Bukkit.getWorld(worldName);
                    if (creativeWorld != null && creativeWorld.getPlayers().isEmpty()) {
                        Bukkit.unloadWorld(creativeWorld, true);
                        if (player.isOnline()) {
                            player.sendMessage("Your creative world was automatically unloaded.");
                        }
                    }
                }
            }.runTaskLater(this, 600L);
        }
        return true;
    }

    private boolean handleTpaCommand(final Player player, final UUID uuid, String[] args) {
        long lastRequest;
        if (args.length != 1) {
            player.sendMessage("Usage: /pc tpa <playername>");
            return true;
        }
        if (!player.getWorld().getName().equals("creative_" + uuid.toString())) {
            player.sendMessage("You must be in your own creative world to invite others.");
            return true;
        }
        long currentTime = System.currentTimeMillis();
        if (this.tpaCooldown.containsKey(uuid) && currentTime - (lastRequest = this.tpaCooldown.get(uuid).longValue()) < this.TPA_COOLDOWN) {
            player.sendMessage("You need to wait a bit before sending another request.");
            return true;
        }
        this.tpaCooldown.put(uuid, currentTime);
        final Player target = Bukkit.getPlayer(args[0]);
        if (target == null) {
            player.sendMessage("Player not found or offline.");
            return true;
        }
        if (target.getWorld().getName().startsWith("creative_")) {
            player.sendMessage("The player is already in a creative world.");
            return true;
        }
        this.pendingTpRequests.put(target.getUniqueId(), uuid);
        this.openTpRequestGUI(target, player);
        player.sendMessage("Invitation sent to " + target.getName() + ".");
        new BukkitRunnable(){

            @Override
            public void run() {
                if (PrivateCreative.this.pendingTpRequests.containsKey(target.getUniqueId()) && PrivateCreative.this.pendingTpRequests.get(target.getUniqueId()).equals(uuid)) {
                    PrivateCreative.this.pendingTpRequests.remove(target.getUniqueId());
                    target.sendMessage("The teleport request from " + player.getName() + " has expired.");
                    player.sendMessage("Your teleport request to " + target.getName() + " has expired.");
                }
            }
        }.runTaskLater(this, this.TPA_TIMEOUT * 20L);
        return true;
    }

    private boolean handleTpAcceptCommand(Player player, UUID uuid) {
        if (!this.pendingTpRequests.containsKey(uuid)) {
            player.sendMessage("You have not received an invitation.");
            return true;
        }
        UUID inviterUUID = this.pendingTpRequests.get(uuid);
        Player inviter = Bukkit.getPlayer(inviterUUID);
        if (inviter == null) {
            player.sendMessage("The inviting player is no longer reachable.");
            this.pendingTpRequests.remove(uuid);
            return true;
        }
        String creativeWorldName = "creative_" + inviterUUID.toString();
        if (!inviter.getWorld().getName().equals(creativeWorldName)) {
            player.sendMessage("The inviting player is currently not in their creative world.");
            this.pendingTpRequests.remove(uuid);
            return true;
        }
        if (!player.getWorld().getName().startsWith("creative_")) {
            PotionEffect[] currentEffects = player.getActivePotionEffects().toArray(new PotionEffect[0]);
            PlayerData survivalData = new PlayerData(player.getLocation(), player.getInventory().getContents(), player.getGameMode(), currentEffects);
            this.playerDataMap.put(uuid, survivalData);
            this.savePlayerData(uuid, survivalData);
        }
        player.getActivePotionEffects().forEach(effect -> player.removePotionEffect(effect.getType()));
        player.teleport(inviter.getLocation());
        player.setGameMode(GameMode.CREATIVE);
        player.sendMessage("You have accepted the invitation from " + inviter.getName() + ". Your survival effects have been saved.");
        inviter.sendMessage(player.getName() + " has accepted your invitation.");
        this.pendingTpRequests.remove(uuid);
        return true;
    }

    private boolean handleTpDenyCommand(Player player, UUID uuid) {
        if (!this.pendingTpRequests.containsKey(uuid)) {
            player.sendMessage("You have not received an invitation.");
            return true;
        }
        UUID inviterUUID = this.pendingTpRequests.get(uuid);
        Player inviter = Bukkit.getPlayer(inviterUUID);
        player.sendMessage("You have declined the invitation.");
        if (inviter != null) {
            inviter.sendMessage(player.getName() + " has declined your invitation.");
        }
        this.pendingTpRequests.remove(uuid);
        return true;
    }

    private boolean handleCreativeStopCommand(Player player, UUID uuid) {
        String worldName = "creative_" + uuid.toString();
        World creativeWorld = Bukkit.getWorld(worldName);
        if (creativeWorld != null) {
            Bukkit.unloadWorld(creativeWorld, true);
            player.sendMessage("Your creative world has been stopped.");
        } else {
            player.sendMessage("You currently have no active creative world.");
        }
        return true;
    }

    private boolean handleCreativeAutoKillCommand(Player player, UUID uuid) {
        boolean currentState = this.autoKillCreative.getOrDefault(uuid, false);
        this.autoKillCreative.put(uuid, !currentState);
        player.sendMessage("Auto-kill of creative world when switching to survival is now " + (!currentState ? "enabled" : "disabled") + ".");
        return true;
    }

    private boolean handleCreativeDeleteCommand(Player player, UUID uuid) {
        String worldName = "creative_" + uuid.toString();
        World creativeWorld = Bukkit.getWorld(worldName);
        if (player.getWorld().getName().equals(worldName)) {
            player.sendMessage("You cannot delete your creative world while you are in it. Use /pc survival first.");
            return true;
        }
        if (creativeWorld != null) {
            Bukkit.unloadWorld(creativeWorld, false);
            player.sendMessage("Your creative world has been unloaded.");
        }
        boolean deleted = false;
        File serverDirectory = Bukkit.getWorldContainer();
        File worldFolder = new File(serverDirectory, worldName);
        player.sendMessage("Deleting your creative world...");
        if (worldFolder.exists() && this.deleteDirectory(worldFolder)) {
            deleted = true;
            this.getLogger().info("Deleted creative world: " + worldName + " for player " + player.getName());
        }
        if (deleted) {
            boolean autoCleanup = this.getConfig().getBoolean("worlds.auto-cleanup", true);
            if (autoCleanup) {
                File survivalDataFile;
                File creativeDataFile = new File(this.creativeDataFolder, uuid.toString() + ".yml");
                if (creativeDataFile.exists()) {
                    creativeDataFile.delete();
                    this.getLogger().info("Auto-cleanup: Deleted creative data file for player " + player.getName());
                }
                if ((survivalDataFile = new File(this.dataFolder, uuid.toString() + ".yml")).exists()) {
                    survivalDataFile.delete();
                    this.getLogger().info("Auto-cleanup: Deleted survival data file for player " + player.getName());
                }
            }
            player.sendMessage("Your creative world has been permanently deleted.");
        } else {
            player.sendMessage("You have no creative world that could be deleted, or deletion failed.");
            this.getLogger().info("No world folder found to delete at: " + worldFolder.getAbsolutePath());
        }
        return true;
    }

    private boolean handleKickCommand(Player player, UUID uuid, String[] args) {
        if (args.length != 1) {
            player.sendMessage("Usage: /pc kick <playername>");
            return true;
        }
        if (!player.getWorld().getName().equals("creative_" + uuid.toString())) {
            player.sendMessage("You must be in your own creative world to kick guests.");
            return true;
        }
        Player target = Bukkit.getPlayer(args[0]);
        if (target == null) {
            player.sendMessage("Player '" + args[0] + "' not found or offline.");
            return true;
        }
        if (target.getUniqueId().equals(uuid)) {
            player.sendMessage("You cannot kick yourself from your own creative world.");
            return true;
        }
        if (!target.getWorld().getName().equals("creative_" + uuid.toString())) {
            player.sendMessage("Player '" + target.getName() + "' is not in your creative world.");
            return true;
        }
        UUID targetUUID = target.getUniqueId();
        PlayerData survivalData = this.playerDataMap.get(targetUUID);
        if (survivalData == null) {
            survivalData = this.loadPlayerData(targetUUID);
        }
        target.getActivePotionEffects().forEach(effect -> target.removePotionEffect(effect.getType()));
        if (survivalData == null) {
            World mainWorld = Bukkit.getWorlds().get(0);
            Location spawnLocation = mainWorld.getSpawnLocation();
            target.teleport(spawnLocation);
            target.setGameMode(GameMode.SURVIVAL);
            target.getInventory().clear();
            target.sendMessage("\u00a7cYou have been kicked from " + player.getName() + "'s creative world.");
            target.sendMessage("\u00a77You were teleported to spawn as no survival data was found.");
        } else {
            target.teleport(survivalData.location);
            target.getInventory().setContents(survivalData.inventory);
            target.setGameMode(survivalData.gameMode);
            if (survivalData.effects != null && survivalData.effects.length > 0) {
                PotionEffect[] potionEffectArray = survivalData.effects;
                int n = survivalData.effects.length;
                int n2 = 0;
                while (n2 < n) {
                    PotionEffect effect2 = potionEffectArray[n2];
                    target.addPotionEffect(effect2);
                    ++n2;
                }
                target.sendMessage("\u00a7cYou have been kicked from " + player.getName() + "'s creative world. Your effects have been restored.");
            } else {
                target.sendMessage("\u00a7cYou have been kicked from " + player.getName() + "'s creative world.");
            }
            this.playerDataMap.remove(targetUUID);
            this.deletePlayerDataFile(targetUUID);
        }
        this.pendingTpRequests.remove(targetUUID);
        player.sendMessage("\u00a7aYou have kicked " + target.getName() + " from your creative world.");
        return true;
    }

    private boolean handleReloadCommand(CommandSender sender) {
        Player player;
        if (sender instanceof Player && !(player = (Player)sender).hasPermission("privatecreative.admin") && !player.isOp()) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        sender.sendMessage("\u00a7eReloading PrivateCreative configuration...");
        String senderName = sender instanceof Player ? ((Player)sender).getName() : "Console";
        try {
            this.saveAllPlayerData();
            this.reloadConfig();
            this.TPA_COOLDOWN = this.getConfig().getInt("teleport.cooldown", 10) * 1000;
            this.TPA_TIMEOUT = this.getConfig().getInt("teleport.timeout", 30);
            this.playerDataMap.clear();
            this.pendingTpRequests.clear();
            this.tpaCooldown.clear();
            this.autoKillCreative.clear();
            if (sender instanceof Player) {
                sender.sendMessage("\u00a7aPrivateCreative configuration successfully reloaded!");
            } else {
                this.getLogger().info("PrivateCreative configuration successfully reloaded!");
            }
            this.getLogger().info("PrivateCreative configuration reloaded by " + senderName);
        }
        catch (Exception e) {
            if (sender instanceof Player) {
                sender.sendMessage("\u00a7cError during configuration reload: " + e.getMessage());
            } else {
                this.getLogger().severe("Error during configuration reload: " + e.getMessage());
            }
            e.printStackTrace();
        }
        return true;
    }

    private boolean handleReloadCommand(Player player) {
        return this.handleReloadCommand((CommandSender)player);
    }

    private void saveAllPlayerData() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerData survivalData;
            UUID uuid = player.getUniqueId();
            if (player.getWorld().getName().equals("creative_" + uuid.toString())) {
                PotionEffect[] currentEffects = player.getActivePotionEffects().toArray(new PotionEffect[0]);
                PlayerData creativeData = new PlayerData(player.getLocation(), player.getInventory().getContents(), player.getGameMode(), currentEffects);
                this.saveCreativeData(uuid, creativeData);
            }
            if ((survivalData = this.playerDataMap.get(uuid)) == null) continue;
            this.savePlayerData(uuid, survivalData);
        }
        this.getLogger().info("All player data saved before reload.");
    }

    /*
     * Exception decompiling
     */
    private World getOrCreateCreativeWorld(UUID uuid, String worldType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl45 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl45 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean deleteDirectory(File directory) {
        File[] files;
        if (directory.exists() && (files = directory.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                } else {
                    file.delete();
                }
                ++n2;
            }
        }
        return directory.delete();
    }

    private void openTpRequestGUI(Player target, Player inviter) {
        Inventory gui = Bukkit.createInventory(null, 9, "TP Request from " + inviter.getName());
        ItemStack acceptItem = new ItemStack(Material.GREEN_WOOL);
        ItemMeta acceptMeta = acceptItem.getItemMeta();
        acceptMeta.setDisplayName("\u00a7aAccept");
        acceptMeta.addItemFlags(ItemFlag.HIDE_ATTRIBUTES);
        acceptItem.setItemMeta(acceptMeta);
        gui.setItem(3, acceptItem);
        ItemStack denyItem = new ItemStack(Material.RED_WOOL);
        ItemMeta denyMeta = denyItem.getItemMeta();
        denyMeta.setDisplayName("\u00a7cDecline");
        denyMeta.addItemFlags(ItemFlag.HIDE_ATTRIBUTES);
        denyItem.setItemMeta(denyMeta);
        gui.setItem(5, denyItem);
        target.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String title = event.getView().getTitle();
        if (title.startsWith("TP Request from ")) {
            event.setCancelled(true);
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            Player target = (Player)event.getWhoClicked();
            UUID targetUUID = target.getUniqueId();
            if (!this.pendingTpRequests.containsKey(targetUUID)) {
                target.closeInventory();
                return;
            }
            String inviterName = title.replace("TP Request from ", "");
            Player inviter = Bukkit.getPlayer(inviterName);
            if (inviter == null) {
                target.sendMessage("The inviting player is no longer reachable.");
                this.pendingTpRequests.remove(targetUUID);
                target.closeInventory();
                return;
            }
            if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null) {
                return;
            }
            String itemName = event.getCurrentItem().getItemMeta().getDisplayName();
            if (itemName != null && itemName.contains("Accept")) {
                String creativeWorldName = "creative_" + inviter.getUniqueId().toString();
                if (!inviter.getWorld().getName().equals(creativeWorldName)) {
                    target.sendMessage("The inviting player is currently not in their creative world.");
                } else {
                    if (!target.getWorld().getName().startsWith("creative_")) {
                        PotionEffect[] currentEffects = target.getActivePotionEffects().toArray(new PotionEffect[0]);
                        PlayerData survivalData = new PlayerData(target.getLocation(), target.getInventory().getContents(), target.getGameMode(), currentEffects);
                        this.playerDataMap.put(targetUUID, survivalData);
                        this.savePlayerData(targetUUID, survivalData);
                    }
                    target.getActivePotionEffects().forEach(effect -> target.removePotionEffect(effect.getType()));
                    target.teleport(inviter.getLocation());
                    target.setGameMode(GameMode.CREATIVE);
                    target.sendMessage("You have accepted the invitation from " + inviter.getName() + ". Your survival effects have been saved.");
                    inviter.sendMessage(target.getName() + " has accepted your invitation.");
                }
                this.pendingTpRequests.remove(targetUUID);
                target.closeInventory();
            } else if (itemName != null && itemName.contains("Decline")) {
                target.sendMessage("You have declined the invitation.");
                inviter.sendMessage(target.getName() + " has declined your invitation.");
                this.pendingTpRequests.remove(targetUUID);
                target.closeInventory();
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        String worldName;
        World creativeWorld;
        final Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        this.pendingTpRequests.remove(uuid);
        boolean autoUnloadEnabled = this.getConfig().getBoolean("auto-unload.on-quit", true);
        if (autoUnloadEnabled && (creativeWorld = Bukkit.getWorld(worldName = "creative_" + uuid.toString())) != null && creativeWorld.getPlayers().isEmpty()) {
            final int delay = this.getConfig().getInt("auto-unload.delay", 30);
            new BukkitRunnable(){

                @Override
                public void run() {
                    if (creativeWorld.getPlayers().isEmpty()) {
                        Bukkit.unloadWorld(creativeWorld, true);
                        PrivateCreative.this.getLogger().info("Creative world for " + player.getName() + " was auto-unloaded after " + delay + " seconds.");
                    }
                }
            }.runTaskLater(this, delay * 20);
        }
    }

    private void savePlayerData(UUID uuid, PlayerData data) {
        File file = new File(this.dataFolder, uuid.toString() + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration(file);
        config.set("world", data.location.getWorld().getName());
        config.set("x", data.location.getX());
        config.set("y", data.location.getY());
        config.set("z", data.location.getZ());
        config.set("pitch", Float.valueOf(data.location.getPitch()));
        config.set("yaw", Float.valueOf(data.location.getYaw()));
        config.set("gameMode", data.gameMode.name());
        config.set("inventory", data.inventory);
        config.set("effects", data.effects);
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private PlayerData loadPlayerData(UUID uuid) {
        List<?> effectsList;
        File file = new File(this.dataFolder, uuid.toString() + ".yml");
        if (!file.exists()) {
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration(file);
        World world = Bukkit.getWorld(config.getString("world"));
        if (world == null) {
            return null;
        }
        Location loc = new Location(world, config.getDouble("x"), config.getDouble("y"), config.getDouble("z"), (float)config.getDouble("yaw"), (float)config.getDouble("pitch"));
        GameMode gm = GameMode.valueOf(config.getString("gameMode"));
        ItemStack[] inv = config.getList("inventory").toArray(new ItemStack[0]);
        PotionEffect[] effects = new PotionEffect[]{};
        if (config.contains("effects") && (effectsList = config.getList("effects")) != null) {
            effects = effectsList.toArray(new PotionEffect[0]);
        }
        return new PlayerData(loc, inv, gm, effects);
    }

    private void deletePlayerDataFile(UUID uuid) {
        File file = new File(this.dataFolder, uuid.toString() + ".yml");
        if (file.exists()) {
            file.delete();
        }
    }

    private void saveCreativeData(UUID uuid, PlayerData data) {
        File file = new File(this.creativeDataFolder, uuid.toString() + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration(file);
        config.set("world", data.location.getWorld().getName());
        config.set("x", data.location.getX());
        config.set("y", data.location.getY());
        config.set("z", data.location.getZ());
        config.set("pitch", Float.valueOf(data.location.getPitch()));
        config.set("yaw", Float.valueOf(data.location.getYaw()));
        config.set("gameMode", data.gameMode.name());
        config.set("inventory", data.inventory);
        config.set("effects", data.effects);
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private PlayerData loadCreativeData(UUID uuid) {
        List<?> effectsList;
        File file = new File(this.creativeDataFolder, uuid.toString() + ".yml");
        if (!file.exists()) {
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration(file);
        World world = Bukkit.getWorld(config.getString("world"));
        if (world == null) {
            return null;
        }
        Location loc = new Location(world, config.getDouble("x"), config.getDouble("y"), config.getDouble("z"), (float)config.getDouble("yaw"), (float)config.getDouble("pitch"));
        GameMode gm = GameMode.valueOf(config.getString("gameMode"));
        ItemStack[] inv = config.getList("inventory").toArray(new ItemStack[0]);
        PotionEffect[] effects = new PotionEffect[]{};
        if (config.contains("effects") && (effectsList = config.getList("effects")) != null) {
            effects = effectsList.toArray(new PotionEffect[0]);
        }
        return new PlayerData(loc, inv, gm, effects);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        String worldName = player.getWorld().getName();
        if (!worldName.startsWith("creative_")) {
            return;
        }
        Material blockType = event.getBlock().getType();
        if (blockType == Material.END_PORTAL_FRAME) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cEnd-Portal-Frames k\u00f6nnen in privaten Creative-Welten nicht platziert werden.");
            return;
        }
    }

    @EventHandler
    public void onPortalCreate(PortalCreateEvent event) {
        World world = event.getWorld();
        String worldName = world.getName();
        if (!worldName.startsWith("creative_")) {
            return;
        }
        event.setCancelled(true);
        for (Player player : world.getPlayers()) {
            player.sendMessage("\u00a7cPortale k\u00f6nnen in privaten Creative-Welten nicht erstellt werden.");
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Location clickedLocation;
        Material clickedBlock;
        Player player = event.getPlayer();
        String worldName = player.getWorld().getName();
        if (!worldName.startsWith("creative_")) {
            return;
        }
        ItemStack item = event.getItem();
        if (item != null && (item.getType() == Material.FLINT_AND_STEEL || item.getType() == Material.FIRE_CHARGE) && event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null && (clickedBlock = event.getClickedBlock().getType()) == Material.OBSIDIAN && this.isPartOfPortalStructure(clickedLocation = event.getClickedBlock().getLocation())) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cNether-Portale k\u00f6nnen in privaten Creative-Welten nicht aktiviert werden.");
            return;
        }
    }

    @EventHandler
    public void onPlayerPortal(PlayerPortalEvent event) {
        Player player = event.getPlayer();
        String worldName = player.getWorld().getName();
        if (!worldName.startsWith("creative_")) {
            return;
        }
        event.setCancelled(true);
        player.sendMessage("\u00a7cPortal-Teleportation ist in privaten Creative-Welten nicht erlaubt.");
    }

    private boolean isPartOfPortalStructure(Location location) {
        World world = location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        int obsidianCount = 1;
        int i = 1;
        while (i <= 10) {
            if (world.getBlockAt(x - i, y, z).getType() != Material.OBSIDIAN) break;
            ++obsidianCount;
            ++i;
        }
        i = 1;
        while (i <= 10) {
            if (world.getBlockAt(x + i, y, z).getType() != Material.OBSIDIAN) break;
            ++obsidianCount;
            ++i;
        }
        if (obsidianCount >= 4) {
            return true;
        }
        obsidianCount = 1;
        i = 1;
        while (i <= 10) {
            if (world.getBlockAt(x, y - i, z).getType() != Material.OBSIDIAN) break;
            ++obsidianCount;
            ++i;
        }
        i = 1;
        while (i <= 10) {
            if (world.getBlockAt(x, y + i, z).getType() != Material.OBSIDIAN) break;
            ++obsidianCount;
            ++i;
        }
        return obsidianCount >= 5;
    }

    private static class PlayerData {
        Location location;
        ItemStack[] inventory;
        GameMode gameMode;
        PotionEffect[] effects;

        PlayerData(Location location, ItemStack[] inventory, GameMode gameMode, PotionEffect[] effects) {
            this.location = location;
            this.inventory = inventory;
            this.gameMode = gameMode;
            this.effects = effects;
        }

        PlayerData(Location location, ItemStack[] inventory, GameMode gameMode) {
            this(location, inventory, gameMode, new PotionEffect[0]);
        }
    }
}

