/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.google.common.base.Preconditions;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Tameable;
import org.jetbrains.annotations.NotNull;

public interface Wolf
extends Tameable,
Sittable {
    public boolean isAngry();

    public void setAngry(boolean var1);

    @NotNull
    public DyeColor getCollarColor();

    public void setCollarColor(@NotNull DyeColor var1);

    public boolean isWet();

    public float getTailAngle();

    public boolean isInterested();

    public void setInterested(boolean var1);

    @NotNull
    public Variant getVariant();

    public void setVariant(@NotNull Variant var1);

    public static interface Variant
    extends Keyed {
        public static final Variant PALE = Variant.getVariant("pale");
        public static final Variant SPOTTED = Variant.getVariant("spotted");
        public static final Variant SNOWY = Variant.getVariant("snowy");
        public static final Variant BLACK = Variant.getVariant("black");
        public static final Variant ASHEN = Variant.getVariant("ashen");
        public static final Variant RUSTY = Variant.getVariant("rusty");
        public static final Variant WOODS = Variant.getVariant("woods");
        public static final Variant CHESTNUT = Variant.getVariant("chestnut");
        public static final Variant STRIPED = Variant.getVariant("striped");

        @NotNull
        private static Variant getVariant(@NotNull String key) {
            NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
            Variant variant = Registry.WOLF_VARIANT.get(namespacedKey);
            Preconditions.checkNotNull(variant, "No Wolf Variant found for %s. This is a bug.", (Object)namespacedKey);
            return variant;
        }
    }
}

