/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.entity.client.renderer;

import com.soybeani.config.InitValue;
import com.soybeani.entity.custom.BulletEntity;
import java.awt.Color;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BulletEntityRenderer
extends class_897<BulletEntity> {
    private static final float SIZE = 0.15f;
    private static final Map<BulletEntity.Type, Color> BULLET_COLORS = Map.of(BulletEntity.Type.COPPER, new Color(12088115), BulletEntity.Type.IRON, new Color(0x808080));

    public BulletEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void render(BulletEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.075f, 0.0f);
        class_243 velocity = entity.method_18798();
        float pitch = (float)Math.atan2(velocity.field_1351, Math.sqrt(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-yaw));
        matrices.method_22907(class_7833.field_40718.rotation(pitch));
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23572((class_2960)this.getTexture(entity)));
        Color color = BULLET_COLORS.get((Object)(entity.hasType() ? entity.getBulletType() : BulletEntity.Type.COPPER));
        matrices.method_22905(0.15f, 0.15f, 0.15f);
        this.renderBullet(matrices, vertexConsumer, light, color);
        matrices.method_22909();
        super.method_3936((class_1297)entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    private void renderBullet(class_4587 matrices, class_4588 vertices, int light, Color color) {
        float baseRed = (float)color.getRed() / 255.0f;
        float baseGreen = (float)color.getGreen() / 255.0f;
        float baseBlue = (float)color.getBlue() / 255.0f;
        float shadowRed = Math.max(baseRed * 0.7f, 0.0f);
        float shadowGreen = Math.max(baseGreen * 0.7f, 0.0f);
        float shadowBlue = Math.max(baseBlue * 0.7f, 0.0f);
        float highlightRed = Math.min(baseRed * 1.3f, 1.0f);
        float highlightGreen = Math.min(baseGreen * 1.3f, 1.0f);
        float highlightBlue = Math.min(baseBlue * 1.3f, 1.0f);
        this.renderFace(vertices, matrices, light, shadowRed, shadowGreen, shadowBlue, baseRed, baseGreen, baseBlue, highlightRed, highlightGreen, highlightBlue, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f);
        this.renderFace(vertices, matrices, light, shadowRed, shadowGreen, shadowBlue, baseRed, baseGreen, baseBlue, highlightRed, highlightGreen, highlightBlue, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f);
        this.renderFace(vertices, matrices, light, shadowRed, shadowGreen, shadowBlue, baseRed, baseGreen, baseBlue, highlightRed, highlightGreen, highlightBlue, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f);
        this.renderFace(vertices, matrices, light, shadowRed, shadowGreen, shadowBlue, baseRed, baseGreen, baseBlue, highlightRed, highlightGreen, highlightBlue, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f);
        this.renderFace(vertices, matrices, light, shadowRed, shadowGreen, shadowBlue, baseRed, baseGreen, baseBlue, highlightRed, highlightGreen, highlightBlue, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f);
        this.renderFace(vertices, matrices, light, shadowRed, shadowGreen, shadowBlue, baseRed, baseGreen, baseBlue, highlightRed, highlightGreen, highlightBlue, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f);
    }

    private void renderFace(class_4588 vertices, class_4587 matrices, int light, float shadowRed, float shadowGreen, float shadowBlue, float baseRed, float baseGreen, float baseBlue, float highlightRed, float highlightGreen, float highlightBlue, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.vertex(vertices, matrices, x1, y1, z1, 0.0f, 0.0f, shadowRed, shadowGreen, shadowBlue, light);
        this.vertex(vertices, matrices, x2, y2, z2, 0.5f, 0.0f, baseRed, baseGreen, baseBlue, light);
        this.vertex(vertices, matrices, x3, y3, z3, 1.0f, 1.0f, highlightRed, highlightGreen, highlightBlue, light);
        this.vertex(vertices, matrices, x4, y4, z4, 0.0f, 1.0f, baseRed, baseGreen, baseBlue, light);
    }

    private void vertex(class_4588 vertices, class_4587 matrices, float x, float y, float z, float u, float v, float red, float green, float blue, int light) {
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        Matrix3f matrix3f = matrices.method_23760().method_23762();
        class_4587.class_4665 entry = matrices.method_23760();
        vertices.method_22918(matrix4f, x, y, z).method_22915(red, green, blue, 1.0f).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(light).method_60831(entry, 0.0f, 1.0f, 0.0f);
    }

    public class_2960 getTexture(BulletEntity entity) {
        return InitValue.id("textures/entity/white.png");
    }
}

