/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.entity.custom;

import com.soybeani.config.InitValue;
import com.soybeani.items.ItemsRegister;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class CustomDiceEntity
extends class_1665
implements GeoEntity {
    public static final class_1299<CustomDiceEntity> COPY_DICE_ENTITY_TYPE = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)InitValue.id("copy_dice_entity"), (Object)class_1299.class_1300.method_5903(CustomDiceEntity::new, (class_1311)class_1311.field_17715).method_17687(0.75f, 0.75f).method_55687(0.3375f).method_27299(8).method_27300(1).build());
    public static final class_1299<CustomDiceEntity> EXPLODE_DICE_ENTITY_TYPE = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)InitValue.id("explode_dice_entity"), (Object)class_1299.class_1300.method_5903(CustomDiceEntity::new, (class_1311)class_1311.field_17715).method_17687(0.75f, 0.75f).method_55687(0.3375f).method_27299(8).method_27300(1).build());
    public static final class_1299<CustomDiceEntity> ELEMENTS_DICE_ENTITY_TYPE = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)InitValue.id("elements_dice_entity"), (Object)class_1299.class_1300.method_5903(CustomDiceEntity::new, (class_1311)class_1311.field_17715).method_17687(0.75f, 0.75f).method_55687(0.3375f).method_27299(8).method_27300(1).build());
    private static final int MAX_ROTATION_TIME = 60;
    private boolean isRotating = false;
    private boolean hasTouchedGround = false;
    private int rotationTicks = 0;
    private int finalNumber = 1;
    private static final int HEALING_DURATION = 200;
    private int healingTicks = 0;
    private boolean isHealingActive = false;
    private RawAnimation idleAnimation;
    private RawAnimation[] rotationAnimations;
    private RawAnimation[] finalAnimations;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final class_2940<Integer> DICE_NUMBER = class_2945.method_12791(CustomDiceEntity.class, (class_2941)class_2943.field_13327);

    public CustomDiceEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
        this.initializeAnimations();
        this.setDiceNumber(this.method_37908().field_9229.method_43048(6) + 1);
        this.field_6011.method_12778(DICE_NUMBER, (Object)this.getDiceNumber());
    }

    public CustomDiceEntity(class_1299<? extends class_1665> entityType, class_1937 world, double x, double y, double z, class_1799 stack) {
        super(entityType, x, y, z, world, stack, stack);
        this.initializeAnimations();
        this.setDiceNumber(this.method_37908().field_9229.method_43048(6) + 1);
        this.field_6011.method_12778(DICE_NUMBER, (Object)this.getDiceNumber());
    }

    protected class_1799 method_57314() {
        return ItemsRegister.DICE.method_7854();
    }

    private void initializeAnimations() {
        this.idleAnimation = RawAnimation.begin().then("animation.dice.idle1", Animation.LoopType.LOOP);
        this.rotationAnimations = new RawAnimation[6];
        this.finalAnimations = new RawAnimation[6];
        for (int i = 0; i < 6; ++i) {
            this.rotationAnimations[i] = RawAnimation.begin().then("animation.dice.rotation" + (i + 1), Animation.LoopType.LOOP);
            this.finalAnimations[i] = RawAnimation.begin().then("animation.dice.idle" + (i + 1), Animation.LoopType.LOOP);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private PlayState predicate(AnimationState<GeoAnimatable> animationState) {
        AnimationController controller = animationState.getController();
        if (!this.hasTouchedGround) {
            controller.setAnimation(this.idleAnimation);
        } else if (this.isRotating) {
            controller.setAnimation(this.rotationAnimations[this.getDiceNumber() - 1]);
        } else {
            controller.setAnimation(this.finalAnimations[this.getDiceNumber() - 1]);
        }
        return PlayState.CONTINUE;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DICE_NUMBER, (Object)0);
    }

    private int getDiceNumber() {
        return (Integer)this.method_5841().method_12789(DICE_NUMBER);
    }

    private void setDiceNumber(int number) {
        this.method_5841().method_12778(DICE_NUMBER, (Object)number);
        this.finalNumber = number;
    }

    protected void method_24920(class_3965 blockHitResult) {
        if (!this.hasTouchedGround) {
            this.hasTouchedGround = true;
            this.isRotating = true;
        }
        super.method_24920(blockHitResult);
    }

    public void method_5773() {
        super.method_5773();
        if (this.hasTouchedGround && this.isRotating) {
            ++this.rotationTicks;
            if (this.rotationTicks >= 60) {
                this.isRotating = false;
                if (!this.method_37908().field_9236) {
                    this.triggerDiceEffect(this.getDiceNumber());
                }
            }
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private void triggerDiceEffect(int number) {
        class_2338 pos = this.method_24515();
        class_3218 serverWorld = (class_3218)this.method_37908();
        if (this.method_5864() == EXPLODE_DICE_ENTITY_TYPE) {
            this.createExplosion(pos, number);
            this.method_31472();
        } else if (this.method_5864() == COPY_DICE_ENTITY_TYPE) {
            class_1657 playerEntity;
            class_1799 offHandStack;
            class_1297 owner = this.method_24921();
            if (owner instanceof class_1657 && !(offHandStack = (playerEntity = (class_1657)owner).method_6079()).method_7960()) {
                int needDecrement;
                int count = offHandStack.method_7947();
                int n = needDecrement = count >= 3 ? 3 : 1;
                if (needDecrement == 3) {
                    this.dropCopyStacks(pos, offHandStack, number);
                } else if (number > 3) {
                    this.dropCopyStacks(pos, offHandStack, 2);
                }
                offHandStack.method_7934(needDecrement);
                this.method_31472();
            }
        } else if (this.method_5864() == ELEMENTS_DICE_ENTITY_TYPE) {
            this.generateSphere(serverWorld, pos, switch (number) {
                case 1 -> class_2246.field_10205;
                case 2 -> class_2246.field_10431;
                case 3 -> class_2246.field_10382;
                case 4 -> class_2246.field_10036;
                case 5 -> class_2246.field_10566;
                case 6 -> class_2246.field_10124;
                default -> class_2246.field_10124;
            }, 15);
            this.method_31472();
        }
    }

    private void createExplosion(class_2338 pos, int level) {
        this.method_37908().method_8437((class_1297)this, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (float)(5 * level), class_1937.class_7867.field_40891);
    }

    private void dropCopyStacks(class_2338 pos, class_1799 itemStack, int num) {
        class_5819 random = this.method_37908().field_9229;
        for (int i = 0; i < num; ++i) {
            double offsetX = random.method_43058() * 6.0 - 3.0;
            double offsetZ = random.method_43058() * 6.0 - 3.0;
            class_1799 copy = itemStack.method_7972();
            copy.method_7939(1);
            class_1542 emerald = new class_1542(this.method_37908(), (double)pos.method_10263() + offsetX, (double)(pos.method_10264() + 10), (double)pos.method_10260() + offsetZ, copy);
            emerald.method_18800(0.0, -0.1, 0.0);
            this.method_37908().method_8649((class_1297)emerald);
        }
    }

    private void generateSphere(class_3218 world, class_2338 center, class_2248 block, int radius) {
        int radiusSquared = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + y * y + z * z > radiusSquared) continue;
                    class_2338 targetPos = center.method_10069(x, y, z);
                    if (block == class_2246.field_10382) {
                        world.method_8652(targetPos, block.method_9564(), 3);
                        if ((x + y + z) % 4 == 0) {
                            world.method_8396(null, targetPos, class_3417.field_15237, class_3419.field_15245, 0.5f, 1.0f);
                        }
                        if ((x + y + z) % 8 != 0) continue;
                        world.method_14199((class_2394)class_2398.field_11202, (double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.5, (double)targetPos.method_10260() + 0.5, 1, 0.2, 0.2, 0.2, 0.0);
                        continue;
                    }
                    if (block == class_2246.field_10036) {
                        world.method_8652(targetPos, block.method_9564(), 2);
                        if ((x + y + z) % 4 == 0) {
                            world.method_8396(null, targetPos, class_3417.field_14993, class_3419.field_15245, 0.5f, 1.0f);
                        }
                        if ((x + y + z) % 8 != 0) continue;
                        world.method_14199((class_2394)class_2398.field_11240, (double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.5, (double)targetPos.method_10260() + 0.5, 1, 0.2, 0.2, 0.2, 0.0);
                        continue;
                    }
                    if (block != class_2246.field_10124) {
                        world.method_8652(targetPos, block.method_9564(), 3);
                        if ((x + y + z) % 4 == 0) {
                            world.method_8396(null, targetPos, class_3417.field_14574, class_3419.field_15245, 0.5f, 1.0f);
                        }
                        if ((x + y + z) % 8 != 0) continue;
                        world.method_14199((class_2394)class_2398.field_11203, (double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.5, (double)targetPos.method_10260() + 0.5, 1, 0.2, 0.2, 0.2, 0.0);
                        continue;
                    }
                    world.method_22352(targetPos, false);
                    if ((x + y + z) % 4 == 0) {
                        world.method_8396(null, targetPos, class_3417.field_15026, class_3419.field_15245, 0.5f, 1.0f);
                    }
                    if ((x + y + z) % 8 != 0) continue;
                    world.method_14199((class_2394)class_2398.field_11203, (double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.5, (double)targetPos.method_10260() + 0.5, 1, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
        world.method_43128(null, (double)center.method_10263(), (double)center.method_10264(), (double)center.method_10260(), class_3417.field_14550, class_3419.field_15245, 1.0f, 1.0f);
        world.method_14199((class_2394)class_2398.field_11221, (double)center.method_10263() + 0.5, (double)center.method_10264() + 0.5, (double)center.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("DiceNumber", this.getDiceNumber());
        nbt.method_10556("IsRotating", this.isRotating);
        nbt.method_10556("HasTouchedGround", this.hasTouchedGround);
        nbt.method_10569("RotationTicks", this.rotationTicks);
        nbt.method_10556("IsHealingActive", this.isHealingActive);
        nbt.method_10569("HealingTicks", this.healingTicks);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setDiceNumber(nbt.method_10550("DiceNumber"));
        this.isRotating = nbt.method_10577("IsRotating");
        this.hasTouchedGround = nbt.method_10577("HasTouchedGround");
        this.rotationTicks = nbt.method_10550("RotationTicks");
        this.isHealingActive = nbt.method_10577("IsHealingActive");
        this.healingTicks = nbt.method_10550("HealingTicks");
    }
}

