/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.entity.custom;

import com.soybeani.config.InitValue;
import com.soybeani.items.ItemsRegister;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1542;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class DiceEntity
extends class_1665
implements GeoEntity {
    public static final class_1299<DiceEntity> DICE_ENTITY_TYPE = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)InitValue.id("dice_entity"), (Object)class_1299.class_1300.method_5903(DiceEntity::new, (class_1311)class_1311.field_17715).method_17687(0.75f, 0.75f).method_55687(0.3375f).method_27299(8).method_27300(1).build());
    private static final int MAX_ROTATION_TIME = 60;
    private boolean isRotating = false;
    private boolean hasTouchedGround = false;
    private int rotationTicks = 0;
    private int finalNumber = 1;
    private static final int HEALING_DURATION = 200;
    private int healingTicks = 0;
    private boolean isHealingActive = false;
    private RawAnimation idleAnimation;
    private RawAnimation[] rotationAnimations;
    private RawAnimation[] finalAnimations;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final class_2940<Integer> DICE_NUMBER = class_2945.method_12791(DiceEntity.class, (class_2941)class_2943.field_13327);

    public DiceEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
        this.initializeAnimations();
        this.setDiceNumber(this.method_37908().field_9229.method_43048(6) + 1);
        this.field_6011.method_12778(DICE_NUMBER, (Object)this.getDiceNumber());
    }

    public DiceEntity(class_1937 world, double x, double y, double z, class_1799 stack) {
        super(DICE_ENTITY_TYPE, x, y, z, world, stack, stack);
        this.initializeAnimations();
        this.setDiceNumber(this.method_37908().field_9229.method_43048(6) + 1);
        this.field_6011.method_12778(DICE_NUMBER, (Object)this.getDiceNumber());
    }

    protected class_1799 method_57314() {
        return ItemsRegister.DICE.method_7854();
    }

    private void initializeAnimations() {
        this.idleAnimation = RawAnimation.begin().then("animation.dice.idle1", Animation.LoopType.LOOP);
        this.rotationAnimations = new RawAnimation[6];
        this.finalAnimations = new RawAnimation[6];
        for (int i = 0; i < 6; ++i) {
            this.rotationAnimations[i] = RawAnimation.begin().then("animation.dice.rotation" + (i + 1), Animation.LoopType.LOOP);
            this.finalAnimations[i] = RawAnimation.begin().then("animation.dice.idle" + (i + 1), Animation.LoopType.LOOP);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private PlayState predicate(AnimationState<GeoAnimatable> animationState) {
        AnimationController controller = animationState.getController();
        if (!this.hasTouchedGround) {
            controller.setAnimation(this.idleAnimation);
        } else if (this.isRotating) {
            controller.setAnimation(this.rotationAnimations[this.getDiceNumber() - 1]);
        } else {
            controller.setAnimation(this.finalAnimations[this.getDiceNumber() - 1]);
        }
        return PlayState.CONTINUE;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DICE_NUMBER, (Object)0);
    }

    private int getDiceNumber() {
        return (Integer)this.method_5841().method_12789(DICE_NUMBER);
    }

    private void setDiceNumber(int number) {
        this.method_5841().method_12778(DICE_NUMBER, (Object)number);
        this.finalNumber = number;
    }

    protected void method_24920(class_3965 blockHitResult) {
        if (!this.hasTouchedGround) {
            this.hasTouchedGround = true;
            this.isRotating = true;
        }
        super.method_24920(blockHitResult);
    }

    public void method_5773() {
        super.method_5773();
        if (this.hasTouchedGround && this.isRotating) {
            ++this.rotationTicks;
            if (this.rotationTicks >= 60) {
                this.isRotating = false;
                if (!this.method_37908().field_9236) {
                    this.triggerDiceEffect(this.getDiceNumber());
                }
            }
        }
        if (this.isHealingActive && !this.method_37908().field_9236) {
            this.tickHealing();
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private void tickHealing() {
        if (this.healingTicks >= 200) {
            this.isHealingActive = false;
            this.method_31472();
            return;
        }
        class_2338 pos = this.method_24515();
        class_3218 serverWorld = (class_3218)this.method_37908();
        class_238 box = new class_238(pos).method_1014(30.0);
        for (int i = 0; i < 10; ++i) {
            double x = (double)pos.method_10263() + (this.method_37908().field_9229.method_43058() - 0.5) * 60.0;
            double y = (double)pos.method_10264() + this.method_37908().field_9229.method_43058() * 10.0;
            double z = (double)pos.method_10260() + (this.method_37908().field_9229.method_43058() - 0.5) * 60.0;
            serverWorld.method_14199((class_2394)class_2398.field_11211, x, y, z, 1, 0.1, 0.1, 0.1, 0.0);
        }
        List entities = this.method_37908().method_18467(class_1309.class, box);
        for (class_1309 living : entities) {
            living.method_6025(1.0f);
        }
        ++this.healingTicks;
    }

    private void triggerDiceEffect(int number) {
        class_2338 pos = this.method_24515();
        class_3218 serverWorld = (class_3218)this.method_37908();
        switch (number) {
            case 1: {
                this.createExplosion(pos);
                this.method_31472();
                break;
            }
            case 2: {
                this.dropEmeralds(pos);
                this.method_31472();
                break;
            }
            case 3: {
                this.isHealingActive = true;
                this.healingTicks = 0;
                break;
            }
            case 4: {
                this.spawnRandomEntities(pos);
                this.method_31472();
                break;
            }
            case 5: {
                this.toggleWorldConditions(serverWorld);
                this.method_31472();
                break;
            }
            case 6: {
                this.dropRedEnvelope(pos);
                this.method_31472();
            }
        }
    }

    private void createExplosion(class_2338 pos) {
        this.method_37908().method_8437((class_1297)this, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 8.0f, class_1937.class_7867.field_40891);
    }

    private void dropEmeralds(class_2338 pos) {
        class_5819 random = this.method_37908().field_9229;
        for (int i = 0; i < 64; ++i) {
            double offsetX = random.method_43058() * 6.0 - 3.0;
            double offsetZ = random.method_43058() * 6.0 - 3.0;
            class_1542 emerald = new class_1542(this.method_37908(), (double)pos.method_10263() + offsetX, (double)(pos.method_10264() + 10), (double)pos.method_10260() + offsetZ, new class_1799((class_1935)class_1802.field_8687));
            emerald.method_18800(0.0, -0.1, 0.0);
            this.method_37908().method_8649((class_1297)emerald);
        }
    }

    private void spawnRandomEntities(class_2338 pos) {
        class_5819 random = this.method_37908().field_9229;
        List<class_1299> possibleEntities = Arrays.asList(class_1299.field_6132, class_1299.field_6115, class_1299.field_6085, class_1299.field_6093, class_1299.field_6140, class_1299.field_6055);
        for (int i = 0; i < 20; ++i) {
            double offsetX = random.method_43058() * 10.0 - 5.0;
            double offsetZ = random.method_43058() * 10.0 - 5.0;
            class_1299 entityType = possibleEntities.get(random.method_43048(possibleEntities.size()));
            class_1297 entity = entityType.method_5883(this.method_37908());
            if (entity == null) continue;
            entity.method_5808((double)pos.method_10263() + offsetX, (double)pos.method_10264(), (double)pos.method_10260() + offsetZ, random.method_43057() * 360.0f, 0.0f);
            this.method_37908().method_8649(entity);
        }
    }

    private void toggleWorldConditions(class_3218 serverWorld) {
        class_5819 random = this.method_37908().field_9229;
        boolean changeTime = random.method_43056();
        if (changeTime) {
            long currentTime = serverWorld.method_8532();
            if (currentTime < 13000L) {
                serverWorld.method_29199(18000L);
            } else {
                serverWorld.method_29199(1000L);
            }
        } else if (serverWorld.method_8419()) {
            serverWorld.method_27910(12000, 0, false, false);
        } else {
            serverWorld.method_27910(0, 12000, true, true);
        }
    }

    private void dropRedEnvelope(class_2338 pos) {
        class_5819 random = this.method_37908().field_9229;
        for (int i = 0; i < 8; ++i) {
            double offsetX = random.method_43058() * 6.0 - 3.0;
            double offsetZ = random.method_43058() * 6.0 - 3.0;
            class_1542 diamond = new class_1542(this.method_37908(), (double)pos.method_10263() + offsetX, (double)(pos.method_10264() + 10), (double)pos.method_10260() + offsetZ, new class_1799((class_1935)ItemsRegister.RED_ENVELOPE));
            diamond.method_18800(0.0, -0.1, 0.0);
            this.method_37908().method_8649((class_1297)diamond);
            class_1542 redstone = new class_1542(this.method_37908(), (double)pos.method_10263() + offsetX, (double)(pos.method_10264() + 10), (double)pos.method_10260() + offsetZ, new class_1799((class_1935)ItemsRegister.GREEN_ENVELOPE));
            redstone.method_18800(0.0, -0.1, 0.0);
            this.method_37908().method_8649((class_1297)redstone);
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("DiceNumber", this.getDiceNumber());
        nbt.method_10556("IsRotating", this.isRotating);
        nbt.method_10556("HasTouchedGround", this.hasTouchedGround);
        nbt.method_10569("RotationTicks", this.rotationTicks);
        nbt.method_10556("IsHealingActive", this.isHealingActive);
        nbt.method_10569("HealingTicks", this.healingTicks);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setDiceNumber(nbt.method_10550("DiceNumber"));
        this.isRotating = nbt.method_10577("IsRotating");
        this.hasTouchedGround = nbt.method_10577("HasTouchedGround");
        this.rotationTicks = nbt.method_10550("RotationTicks");
        this.isHealingActive = nbt.method_10577("IsHealingActive");
        this.healingTicks = nbt.method_10550("HealingTicks");
    }
}

