/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.entity.custom;

import com.soybeani.entity.EntityRegister;
import com.soybeani.items.ItemsRegister;
import com.soybeani.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6880;

public class MeteorEntity
extends class_1676 {
    private static final class_2940<Boolean> HAS_IMPACTED = class_2945.method_12791(MeteorEntity.class, (class_2941)class_2943.field_13323);
    private static final Random RANDOM = new Random();
    private int craterRadius = 12;
    private int craterDepth = 6;
    private boolean givesBetterRewards = true;
    private int lifeTime = 0;
    private boolean hasImpacted = false;
    private int impactTimer = 0;
    private static final int MAX_IMPACT_TIME = 40;

    public MeteorEntity(class_1299<? extends class_1676> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5875(false);
    }

    public MeteorEntity(class_1937 world, class_1309 owner) {
        this(EntityRegister.METEOR_ENTITY_TYPE, world);
        this.method_7432((class_1297)owner);
        class_243 lookDirection = owner.method_5720();
        double distance = 30.0;
        double height = 40.0;
        class_243 targetPos = owner.method_19538().method_1019(lookDirection.method_1021(distance));
        this.method_5814(targetPos.field_1352, targetPos.field_1351 + height, targetPos.field_1350);
        class_243 velocity = new class_243(0.0, -1.5, 0.0);
        this.method_18799(velocity);
    }

    public void setMeteorProperties(int radius, int depth, boolean betterRewards) {
        this.craterRadius = radius;
        this.craterDepth = depth;
        this.givesBetterRewards = betterRewards;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(HAS_IMPACTED, (Object)false);
    }

    public void method_5773() {
        class_243 velocity;
        super.method_5773();
        class_239 hitResult = class_1675.method_49997((class_1297)this, x$0 -> this.method_26958((class_1297)x$0));
        boolean hasHit = false;
        if (hitResult.method_17783() != class_239.class_240.field_1333 && !this.hasImpacted) {
            if (hitResult.method_17783() == class_239.class_240.field_1332) {
                this.method_24920((class_3965)hitResult);
                hasHit = true;
            } else if (hitResult.method_17783() == class_239.class_240.field_1331) {
                this.method_7454((class_3966)hitResult);
                hasHit = true;
            }
        }
        if (this.hasImpacted) {
            ++this.impactTimer;
            this.field_6011.method_12778(HAS_IMPACTED, (Object)true);
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                double offsetZ;
                double offsetY;
                double offsetX;
                int i;
                serverWorld = (class_3218)class_19372;
                double x = this.method_23317();
                double y = this.method_23318() + 0.15;
                double z = this.method_23321();
                for (i = 0; i < 10; ++i) {
                    offsetX = RANDOM.nextGaussian() * 0.5;
                    offsetY = RANDOM.nextGaussian() * 0.5;
                    offsetZ = RANDOM.nextGaussian() * 0.5;
                    serverWorld.method_14199((class_2394)class_2398.field_11215, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
                }
                for (i = 0; i < 5; ++i) {
                    offsetX = RANDOM.nextGaussian() * 0.3;
                    offsetY = RANDOM.nextGaussian() * 0.3;
                    offsetZ = RANDOM.nextGaussian() * 0.3;
                    serverWorld.method_14199((class_2394)class_2398.field_11240, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.05);
                    serverWorld.method_14199((class_2394)class_2398.field_11237, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.05);
                }
            }
            if (this.impactTimer % 10 == 0) {
                this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_26980, class_3419.field_15245, 1.0f, 0.5f + RANDOM.nextFloat() * 0.5f);
            }
            if (this.impactTimer >= 40) {
                if (!this.method_37908().field_9236) {
                    this.spawnRandomItem();
                    this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14709, class_3419.field_15245, 1.0f, 1.0f);
                }
                this.method_31472();
            }
            this.method_18799(class_243.field_1353);
        } else {
            class_1937 x = this.method_37908();
            if (x instanceof class_3218) {
                serverWorld = (class_3218)x;
                double x2 = this.method_23317();
                double y = this.method_23318();
                double z = this.method_23321();
                for (int i = 0; i < 3; ++i) {
                    serverWorld.method_14199((class_2394)class_2398.field_11237, x2, y, z, 1, 0.0, 0.0, 0.0, 0.05);
                    serverWorld.method_14199((class_2394)class_2398.field_23956, x2, y, z, 2, 0.2, 0.2, 0.2, 0.01);
                    serverWorld.method_14199((class_2394)class_2398.field_23114, x2, y, z, 1, 0.1, 0.1, 0.1, 0.01);
                }
                serverWorld.method_14199((class_2394)class_2398.field_11240, x2, y, z, 1, 0.0, 0.0, 0.0, 0.05);
            }
            if (!this.method_5740()) {
                velocity = this.method_18798();
                this.method_18800(velocity.field_1352, velocity.field_1351 - 0.05, velocity.field_1350);
            }
        }
        velocity = this.method_18798();
        class_243 newPos = this.method_19538().method_1019(velocity);
        this.method_5814(newPos.field_1352, newPos.field_1351, newPos.field_1350);
        ++this.lifeTime;
        if (this.lifeTime > 600 && !this.hasImpacted) {
            this.method_31472();
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        if (!this.method_37908().field_9236 && !this.hasImpacted) {
            this.onImpact((class_239)blockHitResult);
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        if (!this.method_37908().field_9236 && !this.hasImpacted) {
            this.onImpact((class_239)entityHitResult);
        }
    }

    private void onImpact(class_239 hitResult) {
        if (this.method_37908().field_9236) {
            return;
        }
        this.hasImpacted = true;
        ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11221, this.method_23317(), this.method_23318(), this.method_23321(), 5, 2.0, 0.5, 2.0, 0.1);
        this.createCrater();
        this.method_37908().method_60511(null, this.method_23317(), this.method_23318(), this.method_23321(), (class_6880)class_3417.field_15152, class_3419.field_15245, 1.0f, 0.8f + this.method_37908().field_9229.method_43057() * 0.4f);
        this.method_37908().method_8503().execute(() -> {
            for (int i = 0; i < 50; ++i) {
                ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11215, this.method_23317() + ((double)this.field_5974.method_43057() * 2.0 - 1.0), this.method_23318() + 0.5 + ((double)this.field_5974.method_43057() * 2.0 - 1.0), this.method_23321() + ((double)this.field_5974.method_43057() * 2.0 - 1.0), 1, 0.0, 0.0, 0.0, 0.1);
            }
            this.spawnRandomItem();
        });
    }

    private void createCrater() {
        class_3218 world = (class_3218)this.method_37908();
        class_2338 impactPos = this.method_24515();
        Random random = CommonUtils.getRandom();
        int craterRadius = this.craterRadius;
        int craterDepth = this.craterDepth;
        for (int x = -craterRadius; x <= craterRadius; ++x) {
            for (int z = -craterRadius; z <= craterRadius; ++z) {
                class_2338 magmaPos;
                class_2338 firePos;
                double distance = Math.sqrt(x * x + z * z);
                if (distance > (double)craterRadius) continue;
                double depthFactor = 1.0 - Math.pow(distance / (double)craterRadius, 1.5);
                int depth = (int)((double)craterDepth * depthFactor);
                depth += random.nextInt(3) - random.nextInt(2);
                depth = Math.max(1, depth);
                class_2338 surfacePos = world.method_8598(class_2902.class_2903.field_13202, impactPos.method_10069(x, 0, z));
                for (int y = 0; y < depth; ++y) {
                    class_2338 pos = surfacePos.method_10087(y);
                    class_2680 blockState = world.method_8320(pos);
                    if (blockState.method_26215() || blockState.method_26204() == class_2246.field_9987 || blockState.method_26227().method_15771()) continue;
                    world.method_14199((class_2394)new class_2388(class_2398.field_11217, blockState), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 5, 0.4, 0.4, 0.4, 0.0);
                    if (!((double)random.nextFloat() < 0.9)) continue;
                    world.method_8501(pos, class_2246.field_10124.method_9564());
                }
                if (distance < (double)craterRadius * 0.7 && (double)random.nextFloat() < 0.3 && world.method_8320(firePos = world.method_8598(class_2902.class_2903.field_13202, impactPos.method_10069(x, 0, z))).method_26215() && world.method_8320(firePos.method_10074()).method_26212((class_1922)world, firePos.method_10074())) {
                    world.method_8501(firePos, class_2246.field_10036.method_9564());
                }
                if (!(distance < (double)craterRadius * 0.4) || depth <= 3 || !((double)random.nextFloat() < 0.4) || !world.method_8320((magmaPos = world.method_8598(class_2902.class_2903.field_13202, impactPos.method_10069(x, 0, z)).method_10074()).method_10074()).method_26212((class_1922)world, magmaPos.method_10074())) continue;
                world.method_8501(magmaPos, class_2246.field_10092.method_9564());
            }
        }
        int ejectaRadius = craterRadius + 3;
        for (int x = -ejectaRadius; x <= ejectaRadius; ++x) {
            for (int z = -ejectaRadius; z <= ejectaRadius; ++z) {
                double distance = Math.sqrt(x * x + z * z);
                if (distance < (double)craterRadius || distance > (double)ejectaRadius) continue;
                class_2338 surfacePos = world.method_8598(class_2902.class_2903.field_13202, impactPos.method_10069(x, 0, z));
                if (!((double)random.nextFloat() < 0.4)) continue;
                class_2338 samplePos = impactPos.method_10069(random.nextInt(craterRadius * 2) - craterRadius, -random.nextInt(3), random.nextInt(craterRadius * 2) - craterRadius);
                class_2680 ejectaBlock = world.method_8320(samplePos);
                if (ejectaBlock.method_26215() || ejectaBlock.method_26204() == class_2246.field_9987) {
                    ejectaBlock = class_2246.field_10566.method_9564();
                }
                world.method_8501(surfacePos.method_10084(), ejectaBlock);
                world.method_14199((class_2394)new class_2388(class_2398.field_11217, ejectaBlock), (double)surfacePos.method_10263() + 0.5, (double)surfacePos.method_10264() + 1.5, (double)surfacePos.method_10260() + 0.5, 3, 0.3, 0.3, 0.3, 0.0);
            }
        }
        for (int i = 0; i < 200; ++i) {
            double angle = random.nextDouble() * Math.PI * 2.0;
            double distance = random.nextDouble() * (double)(craterRadius + 8);
            double x = Math.sin(angle) * distance;
            double z = Math.cos(angle) * distance;
            class_2338 debrisPos = world.method_8598(class_2902.class_2903.field_13202, impactPos.method_10069((int)x, 0, (int)z));
            world.method_14199((class_2394)class_2398.field_11237, (double)debrisPos.method_10263() + 0.5, (double)debrisPos.method_10264() + 1.0, (double)debrisPos.method_10260() + 0.5, 1, 0.0, 0.2, 0.0, 0.05);
            if ((double)random.nextFloat() < 0.3) {
                world.method_14199((class_2394)class_2398.field_11215, (double)debrisPos.method_10263() + 0.5, (double)debrisPos.method_10264() + 1.0, (double)debrisPos.method_10260() + 0.5, 2, 0.3, 0.3, 0.3, 0.05);
            }
            if (!(distance < (double)craterRadius * 0.6) || !((double)random.nextFloat() < 0.2)) continue;
            world.method_14199((class_2394)class_2398.field_11223, (double)debrisPos.method_10263() + 0.5, (double)debrisPos.method_10264() + 0.5, (double)debrisPos.method_10260() + 0.5, 1, 0.2, 0.2, 0.2, 0.0);
        }
        world.method_14199((class_2394)class_2398.field_11221, (double)impactPos.method_10263(), (double)(impactPos.method_10264() + 1), (double)impactPos.method_10260(), 10, 3.0, 1.0, 3.0, 0.1);
        world.method_60511(null, (double)impactPos.method_10263(), (double)impactPos.method_10264(), (double)impactPos.method_10260(), (class_6880)class_3417.field_15152, class_3419.field_15245, 2.0f, 0.5f);
        world.method_43128(null, (double)impactPos.method_10263(), (double)impactPos.method_10264(), (double)impactPos.method_10260(), class_3417.field_15236, class_3419.field_15251, 1.0f, 0.5f);
    }

    private void spawnRandomItem() {
        ArrayList<class_1799> possibleRewards = new ArrayList<class_1799>();
        if (this.givesBetterRewards) {
            possibleRewards.add(new class_1799((class_1935)class_1802.field_22022));
            possibleRewards.add(new class_1799((class_1935)class_1802.field_22024));
            possibleRewards.add(new class_1799((class_1935)class_1802.field_22027));
            possibleRewards.add(new class_1799((class_1935)class_1802.field_22028));
            possibleRewards.add(new class_1799((class_1935)class_1802.field_22029));
            possibleRewards.add(new class_1799((class_1935)class_1802.field_22030));
            possibleRewards.add(new class_1799((class_1935)class_1802.field_8367, 3));
            possibleRewards.add(new class_1799((class_1935)class_1802.field_8288));
        } else {
            possibleRewards.add(new class_1799((class_1935)class_1802.field_8802));
            possibleRewards.add(new class_1799((class_1935)class_1802.field_8377));
            possibleRewards.add(new class_1799((class_1935)class_1802.field_8805));
            possibleRewards.add(new class_1799((class_1935)class_1802.field_8058));
            possibleRewards.add(new class_1799((class_1935)class_1802.field_8348));
            possibleRewards.add(new class_1799((class_1935)class_1802.field_8285));
            possibleRewards.add(new class_1799((class_1935)class_1802.field_8463, 2));
            possibleRewards.add(new class_1799((class_1935)class_1802.field_8367));
        }
        possibleRewards.add(new class_1799((class_1935)ItemsRegister.COPPER_SWORD));
        class_1799 reward = (class_1799)possibleRewards.get(RANDOM.nextInt(possibleRewards.size()));
        this.method_37908().method_8649((class_1297)new class_1542(this.method_37908(), this.method_23317(), this.method_23318() + 0.5, this.method_23321(), reward));
    }

    public boolean method_5862() {
        return !this.hasImpacted;
    }

    public boolean hasImpacted() {
        return this.hasImpacted;
    }

    protected void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.lifeTime = nbt.method_10550("LifeTime");
        this.hasImpacted = nbt.method_10577("HasImpacted");
        this.impactTimer = nbt.method_10550("ImpactTimer");
    }

    protected void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("LifeTime", this.lifeTime);
        nbt.method_10556("HasImpacted", this.hasImpacted);
        nbt.method_10569("ImpactTimer", this.impactTimer);
    }
}

