/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.entity.vehicle;

import com.soybeani.entity.EntityRegister;
import com.soybeani.items.ItemsRegister;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class FlyBoatEntity
extends class_1690
implements GeoEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final Integer IN_FLY = 1;
    private static final Integer CONSTANT_FLY = 2;
    private Integer fly = 0;
    private boolean accelerate = false;

    public FlyBoatEntity(class_1299<? extends class_1690> entityType, class_1937 world) {
        super(entityType, world);
    }

    public FlyBoatEntity(class_1937 world, double x, double y, double z) {
        this(EntityRegister.FLY_BOAT, world);
        this.method_5814(x, y, z);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
    }

    public void method_5773() {
        class_243 velocity = this.method_18798();
        class_243 direction = this.method_5720().method_1029();
        float factor = 0.5f;
        if (this.getFly() == IN_FLY) {
            if (this.getAccelerate()) {
                this.method_18800(velocity.field_1352, velocity.field_1351 + (double)factor, velocity.field_1350);
            } else if (velocity.method_10214() < 1.0) {
                this.method_18800(velocity.field_1352, velocity.field_1351 + 0.1, velocity.field_1350);
            }
        } else if (this.getFly() == CONSTANT_FLY) {
            if (this.getAccelerate()) {
                this.method_18800(velocity.field_1352 + direction.field_1352 * (double)factor, this.method_7490(), velocity.field_1350 + direction.field_1350 * (double)factor);
            } else {
                this.method_18800(velocity.field_1352, this.method_7490(), velocity.field_1350);
            }
        } else if (this.getAccelerate()) {
            this.method_18800(velocity.field_1352 + direction.field_1352 * (double)factor, velocity.field_1351, velocity.field_1350 + direction.field_1350 * (double)factor);
        } else {
            this.method_18800(velocity.field_1352, velocity.field_1351, velocity.field_1350);
        }
        super.method_5773();
    }

    public class_1792 method_7557() {
        return ItemsRegister.FLY_BOAT;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Environment(value=EnvType.CLIENT)
    private PlayState predicate(AnimationState<GeoAnimatable> animationState) {
        if (!this.method_37908().method_8608()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("animation.idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        class_310 client = class_310.method_1551();
        class_746 clientPlayer = client.field_1724;
        class_1309 driver = this.method_5642();
        if (driver == null || clientPlayer == null) {
            animationState.getController().setAnimation(RawAnimation.begin().then("animation.idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        boolean pressingForward = client.field_1690.field_1894.method_1434();
        boolean pressingLeft = client.field_1690.field_1913.method_1434();
        boolean pressingRight = client.field_1690.field_1849.method_1434();
        if (this.getFly() == IN_FLY) {
            if (this.getAccelerate()) {
                animationState.getController().setAnimation(RawAnimation.begin().then("animation.accelerate_fly", Animation.LoopType.LOOP));
            } else {
                animationState.getController().setAnimation(RawAnimation.begin().then("animation.fly", Animation.LoopType.LOOP));
            }
        } else if (this.getAccelerate()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("animation.accelerate", Animation.LoopType.LOOP));
        } else if (pressingForward) {
            animationState.getController().setAnimation(RawAnimation.begin().then("animation.move", Animation.LoopType.LOOP));
        } else if (pressingLeft) {
            animationState.getController().setAnimation(RawAnimation.begin().then("animation.turnleft", Animation.LoopType.LOOP));
        } else if (pressingRight) {
            animationState.getController().setAnimation(RawAnimation.begin().then("animation.turnright", Animation.LoopType.LOOP));
        } else {
            animationState.getController().setAnimation(RawAnimation.begin().then("animation.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void SwitchFly() {
        Integer n = this.fly;
        this.fly = this.fly + 1;
        if (this.fly > 2) {
            this.fly = 0;
        }
    }

    public Integer getFly() {
        return this.fly;
    }

    public void setAccelerate(boolean b) {
        this.accelerate = b;
    }

    public boolean getAccelerate() {
        return this.accelerate;
    }
}

