/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.items.ItemsRegister;
import com.soybeani.items.component.ComponentTypeRegister;
import com.soybeani.utils.CommonUtils;
import com.soybeani.utils.RayCastUtils;
import com.soybeani.utils.ServerEachTickTaskManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_9331;
import net.minecraft.class_9679;
import org.joml.Vector3f;

public class BattleShearsItem
extends class_1829 {
    public static final class_9331<Integer> UPGRADE_COUNT = ComponentTypeRegister.COMMON_INTEGER;
    public static final class_9331<Boolean> IS_UPGRADE = ComponentTypeRegister.COMMON_BOOL;
    public static final class_9331<Integer> MODE_KEY = ComponentTypeRegister.COMMON_INTEGER2;
    public static final int MODE_MAX = 2;
    public static final Integer UPGRADE_LEVEL_MAX = 20;

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (!world.method_8608()) {
            int distance;
            class_1297 targetEntity;
            class_1799 stack = player.method_5998(hand);
            int mode = BattleShearsItem.getMode(stack);
            if (mode == 0 && (targetEntity = RayCastUtils.getTargetEntity(world, player, distance = stack.method_7909() == ItemsRegister.BATTLE_SHEARS ? 10 : 20)) instanceof class_1309) {
                class_1309 livingEntity = (class_1309)targetEntity;
                if (stack.method_7909() == ItemsRegister.BATTLE_SHEARS) {
                    if (livingEntity.method_6032() / livingEntity.method_6063() < 1.0f) {
                        livingEntity.method_5643(player.method_48923().method_48830(), 4.0f);
                        this.spawnRedAndOrangeParticle((class_3218)world, livingEntity);
                        this.playerSoundAndDamageStack(player, stack, 1, hand);
                        player.method_7357().method_7906((class_1792)this, 20);
                        if (livingEntity.method_29504()) {
                            int newLevel = BattleShearsItem.getUpgradeCount(stack) + 1;
                            BattleShearsItem.setUpgradeCount(stack, newLevel);
                            if (newLevel >= UPGRADE_LEVEL_MAX) {
                                int selectedSlot = player.method_31548().field_7545;
                                class_1799 upGradeStack = stack.method_56701((class_1935)ItemsRegister.BATTLE_SHEARS_UP, 1);
                                player.method_31548().method_5447(selectedSlot, upGradeStack);
                                player.method_37908().method_8396(null, player.method_24515(), class_3417.field_14709, class_3419.field_15245, 1.0f, 1.0f);
                            }
                        }
                        return class_1271.method_22427((Object)stack);
                    }
                } else {
                    livingEntity.method_5643(player.method_48923().method_48830(), 6.0f);
                    this.spawnRedAndOrangeParticle((class_3218)world, livingEntity);
                    this.playerSoundAndDamageStack(player, stack, 1, hand);
                    return class_1271.method_22427((Object)stack);
                }
            }
            if (stack.method_7909() == ItemsRegister.BATTLE_SHEARS_UP) {
                if (mode == 1) {
                    class_243 playerPos = player.method_33571();
                    class_243 lookDir = player.method_5828(1.0f);
                    class_243 rightVector = lookDir.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029().method_1021(5.0);
                    class_243 leftVector = rightVector.method_22882();
                    class_243 rightStart = playerPos.method_1019(rightVector);
                    class_243 leftStart = playerPos.method_1019(leftVector);
                    class_243 targetPos = playerPos.method_1019(lookDir.method_1021(20.0));
                    int[] tickCounter = new int[]{0};
                    ArrayList hitEntities = new ArrayList();
                    HashMap middleHitEntities = new HashMap();
                    boolean[] hasIntersected = new boolean[]{false};
                    double[] lastDistance = new double[]{10.0};
                    ServerEachTickTaskManager.scheduleTask("scissor_line_" + String.valueOf(UUID.randomUUID()), 60, 1, () -> {
                        float progress = (float)tickCounter[0] / 20.0f;
                        class_243 currentRightPos = rightStart.method_1019(rightVector.method_1021((double)(-progress)).method_1019(lookDir.method_1021((double)(progress * 20.0f))));
                        class_243 currentLeftPos = leftStart.method_1019(leftVector.method_1021((double)(-progress)).method_1019(lookDir.method_1021((double)(progress * 20.0f))));
                        class_243 rightEnd = currentRightPos.method_1019(lookDir.method_1021(5.0));
                        class_243 leftEnd = currentLeftPos.method_1019(lookDir.method_1021(5.0));
                        class_243 middlePoint = currentRightPos.method_1019(currentLeftPos).method_1021(0.5);
                        double distanceBetweenScissors = currentRightPos.method_1022(currentLeftPos);
                        if (!hasIntersected[0] && lastDistance[0] > 2.0 && distanceBetweenScissors <= 2.0) {
                            world.method_43128(null, middlePoint.field_1352, middlePoint.field_1351, middlePoint.field_1350, class_3417.field_14833, class_3419.field_15248, 0.6f, 2.0f);
                            world.method_43128(null, middlePoint.field_1352, middlePoint.field_1351, middlePoint.field_1350, class_3417.field_14959, class_3419.field_15248, 0.4f, 1.8f);
                            hasIntersected[0] = true;
                        }
                        lastDistance[0] = distanceBetweenScissors;
                        this.spawnLineParticles((class_3218)world, currentRightPos, rightEnd, 10);
                        this.spawnLineParticles((class_3218)world, currentLeftPos, leftEnd, 10);
                        ArrayList<class_1309> rightHits = new ArrayList<class_1309>();
                        ArrayList<class_1309> leftHits = new ArrayList<class_1309>();
                        this.checkLineCollision((class_3218)world, player, currentRightPos, rightEnd, hitEntities, rightHits);
                        this.checkLineCollision((class_3218)world, player, currentLeftPos, leftEnd, hitEntities, leftHits);
                        for (class_1309 entity2 : rightHits) {
                            if (!leftHits.contains(entity2)) continue;
                            entity2.method_5643(player.method_48923().method_48830(), 16.0f);
                            this.spawnCriticalHitParticles((class_3218)world, entity2);
                            middleHitEntities.put(entity2, true);
                            world.method_43128(null, entity2.method_23317(), entity2.method_23318(), entity2.method_23321(), class_3417.field_15016, class_3419.field_15248, 1.0f, 1.0f);
                        }
                        if ((double)progress > 0.5 && distanceBetweenScissors < 3.0) {
                            for (int i = 0; i < 15; ++i) {
                                double offsetX = (world.field_9229.method_43058() - 0.5) * distanceBetweenScissors;
                                double offsetY = (world.field_9229.method_43058() - 0.5) * distanceBetweenScissors;
                                double offsetZ = (world.field_9229.method_43058() - 0.5) * distanceBetweenScissors;
                                ((class_3218)world).method_14199((class_2394)new class_2390(new Vector3f(1.0f, 0.15686275f, 0.0f), 1.2f), middlePoint.field_1352 + offsetX, middlePoint.field_1351 + offsetY, middlePoint.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                            class_238 middleBox = new class_238(middlePoint.field_1352 - distanceBetweenScissors / 2.0, middlePoint.field_1351 - distanceBetweenScissors / 2.0, middlePoint.field_1350 - distanceBetweenScissors / 2.0, middlePoint.field_1352 + distanceBetweenScissors / 2.0, middlePoint.field_1351 + distanceBetweenScissors / 2.0, middlePoint.field_1350 + distanceBetweenScissors / 2.0);
                            List middleEntities = world.method_8390(class_1309.class, middleBox, entity -> entity != player && !middleHitEntities.containsKey(entity));
                            for (class_1309 entity3 : middleEntities) {
                                entity3.method_5643(player.method_48923().method_48830(), 18.0f);
                                this.spawnCriticalHitParticles((class_3218)world, entity3);
                                hitEntities.add(entity3);
                                middleHitEntities.put(entity3, true);
                                world.method_43128(null, entity3.method_23317(), entity3.method_23318(), entity3.method_23321(), class_3417.field_14840, class_3419.field_15248, 1.0f, 0.8f);
                            }
                        }
                        tickCounter[0] = tickCounter[0] + 1;
                    });
                    this.playerSoundAndDamageStack(player, stack, 5, hand);
                    return class_1271.method_22427((Object)stack);
                }
                if (mode == 2) {
                    class_243 pos = player.method_19538();
                    List entities = world.method_8390(class_1309.class, new class_238(pos.method_10216() - 10.0, pos.method_10214() - 10.0, pos.method_10215() - 10.0, pos.method_10216() + 10.0, pos.method_10214() + 10.0, pos.method_10215() + 10.0), nearbyEntity -> nearbyEntity != player);
                    int damageAmount = 0;
                    for (class_1309 target : entities) {
                        this.spawnRedAndOrangeParticle((class_3218)world, target);
                        target.method_5643(player.method_48923().method_48830(), 6.0f);
                        ++damageAmount;
                    }
                    this.playerSoundAndDamageStack(player, stack, damageAmount, hand);
                    return class_1271.method_22427((Object)stack);
                }
            }
        }
        return super.method_7836(world, player, hand);
    }

    public void playerSoundAndDamageStack(class_1657 player, class_1799 stack, int damageAmount, class_1268 hand) {
        player.method_37908().method_8396(null, player.method_24515(), class_3417.field_14975, class_3419.field_15245, 1.0f, 1.0f);
        String handName = hand.name() == class_1268.field_5808.name() ? "mainhand" : "offhand";
        stack.method_7970(damageAmount, (class_1309)player, class_1304.method_5924((String)handName));
    }

    public void spawnRedAndOrangeParticle(class_3218 world, class_1309 livingEntity) {
        CommonUtils.spawnSelfParticle(world, (class_1297)livingEntity, (class_9679)new class_2390(new Vector3f(0.7764706f, 0.0f, 0.08627451f), 1.0f));
        CommonUtils.spawnSelfParticle(world, (class_1297)livingEntity, (class_9679)new class_2390(new Vector3f(0.9411765f, 0.5568628f, 0.03176471f), 1.0f));
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if (!BattleShearsItem.isUpgrade(stack)) {
            tooltip.add((class_2561)class_2561.method_43470((String)("\u89c9\u9192\u8fdb\u5ea6:" + BattleShearsItem.getUpgradeCount(stack) + "/" + UPGRADE_LEVEL_MAX)));
        }
        super.method_7851(stack, context, tooltip, type);
    }

    public static String getMode2String(int mode) {
        Object sayString = "\u5f53\u524d\u6a21\u5f0f: ";
        switch (mode) {
            case 0: {
                sayString = (String)sayString + "\u88c1\u526a";
                break;
            }
            case 1: {
                sayString = (String)sayString + "\u526a\u7ebf";
                break;
            }
            case 2: {
                sayString = (String)sayString + "\u7206\u526a";
                break;
            }
            default: {
                sayString = "\u51fa\u9519\u4e86\uff01\uff01\uff01";
            }
        }
        return sayString;
    }

    private void spawnLineParticles(class_3218 world, class_243 start, class_243 end, int count) {
        class_243 direction = end.method_1020(start);
        double length = direction.method_1033();
        direction = direction.method_1029();
        for (int i = 0; i < count; ++i) {
            double progress = (double)i / (double)count;
            class_243 particlePos = start.method_1019(direction.method_1021(progress * length));
            float size = 0.7f + (float)(Math.sin(progress * Math.PI) * (double)0.3f);
            if (i % 2 == 0) {
                world.method_14199((class_2394)new class_2390(new Vector3f(0.7764706f, 0.0f, 0.08627451f), size), particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.02, 0.02, 0.02, 0.0);
                continue;
            }
            world.method_14199((class_2394)new class_2390(new Vector3f(0.9411765f, 0.5568628f, 0.03176471f), size), particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.02, 0.02, 0.02, 0.0);
        }
    }

    private void checkLineCollision(class_3218 world, class_1657 player, class_243 start, class_243 end, List<class_1309> hitEntities) {
        class_243 direction = end.method_1020(start);
        double length = direction.method_1033();
        direction = direction.method_1029();
        for (double d = 0.0; d <= length; d += 0.3) {
            class_243 checkPos = start.method_1019(direction.method_1021(d));
            class_238 checkBox = new class_238(checkPos.field_1352 - 0.8, checkPos.field_1351 - 0.8, checkPos.field_1350 - 0.8, checkPos.field_1352 + 0.8, checkPos.field_1351 + 0.8, checkPos.field_1350 + 0.8);
            List entities = world.method_8390(class_1309.class, checkBox, entity -> entity != player && !hitEntities.contains(entity));
            for (class_1309 entity2 : entities) {
                if (hitEntities.contains(entity2)) continue;
                entity2.method_5643(player.method_48923().method_48830(), 8.0f);
                this.spawnHitParticles(world, entity2);
                hitEntities.add(entity2);
            }
        }
    }

    private void spawnHitParticles(class_3218 world, class_1309 entity) {
        this.spawnRedAndOrangeParticle(world, entity);
        class_243 pos = entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0);
        for (int i = 0; i < 15; ++i) {
            double offsetX = (world.field_9229.method_43058() - 0.5) * 2.0;
            double offsetY = (world.field_9229.method_43058() - 0.5) * 2.0;
            double offsetZ = (world.field_9229.method_43058() - 0.5) * 2.0;
            world.method_14199((class_2394)new class_2390(new Vector3f(0.7764706f, 0.0f, 0.08627451f), 0.6f), pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.05);
            world.method_14199((class_2394)new class_2390(new Vector3f(0.9411765f, 0.5568628f, 0.03176471f), 0.6f), pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.05);
        }
    }

    private void checkLineCollision(class_3218 world, class_1657 player, class_243 start, class_243 end, List<class_1309> globalHitEntities, List<class_1309> currentHitEntities) {
        class_243 direction = end.method_1020(start);
        double length = direction.method_1033();
        direction = direction.method_1029();
        for (double d = 0.0; d <= length; d += 0.3) {
            class_243 checkPos = start.method_1019(direction.method_1021(d));
            class_238 checkBox = new class_238(checkPos.field_1352 - 0.8, checkPos.field_1351 - 0.8, checkPos.field_1350 - 0.8, checkPos.field_1352 + 0.8, checkPos.field_1351 + 0.8, checkPos.field_1350 + 0.8);
            List entities = world.method_8390(class_1309.class, checkBox, entity -> entity != player && !globalHitEntities.contains(entity));
            for (class_1309 entity2 : entities) {
                if (globalHitEntities.contains(entity2)) continue;
                entity2.method_5643(player.method_48923().method_48830(), 8.0f);
                this.spawnHitParticles(world, entity2);
                globalHitEntities.add(entity2);
                currentHitEntities.add(entity2);
            }
        }
    }

    private void spawnCriticalHitParticles(class_3218 world, class_1309 entity) {
        class_243 pos = entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0);
        for (int i = 0; i < 30; ++i) {
            double offsetX = (world.field_9229.method_43058() - 0.5) * 2.0;
            double offsetY = (world.field_9229.method_43058() - 0.5) * 2.0;
            double offsetZ = (world.field_9229.method_43058() - 0.5) * 2.0;
            world.method_14199((class_2394)new class_2390(new Vector3f(1.0f, 0.84313726f, 0.0f), 0.8f), pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
            world.method_14199((class_2394)new class_2390(new Vector3f(1.0f, 0.0f, 0.0f), 0.7f), pos.field_1352 + offsetX * 1.2, pos.field_1351 + offsetY * 1.2, pos.field_1350 + offsetZ * 1.2, 1, 0.0, 0.0, 0.0, 0.1);
        }
        this.spawnRedAndOrangeParticle(world, entity);
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return ingredient.method_7909() == class_1802.field_8183 || ingredient.method_7909() == class_1802.field_8135;
    }

    public BattleShearsItem(class_1792.class_1793 settings) {
        super((class_1832)class_1834.field_8930, settings);
    }

    public static int getUpgradeCount(class_1799 stack) {
        return (Integer)stack.method_57824(UPGRADE_COUNT);
    }

    public static void setUpgradeCount(class_1799 stack, int count) {
        stack.method_57379(UPGRADE_COUNT, (Object)count);
    }

    public static boolean isUpgrade(class_1799 stack) {
        return (Boolean)stack.method_57824(IS_UPGRADE);
    }

    public static void setUpgrade(class_1799 stack, boolean isUpgrade) {
        stack.method_57379(IS_UPGRADE, (Object)isUpgrade);
    }

    public static int getMode(class_1799 stack) {
        return (Integer)stack.method_57824(MODE_KEY);
    }

    public static void setMode(class_1799 stack, int mode) {
        stack.method_57379(MODE_KEY, (Object)mode);
    }

    public static int switchMode(class_1799 stack) {
        int mode = BattleShearsItem.getMode(stack);
        if (++mode > 2) {
            mode = 0;
        }
        BattleShearsItem.setMode(stack, mode);
        return mode;
    }
}

