/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import java.util.HashSet;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3965;

public class CustomAxeItem
extends class_1743 {
    private Type type;

    public CustomAxeItem(class_1832 toolMaterial, class_1792.class_1793 settings, Type type) {
        super(toolMaterial, settings);
        this.type = type;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (world.method_8608()) {
            return super.method_7836(world, player, hand);
        }
        class_239 hitResult = player.method_5745(30.0, 0.0f, true);
        if (hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            class_2338 targetPos = blockHitResult.method_17777();
            if (this.getType() == Type.DOUBLE && !player.method_7337()) {
                player.method_5643(world.method_48963().method_48830(), 2.0f);
            }
            double dirX = player.method_5720().field_1352;
            double dirY = player.method_5720().field_1351;
            double dirZ = player.method_5720().field_1350;
            double startX = hitResult.method_17784().field_1352;
            double startY = hitResult.method_17784().field_1351;
            double startZ = hitResult.method_17784().field_1350;
            switch (this.getType().ordinal()) {
                case 0: {
                    this.createTunnel(world, startX, startY, startZ, dirX, dirY, dirZ, 3, 30, 30, block -> block.method_26227().method_15767(class_3486.field_15517));
                    break;
                }
                case 1: {
                    this.createTunnel(world, startX, startY, startZ, dirX, dirY, dirZ, 3, 30, 30, block -> block.method_26227().method_15767(class_3486.field_15518));
                    break;
                }
                case 2: {
                    this.createTunnel(world, startX, startY, startZ, dirX, dirY, dirZ, 3, 30, 30, block -> !block.method_26215() && block.method_51367());
                    break;
                }
                case 3: {
                    this.spawnChickenAtBlock(world, targetPos);
                }
            }
            return class_1271.method_22427((Object)player.method_5998(hand));
        }
        return super.method_7836(world, player, hand);
    }

    private void createTunnel(class_1937 world, double startX, double startY, double startZ, double dirX, double dirY, double dirZ, int width, int length, int height, Predicate<class_2680> predicate) {
        double uz;
        double uy;
        double ux;
        double rz;
        double ry;
        double rx;
        double mag = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        dirX /= mag;
        dirY /= mag;
        dirZ /= mag;
        if (Math.abs(dirY) < 0.999) {
            double upX = 0.0;
            double upY = 1.0;
            double upZ = 0.0;
            rx = dirY * upZ - dirZ * upY;
            ry = dirZ * upX - dirX * upZ;
            rz = dirX * upY - dirY * upX;
            rmag = Math.sqrt(rx * rx + ry * ry + rz * rz);
            ux = (ry /= rmag) * dirZ - (rz /= rmag) * dirY;
            uy = rz * dirX - (rx /= rmag) * dirZ;
            uz = rx * dirY - ry * dirX;
        } else {
            double northX = 0.0;
            double northY = 0.0;
            double northZ = 1.0;
            rx = dirY * northZ - dirZ * northY;
            ry = dirZ * northX - dirX * northZ;
            rz = dirX * northY - dirY * northX;
            rmag = Math.sqrt(rx * rx + ry * ry + rz * rz);
            ux = (ry /= rmag) * dirZ - (rz /= rmag) * dirY;
            uy = rz * dirX - (rx /= rmag) * dirZ;
            uz = rx * dirY - ry * dirX;
        }
        double halfWidth = (double)width / 2.0;
        double halfHeight = (double)height / 2.0;
        HashSet<class_2338> processedBlocks = new HashSet<class_2338>();
        for (int l = 0; l < length; ++l) {
            double posX = startX + (double)l * dirX;
            double posY = startY + (double)l * dirY;
            double posZ = startZ + (double)l * dirZ;
            for (double w = -halfWidth; w <= halfWidth; w += 0.5) {
                for (double h = -halfHeight; h <= halfHeight; h += 0.5) {
                    class_2680 state;
                    double x = posX + w * rx + h * ux;
                    double y = posY + w * ry + h * uy;
                    double z = posZ + w * rz + h * uz;
                    class_2338 pos = new class_2338((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
                    if (!processedBlocks.add(pos) || !world.method_22340(pos) || !predicate.test(state = world.method_8320(pos))) continue;
                    world.method_8396(null, pos, state.method_26231().method_10595(), class_3419.field_15245, 0.5f, 1.0f);
                    if (world instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)world;
                        serverWorld.method_14199((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 5, 0.2, 0.2, 0.2, 0.1);
                    }
                    world.method_8501(pos, class_2246.field_10124.method_9564());
                }
            }
        }
    }

    private void spawnChickenAtBlock(class_1937 world, class_2338 pos) {
        class_1428 chicken = new class_1428(class_1299.field_6132, world);
        chicken.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5);
        world.method_8649((class_1297)chicken);
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        boolean result = super.method_7879(stack, world, state, pos, miner);
        if (!world.method_8608()) {
            switch (this.getType().ordinal()) {
                case 3: {
                    this.spawnChickenAtBlock(world, pos);
                    break;
                }
                case 4: {
                    class_1657 player;
                    if (!(miner instanceof class_1657) || (player = (class_1657)miner).method_7337()) break;
                    float hardness = state.method_26214((class_1922)world, pos);
                    float damage = Math.max(0.5f, Math.min(hardness, 4.0f));
                    player.method_5643(world.method_48963().method_48830(), damage);
                }
            }
        }
        return result;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        class_1657 player;
        boolean result = super.method_7873(stack, target, attacker);
        if (!target.method_37908().method_8608() && this.getType() == Type.DOUBLE && attacker instanceof class_1657 && !(player = (class_1657)attacker).method_7337()) {
            player.method_5643(target.method_37908().method_48963().method_48830(), 4.0f);
        }
        return result;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        WATER,
        LAVA,
        MOUNTAIN,
        CHICKEN,
        DOUBLE;

    }
}

