/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.utils.DelayedTaskManager;
import com.soybeani.utils.ServerEachTickTaskManager;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4770;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public class FlintAndCustomItem
extends class_1792 {
    public Type type;

    public FlintAndCustomItem(class_1792.class_1793 settings, Type type) {
        super(settings.method_7895(128));
        this.type = type;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 playerEntity = context.method_8036();
        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_2680 blockState = world.method_8320(blockPos);
        class_2338 blockPos2 = blockPos.method_10093(context.method_8038());
        world.method_8396(playerEntity, blockPos2, class_3417.field_15145, class_3419.field_15245, 1.0f, world.method_8409().method_43057() * 0.4f + 0.8f);
        switch (this.type.ordinal()) {
            case 0: {
                class_2680 waterState = class_2246.field_10382.method_9564();
                world.method_8501(blockPos2, waterState);
                break;
            }
            case 1: {
                class_2350 playerDirection = playerEntity.method_5735();
                this.createWaterWall(world, blockPos2, playerDirection, 20, 20);
                String taskId = "super_water_" + blockPos2.method_10263() + "_" + blockPos2.method_10264() + "_" + blockPos2.method_10260();
                DelayedTaskManager.scheduleTask(taskId, 100, () -> this.removeWaterWall(world, blockPos2, playerDirection, 20, 20));
                break;
            }
            case 4: {
                class_2350 playerDirection = playerEntity.method_5735();
                this.createStonePlatform(world, blockPos2, playerDirection, 3, 3);
                break;
            }
            case 5: {
                class_2350 playerDirection = playerEntity.method_5735();
                String taskId = "super_land_" + blockPos2.method_10263() + "_" + blockPos2.method_10264() + "_" + blockPos2.method_10260();
                int[] currentHeight = new int[]{0};
                int maxHeight = 20;
                ServerEachTickTaskManager.scheduleTask(taskId, -1, 5, () -> {
                    if (currentHeight[0] < 20) {
                        this.createStoneLayer(world, blockPos2, playerDirection, 20, currentHeight[0]);
                        currentHeight[0] = currentHeight[0] + 1;
                    } else {
                        DelayedTaskManager.scheduleTask("remove_" + taskId, 200, () -> this.removeStoneWall(world, blockPos2, playerDirection, 20, 20));
                    }
                });
                break;
            }
            case 2: {
                class_2680 fireState = class_4770.method_24416((class_1922)world, (class_2338)blockPos2);
                int radius = 5;
                int startZ = blockPos2.method_10260() - radius / 2;
                int startX = blockPos2.method_10263() - radius / 2;
                for (int i = 0; i < radius; ++i) {
                    for (int j = 0; j < radius; ++j) {
                        world.method_8501(new class_2338(startX + i, blockPos2.method_10264(), startZ + j), fireState);
                    }
                }
                this.spawnFireParticles(world, blockPos2, 5, 10);
                this.damageNearbyEntities(world, blockPos2, 5.0f, 3.0f);
                break;
            }
            case 3: {
                class_2338 center = blockPos2.method_10074();
                int radius = 20;
                String taskId = "super_fire_" + center.method_10263() + "_" + center.method_10264() + "_" + center.method_10260();
                ServerEachTickTaskManager.scheduleTask(taskId, 600, 5, () -> {
                    for (int i = 0; i < 10; ++i) {
                        class_2338 randomPos = center.method_10069(world.method_8409().method_43048(radius * 2) - radius, -world.method_8409().method_43048(5), world.method_8409().method_43048(radius * 2) - radius);
                        if (!world.method_8320(randomPos).method_45474()) continue;
                        world.method_8501(randomPos, class_2246.field_10164.method_9564());
                    }
                    for (int j = 0; j < 10; ++j) {
                        for (int i = 0; i < 30; ++i) {
                            class_2338 particlePos = center.method_10069(world.method_8409().method_43048(radius * 2) - radius, j, world.method_8409().method_43048(radius * 2) - radius);
                            this.spawnFireParticle(world, particlePos);
                        }
                    }
                    this.damageNearbyEntities(world, center, 15.0f, 2.0f);
                });
                break;
            }
            default: {
                class_2680 fireState = class_4770.method_24416((class_1922)world, (class_2338)blockPos2);
                world.method_8501(blockPos2, fireState);
            }
        }
        world.method_33596((class_1297)playerEntity, (class_6880)class_5712.field_28164, blockPos);
        class_1799 itemStack = context.method_8041();
        if (playerEntity instanceof class_3222) {
            class_174.field_1191.method_23889((class_3222)playerEntity, blockPos2, itemStack);
            itemStack.method_7970(1, (class_1309)playerEntity, class_1309.method_56079((class_1268)context.method_20287()));
        }
        return class_1269.method_29236((boolean)world.method_8608());
    }

    private void createWaterWall(class_1937 world, class_2338 center, class_2350 direction, int width, int height) {
        class_2680 waterState = class_2246.field_10382.method_9564();
        if (direction == class_2350.field_11043 || direction == class_2350.field_11035) {
            int startX = center.method_10263() - width / 2;
            int endX = startX + width;
            int y = center.method_10264();
            int z = center.method_10260();
            for (int x = startX; x < endX; ++x) {
                for (int h = 0; h < height; ++h) {
                    world.method_8501(new class_2338(x, y + h, z), waterState);
                }
            }
        } else {
            int startZ = center.method_10260() - width / 2;
            int endZ = startZ + width;
            int y = center.method_10264();
            int x = center.method_10263();
            for (int z = startZ; z < endZ; ++z) {
                for (int h = 0; h < height; ++h) {
                    world.method_8501(new class_2338(x, y + h, z), waterState);
                }
            }
        }
    }

    private void removeWaterWall(class_1937 world, class_2338 center, class_2350 direction, int width, int height) {
        class_2680 airState = class_2246.field_10124.method_9564();
        if (direction == class_2350.field_11043 || direction == class_2350.field_11035) {
            int startX = center.method_10263() - width / 2;
            int endX = startX + width;
            int y = center.method_10264();
            int z = center.method_10260();
            for (int x = startX; x < endX; ++x) {
                for (int h = 0; h < height; ++h) {
                    class_2338 pos = new class_2338(x, y + h, z);
                    if (world.method_8320(pos).method_26204() != class_2246.field_10382) continue;
                    world.method_8501(pos, airState);
                }
            }
        } else {
            int startZ = center.method_10260() - width / 2;
            int endZ = startZ + width;
            int y = center.method_10264();
            int x = center.method_10263();
            for (int z = startZ; z < endZ; ++z) {
                for (int h = 0; h < height; ++h) {
                    class_2338 pos = new class_2338(x, y + h, z);
                    if (world.method_8320(pos).method_26204() != class_2246.field_10382) continue;
                    world.method_8501(pos, airState);
                }
            }
        }
    }

    private void createStonePlatform(class_1937 world, class_2338 center, class_2350 direction, int width, int height) {
        class_2680 stoneState = class_2246.field_10340.method_9564();
        int startX = center.method_10263() - width / 2;
        int startZ = center.method_10260() - height / 2;
        if (direction == class_2350.field_11043 || direction == class_2350.field_11035) {
            int endX = startX + width;
            int y = center.method_10264();
            int z = center.method_10260();
            for (int x = startX; x < endX; ++x) {
                for (int h = 0; h < height; ++h) {
                    world.method_8501(new class_2338(x, y + h, z), stoneState);
                }
            }
        } else {
            int endZ = startZ + width;
            int y = center.method_10264();
            int x = center.method_10263();
            for (int z = startZ; z < endZ; ++z) {
                for (int h = 0; h < height; ++h) {
                    world.method_8501(new class_2338(x, y + h, z), stoneState);
                }
            }
        }
    }

    private void createStoneLayer(class_1937 world, class_2338 center, class_2350 direction, int width, int height) {
        class_2680 stoneState = class_2246.field_10340.method_9564();
        if (direction == class_2350.field_11043 || direction == class_2350.field_11035) {
            int startX = center.method_10263() - width / 2;
            int endX = startX + width;
            int y = center.method_10264() + height;
            int z = center.method_10260();
            for (int x = startX; x < endX; ++x) {
                world.method_8501(new class_2338(x, y, z), stoneState);
            }
        } else {
            int startZ = center.method_10260() - width / 2;
            int endZ = startZ + width;
            int y = center.method_10264() + height;
            int x = center.method_10263();
            for (int z = startZ; z < endZ; ++z) {
                world.method_8501(new class_2338(x, y, z), stoneState);
            }
        }
    }

    private void removeStoneWall(class_1937 world, class_2338 center, class_2350 direction, int width, int height) {
        class_2680 airState = class_2246.field_10124.method_9564();
        if (direction == class_2350.field_11043 || direction == class_2350.field_11035) {
            int startX = center.method_10263() - width / 2;
            int endX = startX + width;
            int startY = center.method_10264();
            int z = center.method_10260();
            for (int x = startX; x < endX; ++x) {
                for (int h = 0; h < height; ++h) {
                    class_2338 pos = new class_2338(x, startY + h, z);
                    if (world.method_8320(pos).method_26204() != class_2246.field_10340) continue;
                    world.method_8501(pos, airState);
                }
            }
        } else {
            int startZ = center.method_10260() - width / 2;
            int endZ = startZ + width;
            int startY = center.method_10264();
            int x = center.method_10263();
            for (int z = startZ; z < endZ; ++z) {
                for (int h = 0; h < height; ++h) {
                    class_2338 pos = new class_2338(x, startY + h, z);
                    if (world.method_8320(pos).method_26204() != class_2246.field_10340) continue;
                    world.method_8501(pos, airState);
                }
            }
        }
    }

    private void spawnFireParticles(class_1937 world, class_2338 center, int radius, int count) {
        if (world.method_8608()) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            class_2338 particlePos = center.method_10069(world.method_8409().method_43048(radius * 2) - radius, world.method_8409().method_43048(radius), world.method_8409().method_43048(radius * 2) - radius);
            this.spawnFireParticle(world, particlePos);
        }
    }

    private void spawnFireParticle(class_1937 world, class_2338 pos) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199((class_2394)class_2398.field_11240, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 1, 0.2, 0.2, 0.2, 0.05);
        }
    }

    private void damageNearbyEntities(class_1937 world, class_2338 center, float radius, float damage) {
        if (world.method_8608()) {
            return;
        }
        class_238 box = new class_238((double)((float)center.method_10263() - radius), (double)((float)center.method_10264() - radius), (double)((float)center.method_10260() - radius), (double)((float)center.method_10263() + radius), (double)((float)center.method_10264() + radius), (double)((float)center.method_10260() + radius));
        List entities = world.method_18467(class_1309.class, box);
        for (class_1309 entity : entities) {
            entity.method_5643(world.method_48963().method_48794(), damage);
        }
    }

    public static enum Type {
        WATER,
        SUPER_WATER,
        FIRE,
        SUPER_FIRE,
        LAND,
        SUPER_LAND;

    }
}

