/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.entity.client.renderer.GargoyleMaskRenderer;
import com.soybeani.items.component.ComponentTypeRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_572;
import net.minecraft.class_9331;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GargoyleMaskItem
extends class_1738
implements GeoItem {
    private static final String CONTROLLER_NAME = "Activation";
    private static final String BLINK_ANIMATION_NAME = "blink";
    private static final String IDLE_ANIMATION_NAME = "idle";
    private static final RawAnimation BLINK_ANIMATION = RawAnimation.begin().thenPlay("blink");
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenPlay("idle");
    private static final int TICK_INTERVAL = 20;
    private int tickCounter = 0;
    private static final class_9331<Boolean> PETRIFIED_KEY = ComponentTypeRegister.COMMON_BOOL;
    private static Map<UUID, List<class_2338>> storage_stone_map = new HashMap<UUID, List<class_2338>>();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GargoyleMaskItem(class_1792.class_1793 settings) {
        super(class_1740.field_7892, class_1738.class_8051.field_41934, settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1309 livingEntity;
        class_1799 equippedStack;
        if (world.field_9236) {
            return;
        }
        if (entity instanceof class_1309 && (equippedStack = (livingEntity = (class_1309)entity).method_6118(class_1304.field_6169)).method_31574((class_1792)this)) {
            class_239 hitResult;
            class_239.class_240 type;
            boolean isPetrified = GargoyleMaskItem.getPetrified(equippedStack);
            if (isPetrified && (type = (hitResult = livingEntity.method_5745(100.0, 0.0f, true)).method_17783()) == class_239.class_240.field_1332) {
                class_3965 blockHitResult = (class_3965)hitResult;
                class_2350 side = blockHitResult.method_17780();
                class_2338 targetPos = blockHitResult.method_17777().method_10093(side);
                class_2680 blockState = world.method_8320(targetPos);
                if (blockState.method_26215()) {
                    world.method_8501(targetPos, class_2246.field_10340.method_9564());
                    List storage_block_list = storage_stone_map.getOrDefault(livingEntity.method_5667(), new ArrayList());
                    storage_block_list.add(targetPos);
                    storage_stone_map.put(livingEntity.method_5667(), storage_block_list);
                }
            }
            if (this.tickCounter > 20) {
                livingEntity.method_6092(new class_1293(class_1294.field_5904, 200, 3));
                livingEntity.method_6092(new class_1293(class_1294.field_5924, 200, 3));
                livingEntity.method_6092(new class_1293(class_1294.field_5910, 200, 3));
                if (!world.method_8419() && !world.method_23886()) {
                    boolean hasBlockAbove = false;
                    for (int i = 1; i <= 10; ++i) {
                        class_2338 checkPos = livingEntity.method_24515().method_10086(i);
                        if (world.method_8320(checkPos).method_26215()) continue;
                        hasBlockAbove = true;
                        break;
                    }
                    if (!hasBlockAbove) {
                        livingEntity.method_5643(livingEntity.method_48923().method_48830(), 8.0f);
                    }
                }
                if (isPetrified) {
                    equippedStack.method_7970(1, livingEntity, class_1304.field_6169);
                }
                this.tickCounter = 0;
            }
            ++this.tickCounter;
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    public static void setPetrified(class_1799 itemStack, boolean b) {
        itemStack.method_57379(PETRIFIED_KEY, (Object)b);
    }

    public static boolean getPetrified(class_1799 itemStack) {
        return (Boolean)itemStack.method_57824(PETRIFIED_KEY);
    }

    public static void fireStone(class_1309 livingEntity) {
        class_1937 world = livingEntity.method_37908();
        if (world.method_8608()) {
            return;
        }
        List<class_2338> blockPosList = storage_stone_map.get(livingEntity.method_5667());
        for (class_2338 pos : blockPosList) {
            class_2680 blockState = world.method_8320(pos);
            if (blockState.method_26204() != class_2246.field_10340) continue;
            world.method_22352(pos, false);
            world.method_8501(pos, (class_2680)((class_2680)class_2246.field_10036.method_9595().method_11664()).method_11657((class_2769)class_2358.field_11092, (Comparable)Integer.valueOf(0)));
        }
        storage_stone_map.remove(livingEntity.method_5667());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, 0, state -> {
            class_1297 entity = (class_1297)state.getData(DataTickets.ENTITY);
            if (!(entity instanceof class_1309)) {
                return PlayState.CONTINUE;
            }
            class_1309 livingEntity = (class_1309)entity;
            class_1799 helmetStack = livingEntity.method_6118(class_1304.field_6169);
            if (helmetStack.method_7960() || !(helmetStack.method_7909() instanceof GargoyleMaskItem)) {
                return PlayState.STOP;
            }
            boolean petrified = GargoyleMaskItem.getPetrified(helmetStack);
            if (petrified) {
                state.getController().setAnimation(BLINK_ANIMATION);
            } else {
                state.getController().setAnimation(IDLE_ANIMATION);
            }
            return PlayState.CONTINUE;
        }));
    }

    private void ExecuteAnimation(class_1309 entity, String animationName) {
        if (!entity.method_37908().method_8608()) {
            class_3218 serverWorld = (class_3218)entity.method_37908();
            this.triggerAnim((class_1297)entity, GeoItem.getOrAssignId((class_1799)entity.method_6118(class_1304.field_6169), (class_3218)serverWorld), CONTROLLER_NAME, animationName);
        }
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private GeoArmorRenderer<?> renderer;

            public <T extends class_1309> class_572<?> getGeoArmorRenderer(T livingEntity, class_1799 itemStack, class_1304 equipmentSlot, class_572<T> original) {
                if (this.renderer == null) {
                    this.renderer = new GargoyleMaskRenderer();
                }
                return this.renderer;
            }
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

