/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.entity.client.renderer.GatlingRenderer;
import com.soybeani.entity.custom.BulletEntity;
import com.soybeani.items.ItemsRegister;
import com.soybeani.items.item.BulletItem;
import com.soybeani.sound.SoundRegister;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1744;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_756;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.RenderUtil;

public class GatlingItem
extends class_1811
implements GeoItem {
    private static final RawAnimation ACTIVATE_SHOOT = RawAnimation.begin().then("shoot", Animation.LoopType.LOOP);
    private static final RawAnimation ACTIVATE_IDLE = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
    private boolean isShooting = false;
    private static final int SHOOT_INTERVAL = 5;
    private int shootCooldown = 0;
    private static final int SOUND_DURATION = 16;
    private int soundTimer = 0;
    private boolean isSoundPlaying = false;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final Predicate<class_1799> BULLET_PROJECTILES = stack -> stack.method_7909() instanceof BulletItem || stack.method_31573(class_3489.field_18317);
    public static final int RANGE = 100;

    public GatlingItem(class_1792.class_1793 settings) {
        super(settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public Predicate<class_1799> method_19268() {
        return BULLET_PROJECTILES;
    }

    public int method_24792() {
        return 100;
    }

    protected void method_7763(class_1309 shooter, class_1676 projectile, int index, float speed, float divergence, float yaw, @Nullable class_1309 target) {
        projectile.method_24919((class_1297)shooter, shooter.method_36455(), shooter.method_36454(), 0.0f, speed, divergence);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private PlayState predicate(AnimationState<GeoItem> animationState) {
        if (!this.isShooting) {
            animationState.getController().setAnimation(ACTIVATE_IDLE);
        } else {
            animationState.getController().setAnimation(ACTIVATE_SHOOT);
        }
        return PlayState.CONTINUE;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_6115() && player.method_6030() == stack) {
                this.isShooting = true;
                if (!world.field_9236 && this.shootCooldown <= 0) {
                    this.shootArrow(world, player, stack);
                    if (!this.isSoundPlaying) {
                        world.method_8396(null, player.method_24515(), SoundRegister.GATLING_GUN, class_3419.field_15248, 0.5f, 1.0f);
                        this.isSoundPlaying = true;
                        this.soundTimer = 16;
                    }
                    this.shootCooldown = 5;
                }
            } else {
                this.isShooting = false;
                this.isSoundPlaying = false;
                this.soundTimer = 0;
            }
            if (this.shootCooldown > 0) {
                --this.shootCooldown;
            }
            if (this.isSoundPlaying) {
                if (this.soundTimer > 0) {
                    --this.soundTimer;
                } else {
                    this.isSoundPlaying = false;
                }
            }
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    private void shootArrow(class_1937 world, class_1657 player, class_1799 weaponStack) {
        class_1799 bulletStack = player.method_18808(weaponStack);
        if (!bulletStack.method_7960() && !world.field_9236) {
            class_1792 class_17922 = bulletStack.method_7909();
            if (class_17922 instanceof BulletItem) {
                BulletItem bulletItem = (BulletItem)class_17922;
                type = bulletItem == ItemsRegister.COPPER_BULLET ? BulletEntity.Type.COPPER : BulletEntity.Type.IRON;
                bulletItem.setType((BulletEntity.Type)((Object)type));
                class_1665 projectile = bulletItem.createBullet(world, bulletStack, (class_1309)player, bulletStack);
                projectile.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 5.0f, world.field_9229.method_43057());
                projectile.method_5875(true);
                projectile.method_7432((class_1297)player);
                projectile.method_7438(projectile.method_7448() * 1.5);
                world.method_8649((class_1297)projectile);
                if (!player.method_31549().field_7477) {
                    bulletStack.method_7934(1);
                    if (bulletStack.method_7960()) {
                        player.method_31548().method_7378(bulletStack);
                    }
                }
                player.method_7259(class_3468.field_15372.method_14956((Object)this));
            } else {
                type = bulletStack.method_7909();
                if (type instanceof class_1744) {
                    class_1744 arrowItem = (class_1744)type;
                    class_1665 projectile = arrowItem.method_7702(world, bulletStack, (class_1309)player, bulletStack);
                    projectile.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 3.0f, world.field_9229.method_43057());
                    projectile.method_7439(true);
                    projectile.method_7432((class_1297)player);
                    projectile.method_7438(projectile.method_7448() * 1.5);
                    world.method_8649((class_1297)projectile);
                    world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, 1.0f / (world.method_8409().method_43057() * 0.4f + 1.2f));
                    if (!player.method_31549().field_7477) {
                        bulletStack.method_7934(1);
                        if (bulletStack.method_7960()) {
                            player.method_31548().method_7378(bulletStack);
                        }
                    }
                    player.method_7259(class_3468.field_15372.method_14956((Object)this));
                }
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        boolean bl;
        class_1799 itemStack = player.method_5998(hand);
        boolean bl2 = bl = !player.method_18808(itemStack).method_7960();
        if (!player.method_56992() && !bl) {
            return class_1271.method_22431((Object)itemStack);
        }
        player.method_6019(hand);
        return class_1271.method_22428((Object)itemStack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        this.isShooting = false;
        super.method_7840(stack, world, user, remainingUseTicks);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object itemStack) {
        return RenderUtil.getCurrentTick();
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private GatlingRenderer renderer;

            @Nullable
            public class_756 getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new GatlingRenderer();
                }
                return this.renderer;
            }
        });
    }
}

