/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.entity.client.renderer.HotWaterRenderer;
import com.soybeani.items.component.ComponentTypeRegister;
import com.soybeani.utils.CommonUtils;
import com.soybeani.utils.ServerEachTickTaskManager;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_756;
import net.minecraft.class_9331;
import net.minecraft.class_9679;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HotWaterItem
extends class_1792
implements GeoItem {
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenPlay("idle");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static class_9331<Integer> STORE = ComponentTypeRegister.COMMON_INTEGER;
    public static final int MIN_DRAW_DURATION = 10;

    public HotWaterItem(class_1792.class_1793 settings) {
        super(settings.method_57349(STORE, (Object)1));
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_3965 blockHitResult;
        class_2338 pos;
        class_2680 blockState;
        class_1799 itemStack = player.method_5998(hand);
        player.method_6019(hand);
        class_239 hitResult = player.method_5745(6.0, 0.0f, true);
        if (hitResult instanceof class_3965 && ((blockState = world.method_8320(pos = (blockHitResult = (class_3965)hitResult).method_17777())).method_26204() == class_2246.field_10382 || blockState.method_26204() == class_2246.field_27097)) {
            int storeWater = HotWaterItem.getStoreWater(itemStack);
            HotWaterItem.setStoreWater(itemStack, storeWater + 1);
            world.method_8396(null, player.method_24515(), class_3417.field_15126, class_3419.field_15248, 1.0f, 1.0f);
        }
        return class_1271.method_22428((Object)itemStack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 playerEntity = (class_1657)user;
        int useDuration = this.method_7881(stack, user) - remainingUseTicks;
        if (useDuration < 10) {
            return;
        }
        int storeWater = HotWaterItem.getStoreWater(stack);
        if (!world.field_9236 && storeWater > 0) {
            int baseColor = 3776472;
            class_3218 serverWorld = (class_3218)world;
            class_239 raycast = user.method_5745(100.0, 0.0f, false);
            world.method_8396(null, user.method_24515(), class_3417.field_14737, class_3419.field_15248, 1.0f, 1.0f);
            HotWaterItem.setStoreWater(stack, storeWater - 1);
            for (int i = 0; i < 20; ++i) {
                class_2390 dustParticleEffect = new class_2390(CommonUtils.hexToColorV3f(baseColor + 65793 * i), 0.5f + (float)CommonUtils.getRandom().nextGaussian());
                double dx = CommonUtils.getRandom().nextGaussian();
                double dy = CommonUtils.getRandom().nextGaussian();
                int dStep = CommonUtils.getRandom().nextInt(0, 11);
                this.spawnParticlesArc(serverWorld, user, user.method_19538(), raycast.method_17784().method_1031(-0.5 + dx, 0.0, -0.5 + dy), 20 + dStep, (class_9679)dustParticleEffect);
            }
        }
    }

    public static int getStoreWater(class_1799 itemStack) {
        return (Integer)itemStack.method_57824(STORE);
    }

    public static void setStoreWater(class_1799 itemStack, int value) {
        if (value > 2) {
            return;
        }
        itemStack.method_57379(STORE, (Object)value);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Activation", 0, state -> PlayState.STOP).triggerableAnim("idle", IDLE_ANIMATION));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            HotWaterRenderer hotWaterRenderer = null;

            public class_756 getGeoItemRenderer() {
                if (this.hotWaterRenderer == null) {
                    this.hotWaterRenderer = new HotWaterRenderer();
                }
                return this.hotWaterRenderer;
            }
        });
    }

    public void spawnParticlesArc(class_3218 world, class_1309 livingEntity, class_243 start, class_243 end, int steps, class_9679 particleEffect) {
        String taskId = "spawnParticlesArc" + String.valueOf(UUID.randomUUID());
        Integer stepTick = 0;
        ServerEachTickTaskManager.addSaveValue(taskId, stepTick);
        double maxHeight = Math.max(2.0, start.method_1022(end) * 0.5);
        HashSet damagedEntities = new HashSet();
        ServerEachTickTaskManager.addSaveValue(taskId + "_damaged", damagedEntities);
        ServerEachTickTaskManager.scheduleTask(taskId, steps, 1, () -> {
            Object saveValue = ServerEachTickTaskManager.getSaveValue(taskId);
            if (saveValue == null) {
                return;
            }
            int stepTime = (Integer)saveValue;
            if (stepTime >= steps) {
                return;
            }
            HashSet<UUID> damaged = (HashSet<UUID>)ServerEachTickTaskManager.getSaveValue(taskId + "_damaged");
            if (damaged == null) {
                damaged = new HashSet<UUID>();
                ServerEachTickTaskManager.addSaveValue(taskId + "_damaged", damaged);
            }
            double progress = (double)stepTime / (double)steps;
            double x = start.field_1352 + (end.field_1352 - start.field_1352) * progress;
            double z = start.field_1350 + (end.field_1350 - start.field_1350) * progress;
            double y = start.field_1351 + (end.field_1351 - start.field_1351) * progress + 4.0 * maxHeight * (progress - progress * progress);
            double spread = 0.05 * progress;
            int particleCount = (int)(1.0 + progress * 3.0);
            world.method_14199((class_2394)particleEffect, x, y, z, particleCount, spread, 0.02, spread, 0.0);
            double damageRadius = 0.5;
            class_238 damageBox = new class_238(x - damageRadius, y - damageRadius, z - damageRadius, x + damageRadius, y + damageRadius, z + damageRadius);
            List nearbyEntities = world.method_8390(class_1309.class, damageBox, entity -> entity instanceof class_1309 && entity != livingEntity);
            for (class_1297 entity2 : nearbyEntities) {
                if (!(entity2 instanceof class_1309) || damaged.contains(entity2.method_5667())) continue;
                entity2.method_5643(world.method_48963().method_48831(), 105.0f);
                damaged.add(entity2.method_5667());
                ServerEachTickTaskManager.addSaveValue(taskId + "_damaged", damaged);
            }
            if (progress > 0.8) {
                double splashIntensity = (progress - 0.8) * 5.0;
                double splashRadius = 0.3 * splashIntensity;
                int splashParticles = (int)(5.0 * splashIntensity);
                for (int i = 0; i < splashParticles; ++i) {
                    double angle = Math.random() * Math.PI * 2.0;
                    double distance = Math.random() * splashRadius;
                    double splashX = end.field_1352 + Math.cos(angle) * distance;
                    double splashZ = end.field_1350 + Math.sin(angle) * distance;
                    double splashY = end.field_1351 + 0.1;
                    world.method_14199((class_2394)particleEffect, splashX, splashY, splashZ, 1, 0.02, 0.02, 0.02, 0.01);
                    class_238 splashDamageBox = new class_238(splashX - damageRadius, splashY - damageRadius, splashZ - damageRadius, splashX + damageRadius, splashY + damageRadius, splashZ + damageRadius);
                    List splashEntities = world.method_8390(class_1309.class, splashDamageBox, entity -> entity instanceof class_1309 && entity != livingEntity);
                    for (class_1297 entity3 : splashEntities) {
                        if (!(entity3 instanceof class_1309) || damaged.contains(entity3.method_5667())) continue;
                        entity3.method_5643(world.method_48963().method_48831(), 105.0f);
                        damaged.add(entity3.method_5667());
                        ServerEachTickTaskManager.addSaveValue(taskId + "_damaged", damaged);
                    }
                }
            }
            ServerEachTickTaskManager.addSaveValue(taskId, stepTime + 1);
        });
    }
}

