/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.items.item;

import com.soybeani.entity.custom.PurpleLightningEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3965;
import net.minecraft.class_5538;

public class NirvanaSpyglassItem
extends class_5538 {
    private boolean openLightning = false;
    private static final int GENERAL_MODE = 1;
    private static final int LINEAR_MODE = 2;
    private static final int STRAIGHT_MODE = 3;
    private static final int CROSS_MODE = 4;
    private static final int RECTANGLE_MODE = 5;
    private static final int CIRCLE_MODE = 6;
    private int spyglassMode = 1;
    public static final int LEVEL_MAX = 6;

    public NirvanaSpyglassItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public void lookLightning(class_1657 player, int mode) {
        if (!this.openLightning) {
            return;
        }
        class_3965 hitResult = (class_3965)player.method_5745(300.0, 0.0f, true);
        class_2338 blockPos = hitResult.method_17777();
        class_1937 world = player.method_37908();
        PurpleLightningEntity lightning = new PurpleLightningEntity(PurpleLightningEntity.PURPLE_LIGHTNING, world);
        int spacing = 2;
        class_243 lookDir = player.method_5720();
        class_243 perpendicular = lookDir.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
        class_243 direction = player.method_5720().method_1029();
        class_243 playerPos = player.method_19538();
        int lightningCount = 5;
        switch (mode) {
            case 1: {
                lightning.method_5814(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
                world.method_8649((class_1297)lightning);
                break;
            }
            case 2: {
                lightning.method_5814(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
                world.method_8649((class_1297)lightning);
                for (int i = 1; i <= lightningCount; ++i) {
                    class_2338 rightPos = NirvanaSpyglassItem.getOffsetPosition(blockPos, perpendicular, spacing * i);
                    PurpleLightningEntity rightLightning = new PurpleLightningEntity(PurpleLightningEntity.PURPLE_LIGHTNING, world);
                    rightLightning.method_5814(rightPos.method_10263(), rightPos.method_10264(), rightPos.method_10260());
                    world.method_8649((class_1297)rightLightning);
                    class_2338 leftPos = NirvanaSpyglassItem.getOffsetPosition(blockPos, perpendicular, -spacing * i);
                    PurpleLightningEntity leftLightning = new PurpleLightningEntity(PurpleLightningEntity.PURPLE_LIGHTNING, world);
                    leftLightning.method_5814(leftPos.method_10263(), leftPos.method_10264(), leftPos.method_10260());
                    world.method_8649((class_1297)leftLightning);
                }
                break;
            }
            case 3: {
                int count = (int)Math.sqrt(Math.pow(playerPos.field_1352 - (double)blockPos.method_10263(), 2.0) + Math.pow(playerPos.field_1350 - (double)blockPos.method_10260(), 2.0));
                double startDistance = 5.0;
                for (int i = 0; i < count; ++i) {
                    double distance = startDistance + (double)(i * spacing);
                    class_243 lightningPos = playerPos.method_1031(direction.field_1352 * distance, direction.field_1351 * distance, direction.field_1350 * distance);
                    lightning = new PurpleLightningEntity(PurpleLightningEntity.PURPLE_LIGHTNING, world);
                    lightning.method_5814(lightningPos.method_10216(), lightningPos.method_10214(), lightningPos.method_10215());
                    world.method_8649((class_1297)lightning);
                }
                break;
            }
            case 4: {
                lightning.method_5814(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
                world.method_8649((class_1297)lightning);
                for (int i = 1; i <= lightningCount * 2; ++i) {
                    class_2338 frontPos = NirvanaSpyglassItem.getOffsetPosition(blockPos, player.method_5720().method_1029(), spacing * i);
                    PurpleLightningEntity frontLightning = new PurpleLightningEntity(PurpleLightningEntity.PURPLE_LIGHTNING, world);
                    frontLightning.method_5814(frontPos.method_10263(), frontPos.method_10264(), frontPos.method_10260());
                    world.method_8649((class_1297)frontLightning);
                    class_2338 backPos = NirvanaSpyglassItem.getOffsetPosition(blockPos, player.method_5720().method_1029(), -spacing * i);
                    PurpleLightningEntity backLightning = new PurpleLightningEntity(PurpleLightningEntity.PURPLE_LIGHTNING, world);
                    backLightning.method_5814(backPos.method_10263(), backPos.method_10264(), backPos.method_10260());
                    world.method_8649((class_1297)backLightning);
                    class_2338 rightPos = NirvanaSpyglassItem.getOffsetPosition(blockPos, perpendicular, spacing * i);
                    PurpleLightningEntity rightLightning = new PurpleLightningEntity(PurpleLightningEntity.PURPLE_LIGHTNING, world);
                    rightLightning.method_5814(rightPos.method_10263(), rightPos.method_10264(), rightPos.method_10260());
                    world.method_8649((class_1297)rightLightning);
                    class_2338 leftPos = NirvanaSpyglassItem.getOffsetPosition(blockPos, perpendicular, -spacing * i);
                    PurpleLightningEntity leftLightning = new PurpleLightningEntity(PurpleLightningEntity.PURPLE_LIGHTNING, world);
                    leftLightning.method_5814(leftPos.method_10263(), leftPos.method_10264(), leftPos.method_10260());
                    world.method_8649((class_1297)leftLightning);
                }
                break;
            }
            case 5: {
                double sideLength = 20.0;
                class_243 topLeft = playerPos.method_1031(-sideLength / 2.0, 0.0, -sideLength / 2.0);
                class_243 topRight = playerPos.method_1031(sideLength / 2.0, 0.0, -sideLength / 2.0);
                class_243 bottomLeft = playerPos.method_1031(-sideLength / 2.0, 0.0, sideLength / 2.0);
                class_243 bottomRight = playerPos.method_1031(sideLength / 2.0, 0.0, sideLength / 2.0);
                this.generateLightningOnLine(topLeft, topRight, world);
                this.generateLightningOnLine(topRight, bottomRight, world);
                this.generateLightningOnLine(bottomRight, bottomLeft, world);
                this.generateLightningOnLine(bottomLeft, topLeft, world);
                break;
            }
            case 6: {
                double radius = Math.sqrt(Math.pow((double)blockPos.method_10263() - playerPos.field_1352, 2.0) + Math.pow((double)blockPos.method_10260() - playerPos.field_1350, 2.0));
                double circumference = Math.PI * 2 * radius;
                int lightningNum = (int)Math.ceil(circumference / 2.0);
                for (int i = 0; i < lightningNum; ++i) {
                    double angle = (double)(i * 2) * Math.PI / (double)lightningNum;
                    double x = playerPos.field_1352 + radius * Math.cos(angle);
                    double z = playerPos.field_1350 + radius * Math.sin(angle);
                    lightning = new PurpleLightningEntity(PurpleLightningEntity.PURPLE_LIGHTNING, world);
                    lightning.method_5814(x, playerPos.field_1351, z);
                    world.method_8649((class_1297)lightning);
                }
                break;
            }
        }
    }

    public static String getModeName(int num) {
        switch (num) {
            case 1: {
                return "\u666e\u901a\u6a21\u5f0f";
            }
            case 2: {
                return "\u6392\u884c\u6a21\u5f0f";
            }
            case 3: {
                return "\u8def\u5f84\u6a21\u5f0f";
            }
            case 4: {
                return "\u5341\u5b57\u6a21\u5f0f";
            }
            case 5: {
                return "\u77e9\u5f62\u6a21\u5f0f";
            }
            case 6: {
                return "\u5706\u5f62\u6a21\u5f0f";
            }
        }
        return "Unknown Mode";
    }

    private static class_2338 getOffsetPosition(class_2338 original, class_243 direction, double distance) {
        return new class_2338((int)((long)original.method_10263() + Math.round(direction.field_1352 * distance)), original.method_10264(), (int)((long)original.method_10260() + Math.round(direction.field_1350 * distance)));
    }

    private void generateLightningOnLine(class_243 start, class_243 end, class_1937 world) {
        double distance = start.method_1022(end);
        int lightningCount = (int)Math.ceil(distance / 2.0);
        for (int i = 0; i < lightningCount; ++i) {
            double t = (double)i / (double)lightningCount;
            class_243 pos = start.method_35590(end, t);
            PurpleLightningEntity lightning = new PurpleLightningEntity(PurpleLightningEntity.PURPLE_LIGHTNING, world);
            lightning.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
            world.method_8649((class_1297)lightning);
        }
    }

    public void setSpyglassMode(int spyglassMode) {
        this.spyglassMode = spyglassMode;
    }

    public int getSpyglassMode() {
        return this.spyglassMode;
    }

    public void setOpenLightning(boolean b) {
        this.openLightning = b;
    }

    public boolean getOpenLightning() {
        return this.openLightning;
    }
}

