/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.utils;

import com.soybeani.utils.ServerEachTickTaskManager;
import java.util.UUID;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_9679;

public class ParticlesEffectUtils {
    public static void spawnParticlesArc(class_3218 world, class_243 start, class_243 end, int steps, class_9679 particleEffect) {
        String taskId = "spawnParticlesArc" + String.valueOf(UUID.randomUUID());
        Integer stepTick = 0;
        ServerEachTickTaskManager.addSaveValue(taskId, stepTick);
        double maxHeight = Math.max(2.0, start.method_1022(end) * 0.5);
        ServerEachTickTaskManager.scheduleTask(taskId, steps, 1, () -> {
            Object saveValue = ServerEachTickTaskManager.getSaveValue(taskId);
            if (saveValue == null) {
                return;
            }
            int stepTime = (Integer)saveValue;
            if (stepTime >= steps) {
                return;
            }
            double progress = (double)stepTime / (double)steps;
            double x = start.field_1352 + (end.field_1352 - start.field_1352) * progress;
            double z = start.field_1350 + (end.field_1350 - start.field_1350) * progress;
            double y = start.field_1351 + (end.field_1351 - start.field_1351) * progress + 4.0 * maxHeight * (progress - progress * progress);
            double spread = 0.05 * progress;
            int particleCount = (int)(1.0 + progress * 3.0);
            world.method_14199((class_2394)particleEffect, x, y, z, particleCount, spread, 0.02, spread, 0.0);
            if (progress > 0.8) {
                double splashIntensity = (progress - 0.8) * 5.0;
                double splashRadius = 0.3 * splashIntensity;
                int splashParticles = (int)(5.0 * splashIntensity);
                for (int i = 0; i < splashParticles; ++i) {
                    double angle = Math.random() * Math.PI * 2.0;
                    double distance = Math.random() * splashRadius;
                    double splashX = end.field_1352 + Math.cos(angle) * distance;
                    double splashZ = end.field_1350 + Math.sin(angle) * distance;
                    double splashY = end.field_1351 + 0.1;
                    world.method_14199((class_2394)particleEffect, splashX, splashY, splashZ, 1, 0.02, 0.02, 0.02, 0.01);
                }
            }
            ServerEachTickTaskManager.addSaveValue(taskId, stepTime + 1);
        });
    }

    public static void spawnWaterArcEffect(class_3218 world, class_243 start, class_243 end, int steps, class_9679 waterParticle, class_9679 splashParticle) {
        String taskId = "spawnWaterArc" + String.valueOf(UUID.randomUUID());
        Integer stepTick = 0;
        ServerEachTickTaskManager.addSaveValue(taskId, stepTick);
        double maxHeight = Math.max(2.0, start.method_1022(end) * 0.4);
        double gravity = 0.05;
        ServerEachTickTaskManager.scheduleTask(taskId, steps, 1, () -> {
            Object saveValue = ServerEachTickTaskManager.getSaveValue(taskId);
            if (saveValue == null) {
                return;
            }
            int stepTime = (Integer)saveValue;
            if (stepTime >= steps) {
                for (int i = 0; i < 15; ++i) {
                    double angle = Math.random() * Math.PI * 2.0;
                    double distance = Math.random() * 0.5;
                    double velocityY = 0.1 + Math.random() * 0.1;
                    world.method_14199((class_2394)splashParticle, end.field_1352 + Math.cos(angle) * distance, end.field_1351 + 0.1, end.field_1350 + Math.sin(angle) * distance, 1, Math.cos(angle) * 0.1, velocityY, Math.sin(angle) * 0.1, 0.0);
                }
                return;
            }
            double progress = (double)stepTime / (double)steps;
            double x = start.field_1352 + (end.field_1352 - start.field_1352) * progress;
            double z = start.field_1350 + (end.field_1350 - start.field_1350) * progress;
            double initialVelocityY = 4.0 * maxHeight / (double)steps;
            double timeInAir = stepTime;
            double y = start.field_1351 + initialVelocityY * timeInAir - 0.5 * gravity * timeInAir * timeInAir;
            if (y < end.field_1351) {
                y = end.field_1351;
            }
            double spread = 0.02 + 0.05 * progress;
            world.method_14199((class_2394)waterParticle, x, y, z, 1, spread, 0.01, spread, 0.0);
            if (stepTime > 3) {
                double trailProgress = (double)(stepTime - 3) / (double)steps;
                double trailX = start.field_1352 + (end.field_1352 - start.field_1352) * trailProgress;
                double trailZ = start.field_1350 + (end.field_1350 - start.field_1350) * trailProgress;
                double trailTime = stepTime - 3;
                double trailY = start.field_1351 + initialVelocityY * trailTime - 0.5 * gravity * trailTime * trailTime;
                if (trailY >= end.field_1351) {
                    world.method_14199((class_2394)waterParticle, trailX, trailY, trailZ, 1, 0.01, 0.01, 0.01, 0.0);
                }
            }
            if (y <= end.field_1351 + 0.1 || progress > 0.9) {
                double splashIntensity = progress > 0.9 ? (progress - 0.9) * 10.0 : 1.0;
                double splashRadius = 0.2 * splashIntensity;
                for (int i = 0; i < 3; ++i) {
                    double angle = Math.random() * Math.PI * 2.0;
                    double distance = Math.random() * splashRadius;
                    world.method_14199((class_2394)splashParticle, x + Math.cos(angle) * distance, end.field_1351 + 0.05, z + Math.sin(angle) * distance, 1, Math.cos(angle) * 0.05, 0.05, Math.sin(angle) * 0.05, 0.0);
                }
            }
            ServerEachTickTaskManager.addSaveValue(taskId, stepTime + 1);
        });
    }
}

