/*
 * Decompiled with CFR 0.152.
 */
package com.soybeani.utils;

import com.soybeani.config.InitValue;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.io.InputStream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3532;
import net.minecraft.class_3673;
import net.minecraft.class_4587;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_756;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_897;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;

public final class RenderUtils {
    public static void translateMatrixToBone(class_4587 poseStack, GeoBone bone) {
        poseStack.method_46416(-bone.getPosX() / 16.0f, bone.getPosY() / 16.0f, bone.getPosZ() / 16.0f);
    }

    public static void rotateMatrixAroundBone(class_4587 poseStack, GeoBone bone) {
        if (bone.getRotZ() != 0.0f) {
            poseStack.method_22907(class_7833.field_40718.rotation(bone.getRotZ()));
        }
        if (bone.getRotY() != 0.0f) {
            poseStack.method_22907(class_7833.field_40716.rotation(bone.getRotY()));
        }
        if (bone.getRotX() != 0.0f) {
            poseStack.method_22907(class_7833.field_40714.rotation(bone.getRotX()));
        }
    }

    public static void rotateMatrixAroundCube(class_4587 poseStack, GeoCube cube) {
        class_243 rotation = cube.rotation();
        poseStack.method_22907(new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)rotation.method_10215()));
        poseStack.method_22907(new Quaternionf().rotationXYZ(0.0f, (float)rotation.method_10214(), 0.0f));
        poseStack.method_22907(new Quaternionf().rotationXYZ((float)rotation.method_10216(), 0.0f, 0.0f));
    }

    public static void scaleMatrixForBone(class_4587 poseStack, GeoBone bone) {
        poseStack.method_22905(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void translateToPivotPoint(class_4587 poseStack, GeoCube cube) {
        class_243 pivot = cube.pivot();
        poseStack.method_22904(pivot.method_10216() / 16.0, pivot.method_10214() / 16.0, pivot.method_10215() / 16.0);
    }

    public static void translateToPivotPoint(class_4587 poseStack, GeoBone bone) {
        poseStack.method_46416(bone.getPivotX() / 16.0f, bone.getPivotY() / 16.0f, bone.getPivotZ() / 16.0f);
    }

    public static void translateAwayFromPivotPoint(class_4587 poseStack, GeoCube cube) {
        class_243 pivot = cube.pivot();
        poseStack.method_22904(-pivot.method_10216() / 16.0, -pivot.method_10214() / 16.0, -pivot.method_10215() / 16.0);
    }

    public static void translateAwayFromPivotPoint(class_4587 poseStack, GeoBone bone) {
        poseStack.method_46416(-bone.getPivotX() / 16.0f, -bone.getPivotY() / 16.0f, -bone.getPivotZ() / 16.0f);
    }

    public static void translateAndRotateMatrixForBone(class_4587 poseStack, GeoBone bone) {
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
    }

    public static void prepMatrixForBone(class_4587 poseStack, GeoBone bone) {
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
    }

    public static Matrix4f invertAndMultiplyMatrices(Matrix4f baseMatrix, Matrix4f inputMatrix) {
        inputMatrix = new Matrix4f((Matrix4fc)inputMatrix);
        inputMatrix.invert();
        inputMatrix.mul((Matrix4fc)baseMatrix);
        return inputMatrix;
    }

    public static void faceRotation(class_4587 poseStack, class_1297 animatable, float partialTick) {
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)partialTick, (float)animatable.field_5982, (float)animatable.method_36454()) - 90.0f));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_16439((float)partialTick, (float)animatable.field_6004, (float)animatable.method_36455())));
    }

    public static Matrix4f translateMatrix(Matrix4f matrix, Vector3f vector) {
        return matrix.add((Matrix4fc)new Matrix4f().m30(vector.x).m31(vector.y).m32(vector.z));
    }

    @Nullable
    public static IntIntPair getTextureDimensions(class_2960 texture) {
        if (texture == null) {
            return null;
        }
        class_1044 originalTexture = null;
        class_310 mc = class_310.method_1551();
        try {
            originalTexture = (class_1044)mc.method_5385(() -> mc.method_1531().method_4619(texture)).get();
        }
        catch (Exception var6) {
            InitValue.LOGGER.warn("Failed to load image for id {}", (Object)texture);
            var6.printStackTrace();
        }
        if (originalTexture == null) {
            return null;
        }
        class_1011 image = null;
        try {
            class_1011 var10000;
            if (originalTexture instanceof class_1043) {
                class_1043 dynamicTexture = (class_1043)originalTexture;
                var10000 = dynamicTexture.method_4525();
            } else {
                var10000 = class_1011.method_4309((InputStream)((class_3298)mc.method_1478().method_14486(texture).get()).method_14482());
            }
            image = var10000;
        }
        catch (Exception var5) {
            InitValue.LOGGER.error("Failed to read image for id {}", (Object)texture);
            var5.printStackTrace();
        }
        return image == null ? null : IntIntImmutablePair.of((int)image.method_4307(), (int)image.method_4323());
    }

    public static double getCurrentSystemTick() {
        return (double)System.nanoTime() / 1000000.0 / 50.0;
    }

    public static double getCurrentTick() {
        return class_3673.method_15974() * 20.0;
    }

    public static float booleanToFloat(boolean input) {
        return input ? 1.0f : 0.0f;
    }

    public static class_243 arrayToVec(double[] array) {
        return new class_243(array[0], array[1], array[2]);
    }

    public static void matchModelPartRot(class_630 from, GeoBone to) {
        to.updateRotation(-from.field_3654, -from.field_3675, from.field_3674);
    }

    public static void fixInvertedFlatCube(GeoCube cube, Vector3f normal) {
        if (normal.x() < 0.0f && (cube.size().method_10214() == 0.0 || cube.size().method_10215() == 0.0)) {
            normal.mul(-1.0f, 1.0f, 1.0f);
        }
        if (normal.y() < 0.0f && (cube.size().method_10216() == 0.0 || cube.size().method_10215() == 0.0)) {
            normal.mul(1.0f, -1.0f, 1.0f);
        }
        if (normal.z() < 0.0f && (cube.size().method_10216() == 0.0 || cube.size().method_10214() == 0.0)) {
            normal.mul(1.0f, 1.0f, -1.0f);
        }
    }

    public static float getDirectionAngle(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> 90.0f;
            case class_2350.field_11043 -> 270.0f;
            case class_2350.field_11034 -> 180.0f;
            default -> 0.0f;
        };
    }

    @Nullable
    public static GeoAnimatable getReplacedAnimatable(class_1297 entity) {
        GeoAnimatable var10000;
        class_897 renderer = class_310.method_1551().method_1561().method_3953(entity);
        if (renderer instanceof GeoReplacedEntityRenderer) {
            GeoReplacedEntityRenderer replacedEntityRenderer = (GeoReplacedEntityRenderer)renderer;
            var10000 = replacedEntityRenderer.getAnimatable();
        } else {
            var10000 = null;
        }
        return var10000;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForEntity(class_1297 entity) {
        GeoModel var10000;
        class_897 renderer = class_310.method_1551().method_1561().method_3953(entity);
        if (renderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)renderer;
            var10000 = geoRenderer.getGeoModel();
        } else {
            var10000 = null;
        }
        return var10000;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForItem(class_1792 item) {
        class_756 var2 = GeoRenderProvider.of((class_1792)item).getGeoItemRenderer();
        if (var2 instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)var2;
            return geoRenderer.getGeoModel();
        }
        return null;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForBlock(class_2586 blockEntity) {
        GeoModel var10000;
        class_827 renderer = class_310.method_1551().method_31975().method_3550(blockEntity);
        if (renderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)renderer;
            var10000 = geoRenderer.getGeoModel();
        } else {
            var10000 = null;
        }
        return var10000;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForArmor(class_1799 stack) {
        class_572 var2 = GeoRenderProvider.of((class_1799)stack).getGeoArmorRenderer((class_1309)null, stack, (class_1304)null, (class_572)null);
        if (var2 instanceof GeoArmorRenderer) {
            GeoArmorRenderer armorRenderer = (GeoArmorRenderer)var2;
            return armorRenderer.getGeoModel();
        }
        return null;
    }

    private RenderUtils() {
        throw new UnsupportedOperationException();
    }
}

